/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

public class Quartic {
    public static int solve(double[] dArray, double[] dArray2) {
        int n;
        double d2 = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d2 += Math.abs(dArray[n]);
        }
        if (d2 < 1.0E-15) {
            dArray2[0] = 0.0;
            return 1;
        }
        n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] / d2;
        }
        n = 4;
        while (Math.abs(dArray[n]) < 1.0E-15) {
            --n;
        }
        if (n == 4) {
            double[] dArray3 = new double[4];
            return Quartic.quartic(dArray, dArray2, dArray3);
        }
        if (n == 3) {
            return Quartic.cubic(dArray, dArray2);
        }
        if (n == 2) {
            double d3 = -dArray[1] / (2.0 * dArray[2]);
            double d4 = d3 * d3 - dArray[0] / dArray[2];
            if (d4 < -1.0E-10) {
                return 0;
            }
            if (Math.abs(d4) < 1.0E-10) {
                dArray2[0] = d3;
                return 1;
            }
            dArray2[0] = d3 + Math.sqrt(d4);
            dArray2[1] = d3 - Math.sqrt(d4);
            return 2;
        }
        if (n == 1) {
            dArray2[0] = -dArray[0] / dArray[1];
            return 1;
        }
        if (Math.abs(dArray[0]) < 1.0E-10) {
            dArray2[0] = 0.0;
            return 1;
        }
        return 0;
    }

    static int quartic(double[] dArray, double[] dArray2, double[] dArray3) {
        int n;
        double[] dArray4 = new double[4];
        double[] dArray5 = new double[3];
        int n2 = 0;
        if (dArray[4] == 0.0) {
            return 0;
        }
        double d2 = dArray[4];
        double d3 = dArray[3];
        double d4 = dArray[2];
        double d5 = dArray[1];
        double d6 = dArray[0];
        double d7 = (-3.0 * Math.pow(d3, 2.0) + 8.0 * d2 * d4) / (8.0 * Math.pow(d2, 2.0));
        double d8 = (Math.pow(d3, 3.0) - 4.0 * d2 * d3 * d4 + 8.0 * d5 * Math.pow(d2, 2.0)) / (8.0 * Math.pow(d2, 3.0));
        double d9 = (-3.0 * Math.pow(d3, 4.0) + 16.0 * d2 * Math.pow(d3, 2.0) * d4 - 64.0 * Math.pow(d2, 2.0) * d3 * d5 + 256.0 * Math.pow(d2, 3.0) * d6) / (256.0 * Math.pow(d2, 4.0));
        dArray4[3] = 8.0;
        dArray4[2] = -4.0 * d7;
        dArray4[1] = -8.0 * d9;
        dArray4[0] = 4.0 * d7 * d9 - Math.pow(d8, 2.0);
        int n3 = Quartic.cubic(dArray4, dArray5);
        double d10 = -1.0E99;
        for (n = 0; n < n3; ++n) {
            d10 = Math.max(d10, dArray5[n]);
        }
        dArray5[0] = d10;
        double d11 = 2.0 * dArray5[0] - d7;
        double d12 = Math.sqrt(d11);
        double d13 = d8 / (2.0 * d12);
        double d14 = d11 - 4.0 * (dArray5[0] + d13);
        double d15 = d11 - 4.0 * (dArray5[0] - d13);
        for (n = 0; n < 4; ++n) {
            dArray3[n] = 0.0;
        }
        if (d14 >= 0.0 && d15 >= 0.0) {
            dArray2[0] = 0.5 * (d12 + Math.sqrt(d14));
            dArray2[1] = 0.5 * (d12 - Math.sqrt(d14));
            dArray2[2] = 0.5 * (-d12 + Math.sqrt(d15));
            dArray2[3] = 0.5 * (-d12 - Math.sqrt(d15));
            n2 = 4;
        } else if (d14 >= 0.0 && d15 < 0.0) {
            dArray2[0] = 0.5 * (d12 + Math.sqrt(d14));
            dArray2[1] = 0.5 * (d12 - Math.sqrt(d14));
            dArray2[2] = -0.5 * d12;
            dArray2[3] = -0.5 * d12;
            dArray3[2] = Math.sqrt(-0.25 * d15);
            dArray3[3] = -Math.sqrt(-0.25 * d15);
            n2 = 2;
        } else if (d14 < 0.0 && d15 >= 0.0) {
            dArray2[0] = 0.5 * (-d12 + Math.sqrt(d15));
            dArray2[1] = 0.5 * (-d12 - Math.sqrt(d15));
            dArray2[2] = 0.5 * d12;
            dArray2[3] = 0.5 * d12;
            dArray3[2] = Math.sqrt(-0.25 * d14);
            dArray3[3] = -Math.sqrt(-0.25 * d14);
            n2 = 2;
        } else if (d14 < 0.0 && d15 < 0.0) {
            dArray2[0] = -0.5 * d12;
            dArray2[1] = -0.5 * d12;
            dArray3[0] = Math.sqrt(-0.25 * d15);
            dArray3[1] = -Math.sqrt(-0.25 * d15);
            dArray2[2] = 0.5 * d12;
            dArray2[3] = 0.5 * d12;
            dArray3[2] = Math.sqrt(-0.25 * d14);
            dArray3[3] = -Math.sqrt(-0.25 * d14);
            n2 = 0;
        }
        n = 0;
        while (n < 4) {
            int n4 = n++;
            dArray2[n4] = dArray2[n4] - d3 / (4.0 * d2);
        }
        return n2;
    }

    public static int cubic(double[] dArray, double[] dArray2) {
        int n;
        int n2;
        double d2;
        double d3;
        double[] dArray3 = new double[3];
        if (dArray[3] != 0.0) {
            double d4 = dArray[2] / dArray[3] * 0.3333333333333333;
            d3 = Math.pow(dArray[1] / dArray[3] * 0.3333333333333333 - Math.pow(d4, 2.0), 3.0);
            double d5 = -0.5 * (2.0 * Math.pow(d4, 3.0) - (dArray[1] * d4 - dArray[0]) / dArray[3]);
            d2 = Math.pow(d5, 2.0) + d3;
            if (d2 < 0.0) {
                double d6 = Math.acos(Math.min(1.0, Math.max(-1.0, d5 / Math.sqrt(-d3))));
                d3 = 2.0 * Math.pow(-d3, 0.16666666666666666);
                for (n2 = 0; n2 < 3; ++n2) {
                    dArray3[n2] = d3 * Math.cos((d6 + 2.0 * (double)n2 * Math.PI) * 0.3333333333333333) - d4;
                }
                dArray2[0] = Math.min(dArray3[0], Math.min(dArray3[1], dArray3[2]));
                dArray2[1] = Math.max(Math.min(dArray3[0], dArray3[1]), Math.max(Math.min(dArray3[0], dArray3[2]), Math.min(dArray3[1], dArray3[2])));
                dArray2[2] = Math.max(dArray3[0], Math.max(dArray3[1], dArray3[2]));
                n = 3;
            } else {
                d2 = Math.sqrt(d2);
                dArray2[0] = Quartic.CBRT(d5 + d2) + Quartic.CBRT(d5 - d2) - d4;
                n = 1;
            }
        } else if (dArray[2] != 0.0) {
            d3 = 0.5 * dArray[1] / dArray[2];
            d2 = Math.pow(d3, 2.0) - dArray[0] / dArray[2];
            if (d2 > 0.0) {
                dArray2[0] = -d3 - Math.sqrt(d2);
                dArray2[1] = -d3 + Math.sqrt(d2);
                n = 2;
            } else {
                n = 0;
            }
        } else if (dArray[1] != 0.0) {
            dArray2[0] = dArray[0] / dArray[1];
            n = 1;
        } else {
            n = 0;
        }
        for (n2 = 0; n2 < n; ++n2) {
            dArray2[n2] = dArray2[n2] - (dArray[0] + dArray2[n2] * (dArray[1] + dArray2[n2] * (dArray[2] + dArray2[n2] * dArray[3]))) / (dArray[1] + dArray2[n2] * (2.0 * dArray[2] + dArray2[n2] * 3.0 * dArray[3]));
        }
        return n;
    }

    static double CBRT(double d2) {
        if (d2 > 0.0) {
            return Math.pow(d2, 0.3333333333333333);
        }
        if (d2 < 0.0) {
            return -Math.pow(Math.abs(d2), 0.3333333333333333);
        }
        return 0.0;
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[]{0.0, 3.0, -3.0, -6.0, 5.0};
        double[] dArray2 = new double[5];
        double[] dArray3 = new double[5];
        int n = Quartic.quartic(dArray, dArray2, dArray3);
        System.out.println(n + " solutions!");
        for (int i = 0; i < n; ++i) {
            System.out.println(dArray2[i]);
        }
    }
}

