---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, mode mathématique, 
              hors-ligne, en ligne
---

# Comment insérer des mathématiques ?

LaTeX, comme TeX, propose deux façons d'insérer des mathématiques nommées 
les **modes mathématiques** : le mode hors-ligne et le mode en ligne.

Dans ces deux modes, LaTeX traite des formules mathématiques et change alors
la présentation des éléments. Par exemple :
- le texte est par défaut affiché en italique car LaTeX considère que 
  les lettres sont des variables mathématiques ;
- de même, la gestion des espaces et des retours à la ligne devient 
  entièrement automatique.

Notez bien que LaTeX ne fait que présenter des mathématiques. Il n'a pas 
pour vocation de comprendre ce que vous écrivez : vous pouvez donc écrire 
des formules fausses sans que LaTeX y trouve matière à erreur.


## Avec le mode hors-ligne

Ce mode hors-ligne, appelé *displaystyle* en anglais, permet d'isoler 
une formule du texte qui l’entoure. En LaTeX, ce mode s'ouvre puis se ferme
avec les commandes suivantes :

- soit `\[` et `\]` ;
- soit `\begin{displaymath}` et `\end{displaymath}`.

En `Plain` TeX, il existe une autre solution, à savoir utiliser `$$` et `$$`.
Cependant, cette solution ne doit pas être employée avec LaTeX pour les raisons
évoquées à la question 
"[](/4_domaines_specialises/mathematiques/styles/arguments_contre_les_doubles_dollars)".

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Résoudre l'équation : \[ 3 + 4 x = 0\]
Puis résoudre l'équation :
\begin{displaymath}
  \sum_{k=0}^\infty y^k = 2
\end{displaymath}
\end{document}
```


## Avec le mode en ligne

Le mode en ligne sert à placer de courts morceaux de mathématiques 
dans le texte courant. En LaTeX, ce mode s'ouvre puis se ferme 
avec les commandes suivantes :

- `$` et `$` (solution pour `Plain` TeX mais qui fonctionne en LaTeX) ;
- `\(` et `\)` ;
- `\begin{math}` et `\end{math}`.

Voici un exemple d'insertion de mathématiques en ligne :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Résoudre l'équation : $2x-4 = 0$. Puis
l'équation : $\sum_{k=0}^\infty y^k = 2$. Enfin calculer
la valeur de \begin{math}x+y\end{math}.
\end{document}
```

La comparaison avec l'exemple du mode hors-ligne montre que les équations
elles-même ne sont pas présentées de la même manière. Dans le cas du mode
en ligne, LaTeX fait en sorte de respecter l'interligne et compacte 
la présentation de certains éléments, dans le cas présent les éléments 
en indice et en exposant du symbole de sommation. Ce comportement peut 
être modifié comme le montrent les questions :

- "[](/4_domaines_specialises/mathematiques/styles/a_quoi_sert_displaystyle)" ;
- "[](/4_domaines_specialises/mathematiques/structures/operateurs/changer_la_position_des_limites_autour_des_sommes_et_integrales)".


## Avec l'extension <ctanpkg:mathtools>

Au-delà de l'utilisation de ces deux modes, LaTeX permet d'obtenir 
beaucoup de notations mathématiques pour composer des textes mathématiques.
Cependant, des extensions permettent de compléter largement ces possibilités
de base. C'est tout particulièrement le cas 
avec l'extension <ctanpkg:mathtools> qui donne accès à 
beaucoup de fonctionnalités usuelles pour saisir des mathématiques, 
illustrées pour beaucoup dans cette FAQ sur les pages traitant 
des [Mathématiques](/4_domaines_specialises/mathematiques/start). 

Comme l'indique sa [documentation](texdoc:mathtools), <ctanpkg:mathtools> 
reprend et corrige les fonctionnalités d'une extension de référence, 
<ctanpkg:amsmath> (dont l'origine est décrite à la question 
"[](/1_generalites/glossaire/ams-tex_et_ams-latex)"). De fait, vous pourrez
trouver fréquemment des références à <ctanpkg:amsmath> 
dans la littérature existante : remplacez-la par <ctanpkg:mathtools> 
pour être sûr de bénéficier des fonctionnalités les plus à jour.

```{warning}
Ce qui suit n'a qu'un caractère historique, l'utilisation de LaTeX 2.09 
n'étant plus recommandée. 

Si vous travaillez avec LaTeX 2.09 , vous pouvez utiliser les extensions 
<ctanpkg:amstex>, <ctanpkg:amsbsy> et <ctanpkg:amsopn> mais il faut savoir
que <ctanpkg:amstex> est obsolète.
```


:::{seealso}
N'hésitez pas à consulter la question évoquant les 
[8 styles mathématiques](/4_domaines_specialises/mathematiques/styles/les_huit_styles_mathematiques)
sous-jacents à ces modes. Par ailleurs, si la gestion automatique 
des mathématiques par LaTeX vous pose des difficultés, vous pouvez
étudier les questions :

- "[](/4_domaines_specialises/mathematiques/espaces_en_mode_mathematique)" ;
- "[](/4_domaines_specialises/mathematiques/composer_du_texte_en_mode_mathematique)" ;
- "[](/4_domaines_specialises/mathematiques/coupures_de_lignes_en_mode_mathematique)" 
  (uniquement pour le mode en ligne).
:::