---
myst:
  html_meta:
    keywords: LaTeX, composition, flottants, figures, floats, tables
---

# Comment isoler un flottant sur une page à part ?

Il est parfois nécessaire de forcer un flottant à être placé seul et sans texte
sur une page. Cela peut même aller jusqu'à ce que cela soit nécessaire 
pour *chaque* flottant. Lorsqu'un flottant ne parvient pas à "se positionner"
seul et attend alors la fin d'un chapitre ou du document, un réflexe est 
souvent d'introduire le flottant avec la commande `\begin{⟨figure ou table⟩`. 
La question "[](/3_composition/flottants/pourquoi_faire_flotter_ses_figures_et_tableaux)" 
propose quelques suggestions mais ne résout pas la question d'avoir un flottant
par page.

Les environnements `figure` et `table` disposent d'un argument facultatif 
permettant la position du flottant. Dans le cas présent, il faut utiliser
la valeur `p` (pour page) qui demande à LaTeX de positionner le flottant 
sur une page séparée du texte. Mais il peut alors placer plusieurs flottants
sur la même page. 

Dans ce cadre, la solution utilisant le compteur `totalnumber` (définissant 
le nombre total de flottants par page) ne fonctionne pas : `totalnumber` 
ne s'applique en effet qu'aux flottants sur les pages contenant aussi 
du texte. Aussi, pour permettre à n'importe quel flottant de prendre 
une page entière :

- définissez `\floatpagefraction` avec une petite valeur ;
- et, pour vous assurer qu'il n'y ait pas plus d'un flottant par page, 
imposez une séparation importante entre les flottants en modifiant
la valeur de `@fpsep`.

Voici un exemple illustrant cette méthode :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

  % Redéfinitions
  \renewcommand\floatpagefraction{.001}
  \makeatletter
    \setlength\@fpsep{\textheight}
  \makeatother

\begin{document}
Donner des exemples peut aider.
\begin{figure}[p]
  \centering\framebox{\Huge Un exemple}
  \caption{Exemple exemplaire}
\end{figure}

Il faut les rendre aussi précis que possible.
\begin{figure}[p]
\centering\framebox{\Huge Un autre exemple}
\caption{Exemplaire d'exemple}
\end{figure}
\end{document}
```


:::{sources}
[Floats on their own on float pages](faquk:FAQ-floatpages)
:::