// AUTOGENERATED FROM index-jis0212.txt, ORIGINAL COMMENT FOLLOWS:
//
// Any copyright is dedicated to the Public Domain.
// https://creativecommons.org/publicdomain/zero/1.0/
//
// For details on index index-jis0212.txt see the Encoding Standard
// https://encoding.spec.whatwg.org/
//
// Identifier: 83bf90dd1c591a4355730d8c4567efc499d74da7490531019ef22a879991cfb7
// Date: 2016-01-20

#[allow(dead_code)] const X: u16 = 0xffff;

fn premap_forward(code: u16) -> u16 {
    match code {
        0...174 => code,
        175...533 => X,
        534...1026 => code - 359,
        1027...1409 => X,
        _ => code - 742,
    }
}

#[cfg(feature = "no-optimized-legacy-encoding")]
fn premap_backward(code: u16) -> u16 {
    match code {
        0...174 => code,
        175...667 => code + 359,
        _ => code.saturating_add(742),
    }
}

const FORWARD_TABLE: &'static [u16] = &[
    728, 711, 184, 729, 733, 175, 731, 730, 65374, 900, 901, X, X, X, X, X, X,
    X, X, 161, 166, 191, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 186, 170, 169,
    174, 8482, 164, 8470, 902, 904, 905, 906, 938, X, 908, X, 910, 939, X, 911,
    X, X, X, X, 940, 941, 942, 943, 970, 912, 972, 962, 973, 971, 944, 974, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, 1026, 1027, 1028, 1029, 1030, 1031, 1032, 1033,
    1034, 1035, 1036, 1038, 1039, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 1106, 1107,
    1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115, 1116, 1118, 1119, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 198, 272, X, 294, X, 306,
    X, 321, 319, X, 330, 216, 338, X, 358, 222, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, 230, 273, 240, 295, 305, 307, 312, 322, 320, 329, 331,
    248, 339, 223, 359, 254, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, 193, 192, 196, 194, 258, 461, 256, 260, 197, 195, 262, 264,
    268, 199, 266, 270, 201, 200, 203, 202, 282, 278, 274, 280, X, 284, 286,
    290, 288, 292, 205, 204, 207, 206, 463, 304, 298, 302, 296, 308, 310, 313,
    317, 315, 323, 327, 325, 209, 211, 210, 214, 212, 465, 336, 332, 213, 340,
    344, 342, 346, 348, 352, 350, 356, 354, 218, 217, 220, 219, 364, 467, 368,
    362, 370, 366, 360, 471, 475, 473, 469, 372, 221, 376, 374, 377, 381, 379,
    X, X, X, X, X, X, X, 225, 224, 228, 226, 259, 462, 257, 261, 229, 227, 263,
    265, 269, 231, 267, 271, 233, 232, 235, 234, 283, 279, 275, 281, 501, 285,
    287, X, 289, 293, 237, 236, 239, 238, 464, X, 299, 303, 297, 309, 311, 314,
    318, 316, 324, 328, 326, 241, 243, 242, 246, 244, 466, 337, 333, 245, 341,
    345, 343, 347, 349, 353, 351, 357, 355, 250, 249, 252, 251, 365, 468, 369,
    363, 371, 367, 361, 472, 476, 474, 470, 373, 253, 255, 375, 378, 382, 380,
    19970, 19972, 19973, 19980, 19986, 19999, 20003, 20004, 20008, 20011,
    20014, 20015, 20016, 20021, 20032, 20033, 20036, 20039, 20049, 20058,
    20060, 20067, 20072, 20073, 20084, 20085, 20089, 20095, 20109, 20118,
    20119, 20125, 20143, 20153, 20163, 20176, 20186, 20187, 20192, 20193,
    20194, 20200, 20207, 20209, 20211, 20213, 20221, 20222, 20223, 20224,
    20226, 20227, 20232, 20235, 20236, 20242, 20245, 20246, 20247, 20249,
    20270, 20273, 20320, 20275, 20277, 20279, 20281, 20283, 20286, 20288,
    20290, 20296, 20297, 20299, 20300, 20306, 20308, 20310, 20312, 20319,
    20323, 20330, 20332, 20334, 20337, 20343, 20344, 20345, 20346, 20349,
    20350, 20353, 20354, 20356, 20357, 20361, 20362, 20364, 20366, 20368,
    20370, 20371, 20372, 20375, 20377, 20378, 20382, 20383, 20402, 20407,
    20409, 20411, 20412, 20413, 20414, 20416, 20417, 20421, 20422, 20424,
    20425, 20427, 20428, 20429, 20431, 20434, 20444, 20448, 20450, 20464,
    20466, 20476, 20477, 20479, 20480, 20481, 20484, 20487, 20490, 20492,
    20494, 20496, 20499, 20503, 20504, 20507, 20508, 20509, 20510, 20514,
    20519, 20526, 20528, 20530, 20531, 20533, 20544, 20545, 20546, 20549,
    20550, 20554, 20556, 20558, 20561, 20562, 20563, 20567, 20569, 20575,
    20576, 20578, 20579, 20582, 20583, 20586, 20589, 20592, 20593, 20539,
    20609, 20611, 20612, 20614, 20618, 20622, 20623, 20624, 20626, 20627,
    20628, 20630, 20635, 20636, 20638, 20639, 20640, 20641, 20642, 20650,
    20655, 20656, 20665, 20666, 20669, 20672, 20675, 20676, 20679, 20684,
    20686, 20688, 20691, 20692, 20696, 20700, 20701, 20703, 20706, 20708,
    20710, 20712, 20713, 20719, 20721, 20726, 20730, 20734, 20739, 20742,
    20743, 20744, 20747, 20748, 20749, 20750, 20722, 20752, 20759, 20761,
    20763, 20764, 20765, 20766, 20771, 20775, 20776, 20780, 20781, 20783,
    20785, 20787, 20788, 20789, 20792, 20793, 20802, 20810, 20815, 20819,
    20821, 20823, 20824, 20831, 20836, 20838, 20862, 20867, 20868, 20875,
    20878, 20888, 20893, 20897, 20899, 20909, 20920, 20922, 20924, 20926,
    20927, 20930, 20936, 20943, 20945, 20946, 20947, 20949, 20952, 20958,
    20962, 20965, 20974, 20978, 20979, 20980, 20983, 20993, 20994, 20997,
    21010, 21011, 21013, 21014, 21016, 21026, 21032, 21041, 21042, 21045,
    21052, 21061, 21065, 21077, 21079, 21080, 21082, 21084, 21087, 21088,
    21089, 21094, 21102, 21111, 21112, 21113, 21120, 21122, 21125, 21130,
    21132, 21139, 21141, 21142, 21143, 21144, 21146, 21148, 21156, 21157,
    21158, 21159, 21167, 21168, 21174, 21175, 21176, 21178, 21179, 21181,
    21184, 21188, 21190, 21192, 21196, 21199, 21201, 21204, 21206, 21211,
    21212, 21217, 21221, 21224, 21225, 21226, 21228, 21232, 21233, 21236,
    21238, 21239, 21248, 21251, 21258, 21259, 21260, 21265, 21267, 21272,
    21275, 21276, 21278, 21279, 21285, 21287, 21288, 21289, 21291, 21292,
    21293, 21296, 21298, 21301, 21308, 21309, 21310, 21314, 21324, 21323,
    21337, 21339, 21345, 21347, 21349, 21356, 21357, 21362, 21369, 21374,
    21379, 21383, 21384, 21390, 21395, 21396, 21401, 21405, 21409, 21412,
    21418, 21419, 21423, 21426, 21428, 21429, 21431, 21432, 21434, 21437,
    21440, 21445, 21455, 21458, 21459, 21461, 21466, 21469, 21470, 21472,
    21478, 21479, 21493, 21506, 21523, 21530, 21537, 21543, 21544, 21546,
    21551, 21553, 21556, 21557, 21571, 21572, 21575, 21581, 21583, 21598,
    21602, 21604, 21606, 21607, 21609, 21611, 21613, 21614, 21620, 21631,
    21633, 21635, 21637, 21640, 21641, 21645, 21649, 21653, 21654, 21660,
    21663, 21665, 21670, 21671, 21673, 21674, 21677, 21678, 21681, 21687,
    21689, 21690, 21691, 21695, 21702, 21706, 21709, 21710, 21728, 21738,
    21740, 21743, 21750, 21756, 21758, 21759, 21760, 21761, 21765, 21768,
    21769, 21772, 21773, 21774, 21781, 21802, 21803, 21810, 21813, 21814,
    21819, 21820, 21821, 21825, 21831, 21833, 21834, 21837, 21840, 21841,
    21848, 21850, 21851, 21854, 21856, 21857, 21860, 21862, 21887, 21889,
    21890, 21894, 21896, 21902, 21903, 21905, 21906, 21907, 21908, 21911,
    21923, 21924, 21933, 21938, 21951, 21953, 21955, 21958, 21961, 21963,
    21964, 21966, 21969, 21970, 21971, 21975, 21976, 21979, 21982, 21986,
    21993, 22006, 22015, 22021, 22024, 22026, 22029, 22030, 22031, 22032,
    22033, 22034, 22041, 22060, 22064, 22067, 22069, 22071, 22073, 22075,
    22076, 22077, 22079, 22080, 22081, 22083, 22084, 22086, 22089, 22091,
    22093, 22095, 22100, 22110, 22112, 22113, 22114, 22115, 22118, 22121,
    22125, 22127, 22129, 22130, 22133, 22148, 22149, 22152, 22155, 22156,
    22165, 22169, 22170, 22173, 22174, 22175, 22182, 22183, 22184, 22185,
    22187, 22188, 22189, 22193, 22195, 22199, 22206, 22213, 22217, 22218,
    22219, 22223, 22224, 22220, 22221, 22233, 22236, 22237, 22239, 22241,
    22244, 22245, 22246, 22247, 22248, 22257, 22251, 22253, 22262, 22263,
    22273, 22274, 22279, 22282, 22284, 22289, 22293, 22298, 22299, 22301,
    22304, 22306, 22307, 22308, 22309, 22313, 22314, 22316, 22318, 22319,
    22323, 22324, 22333, 22334, 22335, 22341, 22342, 22348, 22349, 22354,
    22370, 22373, 22375, 22376, 22379, 22381, 22382, 22383, 22384, 22385,
    22387, 22388, 22389, 22391, 22393, 22394, 22395, 22396, 22398, 22401,
    22403, 22412, 22420, 22423, 22425, 22426, 22428, 22429, 22430, 22431,
    22433, 22421, 22439, 22440, 22441, 22444, 22456, 22461, 22471, 22472,
    22476, 22479, 22485, 22493, 22494, 22500, 22502, 22503, 22505, 22509,
    22512, 22517, 22518, 22520, 22525, 22526, 22527, 22531, 22532, 22536,
    22537, 22497, 22540, 22541, 22555, 22558, 22559, 22560, 22566, 22567,
    22573, 22578, 22585, 22591, 22601, 22604, 22605, 22607, 22608, 22613,
    22623, 22625, 22628, 22631, 22632, 22648, 22652, 22655, 22656, 22657,
    22663, 22664, 22665, 22666, 22668, 22669, 22671, 22672, 22676, 22678,
    22685, 22688, 22689, 22690, 22694, 22697, 22705, 22706, 22724, 22716,
    22722, 22728, 22733, 22734, 22736, 22738, 22740, 22742, 22746, 22749,
    22753, 22754, 22761, 22771, 22789, 22790, 22795, 22796, 22802, 22803,
    22804, 34369, 22813, 22817, 22819, 22820, 22824, 22831, 22832, 22835,
    22837, 22838, 22847, 22851, 22854, 22866, 22867, 22873, 22875, 22877,
    22878, 22879, 22881, 22883, 22891, 22893, 22895, 22898, 22901, 22902,
    22905, 22907, 22908, 22923, 22924, 22926, 22930, 22933, 22935, 22943,
    22948, 22951, 22957, 22958, 22959, 22960, 22963, 22967, 22970, 22972,
    22977, 22979, 22980, 22984, 22986, 22989, 22994, 23005, 23006, 23007,
    23011, 23012, 23015, 23022, 23023, 23025, 23026, 23028, 23031, 23040,
    23044, 23052, 23053, 23054, 23058, 23059, 23070, 23075, 23076, 23079,
    23080, 23082, 23085, 23088, 23108, 23109, 23111, 23112, 23116, 23120,
    23125, 23134, 23139, 23141, 23143, 23149, 23159, 23162, 23163, 23166,
    23179, 23184, 23187, 23190, 23193, 23196, 23198, 23199, 23200, 23202,
    23207, 23212, 23217, 23218, 23219, 23221, 23224, 23226, 23227, 23231,
    23236, 23238, 23240, 23247, 23258, 23260, 23264, 23269, 23274, 23278,
    23285, 23286, 23293, 23296, 23297, 23304, 23319, 23348, 23321, 23323,
    23325, 23329, 23333, 23341, 23352, 23361, 23371, 23372, 23378, 23382,
    23390, 23400, 23406, 23407, 23420, 23421, 23422, 23423, 23425, 23428,
    23430, 23434, 23438, 23440, 23441, 23443, 23444, 23446, 23464, 23465,
    23468, 23469, 23471, 23473, 23474, 23479, 23482, 23484, 23488, 23489,
    23501, 23503, 23510, 23511, 23512, 23513, 23514, 23520, 23535, 23537,
    23540, 23549, 23564, 23575, 23582, 23583, 23587, 23590, 23593, 23595,
    23596, 23598, 23600, 23602, 23605, 23606, 23641, 23642, 23644, 23650,
    23651, 23655, 23656, 23657, 23661, 23664, 23668, 23669, 23674, 23675,
    23676, 23677, 23687, 23688, 23690, 23695, 23698, 23709, 23711, 23712,
    23714, 23715, 23718, 23722, 23730, 23732, 23733, 23738, 23753, 23755,
    23762, 23773, 23767, 23790, 23793, 23794, 23796, 23809, 23814, 23821,
    23826, 23851, 23843, 23844, 23846, 23847, 23857, 23860, 23865, 23869,
    23871, 23874, 23875, 23878, 23880, 23893, 23889, 23897, 23882, 23903,
    23904, 23905, 23906, 23908, 23914, 23917, 23920, 23929, 23930, 23934,
    23935, 23937, 23939, 23944, 23946, 23954, 23955, 23956, 23957, 23961,
    23963, 23967, 23968, 23975, 23979, 23984, 23988, 23992, 23993, 24003,
    24007, 24011, 24016, 24014, 24024, 24025, 24032, 24036, 24041, 24056,
    24057, 24064, 24071, 24077, 24082, 24084, 24085, 24088, 24095, 24096,
    24110, 24104, 24114, 24117, 24126, 24139, 24144, 24137, 24145, 24150,
    24152, 24155, 24156, 24158, 24168, 24170, 24171, 24172, 24173, 24174,
    24176, 24192, 24203, 24206, 24226, 24228, 24229, 24232, 24234, 24236,
    24241, 24243, 24253, 24254, 24255, 24262, 24268, 24267, 24270, 24273,
    24274, 24276, 24277, 24284, 24286, 24293, 24299, 24322, 24326, 24327,
    24328, 24334, 24345, 24348, 24349, 24353, 24354, 24355, 24356, 24360,
    24363, 24364, 24366, 24368, 24372, 24374, 24379, 24381, 24383, 24384,
    24388, 24389, 24391, 24397, 24400, 24404, 24408, 24411, 24416, 24419,
    24420, 24423, 24431, 24434, 24436, 24437, 24440, 24442, 24445, 24446,
    24457, 24461, 24463, 24470, 24476, 24477, 24482, 24487, 24491, 24484,
    24492, 24495, 24496, 24497, 24504, 24516, 24519, 24520, 24521, 24523,
    24528, 24529, 24530, 24531, 24532, 24542, 24545, 24546, 24552, 24553,
    24554, 24556, 24557, 24558, 24559, 24562, 24563, 24566, 24570, 24572,
    24583, 24586, 24589, 24595, 24596, 24599, 24600, 24602, 24607, 24612,
    24621, 24627, 24629, 24640, 24647, 24648, 24649, 24652, 24657, 24660,
    24662, 24663, 24669, 24673, 24679, 24689, 24702, 24703, 24706, 24710,
    24712, 24714, 24718, 24721, 24723, 24725, 24728, 24733, 24734, 24738,
    24740, 24741, 24744, 24752, 24753, 24759, 24763, 24766, 24770, 24772,
    24776, 24777, 24778, 24779, 24782, 24783, 24788, 24789, 24793, 24795,
    24797, 24798, 24802, 24805, 24818, 24821, 24824, 24828, 24829, 24834,
    24839, 24842, 24844, 24848, 24849, 24850, 24851, 24852, 24854, 24855,
    24857, 24860, 24862, 24866, 24874, 24875, 24880, 24881, 24885, 24886,
    24887, 24889, 24897, 24901, 24902, 24905, 24926, 24928, 24940, 24946,
    24952, 24955, 24956, 24959, 24960, 24961, 24963, 24964, 24971, 24973,
    24978, 24979, 24983, 24984, 24988, 24989, 24991, 24992, 24997, 25000,
    25002, 25005, 25016, 25017, 25020, 25024, 25025, 25026, 25038, 25039,
    25045, 25052, 25053, 25054, 25055, 25057, 25058, 25063, 25065, 25061,
    25068, 25069, 25071, 25089, 25091, 25092, 25095, 25107, 25109, 25116,
    25120, 25122, 25123, 25127, 25129, 25131, 25145, 25149, 25154, 25155,
    25156, 25158, 25164, 25168, 25169, 25170, 25172, 25174, 25178, 25180,
    25188, 25197, 25199, 25203, 25210, 25213, 25229, 25230, 25231, 25232,
    25254, 25256, 25267, 25270, 25271, 25274, 25278, 25279, 25284, 25294,
    25301, 25302, 25306, 25322, 25330, 25332, 25340, 25341, 25347, 25348,
    25354, 25355, 25357, 25360, 25363, 25366, 25368, 25385, 25386, 25389,
    25397, 25398, 25401, 25404, 25409, 25410, 25411, 25412, 25414, 25418,
    25419, 25422, 25426, 25427, 25428, 25432, 25435, 25445, 25446, 25452,
    25453, 25457, 25460, 25461, 25464, 25468, 25469, 25471, 25474, 25476,
    25479, 25482, 25488, 25492, 25493, 25497, 25498, 25502, 25508, 25510,
    25517, 25518, 25519, 25533, 25537, 25541, 25544, 25550, 25553, 25555,
    25556, 25557, 25564, 25568, 25573, 25578, 25580, 25586, 25587, 25589,
    25592, 25593, 25609, 25610, 25616, 25618, 25620, 25624, 25630, 25632,
    25634, 25636, 25637, 25641, 25642, 25647, 25648, 25653, 25661, 25663,
    25675, 25679, 25681, 25682, 25683, 25684, 25690, 25691, 25692, 25693,
    25695, 25696, 25697, 25699, 25709, 25715, 25716, 25723, 25725, 25733,
    25735, 25743, 25744, 25745, 25752, 25753, 25755, 25757, 25759, 25761,
    25763, 25766, 25768, 25772, 25779, 25789, 25790, 25791, 25796, 25801,
    25802, 25803, 25804, 25806, 25808, 25809, 25813, 25815, 25828, 25829,
    25833, 25834, 25837, 25840, 25845, 25847, 25851, 25855, 25857, 25860,
    25864, 25865, 25866, 25871, 25875, 25876, 25878, 25881, 25883, 25886,
    25887, 25890, 25894, 25897, 25902, 25905, 25914, 25916, 25917, 25923,
    25927, 25929, 25936, 25938, 25940, 25951, 25952, 25959, 25963, 25978,
    25981, 25985, 25989, 25994, 26002, 26005, 26008, 26013, 26016, 26019,
    26022, 26030, 26034, 26035, 26036, 26047, 26050, 26056, 26057, 26062,
    26064, 26068, 26070, 26072, 26079, 26096, 26098, 26100, 26101, 26105,
    26110, 26111, 26112, 26116, 26120, 26121, 26125, 26129, 26130, 26133,
    26134, 26141, 26142, 26145, 26146, 26147, 26148, 26150, 26153, 26154,
    26155, 26156, 26158, 26160, 26161, 26163, 26169, 26167, 26176, 26181,
    26182, 26186, 26188, 26193, 26190, 26199, 26200, 26201, 26203, 26204,
    26208, 26209, 26363, 26218, 26219, 26220, 26238, 26227, 26229, 26239,
    26231, 26232, 26233, 26235, 26240, 26236, 26251, 26252, 26253, 26256,
    26258, 26265, 26266, 26267, 26268, 26271, 26272, 26276, 26285, 26289,
    26290, 26293, 26299, 26303, 26304, 26306, 26307, 26312, 26316, 26318,
    26319, 26324, 26331, 26335, 26344, 26347, 26348, 26350, 26362, 26373,
    26375, 26382, 26387, 26393, 26396, 26400, 26402, 26419, 26430, 26437,
    26439, 26440, 26444, 26452, 26453, 26461, 26470, 26476, 26478, 26484,
    26486, 26491, 26497, 26500, 26510, 26511, 26513, 26515, 26518, 26520,
    26521, 26523, 26544, 26545, 26546, 26549, 26555, 26556, 26557, 26617,
    26560, 26562, 26563, 26565, 26568, 26569, 26578, 26583, 26585, 26588,
    26593, 26598, 26608, 26610, 26614, 26615, 26706, 26644, 26649, 26653,
    26655, 26664, 26663, 26668, 26669, 26671, 26672, 26673, 26675, 26683,
    26687, 26692, 26693, 26698, 26700, 26709, 26711, 26712, 26715, 26731,
    26734, 26735, 26736, 26737, 26738, 26741, 26745, 26746, 26747, 26748,
    26754, 26756, 26758, 26760, 26774, 26776, 26778, 26780, 26785, 26787,
    26789, 26793, 26794, 26798, 26802, 26811, 26821, 26824, 26828, 26831,
    26832, 26833, 26835, 26838, 26841, 26844, 26845, 26853, 26856, 26858,
    26859, 26860, 26861, 26864, 26865, 26869, 26870, 26875, 26876, 26877,
    26886, 26889, 26890, 26896, 26897, 26899, 26902, 26903, 26929, 26931,
    26933, 26936, 26939, 26946, 26949, 26953, 26958, 26967, 26971, 26979,
    26980, 26981, 26982, 26984, 26985, 26988, 26992, 26993, 26994, 27002,
    27003, 27007, 27008, 27021, 27026, 27030, 27032, 27041, 27045, 27046,
    27048, 27051, 27053, 27055, 27063, 27064, 27066, 27068, 27077, 27080,
    27089, 27094, 27095, 27106, 27109, 27118, 27119, 27121, 27123, 27125,
    27134, 27136, 27137, 27139, 27151, 27153, 27157, 27162, 27165, 27168,
    27172, 27176, 27184, 27186, 27188, 27191, 27195, 27198, 27199, 27205,
    27206, 27209, 27210, 27214, 27216, 27217, 27218, 27221, 27222, 27227,
    27236, 27239, 27242, 27249, 27251, 27262, 27265, 27267, 27270, 27271,
    27273, 27275, 27281, 27291, 27293, 27294, 27295, 27301, 27307, 27311,
    27312, 27313, 27316, 27325, 27326, 27327, 27334, 27337, 27336, 27340,
    27344, 27348, 27349, 27350, 27356, 27357, 27364, 27367, 27372, 27376,
    27377, 27378, 27388, 27389, 27394, 27395, 27398, 27399, 27401, 27407,
    27408, 27409, 27415, 27419, 27422, 27428, 27432, 27435, 27436, 27439,
    27445, 27446, 27451, 27455, 27462, 27466, 27469, 27474, 27478, 27480,
    27485, 27488, 27495, 27499, 27502, 27504, 27509, 27517, 27518, 27522,
    27525, 27543, 27547, 27551, 27552, 27554, 27555, 27560, 27561, 27564,
    27565, 27566, 27568, 27576, 27577, 27581, 27582, 27587, 27588, 27593,
    27596, 27606, 27610, 27617, 27619, 27622, 27623, 27630, 27633, 27639,
    27641, 27647, 27650, 27652, 27653, 27657, 27661, 27662, 27664, 27666,
    27673, 27679, 27686, 27687, 27688, 27692, 27694, 27699, 27701, 27702,
    27706, 27707, 27711, 27722, 27723, 27725, 27727, 27730, 27732, 27737,
    27739, 27740, 27755, 27757, 27759, 27764, 27766, 27768, 27769, 27771,
    27781, 27782, 27783, 27785, 27796, 27797, 27799, 27800, 27804, 27807,
    27824, 27826, 27828, 27842, 27846, 27853, 27855, 27856, 27857, 27858,
    27860, 27862, 27866, 27868, 27872, 27879, 27881, 27883, 27884, 27886,
    27890, 27892, 27908, 27911, 27914, 27918, 27919, 27921, 27923, 27930,
    27942, 27943, 27944, 27751, 27950, 27951, 27953, 27961, 27964, 27967,
    27991, 27998, 27999, 28001, 28005, 28007, 28015, 28016, 28028, 28034,
    28039, 28049, 28050, 28052, 28054, 28055, 28056, 28074, 28076, 28084,
    28087, 28089, 28093, 28095, 28100, 28104, 28106, 28110, 28111, 28118,
    28123, 28125, 28127, 28128, 28130, 28133, 28137, 28143, 28144, 28148,
    28150, 28156, 28160, 28164, 28190, 28194, 28199, 28210, 28214, 28217,
    28219, 28220, 28228, 28229, 28232, 28233, 28235, 28239, 28241, 28242,
    28243, 28244, 28247, 28252, 28253, 28254, 28258, 28259, 28264, 28275,
    28283, 28285, 28301, 28307, 28313, 28320, 28327, 28333, 28334, 28337,
    28339, 28347, 28351, 28352, 28353, 28355, 28359, 28360, 28362, 28365,
    28366, 28367, 28395, 28397, 28398, 28409, 28411, 28413, 28420, 28424,
    28426, 28428, 28429, 28438, 28440, 28442, 28443, 28454, 28457, 28458,
    28463, 28464, 28467, 28470, 28475, 28476, 28461, 28495, 28497, 28498,
    28499, 28503, 28505, 28506, 28509, 28510, 28513, 28514, 28520, 28524,
    28541, 28542, 28547, 28551, 28552, 28555, 28556, 28557, 28560, 28562,
    28563, 28564, 28566, 28570, 28575, 28576, 28581, 28582, 28583, 28584,
    28590, 28591, 28592, 28597, 28598, 28604, 28613, 28615, 28616, 28618,
    28634, 28638, 28648, 28649, 28656, 28661, 28665, 28668, 28669, 28672,
    28677, 28678, 28679, 28685, 28695, 28704, 28707, 28719, 28724, 28727,
    28729, 28732, 28739, 28740, 28744, 28745, 28746, 28747, 28756, 28757,
    28765, 28766, 28750, 28772, 28773, 28780, 28782, 28789, 28790, 28798,
    28801, 28805, 28806, 28820, 28821, 28822, 28823, 28824, 28827, 28836,
    28843, 28848, 28849, 28852, 28855, 28874, 28881, 28883, 28884, 28885,
    28886, 28888, 28892, 28900, 28922, 28931, 28932, 28933, 28934, 28935,
    28939, 28940, 28943, 28958, 28960, 28971, 28973, 28975, 28976, 28977,
    28984, 28993, 28997, 28998, 28999, 29002, 29003, 29008, 29010, 29015,
    29018, 29020, 29022, 29024, 29032, 29049, 29056, 29061, 29063, 29068,
    29074, 29082, 29083, 29088, 29090, 29103, 29104, 29106, 29107, 29114,
    29119, 29120, 29121, 29124, 29131, 29132, 29139, 29142, 29145, 29146,
    29148, 29176, 29182, 29184, 29191, 29192, 29193, 29203, 29207, 29210,
    29213, 29215, 29220, 29227, 29231, 29236, 29240, 29241, 29249, 29250,
    29251, 29253, 29262, 29263, 29264, 29267, 29269, 29270, 29274, 29276,
    29278, 29280, 29283, 29288, 29291, 29294, 29295, 29297, 29303, 29304,
    29307, 29308, 29311, 29316, 29321, 29325, 29326, 29331, 29339, 29352,
    29357, 29358, 29361, 29364, 29374, 29377, 29383, 29385, 29388, 29397,
    29398, 29400, 29407, 29413, 29427, 29428, 29434, 29435, 29438, 29442,
    29444, 29445, 29447, 29451, 29453, 29458, 29459, 29464, 29465, 29470,
    29474, 29476, 29479, 29480, 29484, 29489, 29490, 29493, 29498, 29499,
    29501, 29507, 29517, 29520, 29522, 29526, 29528, 29533, 29534, 29535,
    29536, 29542, 29543, 29545, 29547, 29548, 29550, 29551, 29553, 29559,
    29561, 29564, 29568, 29569, 29571, 29573, 29574, 29582, 29584, 29587,
    29589, 29591, 29592, 29596, 29598, 29599, 29600, 29602, 29605, 29606,
    29610, 29611, 29613, 29621, 29623, 29625, 29628, 29629, 29631, 29637,
    29638, 29641, 29643, 29644, 29647, 29650, 29651, 29654, 29657, 29661,
    29665, 29667, 29670, 29671, 29673, 29684, 29685, 29687, 29689, 29690,
    29691, 29693, 29695, 29696, 29697, 29700, 29703, 29706, 29713, 29722,
    29723, 29732, 29734, 29736, 29737, 29738, 29739, 29740, 29741, 29742,
    29743, 29744, 29745, 29753, 29760, 29763, 29764, 29766, 29767, 29771,
    29773, 29777, 29778, 29783, 29789, 29794, 29798, 29799, 29800, 29803,
    29805, 29806, 29809, 29810, 29824, 29825, 29829, 29830, 29831, 29833,
    29839, 29840, 29841, 29842, 29848, 29849, 29850, 29852, 29855, 29856,
    29857, 29859, 29862, 29864, 29865, 29866, 29867, 29870, 29871, 29873,
    29874, 29877, 29881, 29883, 29887, 29896, 29897, 29900, 29904, 29907,
    29912, 29914, 29915, 29918, 29919, 29924, 29928, 29930, 29931, 29935,
    29940, 29946, 29947, 29948, 29951, 29958, 29970, 29974, 29975, 29984,
    29985, 29988, 29991, 29993, 29994, 29999, 30006, 30009, 30013, 30014,
    30015, 30016, 30019, 30023, 30024, 30030, 30032, 30034, 30039, 30046,
    30047, 30049, 30063, 30065, 30073, 30074, 30075, 30076, 30077, 30078,
    30081, 30085, 30096, 30098, 30099, 30101, 30105, 30108, 30114, 30116,
    30132, 30138, 30143, 30144, 30145, 30148, 30150, 30156, 30158, 30159,
    30167, 30172, 30175, 30176, 30177, 30180, 30183, 30188, 30190, 30191,
    30193, 30201, 30208, 30210, 30211, 30212, 30215, 30216, 30218, 30220,
    30223, 30226, 30227, 30229, 30230, 30233, 30235, 30236, 30237, 30238,
    30243, 30245, 30246, 30249, 30253, 30258, 30259, 30261, 30264, 30265,
    30266, 30268, 30282, 30272, 30273, 30275, 30276, 30277, 30281, 30283,
    30293, 30297, 30303, 30308, 30309, 30317, 30318, 30319, 30321, 30324,
    30337, 30341, 30348, 30349, 30357, 30363, 30364, 30365, 30367, 30368,
    30370, 30371, 30372, 30373, 30374, 30375, 30376, 30378, 30381, 30397,
    30401, 30405, 30409, 30411, 30412, 30414, 30420, 30425, 30432, 30438,
    30440, 30444, 30448, 30449, 30454, 30457, 30460, 30464, 30470, 30474,
    30478, 30482, 30484, 30485, 30487, 30489, 30490, 30492, 30498, 30504,
    30509, 30510, 30511, 30516, 30517, 30518, 30521, 30525, 30526, 30530,
    30533, 30534, 30538, 30541, 30542, 30543, 30546, 30550, 30551, 30556,
    30558, 30559, 30560, 30562, 30564, 30567, 30570, 30572, 30576, 30578,
    30579, 30580, 30586, 30589, 30592, 30596, 30604, 30605, 30612, 30613,
    30614, 30618, 30623, 30626, 30631, 30634, 30638, 30639, 30641, 30645,
    30654, 30659, 30665, 30673, 30674, 30677, 30681, 30686, 30687, 30688,
    30692, 30694, 30698, 30700, 30704, 30705, 30708, 30712, 30715, 30725,
    30726, 30729, 30733, 30734, 30737, 30749, 30753, 30754, 30755, 30765,
    30766, 30768, 30773, 30775, 30787, 30788, 30791, 30792, 30796, 30798,
    30802, 30812, 30814, 30816, 30817, 30819, 30820, 30824, 30826, 30830,
    30842, 30846, 30858, 30863, 30868, 30872, 30881, 30877, 30878, 30879,
    30884, 30888, 30892, 30893, 30896, 30897, 30898, 30899, 30907, 30909,
    30911, 30919, 30920, 30921, 30924, 30926, 30930, 30931, 30933, 30934,
    30948, 30939, 30943, 30944, 30945, 30950, 30954, 30962, 30963, 30976,
    30966, 30967, 30970, 30971, 30975, 30982, 30988, 30992, 31002, 31004,
    31006, 31007, 31008, 31013, 31015, 31017, 31021, 31025, 31028, 31029,
    31035, 31037, 31039, 31044, 31045, 31046, 31050, 31051, 31055, 31057,
    31060, 31064, 31067, 31068, 31079, 31081, 31083, 31090, 31097, 31099,
    31100, 31102, 31115, 31116, 31121, 31123, 31124, 31125, 31126, 31128,
    31131, 31132, 31137, 31144, 31145, 31147, 31151, 31153, 31156, 31160,
    31163, 31170, 31172, 31175, 31176, 31178, 31183, 31188, 31190, 31194,
    31197, 31198, 31200, 31202, 31205, 31210, 31211, 31213, 31217, 31224,
    31228, 31234, 31235, 31239, 31241, 31242, 31244, 31249, 31253, 31259,
    31262, 31265, 31271, 31275, 31277, 31279, 31280, 31284, 31285, 31288,
    31289, 31290, 31300, 31301, 31303, 31304, 31308, 31317, 31318, 31321,
    31324, 31325, 31327, 31328, 31333, 31335, 31338, 31341, 31349, 31352,
    31358, 31360, 31362, 31365, 31366, 31370, 31371, 31376, 31377, 31380,
    31390, 31392, 31395, 31404, 31411, 31413, 31417, 31419, 31420, 31430,
    31433, 31436, 31438, 31441, 31451, 31464, 31465, 31467, 31468, 31473,
    31476, 31483, 31485, 31486, 31495, 31508, 31519, 31523, 31527, 31529,
    31530, 31531, 31533, 31534, 31535, 31536, 31537, 31540, 31549, 31551,
    31552, 31553, 31559, 31566, 31573, 31584, 31588, 31590, 31593, 31594,
    31597, 31599, 31602, 31603, 31607, 31620, 31625, 31630, 31632, 31633,
    31638, 31643, 31646, 31648, 31653, 31660, 31663, 31664, 31666, 31669,
    31670, 31674, 31675, 31676, 31677, 31682, 31685, 31688, 31690, 31700,
    31702, 31703, 31705, 31706, 31707, 31720, 31722, 31730, 31732, 31733,
    31736, 31737, 31738, 31740, 31742, 31745, 31746, 31747, 31748, 31750,
    31753, 31755, 31756, 31758, 31759, 31769, 31771, 31776, 31781, 31782,
    31784, 31788, 31793, 31795, 31796, 31798, 31801, 31802, 31814, 31818,
    31829, 31825, 31826, 31827, 31833, 31834, 31835, 31836, 31837, 31838,
    31841, 31843, 31847, 31849, 31853, 31854, 31856, 31858, 31865, 31868,
    31869, 31878, 31879, 31887, 31892, 31902, 31904, 31910, 31920, 31926,
    31927, 31930, 31931, 31932, 31935, 31940, 31943, 31944, 31945, 31949,
    31951, 31955, 31956, 31957, 31959, 31961, 31962, 31965, 31974, 31977,
    31979, 31989, 32003, 32007, 32008, 32009, 32015, 32017, 32018, 32019,
    32022, 32029, 32030, 32035, 32038, 32042, 32045, 32049, 32060, 32061,
    32062, 32064, 32065, 32071, 32072, 32077, 32081, 32083, 32087, 32089,
    32090, 32092, 32093, 32101, 32103, 32106, 32112, 32120, 32122, 32123,
    32127, 32129, 32130, 32131, 32133, 32134, 32136, 32139, 32140, 32141,
    32145, 32150, 32151, 32157, 32158, 32166, 32167, 32170, 32179, 32182,
    32183, 32185, 32194, 32195, 32196, 32197, 32198, 32204, 32205, 32206,
    32215, 32217, 32256, 32226, 32229, 32230, 32234, 32235, 32237, 32241,
    32245, 32246, 32249, 32250, 32264, 32272, 32273, 32277, 32279, 32284,
    32285, 32288, 32295, 32296, 32300, 32301, 32303, 32307, 32310, 32319,
    32324, 32325, 32327, 32334, 32336, 32338, 32344, 32351, 32353, 32354,
    32357, 32363, 32366, 32367, 32371, 32376, 32382, 32385, 32390, 32391,
    32394, 32397, 32401, 32405, 32408, 32410, 32413, 32414, 32572, 32571,
    32573, 32574, 32575, 32579, 32580, 32583, 32591, 32594, 32595, 32603,
    32604, 32605, 32609, 32611, 32612, 32613, 32614, 32621, 32625, 32637,
    32638, 32639, 32640, 32651, 32653, 32655, 32656, 32657, 32662, 32663,
    32668, 32673, 32674, 32678, 32682, 32685, 32692, 32700, 32703, 32704,
    32707, 32712, 32718, 32719, 32731, 32735, 32739, 32741, 32744, 32748,
    32750, 32751, 32754, 32762, 32765, 32766, 32767, 32775, 32776, 32778,
    32781, 32782, 32783, 32785, 32787, 32788, 32790, 32797, 32798, 32799,
    32800, 32804, 32806, 32812, 32814, 32816, 32820, 32821, 32823, 32825,
    32826, 32828, 32830, 32832, 32836, 32864, 32868, 32870, 32877, 32881,
    32885, 32897, 32904, 32910, 32924, 32926, 32934, 32935, 32939, 32952,
    32953, 32968, 32973, 32975, 32978, 32980, 32981, 32983, 32984, 32992,
    33005, 33006, 33008, 33010, 33011, 33014, 33017, 33018, 33022, 33027,
    33035, 33046, 33047, 33048, 33052, 33054, 33056, 33060, 33063, 33068,
    33072, 33077, 33082, 33084, 33093, 33095, 33098, 33100, 33106, 33111,
    33120, 33121, 33127, 33128, 33129, 33133, 33135, 33143, 33153, 33168,
    33156, 33157, 33158, 33163, 33166, 33174, 33176, 33179, 33182, 33186,
    33198, 33202, 33204, 33211, 33227, 33219, 33221, 33226, 33230, 33231,
    33237, 33239, 33243, 33245, 33246, 33249, 33252, 33259, 33260, 33264,
    33265, 33266, 33269, 33270, 33272, 33273, 33277, 33279, 33280, 33283,
    33295, 33299, 33300, 33305, 33306, 33309, 33313, 33314, 33320, 33330,
    33332, 33338, 33347, 33348, 33349, 33350, 33355, 33358, 33359, 33361,
    33366, 33372, 33376, 33379, 33383, 33389, 33396, 33403, 33405, 33407,
    33408, 33409, 33411, 33412, 33415, 33417, 33418, 33422, 33425, 33428,
    33430, 33432, 33434, 33435, 33440, 33441, 33443, 33444, 33447, 33448,
    33449, 33450, 33454, 33456, 33458, 33460, 33463, 33466, 33468, 33470,
    33471, 33478, 33488, 33493, 33498, 33504, 33506, 33508, 33512, 33514,
    33517, 33519, 33526, 33527, 33533, 33534, 33536, 33537, 33543, 33544,
    33546, 33547, 33620, 33563, 33565, 33566, 33567, 33569, 33570, 33580,
    33581, 33582, 33584, 33587, 33591, 33594, 33596, 33597, 33602, 33603,
    33604, 33607, 33613, 33614, 33617, 33621, 33622, 33623, 33648, 33656,
    33661, 33663, 33664, 33666, 33668, 33670, 33677, 33682, 33684, 33685,
    33688, 33689, 33691, 33692, 33693, 33702, 33703, 33705, 33708, 33726,
    33727, 33728, 33735, 33737, 33743, 33744, 33745, 33748, 33757, 33619,
    33768, 33770, 33782, 33784, 33785, 33788, 33793, 33798, 33802, 33807,
    33809, 33813, 33817, 33709, 33839, 33849, 33861, 33863, 33864, 33866,
    33869, 33871, 33873, 33874, 33878, 33880, 33881, 33882, 33884, 33888,
    33892, 33893, 33895, 33898, 33904, 33907, 33908, 33910, 33912, 33916,
    33917, 33921, 33925, 33938, 33939, 33941, 33950, 33958, 33960, 33961,
    33962, 33967, 33969, 33972, 33978, 33981, 33982, 33984, 33986, 33991,
    33992, 33996, 33999, 34003, 34012, 34023, 34026, 34031, 34032, 34033,
    34034, 34039, 34098, 34042, 34043, 34045, 34050, 34051, 34055, 34060,
    34062, 34064, 34076, 34078, 34082, 34083, 34084, 34085, 34087, 34090,
    34091, 34095, 34099, 34100, 34102, 34111, 34118, 34127, 34128, 34129,
    34130, 34131, 34134, 34137, 34140, 34141, 34142, 34143, 34144, 34145,
    34146, 34148, 34155, 34159, 34169, 34170, 34171, 34173, 34175, 34177,
    34181, 34182, 34185, 34187, 34188, 34191, 34195, 34200, 34205, 34207,
    34208, 34210, 34213, 34215, 34228, 34230, 34231, 34232, 34236, 34237,
    34238, 34239, 34242, 34247, 34250, 34251, 34254, 34221, 34264, 34266,
    34271, 34272, 34278, 34280, 34285, 34291, 34294, 34300, 34303, 34304,
    34308, 34309, 34317, 34318, 34320, 34321, 34322, 34328, 34329, 34331,
    34334, 34337, 34343, 34345, 34358, 34360, 34362, 34364, 34365, 34368,
    34370, 34374, 34386, 34387, 34390, 34391, 34392, 34393, 34397, 34400,
    34401, 34402, 34403, 34404, 34409, 34412, 34415, 34421, 34422, 34423,
    34426, 34445, 34449, 34454, 34456, 34458, 34460, 34465, 34470, 34471,
    34472, 34477, 34481, 34483, 34484, 34485, 34487, 34488, 34489, 34495,
    34496, 34497, 34499, 34501, 34513, 34514, 34517, 34519, 34522, 34524,
    34528, 34531, 34533, 34535, 34440, 34554, 34556, 34557, 34564, 34565,
    34567, 34571, 34574, 34575, 34576, 34579, 34580, 34585, 34590, 34591,
    34593, 34595, 34600, 34606, 34607, 34609, 34610, 34617, 34618, 34620,
    34621, 34622, 34624, 34627, 34629, 34637, 34648, 34653, 34657, 34660,
    34661, 34671, 34673, 34674, 34683, 34691, 34692, 34693, 34694, 34695,
    34696, 34697, 34699, 34700, 34704, 34707, 34709, 34711, 34712, 34713,
    34718, 34720, 34723, 34727, 34732, 34733, 34734, 34737, 34741, 34750,
    34751, 34753, 34760, 34761, 34762, 34766, 34773, 34774, 34777, 34778,
    34780, 34783, 34786, 34787, 34788, 34794, 34795, 34797, 34801, 34803,
    34808, 34810, 34815, 34817, 34819, 34822, 34825, 34826, 34827, 34832,
    34841, 34834, 34835, 34836, 34840, 34842, 34843, 34844, 34846, 34847,
    34856, 34861, 34862, 34864, 34866, 34869, 34874, 34876, 34881, 34883,
    34885, 34888, 34889, 34890, 34891, 34894, 34897, 34901, 34902, 34904,
    34906, 34908, 34911, 34912, 34916, 34921, 34929, 34937, 34939, 34944,
    34968, 34970, 34971, 34972, 34975, 34976, 34984, 34986, 35002, 35005,
    35006, 35008, 35018, 35019, 35020, 35021, 35022, 35025, 35026, 35027,
    35035, 35038, 35047, 35055, 35056, 35057, 35061, 35063, 35073, 35078,
    35085, 35086, 35087, 35093, 35094, 35096, 35097, 35098, 35100, 35104,
    35110, 35111, 35112, 35120, 35121, 35122, 35125, 35129, 35130, 35134,
    35136, 35138, 35141, 35142, 35145, 35151, 35154, 35159, 35162, 35163,
    35164, 35169, 35170, 35171, 35179, 35182, 35184, 35187, 35189, 35194,
    35195, 35196, 35197, 35209, 35213, 35216, 35220, 35221, 35227, 35228,
    35231, 35232, 35237, 35248, 35252, 35253, 35254, 35255, 35260, 35284,
    35285, 35286, 35287, 35288, 35301, 35305, 35307, 35309, 35313, 35315,
    35318, 35321, 35325, 35327, 35332, 35333, 35335, 35343, 35345, 35346,
    35348, 35349, 35358, 35360, 35362, 35364, 35366, 35371, 35372, 35375,
    35381, 35383, 35389, 35390, 35392, 35395, 35397, 35399, 35401, 35405,
    35406, 35411, 35414, 35415, 35416, 35420, 35421, 35425, 35429, 35431,
    35445, 35446, 35447, 35449, 35450, 35451, 35454, 35455, 35456, 35459,
    35462, 35467, 35471, 35472, 35474, 35478, 35479, 35481, 35487, 35495,
    35497, 35502, 35503, 35507, 35510, 35511, 35515, 35518, 35523, 35526,
    35528, 35529, 35530, 35537, 35539, 35540, 35541, 35543, 35549, 35551,
    35564, 35568, 35572, 35573, 35574, 35580, 35583, 35589, 35590, 35595,
    35601, 35612, 35614, 35615, 35594, 35629, 35632, 35639, 35644, 35650,
    35651, 35652, 35653, 35654, 35656, 35666, 35667, 35668, 35673, 35661,
    35678, 35683, 35693, 35702, 35704, 35705, 35708, 35710, 35713, 35716,
    35717, 35723, 35725, 35727, 35732, 35733, 35740, 35742, 35743, 35896,
    35897, 35901, 35902, 35909, 35911, 35913, 35915, 35919, 35921, 35923,
    35924, 35927, 35928, 35931, 35933, 35929, 35939, 35940, 35942, 35944,
    35945, 35949, 35955, 35957, 35958, 35963, 35966, 35974, 35975, 35979,
    35984, 35986, 35987, 35993, 35995, 35996, 36004, 36025, 36026, 36037,
    36038, 36041, 36043, 36047, 36054, 36053, 36057, 36061, 36065, 36072,
    36076, 36079, 36080, 36082, 36085, 36087, 36088, 36094, 36095, 36097,
    36099, 36105, 36114, 36119, 36123, 36197, 36201, 36204, 36206, 36223,
    36226, 36228, 36232, 36237, 36240, 36241, 36245, 36254, 36255, 36256,
    36262, 36267, 36268, 36271, 36274, 36277, 36279, 36281, 36283, 36288,
    36293, 36294, 36295, 36296, 36298, 36302, 36305, 36308, 36309, 36311,
    36313, 36324, 36325, 36327, 36332, 36336, 36284, 36337, 36338, 36340,
    36349, 36353, 36356, 36357, 36358, 36363, 36369, 36372, 36374, 36384,
    36385, 36386, 36387, 36390, 36391, 36401, 36403, 36406, 36407, 36408,
    36409, 36413, 36416, 36417, 36427, 36429, 36430, 36431, 36436, 36443,
    36444, 36445, 36446, 36449, 36450, 36457, 36460, 36461, 36463, 36464,
    36465, 36473, 36474, 36475, 36482, 36483, 36489, 36496, 36498, 36501,
    36506, 36507, 36509, 36510, 36514, 36519, 36521, 36525, 36526, 36531,
    36533, 36538, 36539, 36544, 36545, 36547, 36548, 36551, 36559, 36561,
    36564, 36572, 36584, 36590, 36592, 36593, 36599, 36601, 36602, 36589,
    36608, 36610, 36615, 36616, 36623, 36624, 36630, 36631, 36632, 36638,
    36640, 36641, 36643, 36645, 36647, 36648, 36652, 36653, 36654, 36660,
    36661, 36662, 36663, 36666, 36672, 36673, 36675, 36679, 36687, 36689,
    36690, 36691, 36692, 36693, 36696, 36701, 36702, 36709, 36765, 36768,
    36769, 36772, 36773, 36774, 36789, 36790, 36792, 36798, 36800, 36801,
    36806, 36810, 36811, 36813, 36816, 36818, 36819, 36821, 36832, 36835,
    36836, 36840, 36846, 36849, 36853, 36854, 36859, 36862, 36866, 36868,
    36872, 36876, 36888, 36891, 36904, 36905, 36911, 36906, 36908, 36909,
    36915, 36916, 36919, 36927, 36931, 36932, 36940, 36955, 36957, 36962,
    36966, 36967, 36972, 36976, 36980, 36985, 36997, 37000, 37003, 37004,
    37006, 37008, 37013, 37015, 37016, 37017, 37019, 37024, 37025, 37026,
    37029, 37040, 37042, 37043, 37044, 37046, 37053, 37068, 37054, 37059,
    37060, 37061, 37063, 37064, 37077, 37079, 37080, 37081, 37084, 37085,
    37087, 37093, 37074, 37110, 37099, 37103, 37104, 37108, 37118, 37119,
    37120, 37124, 37125, 37126, 37128, 37133, 37136, 37140, 37142, 37143,
    37144, 37146, 37148, 37150, 37152, 37157, 37154, 37155, 37159, 37161,
    37166, 37167, 37169, 37172, 37174, 37175, 37177, 37178, 37180, 37181,
    37187, 37191, 37192, 37199, 37203, 37207, 37209, 37210, 37211, 37217,
    37220, 37223, 37229, 37236, 37241, 37242, 37243, 37249, 37251, 37253,
    37254, 37258, 37262, 37265, 37267, 37268, 37269, 37272, 37278, 37281,
    37286, 37288, 37292, 37293, 37294, 37296, 37297, 37298, 37299, 37302,
    37307, 37308, 37309, 37311, 37314, 37315, 37317, 37331, 37332, 37335,
    37337, 37338, 37342, 37348, 37349, 37353, 37354, 37356, 37357, 37358,
    37359, 37360, 37361, 37367, 37369, 37371, 37373, 37376, 37377, 37380,
    37381, 37382, 37383, 37385, 37386, 37388, 37392, 37394, 37395, 37398,
    37400, 37404, 37405, 37411, 37412, 37413, 37414, 37416, 37422, 37423,
    37424, 37427, 37429, 37430, 37432, 37433, 37434, 37436, 37438, 37440,
    37442, 37443, 37446, 37447, 37450, 37453, 37454, 37455, 37457, 37464,
    37465, 37468, 37469, 37472, 37473, 37477, 37479, 37480, 37481, 37486,
    37487, 37488, 37493, 37494, 37495, 37496, 37497, 37499, 37500, 37501,
    37503, 37512, 37513, 37514, 37517, 37518, 37522, 37527, 37529, 37535,
    37536, 37540, 37541, 37543, 37544, 37547, 37551, 37554, 37558, 37560,
    37562, 37563, 37564, 37565, 37567, 37568, 37569, 37570, 37571, 37573,
    37574, 37575, 37576, 37579, 37580, 37581, 37582, 37584, 37587, 37589,
    37591, 37592, 37593, 37596, 37597, 37599, 37600, 37601, 37603, 37605,
    37607, 37608, 37612, 37614, 37616, 37625, 37627, 37631, 37632, 37634,
    37640, 37645, 37649, 37652, 37653, 37660, 37661, 37662, 37663, 37665,
    37668, 37669, 37671, 37673, 37674, 37683, 37684, 37686, 37687, 37703,
    37704, 37705, 37712, 37713, 37714, 37717, 37719, 37720, 37722, 37726,
    37732, 37733, 37735, 37737, 37738, 37741, 37743, 37744, 37745, 37747,
    37748, 37750, 37754, 37757, 37759, 37760, 37761, 37762, 37768, 37770,
    37771, 37773, 37775, 37778, 37781, 37784, 37787, 37790, 37793, 37795,
    37796, 37798, 37800, 37803, 37812, 37813, 37814, 37818, 37801, 37825,
    37828, 37829, 37830, 37831, 37833, 37834, 37835, 37836, 37837, 37843,
    37849, 37852, 37854, 37855, 37858, 37862, 37863, 37881, 37879, 37880,
    37882, 37883, 37885, 37889, 37890, 37892, 37896, 37897, 37901, 37902,
    37903, 37909, 37910, 37911, 37919, 37934, 37935, 37937, 37938, 37939,
    37940, 37947, 37951, 37949, 37955, 37957, 37960, 37962, 37964, 37973,
    37977, 37980, 37983, 37985, 37987, 37992, 37995, 37997, 37998, 37999,
    38001, 38002, 38020, 38019, 38264, 38265, 38270, 38276, 38280, 38284,
    38285, 38286, 38301, 38302, 38303, 38305, 38310, 38313, 38315, 38316,
    38324, 38326, 38330, 38333, 38335, 38342, 38344, 38345, 38347, 38352,
    38353, 38354, 38355, 38361, 38362, 38365, 38366, 38367, 38368, 38372,
    38374, 38429, 38430, 38434, 38436, 38437, 38438, 38444, 38449, 38451,
    38455, 38456, 38457, 38458, 38460, 38461, 38465, 38482, 38484, 38486,
    38487, 38488, 38497, 38510, 38516, 38523, 38524, 38526, 38527, 38529,
    38530, 38531, 38532, 38537, 38545, 38550, 38554, 38557, 38559, 38564,
    38565, 38566, 38569, 38574, 38575, 38579, 38586, 38602, 38610, 23986,
    38616, 38618, 38621, 38622, 38623, 38633, 38639, 38641, 38650, 38658,
    38659, 38661, 38665, 38682, 38683, 38685, 38689, 38690, 38691, 38696,
    38705, 38707, 38721, 38723, 38730, 38734, 38735, 38741, 38743, 38744,
    38746, 38747, 38755, 38759, 38762, 38766, 38771, 38774, 38775, 38776,
    38779, 38781, 38783, 38784, 38793, 38805, 38806, 38807, 38809, 38810,
    38814, 38815, 38818, 38828, 38830, 38833, 38834, 38837, 38838, 38840,
    38841, 38842, 38844, 38846, 38847, 38849, 38852, 38853, 38855, 38857,
    38858, 38860, 38861, 38862, 38864, 38865, 38868, 38871, 38872, 38873,
    38877, 38878, 38880, 38875, 38881, 38884, 38895, 38897, 38900, 38903,
    38904, 38906, 38919, 38922, 38937, 38925, 38926, 38932, 38934, 38940,
    38942, 38944, 38947, 38950, 38955, 38958, 38959, 38960, 38962, 38963,
    38965, 38949, 38974, 38980, 38983, 38986, 38993, 38994, 38995, 38998,
    38999, 39001, 39002, 39010, 39011, 39013, 39014, 39018, 39020, 39083,
    39085, 39086, 39088, 39092, 39095, 39096, 39098, 39099, 39103, 39106,
    39109, 39112, 39116, 39137, 39139, 39141, 39142, 39143, 39146, 39155,
    39158, 39170, 39175, 39176, 39185, 39189, 39190, 39191, 39194, 39195,
    39196, 39199, 39202, 39206, 39207, 39211, 39217, 39218, 39219, 39220,
    39221, 39225, 39226, 39227, 39228, 39232, 39233, 39238, 39239, 39240,
    39245, 39246, 39252, 39256, 39257, 39259, 39260, 39262, 39263, 39264,
    39323, 39325, 39327, 39334, 39344, 39345, 39346, 39349, 39353, 39354,
    39357, 39359, 39363, 39369, 39379, 39380, 39385, 39386, 39388, 39390,
    39399, 39402, 39403, 39404, 39408, 39412, 39413, 39417, 39421, 39422,
    39426, 39427, 39428, 39435, 39436, 39440, 39441, 39446, 39454, 39456,
    39458, 39459, 39460, 39463, 39469, 39470, 39475, 39477, 39478, 39480,
    39495, 39489, 39492, 39498, 39499, 39500, 39502, 39505, 39508, 39510,
    39517, 39594, 39596, 39598, 39599, 39602, 39604, 39605, 39606, 39609,
    39611, 39614, 39615, 39617, 39619, 39622, 39624, 39630, 39632, 39634,
    39637, 39638, 39639, 39643, 39644, 39648, 39652, 39653, 39655, 39657,
    39660, 39666, 39667, 39669, 39673, 39674, 39677, 39679, 39680, 39681,
    39682, 39683, 39684, 39685, 39688, 39689, 39691, 39692, 39693, 39694,
    39696, 39698, 39702, 39705, 39707, 39708, 39712, 39718, 39723, 39725,
    39731, 39732, 39733, 39735, 39737, 39738, 39741, 39752, 39755, 39756,
    39765, 39766, 39767, 39771, 39774, 39777, 39779, 39781, 39782, 39784,
    39786, 39787, 39788, 39789, 39790, 39795, 39797, 39799, 39800, 39801,
    39807, 39808, 39812, 39813, 39814, 39815, 39817, 39818, 39819, 39821,
    39823, 39824, 39828, 39834, 39837, 39838, 39846, 39847, 39849, 39852,
    39856, 39857, 39858, 39863, 39864, 39867, 39868, 39870, 39871, 39873,
    39879, 39880, 39886, 39888, 39895, 39896, 39901, 39903, 39909, 39911,
    39914, 39915, 39919, 39923, 39927, 39928, 39929, 39930, 39933, 39935,
    39936, 39938, 39947, 39951, 39953, 39958, 39960, 39961, 39962, 39964,
    39966, 39970, 39971, 39974, 39975, 39976, 39977, 39978, 39985, 39989,
    39990, 39991, 39997, 40001, 40003, 40004, 40005, 40009, 40010, 40014,
    40015, 40016, 40019, 40020, 40022, 40024, 40027, 40029, 40030, 40031,
    40035, 40041, 40042, 40028, 40043, 40040, 40046, 40048, 40050, 40053,
    40055, 40059, 40166, 40178, 40183, 40185, 40203, 40194, 40209, 40215,
    40216, 40220, 40221, 40222, 40239, 40240, 40242, 40243, 40244, 40250,
    40252, 40261, 40253, 40258, 40259, 40263, 40266, 40275, 40276, 40287,
    40291, 40290, 40293, 40297, 40298, 40299, 40304, 40310, 40311, 40315,
    40316, 40318, 40323, 40324, 40326, 40330, 40333, 40334, 40338, 40339,
    40341, 40342, 40343, 40344, 40353, 40362, 40364, 40366, 40369, 40373,
    40377, 40380, 40383, 40387, 40391, 40393, 40394, 40404, 40405, 40406,
    40407, 40410, 40414, 40415, 40416, 40421, 40423, 40425, 40427, 40430,
    40432, 40435, 40436, 40446, 40458, 40450, 40455, 40462, 40464, 40465,
    40466, 40469, 40470, 40473, 40476, 40477, 40570, 40571, 40572, 40576,
    40578, 40579, 40580, 40581, 40583, 40590, 40591, 40598, 40600, 40603,
    40606, 40612, 40616, 40620, 40622, 40623, 40624, 40627, 40628, 40629,
    40646, 40648, 40651, 40661, 40671, 40676, 40679, 40684, 40685, 40686,
    40688, 40689, 40690, 40693, 40696, 40703, 40706, 40707, 40713, 40719,
    40720, 40721, 40722, 40724, 40726, 40727, 40729, 40730, 40731, 40735,
    40738, 40742, 40746, 40747, 40751, 40753, 40754, 40756, 40759, 40761,
    40762, 40764, 40765, 40767, 40769, 40771, 40772, 40773, 40774, 40775,
    40787, 40789, 40790, 40791, 40792, 40794, 40797, 40798, 40808, 40809,
    40813, 40814, 40815, 40816, 40817, 40819, 40821, 40826, 40829, 40847,
    40848, 40849, 40850, 40852, 40854, 40855, 40862, 40865, 40866, 40867,
    40869,
]; // 6361 entries

/// Returns the index code point for pointer `code` in this index.
#[inline]
pub fn forward(code: u16) -> u32 {
    let code = premap_forward(code);
    let code = (code as usize).wrapping_sub(108);
    if code < 6361 {
        FORWARD_TABLE[code] as u32
    } else {
        X as u32
    }
}

#[cfg(not(feature = "no-optimized-legacy-encoding"))]
const BACKWARD_TABLE_LOWER: &'static [u16] = &[
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, 7109, X, 7110, 7111, 7112, 7113, X, 7114, X, X, X, X,
    X, X, 7115, 7116, X, X, X, X, X, X, 7117, X, 7118, X, X, 7119, X, X, 7120,
    X, 6536, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 6537, X, 6538, X,
    6539, 6540, 6541, X, X, X, X, X, X, X, X, 6064, 6065, 6067, X, 6068, 6069,
    X, 6066, X, X, X, 6070, 6071, X, X, 6072, X, X, X, X, X, X, X, 6073, 5581,
    X, X, X, X, X, X, X, X, X, 5582, 5583, 5584, 5585, 5586, X, X, 5587, 5588,
    5589, X, X, X, X, X, X, X, 5590, X, X, 5591, X, 4848, 4849, X, X, 4850, X,
    X, X, X, X, 4851, X, X, 4852, 4853, X, X, X, 4854, X, X, X, X, 4855, X, X,
    X, X, X, 4856, X, 3800, X, X, X, 3801, 3802, X, X, X, X, X, X, X, X, X, X,
    X, X, X, 3803, 3804, 3805, 3806, 3807, X, X, 3808, X, X, X, X, X, 3756, X,
    3757, 3758, X, 3759, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 3760, X,
    X, X, 3761, X, 2220, 2221, X, X, X, X, X, X, 2222, X, X, X, X, X, X, X, X,
    X, 2223, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 7199, 7200, 7201,
    7202, X, 7203, X, 7204, 7205, X, X, X, X, X, X, 7206, X, 6549, 6550, 6551,
    6552, X, X, X, X, 6553, X, X, X, X, X, X, X, 6554, X, X, X, X, 6555, X, X,
    X, 6556, X, X, 6557, X, 6558, 6130, X, X, X, 6131, 6132, 6133, X, 6134, X,
    X, X, X, 6135, X, X, 6136, X, X, X, 6137, X, 6138, 6139, 6140, X, 6141, X,
    6142, X, 6143, X, 5501, X, X, X, X, X, X, 5502, 5503, 5504, X, X, X, 5505,
    X, X, X, X, X, X, 5506, 5507, X, X, 5508, 5509, X, 5510, X, X, 5511, 5191,
    X, X, X, X, X, X, 5192, X, 5193, X, X, X, X, X, 5194, 5195, 5196, X, X,
    5197, X, X, X, X, X, X, X, X, 5198, X, X, 2918, X, 2919, X, X, 2920, X, X,
    2921, X, X, X, X, X, 2922, X, X, X, 2923, 2924, X, X, X, 2925, 2926, X, X,
    X, 2927, X, 1828, X, X, 1829, X, X, X, X, X, 1830, 1831, X, X, X, 1832, X,
    X, 1833, X, 1834, 1835, X, 1836, 1837, X, 1838, X, X, 1839, X, X, X, 4742,
    X, X, X, 4743, 4744, 4745, X, X, X, X, X, 4746, X, 4747, 4748, 4749, X, X,
    4750, X, X, X, X, X, X, 4751, 4752, X, 3503, X, 3504, X, X, 3505, 3506, X,
    X, X, X, X, X, 3507, X, X, 3508, X, X, X, X, X, 3509, X, 3510, X, X, X, X,
    X, 3511, 3484, X, 3485, 3486, X, X, X, X, 3487, 3488, X, X, 3489, 3490,
    3491, X, 3492, X, X, X, X, X, X, X, 3493, 3494, X, X, X, 3495, 3496, X,
    2070, 2071, X, X, X, X, 2072, X, X, 2073, X, 2074, X, X, X, X, 2075, X, X,
    X, 2076, X, X, X, X, 2077, 2078, X, 2079, X, X, X, 4873, 4874, X, X, 4875,
    X, X, X, X, X, X, X, 4876, X, X, 4877, 4878, X, X, X, X, X, X, X, 4879,
    4880, 4881, X, X, 2742, X, X, 2743, X, X, X, X, X, X, X, X, X, X, X, X,
    2744, X, X, 2745, X, X, 2746, X, X, X, 2747, 2748, X, X, X, 6464, X, 6465,
    X, X, 6466, X, 6467, X, 6468, X, X, X, X, X, X, X, X, 6469, X, X, X, 6470,
    X, X, 6471, X, X, 6472, 6014, 6015, X, 6016, X, X, X, 6017, X, X, X, X, X,
    X, X, 6018, X, 6019, 6020, 6021, 6022, 6023, X, X, 6024, X, X, X, X, 6025,
    6026, X, 5371, X, X, X, X, X, 5372, X, 5373, X, X, X, X, X, X, X, X, X, X,
    X, X, 5374, X, 5375, X, 5376, X, 5377, 5378, X, X, 3270, X, 3271, X, 3272,
    X, 3273, X, X, X, X, X, X, X, X, X, X, X, X, X, 3274, X, 3275, X, 3276, X,
    3277, X, X, X, X, 4125, X, X, X, 4126, X, 4127, 4128, X, X, X, 4129, X, X,
    X, X, 4130, X, X, X, X, X, 4131, 4132, 4133, X, X, 4134, 4084, 4085, X, X,
    X, 4086, 4087, 4088, X, 4089, X, X, X, X, X, 4090, 4091, 4092, 4093, X, X,
    X, X, X, 4094, 4095, 4096, X, 4097, X, X, 4098, 4006, X, 4007, X, X, 4008,
    4009, X, X, X, 4010, 4011, X, 4012, X, X, X, X, X, X, X, 4013, X, 4014, X,
    4015, X, X, 4016, 4017, X, 4018, 3980, X, X, X, X, X, 3981, 3982, X, 3983,
    X, 3984, 3985, X, 3986, 3987, X, 3988, X, X, X, X, X, 3989, X, 3990, X, X,
    3991, X, X, X, X, 6380, 6381, X, 6382, X, 6383, 6384, X, X, 6385, X, 6386,
    6387, 6388, X, 6389, 6390, X, 6391, X, X, X, 6392, X, X, 6393, X, 6394,
    5932, 5933, X, X, X, X, X, X, X, X, X, 5934, X, 5935, 5936, 5937, X, X, X,
    X, 5938, X, X, X, X, X, X, 5939, 5940, 5941, 5942, X, 5206, X, X, X, X,
    5207, X, X, X, 5208, X, X, X, X, 5209, X, 5210, X, X, X, 5211, X, X, X,
    5212, X, X, X, X, X, X, 3196, X, X, X, X, X, 3197, X, 3198, X, X, X, X, X,
    3199, X, 3200, X, X, X, X, 3201, X, X, X, X, X, 2989, X, 2990, X, X, X, X,
    X, X, X, 2991, 2992, 2993, X, X, X, X, X, X, 2994, 2995, X, 2996, X, 2997,
    X, 2998, 2797, X, X, X, X, 2798, X, X, 2799, X, 2800, X, X, 2801, X, X, X,
    X, X, X, X, X, X, X, 2802, 2803, X, X, 2804, X, X, X, X, 3624, X, X, X,
    3625, X, 3626, X, X, X, 3627, 3628, X, X, X, X, X, X, 3629, X, X, X, X,
    3630, X, 3631, X, 3632, 3769, X, X, X, X, 3770, 3771, 3772, X, X, X, X, X,
    3773, X, X, X, X, X, X, X, X, X, 3774, X, X, X, X, X, X, X, X, X, 2640, X,
    X, X, 2641, X, 2642, X, X, X, X, X, X, 2643, X, X, X, X, X, 2644, 2645, X,
    X, X, 6160, X, X, X, 6161, 6162, X, X, X, X, X, X, 6163, X, X, X, 6164, X,
    X, X, 6165, X, 6166, 6167, 6168, X, X, X, X, 1748, 1749, 1750, 1751, X, X,
    X, X, X, X, X, 1752, 1753, X, X, X, X, X, 1754, 1755, 1756, X, 1757, 1758,
    X, 1759, X, X, X, 4384, 4385, X, X, 4386, 4387, X, X, X, 4388, X, 4389, X,
    X, X, 4390, X, X, X, X, X, X, X, X, X, 4391, X, 4392, X, 2823, X, 2824,
    2825, X, X, 2826, X, X, X, X, X, X, X, X, X, X, X, 2827, X, 2828, X, X, X,
    X, X, X, 2829, X, X, X, X, 3652, 3653, X, X, 3654, 3655, X, 3656, X, X, X,
    3657, X, 3658, 3659, 3660, 3661, X, X, 3662, X, X, X, X, 3663, 3664, 3665,
    X, 2130, X, X, X, X, X, 2132, 2133, 2134, X, X, 2135, X, X, X, X, X, X, X,
    X, X, X, X, 2136, X, X, X, X, 2137, X, X, X, 4916, X, 4917, X, X, 4918, X,
    X, X, 4919, X, 4920, 4921, X, X, 4922, X, X, X, X, X, X, X, 4923, X, X,
    4924, 4925, 4926, 4761, 4762, X, X, X, X, X, 4763, 4764, X, X, X, X, 4765,
    X, X, X, 4766, X, 4767, X, X, X, 4768, X, 4769, 4770, X, 4771, 4772, X, X,
    2719, X, 2720, 2721, X, X, 2722, X, X, X, X, X, X, X, 2723, 2724, X, X, X,
    X, X, 2725, X, X, X, 2726, X, X, 2727, X, 1683, X, 1684, X, X, X, X, X, X,
    X, X, X, 1685, X, X, X, X, X, X, X, X, X, X, 1686, X, 1687, X, 1688, X,
    1689, 1690, 1424, 1425, X, X, 1426, X, X, 1427, X, X, X, X, X, X, X, X, X,
    1428, X, X, X, X, X, X, X, X, 1429, X, 1430, X, X, X, X, 2655, X, X, 2656,
    2657, 2658, X, 2659, X, X, X, X, 2660, 2661, 2662, 2663, 2664, X, X, X, X,
    X, X, X, X, X, 2665, X, 1501, 1502, X, 1503, 1504, X, X, X, 1505, 1506, X,
    1507, X, 1508, X, 1509, X, 1510, 1511, 1512, X, X, 1513, X, 1514, 1515, X,
    X, X, 1516, 1517, 847, 846, 849, 855, 848, 854, 752, 859, 863, 862, 865,
    864, 877, 876, 879, 878, X, 893, 895, 894, 897, 901, 896, X, 763, 912, 911,
    914, 913, 927, 767, 797, X, 6635, X, X, 6636, 6637, X, 6638, X, 6639, 6640,
    X, 6641, 6642, 6643, X, 6644, 6645, X, X, 6646, X, X, 6647, 6648, 6649, X,
    6653, X, 6650, 6651, X, 5859, X, 5860, X, X, X, X, X, 5861, X, X, X, X, X,
    X, X, X, 5862, X, X, X, X, 5863, X, X, X, 5864, X, X, X, X, X, 6086, X, X,
    6087, X, X, 6088, 6089, X, 6090, X, 6091, X, X, X, X, 6092, X, 6093, 6094,
    6095, X, 6096, X, X, X, X, 1674, X, 1675, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, 1676, X, X, 6058, X, 6059, X, X, X,
    6060, X, X, X, 6061, X, X, X, X, X, X, X, X, X, X, X, 6062, X, X, 6063, X,
    X, X, X, 117, 118, 534, X, 535, 536, 537, X, 540, X, 542, 545, 555, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 1518, X, X, X, X, 1519, X,
    1520, X, 1521, 1522, 1523, 1524, X, X, 5769, 5770, 5771, 5772, 5773, X,
    5774, X, X, X, X, 5779, X, X, X, X, 5775, 5776, 5777, X, X, X, X, 5778, X,
    X, X, X, 5780, X, 5018, X, X, 5020, 5021, 5022, X, X, X, X, 5023, X, X,
    5024, X, 5019, X, X, X, X, X, 5025, X, 5026, X, X, 5027, X, X, 5028, X,
    4170, X, X, X, 4171, X, X, X, X, X, X, X, X, X, X, 4172, X, 4173, 4174, X,
    4175, X, X, X, 4176, X, X, 4177, X, X, X, X, 6487, X, X, X, 6488, X, X, X,
    6489, 6490, 6491, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 6492, 6493,
    6494, 6029, 6030, X, X, 6031, 6032, 6033, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, 6034, 6035, X, 6036, X, X, X, X, X, 6037, X, 5407, X, X, X, X,
    5408, 5409, 5410, X, X, X, X, 5411, X, X, X, 5412, X, 5413, 5414, 5415, X,
    5416, 5417, 5418, X, X, X, X, X, 5419, 5125, X, 5126, X, 5127, X, X, X,
    5128, X, 5129, X, X, 5130, X, 5131, X, X, X, X, X, X, 5132, 5133, X, X, X,
    X, X, 5134, 5135, X, 4270, X, X, X, 4271, X, X, X, 4272, X, 4273, 4274, X,
    4275, X, X, X, X, X, 4276, X, X, X, X, 4277, X, X, X, X, X, X, 1904, X, X,
    X, 1905, X, X, 1906, 1907, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, 174, X, X, X, X, X, X, X, X, X, X, X, 6699, X, 6700,
    6701, X, 6702, X, X, X, 6703, X, X, 6704, 6705, X, 6706, 6707, X, X, X,
    6708, 6300, X, X, X, 6301, 6302, X, 6303, 6304, X, X, 6305, X, X, X, 6306,
    X, X, 6307, X, X, X, 6308, X, 6309, X, 6310, 6311, 6312, 6313, X, 6314,
    5718, X, X, 5719, X, X, 5720, X, X, X, X, 5721, X, X, X, 5722, 5723, X,
    5724, X, X, X, 5725, 5726, X, 5727, X, X, X, X, X, 5728, 5389, 5390, 5391,
    5392, 5393, X, X, X, X, 5394, X, X, 5395, X, X, 5396, X, X, X, X, X, 5397,
    5398, 5399, X, X, 5400, X, X, X, X, X, X, 5296, X, X, X, X, X, X, X, X,
    5297, 5298, 5299, 5300, 5301, X, X, 5302, X, X, 5303, X, X, 5304, 5305,
    5306, 5307, 4996, X, X, X, 4997, X, X, 4998, X, X, X, X, 4999, X, X, X,
    5000, X, X, X, X, 5001, X, X, X, X, 5002, X, 5003, X, X, X, 1654, X, X, X,
    1655, 1656, X, X, X, 1657, 1658, X, 1659, X, 1660, X, 1661, 1662, 1663, X,
    X, 1664, 1665, X, X, X, X, X, X, X, 2138, 2139, X, X, X, 2140, X, X, 2141,
    X, X, X, X, X, 2142, X, X, X, X, X, X, X, 2143, 2144, X, X, 6790, 6791,
    6792, X, X, X, X, X, X, 6793, 6794, X, X, X, 6795, 6796, X, X, X, X, 6797,
    X, X, X, X, X, X, X, 6798, X, 6189, X, X, X, X, 6190, X, 6191, X, X, X,
    6192, 6193, 6194, X, 6195, 6196, 6197, 6198, X, X, 6199, X, X, X, X, 6200,
    6201, 6202, X, 6203, 5651, X, X, X, X, 5652, X, X, X, X, X, X, X, X, X, X,
    5653, X, X, X, 5654, 5655, 5656, 5657, X, X, X, X, 5658, X, X, X, 2426, X,
    X, 2427, X, X, 2428, X, 2429, 2430, X, 2431, X, 2432, X, 2433, X, X, 2434,
    2435, X, X, X, X, X, X, X, X, X, X, 1925, 1926, X, X, X, X, X, X, 1927, X,
    X, 1928, 1929, X, X, X, X, 1930, 1931, 1932, X, X, X, 4753, X, X, 4754, X,
    X, X, 4755, X, X, 4756, X, X, X, 4757, X, X, X, X, X, X, X, X, X, X, 4758,
    4759, 4760, X, 3603, X, X, X, 3604, X, 3605, X, X, X, X, X, X, X, 3606,
    3607, X, X, X, X, X, X, X, X, X, X, X, 3608, X, X, X, X, 4625, X, X, X, X,
    4626, X, X, X, X, 4627, X, 4628, 4629, X, X, X, X, 4630, X, X, X, X, 4631,
    X, X, 4632, X, 3230, X, X, X, X, 3231, X, X, X, X, X, X, X, X, X, 3232, X,
    3233, X, X, X, 3234, 3235, X, 3219, X, X, X, X, X, X, X, 5265, X, X, 5266,
    X, X, X, X, 5267, 5268, 5269, 5270, X, X, X, X, 5271, X, X, 5273, 5274, X,
    5275, X, X, 3076, X, X, X, X, X, 3077, 3078, X, X, X, X, 3079, X, 3080, X,
    X, X, 3081, X, 3082, X, 3083, X, X, X, X, X, X, 3084, 3056, X, X, X, X, X,
    X, 3057, X, X, X, 3058, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 3059, X,
    X, 3060, X, X, 557, X, X, X, X, X, X, X, 554, 559, 556, 558, 561, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 3600, X, X, X,
    X, X, X, 3601, 3602, 3683, 3684, X, 3685, X, X, X, 3686, 3687, X, 3688, X,
    X, 3689, 3690, 3691, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    645, 646, 647, 648, 649, 650, 651, 652, 653, 654, 655, X, 656, 657, X,
    6939, X, X, X, X, X, 6940, 6941, X, X, X, X, X, 6942, X, 6943, X, X, X, X,
    X, X, 6944, 6945, X, X, X, X, 6946, X, 6947, 6745, 6746, X, X, X, X, 6747,
    6748, 6749, X, X, X, X, 6750, 6751, X, X, X, X, X, 6752, X, X, X, 6753,
    6754, X, 6755, 6756, X, 6757, 6758, 6336, 6337, X, 6338, X, 6339, X, 6340,
    6341, X, X, X, 6342, X, 6343, X, 6344, X, X, X, X, X, X, X, X, 6345, X,
    6346, X, X, X, 6347, 5889, X, X, X, X, 5890, 5891, 5892, 5893, X, 5894, X,
    X, X, 5895, X, X, 5896, X, X, 5897, 5898, X, 5899, X, 5900, X, X, X, X, X,
    X, 3426, X, 3428, 3427, X, X, 3429, X, X, X, 3430, X, X, X, 3431, 3432,
    3433, X, X, X, X, X, 3434, 3435, X, X, 1691, X, X, X, X, X, 1692, X, X, X,
    X, X, X, 1693, X, 1694, 1695, 1696, X, 1697, X, X, 1698, X, X, X, X, X,
    1699, X, X, 6079, X, X, X, 6080, 6081, X, X, X, X, 6082, X, X, X, 6083, X,
    X, X, 6084, X, X, X, X, 6085, X, X, X, X, X, X, 3464, X, X, X, 3465, X, X,
    3466, X, X, X, X, 3467, X, X, X, 3468, X, 3469, X, X, X, X, 3470, X, X,
    1715, X, X, X, X, X, 1716, X, X, X, X, X, X, X, X, 1717, 1718, X, X, 1719,
    X, X, X, X, X, X, 1720, X, X, X, X, 2850, X, X, X, X, X, X, X, X, 2851, X,
    2852, X, X, X, 2853, X, X, X, X, X, X, 2854, X, X, 2855, X, X, X, 6602, X,
    X, X, 6603, X, X, 6604, X, X, X, 6605, X, X, X, X, 6606, X, X, 6607, 6608,
    6609, X, X, 6610, X, 6611, X, 6612, 6227, 6228, X, X, 6229, 6230, 6231,
    6232, X, 6233, 6234, X, 6235, X, X, X, 6236, X, 6237, 6238, X, X, 6239, X,
    6240, X, X, X, 6241, 6242, X, X, 4298, X, X, X, X, X, 4299, X, X, X, X,
    4300, 4301, 4302, X, X, X, X, 4303, 4304, 4305, X, X, 4306, X, X, X, 4307,
    4308, X, 2772, X, X, X, 2773, 2774, X, X, 2775, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, 2776, X, 1812, X, 1813, X, 1814, X, X, X,
    X, X, X, 1815, 1816, X, X, X, X, 1817, X, X, X, X, X, X, 1818, X, X, X, X,
    1819, X, X, 6434, X, X, X, 6435, 6436, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, 6438, 6439, 6437, 6440, 6441, X, 6442, X, X, 4343, X, X, X, X,
    4344, X, X, 4345, X, X, X, 4346, 4347, X, 4348, X, X, X, 4349, X, X, X, X,
    X, X, X, X, 4350, X, 2815, 2816, X, X, 2819, X, 2817, X, 2818, X, X, 2820,
    2821, X, 2822, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    5659, 5660, 5661, 5662, 5663, X, X, X, X, X, X, X, X, 5982, X, X, X, X,
    5989, 5983, X, 5984, 5985, X, X, X, X, X, 5986, X, 5987, 5988, X, X, X, X,
    X, X, 6505, X, 6506, 6507, X, 6508, X, X, X, X, 6509, 6510, 6511, 6512, X,
    X, X, X, X, 6513, 6514, X, X, 6515, 6516, 6517, 6048, X, X, 6049, 6050, X,
    X, X, 6051, X, X, X, X, X, 6052, X, X, 6053, X, X, X, 6054, 6055, X, X, X,
    X, 6056, X, X, 6057, X, 5450, X, 5451, X, X, X, X, 5452, X, X, X, X, X,
    5453, 5454, X, 5455, 5456, X, X, X, X, X, X, 5457, 5458, X, 5459, 5460,
    5461, X, 4665, 4666, 4667, 4668, X, 4669, X, X, 4670, X, 4671, 4672, X,
    4673, 4674, X, X, X, X, X, X, X, X, X, 4675, X, 4676, X, X, X, X, X, 5757,
    5758, X, X, X, 5764, 5759, X, X, X, X, X, 5760, X, X, X, X, X, X, X, X, X,
    X, 5761, X, 5762, 5763, 5462, X, X, 5463, X, 5464, X, X, X, X, X, X, X,
    5465, X, X, X, X, X, X, X, X, X, X, 5466, X, X, X, X, 5467, X, X, 3444,
    3445, X, X, 3446, 3447, X, 3448, X, X, X, X, X, 3449, 3450, 3451, X, X, X,
    X, X, 3452, X, X, X, 3453, X, X, 3454, X, 1965, X, 1966, X, X, 1967, X, X,
    1968, X, 1969, 1970, X, 1971, X, X, 1972, 1973, 1974, X, X, X, 1975, 1976,
    X, X, 1977, X, X, 1978, X, X, 6693, 6694, X, 6695, 6696, X, X, X, 6697, X,
    6698, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, 5799, 5800, X, X, X, 5801, 5802, X, 5066, 5067, X, X, X, X, X, 5068, X,
    X, X, X, X, X, X, X, X, 5069, X, 5070, X, X, X, X, X, 5071, X, X, X, X, X,
    X, 5185, 5186, X, 5187, X, X, 5188, 5213, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, 5189, 5190, 4955, X, X, X, 4956, X, 4957, X, X, X, X, X, X,
    4958, X, X, X, 4959, X, X, X, 4960, X, X, X, X, X, X, X, X, X, X, X, 3259,
    X, X, 3260, 3261, 3262, 3263, 3264, X, X, 3265, X, X, X, 3266, 3267, 3268,
    3269, X, X, X, X, 4051, X, 4052, X, 4053, 4054, 4055, 4056, 4057, 4058,
    4059, 4060, 4061, 4062, X, X, X, X, X, X, X, 4063, X, X, X, X, X, X, X,
    6662, X, X, 6663, X, X, 6665, 6666, X, X, X, X, X, 6667, X, 6668, X, X,
    6664, X, X, 6669, X, 6670, X, 5911, X, X, 5912, 5913, 5914, X, X, X, X,
    5915, X, X, X, X, X, 5916, X, X, 5917, X, 5918, X, X, X, X, X, X, X, X, X,
    X, 2873, X, X, X, X, X, X, X, 2874, X, 2875, X, X, X, X, X, X, X, 2876,
    2877, X, X, X, 6772, X, X, X, X, X, 6773, X, X, X, X, X, X, X, X, X, 6774,
    6775, X, X, X, X, 6776, 6777, X, 6778, X, 6779, X, 6169, X, X, 6170, X, X,
    6171, X, X, X, X, X, 6172, X, X, X, X, X, X, 6173, X, X, X, X, 6174, 6175,
    6176, X, X, X, X, 2025, 2026, X, X, 2027, X, X, 2028, 2029, X, X, X, X, X,
    X, X, X, 2030, X, X, X, 2031, 2032, X, X, 2033, 2034, 2035, 1615, X, X,
    1616, 1617, X, X, 1618, X, X, X, X, 1619, X, 1620, X, 1621, X, X, 1622,
    1623, X, X, X, 1624, X, X, X, 1625, 1626, X, 1627, 792, 759, 791, 890, 984,
    892, 986, 891, 985, 793, 762, 794, 900, 994, X, X, 899, 993, 764, 796, 902,
    996, 904, 998, 903, 997, 905, 999, 906, 1000, 908, 1002, X, 6895, X, 6896,
    X, 6897, 6898, X, 6899, X, 6900, 6901, 6902, 6903, 6904, X, X, X, X, 6905,
    X, 6906, X, 6907, 6908, 6909, X, X, X, X, X, 6910, 6652, 6654, X, X, 6655,
    X, X, X, X, X, X, X, X, X, X, 6656, X, 6657, X, X, 6658, X, X, 6659, 6660,
    X, 6661, X, X, X, X, X, 1721, X, X, X, 1722, X, X, X, X, X, X, X, X, X, X,
    X, 1723, X, 1724, 1725, X, 1726, X, 1727, X, X, 1728, 1448, 1449, 1450, X,
    X, X, X, X, 1451, X, X, X, X, X, X, 1452, X, 1453, X, 1454, X, 1455, X, X,
    X, X, X, X, X, 1456, 1457, 1458, X, 7174, X, 7175, 7176, 7177, 7178, 7179,
    X, X, X, X, X, X, X, X, X, X, X, 7180, X, 7181, 7182, 7183, 7184, X, 7185,
    X, X, 7186, 7187, X, 6542, X, X, X, X, X, X, X, X, X, X, X, X, 6543, X, X,
    X, X, X, 6544, X, X, X, X, X, X, 6545, 6546, X, 6547, 6548, 6097, 6098,
    6099, X, X, 6100, X, X, X, X, X, X, X, X, X, X, 6101, X, 6102, 6103, 6104,
    X, 6105, X, X, X, X, X, X, 6106, 6108, X, 5468, X, X, 5469, 5470, X, X, X,
    X, X, X, X, X, X, 5471, X, 5472, 5473, X, X, X, X, X, X, X, X, 5474, X, X,
    X, X, X, 5865, X, X, X, 5866, X, X, 5867, X, 5868, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, 5869, 5569, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, 5570, X, 5571, 5572, 5573, X, X, 5574, 5330,
    X, 5331, X, X, 5332, X, 5333, X, X, X, X, X, 5347, X, X, X, X, X, X, 5334,
    X, 5335, 5336, 5337, X, X, X, 5338, 5339, 5340, 5341, 5082, X, X, 5083, X,
    X, X, 5084, X, X, X, X, X, 5085, X, X, X, X, X, X, 5086, X, X, X, X, X, X,
    5087, X, 5088, X, 5089, 4892, X, X, X, X, X, X, X, X, X, X, 4893, X, 4894,
    X, 4895, 4896, 4897, X, X, X, X, 4898, 4899, X, X, X, X, 4900, X, X, X,
    1638, X, X, 1639, 1640, 1641, X, X, 1642, 1643, 1644, 1645, X, 1647, X, X,
    X, X, X, X, 1648, X, 1649, X, 1650, 1651, 1652, 1653, X, X, 5964, X, X, X,
    X, 5965, X, 5966, X, X, X, 5967, 5968, X, X, X, X, 5969, X, 5970, X, X, X,
    X, 5971, 5972, X, X, X, X, X, 6948, X, 6949, X, X, 6950, 6951, X, X, X,
    6952, X, X, X, 6953, X, X, X, 6954, 6955, 6956, 6957, X, X, 6958, X, 6959,
    6759, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, 116, X, 6586, 6587, 6588, X, X, X, X, 6589, X, X,
    X, X, X, X, X, X, 6590, X, 6591, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    1470, X, X, 1471, X, 1473, X, 1474, X, 1475, X, 1476, X, 1477, X, X, 1478,
    X, X, 5342, X, X, X, X, 5343, X, X, 5344, 5345, X, X, 5346, X, X, X, X, X,
    X, X, X, X, 5348, X, 5349, X, X, X, X, 5350, 5090, 5091, X, 5092, 5093, X,
    X, 5094, X, 5095, 5096, X, X, X, 5097, X, X, 5098, X, X, 5099, X, 5100, X,
    5101, X, 5102, 5103, X, X, X, X, X, 5839, 5840, X, X, 5841, X, 5842, X, X,
    X, 5843, X, X, X, X, X, 5845, 5844, X, X, 5846, X, X, X, 5847, X, X, 3609,
    X, X, X, X, 3610, X, X, X, X, X, X, X, X, X, 3611, 3612, X, 3613, X, 3614,
    3615, 3616, X, X, X, X, X, X, X, X, 5200, X, 5201, X, X, X, X, X, X, X, X,
    X, X, X, 5202, X, 5203, 5204, X, X, 5205, X, X, X, 1820, X, X, X, 1821,
    1822, X, X, X, X, X, 1823, X, X, X, X, 1824, 1825, X, X, X, X, 1826, X, X,
    X, 1827, X, X, X, 4597, X, X, X, 4598, X, 4599, 4600, 4601, X, 4602, 4603,
    4604, 4605, 4606, X, X, 4607, X, X, X, X, X, X, X, X, 4608, X, 4609, 4512,
    X, 4513, X, X, 4514, X, X, X, X, 4515, 4516, X, 4517, X, X, X, 4518, X, X,
    X, X, X, X, 4519, X, X, X, 4520, X, X, X, 1431, X, X, X, X, 1432, 1433, X,
    X, X, X, X, X, X, X, X, X, 1434, 1435, X, X, X, 1436, X, X, X, X, X, 1437,
    X, 7064, X, X, X, X, X, X, X, X, 7065, X, 7066, X, 7067, X, X, 7068, X, X,
    X, 7069, X, X, X, 7070, X, X, 7071, X, X, 7072, 6858, 6859, 6860, 6861,
    6862, 6863, X, X, 6864, 6865, X, 6866, 6867, 6868, 6869, X, 6870, X, 6871,
    X, X, X, 6872, X, X, 6873, X, 6874, 6875, X, X, X, 3732, X, X, X, 3733,
    3734, X, X, 3735, 3736, 3737, X, X, 3738, X, 3739, 3740, 3741, X, 3742, X,
    X, X, 3743, X, X, X, X, 3744, 3834, X, X, X, X, X, X, X, X, X, X, 3835, X,
    3836, X, 3837, 3838, 3839, X, X, X, X, X, X, 3840, X, X, X, X, X, X, X, X,
    5434, X, X, X, X, 5401, X, X, X, 5402, X, X, X, X, 5403, X, 5404, X, 5405,
    X, 5406, X, X, X, 2157, 2158, X, X, X, 2159, 2160, X, X, 2162, 2163, X, X,
    X, X, X, X, X, X, X, X, X, X, X, 2164, X, X, 2165, 2166, 1840, X, X, X, X,
    1841, X, X, X, X, X, X, X, X, X, 1842, X, X, 1843, 1844, X, 1845, X, X, X,
    X, 1846, X, X, 1847, 1848, X, X, 6523, X, 6524, 6525, 6526, X, X, X, X, X,
    6527, X, X, X, X, 6528, X, 6529, X, X, X, 6530, 6531, 6532, 6533, X, 6534,
    6535, X, X, 4501, X, 4502, X, X, 4503, 4504, X, 4505, X, X, X, X, 4506, X,
    X, X, X, 4507, X, 4508, X, X, X, 4509, X, X, 4510, 4511, X, 2999, X, 3000,
    X, X, 3001, X, 3002, X, X, X, 3003, X, X, X, X, X, X, 3004, X, X, X, X, X,
    X, X, X, X, 3005, 3006, 3007, 2805, 2806, 2807, X, X, X, X, X, X, X, X, X,
    X, X, 2808, 2809, X, X, X, X, X, 2810, X, X, X, X, X, X, 2811, 2812, 2813,
    2814, 2619, X, X, X, 2620, 2621, X, 2622, X, X, X, X, X, 2623, X, X, 2624,
    X, X, X, 2625, X, X, X, 2626, X, X, 2627, X, X, X, X, X, 2224, 2225, X, X,
    X, X, 2226, 2227, X, X, X, X, X, 2228, 2229, 2230, X, X, X, X, X, X, X, X,
    2232, X, X, X, 5072, 5073, 5074, 5075, X, X, X, X, 5076, X, X, 5077, 5078,
    X, 5079, X, X, X, X, 5080, X, X, X, X, X, 5081, X, X, X, 1677, 1678, X, X,
    X, X, X, X, 1679, X, X, 1680, X, X, X, X, X, X, X, X, X, 1681, X, X, X, X,
    1682, X, X, X, 4351, X, X, X, X, X, 4352, X, X, X, X, X, X, X, 4353, 4354,
    X, X, 4355, X, X, X, 4356, X, X, X, X, 4357, 4358, 4278, X, X, X, X, X,
    4279, X, 4280, X, X, X, 4281, X, X, X, 4282, 4283, X, X, X, X, 4284, X, X,
    4285, X, X, 4286, X, X, X, X, 6683, X, X, 6684, X, X, 6685, X, X, X, X, X,
    X, 6686, 6687, 6688, X, X, 6689, 6690, X, 6691, 6692, X, X, X, X, X, 1794,
    X, 1795, 1796, 1797, X, 1798, 1799, 1800, X, X, 1801, X, 1802, X, X, 1803,
    X, X, X, X, X, X, 1804, 1805, 1806, X, X, 6204, 6205, X, 6206, X, X, X, X,
    X, X, X, X, X, X, X, X, X, 6207, 6208, X, X, 6209, X, 6210, 6211, X, X, X,
    6212, X, 5548, X, 5549, X, 5550, X, X, 5551, 5552, 5553, 5554, X, X, 5555,
    X, X, 5556, X, X, X, 5557, 5558, X, 5559, X, 5560, X, 5561, X, X, 5562,
    5308, 5309, 5310, X, 5311, X, X, X, X, X, X, 5312, X, X, X, 5313, X, X, X,
    X, X, X, X, X, X, 5314, 5315, 5316, X, 5317, X, 5318, 5010, 5011, X, X, X,
    X, X, 5012, 5013, 5014, X, X, X, 5015, X, 5016, X, X, X, X, X, X, X, 5017,
    X, X, X, X, X, X, X, X, 2398, 2399, X, X, 2400, 2401, X, 2402, X, 2403,
    2404, X, X, X, X, 2405, X, X, 2406, X, 2407, X, X, X, X, 3436, X, X, 3437,
    X, X, X, X, 3438, X, X, X, 3439, 3440, 3441, X, X, X, X, X, X, X, X, X,
    3442, 3443, X, X, 1700, X, X, 1701, X, X, X, X, X, X, X, X, 1702, X, X, X,
    1703, 1704, 1705, X, X, 1706, X, X, X, X, X, X, X, X, X, X, 3617, X, 3618,
    X, X, X, X, X, X, X, 3619, X, X, 3620, X, 3621, X, X, X, 3622, X, 3623,
    3745, X, X, X, X, 3746, 3747, 3748, 3749, X, X, X, X, X, 3750, 3751, 3752,
    X, X, X, X, 3753, 3754, X, X, X, X, X, 3755, X, X, X, X, 5674, 5675, X,
    5676, X, X, X, X, X, X, X, 5677, X, 5678, 5679, X, 5680, 5681, X, X, X, X,
    X, X, X, X, 5682, X, 4882, X, 4883, 4884, 4885, 4886, X, X, X, X, X, X,
    4887, X, X, X, 4888, X, X, X, X, X, X, X, X, X, X, X, 4889, 4890, 4891,
    4633, X, X, X, X, 4634, X, X, X, X, X, X, 4635, X, X, 4636, 4637, X, 4638,
    X, X, 4639, 4640, X, X, X, 4641, 4642, 4643, 4644, X, X, 2597, X, X, X,
    2598, 2599, 2600, X, X, X, X, X, 2601, X, X, X, X, X, X, X, X, X, X, 2602,
    X, X, 2603, 2604, X, X, X, 6109, 6110, 6111, X, 6112, 6113, X, X, X, 6107,
    X, X, X, X, X, 6122, X, X, 6114, X, 6115, 6116, 6117, X, X, 6118, 6119, X,
    6120, 5609, X, X, X, X, X, 5610, 5611, 5612, X, X, X, X, X, X, X, 5613,
    5614, 5615, X, X, 5616, X, X, X, 5617, 5618, X, X, X, 5619, X, 4857, X, X,
    X, X, 4858, 4859, X, X, 4860, X, X, 4861, X, X, X, 4862, X, X, X, 4863, X,
    X, 4864, X, 4865, X, X, 4866, 4867, X, 3841, X, X, X, 3842, 3843, 3844, X,
    X, 3845, 3846, X, X, X, X, 3847, X, 3848, X, X, X, X, 3849, X, X, 3850, X,
    3851, X, 3852, X, 2371, X, X, X, 2372, X, X, X, X, X, X, X, 2373, X, X, X,
    X, X, X, 2367, X, X, X, 2374, X, X, X, X, X, X, X, X, 4115, 4116, X, X,
    4117, X, X, X, 4118, X, X, 4119, X, X, X, X, 4120, X, 4121, 4122, X, X,
    4123, 4124, 4064, X, X, 4065, 4066, X, 4067, 4068, X, X, X, 4069, X, 4070,
    X, X, X, 4071, 4072, X, X, X, X, 4073, X, X, X, X, X, 4074, X, X, 2210, X,
    2208, X, X, X, 2211, X, X, X, X, 2212, 2213, X, 2214, X, 2215, X, 2216, X,
    2217, X, X, X, 2218, X, X, 2219, X, X, X, 5035, X, 5036, X, X, X, X, 5037,
    5034, X, X, 5038, 5039, X, X, X, X, X, 5040, X, 5041, X, X, X, 5042, X,
    5043, 5044, X, 4250, X, X, X, 4251, X, X, X, X, X, X, 4252, 4253, X, X, X,
    X, X, X, X, 4254, X, X, X, X, X, 4255, 4256, 4257, X, 4258, 4202, X, 4203,
    4204, 4205, X, X, 4206, 4207, X, 4208, X, 4209, X, X, 4210, X, X, 4211,
    4212, X, 4213, 4214, X, X, 4215, X, 4216, 4217, 4218, 4219, X, 2703, X, X,
    X, X, X, 2704, X, X, X, X, X, X, X, X, X, 2705, X, X, X, X, X, X, X, X, X,
    X, X, X, 2706, 2707, 2541, X, X, X, X, X, X, 2542, X, X, X, X, X, 2543, X,
    X, X, X, 2544, X, 2545, 2546, X, X, 2547, X, X, X, X, X, X, 2548, 2459, X,
    2460, 2461, X, X, 2462, X, X, X, 2463, X, X, X, X, X, X, X, 2464, X, 2465,
    2466, X, X, X, X, 2467, X, X, X, X, X, X, 4135, X, X, X, X, X, X, X, X, X,
    X, X, 4136, X, X, X, 4137, 4138, X, X, X, X, X, X, X, X, X, 2952, 2953, X,
    X, X, X, X, 2954, X, 2955, X, 2956, X, X, X, 2957, X, X, X, X, X, 2958, X,
    1856, X, X, X, X, X, 1857, 1858, X, 1859, X, X, X, X, 1860, X, 1861, X, X,
    1862, 1863, X, X, X, X, X, X, X, X, X, X, X, X, 1993, X, X, X, 1994, X, X,
    1995, X, 1996, X, 1997, X, 1998, X, 1999, 2000, 2001, X, 2002, 1606, 1607,
    1608, X, X, X, X, X, X, X, 1609, X, X, X, X, 1610, 1611, X, X, X, X, X, X,
    X, X, 1612, 1613, X, X, 1614, X, X, X, 4220, X, 4221, 4222, X, X, 4223, X,
    X, X, 4224, X, X, X, X, 4225, 4226, X, 4227, X, X, 4228, 4229, 4230, X,
    4231, X, X, X, X, 6559, 6560, 6561, X, X, 6562, X, X, X, X, 6563, 6564, X,
    X, X, 6565, X, X, X, X, X, X, 6566, X, X, X, X, X, X, 7012, X, X, X, X, X,
    X, X, X, X, X, X, 7013, X, X, X, X, 7014, X, 7015, X, X, X, X, X, X, 3522,
    3523, 3524, X, X, X, 3525, X, 3526, X, X, X, X, 3527, X, 3528, 3529, X, X,
    X, 3530, 3531, X, X, X, 3532, 3633, X, 3634, X, X, 3635, X, X, X, 3636, X,
    X, X, X, X, 3637, 3638, X, X, X, 3639, X, 3640, X, X, X, X, X, 3641, X, X,
    X, X, 4725, X, X, 4726, 4727, 4728, X, X, X, 4729, X, 4730, X, X, X, 4731,
    4732, 4733, X, 4734, X, 4735, 4736, X, X, 4737, X, X, 2708, X, X, X, 2709,
    X, 2710, X, 2711, X, X, X, 2712, X, X, 2713, X, 2714, X, 2715, X, X, 2716,
    X, X, X, X, 2717, 2718, X, 1590, X, 1591, 1592, X, 1593, X, X, X, 1594, X,
    X, X, 1595, 1596, 1597, X, 1598, 1599, 1600, X, 1601, X, X, X, X, 1602,
    1603, X, 1604, 1605, 874, 968, 873, X, 875, 969, 755, 787, 884, 978, 882,
    976, X, X, 883, 977, 881, 788, 757, 789, 885, 979, 886, 980, 790, 887, 981,
    889, 983, 888, 982, 760, X, 6833, X, 6834, X, X, 6835, X, 6836, X, X, X, X,
    X, 6837, X, 6838, X, 6839, X, X, 6840, 6841, 6842, X, X, X, 6843, 6844, X,
    X, X, 3497, 3498, X, X, X, X, 3499, X, X, 3500, X, X, X, X, X, X, X, X, X,
    3501, X, X, X, 3502, X, X, X, X, X, X, 4688, X, X, X, 4689, X, X, X, X, X,
    X, 4691, 4692, 4693, X, 4690, X, X, X, 4694, 4695, 4696, 4697, 4698, 4699,
    X, 3347, X, X, X, 3348, 3349, X, 3350, X, X, 3351, X, 3352, X, 3353, X, X,
    X, X, X, X, X, 3354, 3355, X, 3356, X, 3357, X, X, X, X, 4243, 4244, X, X,
    X, X, X, X, X, 4245, 4246, 4247, X, 4248, X, X, 4249, X, X, X, X, X, X, X,
    X, X, X, X, X, X, 1438, X, X, X, X, X, X, X, X, 1439, 1440, X, X, X, X, X,
    1441, X, X, X, 3971, X, X, X, X, X, X, X, X, X, 3972, X, X, 3973, X, 3974,
    X, X, X, 3975, X, 3976, X, X, X, X, 3977, 3978, 3979, 3883, X, X, X, X, X,
    X, 3884, 3885, 3886, X, X, X, X, X, X, X, X, X, 3887, X, X, X, 3888, X, X,
    3889, X, X, 3890, X, 3891, 3856, X, X, X, X, 3857, X, 3858, X, X, X, X,
    3859, X, X, X, X, X, 3860, X, X, X, X, X, X, X, 3861, 3862, X, X, X, X, X,
    3943, X, X, X, X, X, X, X, X, X, X, X, X, X, 3944, 3945, X, X, X, X, X,
    3946, 3947, X, X, 3948, X, 2511, X, 2512, X, X, X, X, 2513, X, 2514, X, X,
    X, X, X, X, X, 2515, 2516, 2517, 2518, X, X, X, 2519, X, 2520, X, X, X,
    2521, 2417, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 2418, X, 2419, X, X,
    2420, X, X, X, X, X, X, X, X, 2421, X, X, X, 5781, X, X, X, X, X, X, X, X,
    X, 5782, X, X, X, X, X, X, X, X, 5783, X, 5784, 5785, X, X, 5786, X, 5787,
    X, 5045, X, X, 5046, X, X, X, X, X, X, 5047, 5048, X, X, X, 5049, 5050,
    5051, X, X, 5052, 5053, X, 5054, 5055, X, X, X, 5056, X, 5057, 4812, X, X,
    X, X, X, X, X, 4824, X, X, X, X, X, X, X, 4825, 4826, X, X, X, 4827, X,
    4828, X, X, X, X, 4829, 4830, X, X, 2728, X, 2729, X, X, X, 2730, 2731,
    2732, 2733, X, X, 2734, 2735, X, X, X, X, 2736, 2737, X, X, X, 2738, X,
    2739, X, 2740, 2741, X, 1707, 1708, X, X, 1709, X, X, X, X, X, X, X, X, X,
    X, X, X, 1710, 1711, X, 1712, 1713, X, 1714, X, X, X, X, X, X, X, X, 3929,
    X, X, X, X, 3930, 3931, X, X, 3932, X, X, 3933, X, X, X, X, X, X, X, X, X,
    3934, X, 2477, X, X, X, X, 2478, X, X, X, X, X, X, 2479, X, X, X, X, 2480,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 3717, X, 3718, 3719, 3720, X,
    X, X, 3721, X, 3722, 3723, X, X, 3724, 3725, X, 2161, X, X, 2145, X, 2146,
    2147, X, 2148, X, X, X, 2149, X, X, 2150, X, X, X, X, 2151, 2152, X, 2153,
    X, X, X, X, 2154, 2155, 2156, 1782, X, X, 1783, X, X, X, X, X, X, 1784,
    1785, 1786, X, X, X, X, 1787, X, 1788, X, X, X, X, 1789, X, X, 1790, 1791,
    X, 1792, 1793, 1459, X, 1460, 1461, X, X, X, X, 1462, X, X, 1463, 1464, X,
    X, X, X, X, 1465, X, X, 1466, 1467, 1468, X, 1469, X, X, X, X, X, X, X,
    109, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 108, 111, 115, 114, X,
    112, X, X, X, 3825, 3826, 3827, 3828, 3829, X, X, X, 3830, 3831, X, X,
    3832, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 3833, X, 2280, X, 2281,
    2282, X, X, X, 2283, X, 2284, X, X, 2285, X, X, X, X, 2286, X, X, X, X, X,
    X, X, X, X, X, 2287, 2288, 2289, 2080, X, 2081, 2082, 2083, 2084, X, X, X,
    2085, 2086, X, 2087, X, 2088, 2089, X, X, X, 2090, 2091, X, X, X, X, X, X,
    X, X, 2092, 2093, 2094, 1736, X, 1737, X, X, 1738, X, X, X, X, 1739, X,
    1740, X, X, X, X, X, X, 1741, X, 1742, 1743, 1744, 1745, X, 1746, X, 1747,
    X, X, X, X, 2868, X, X, X, X, X, X, X, X, X, 2869, X, X, X, X, X, X, 2870,
    2871, X, X, X, 2872, X, X, X, X, X, X, 4579, X, X, 4580, X, X, 4581, X,
    4582, X, X, 4583, X, X, X, X, X, X, X, X, X, 4584, X, X, X, X, X, 5216, X,
    5217, 5218, X, 5219, X, X, 5220, X, 5221, X, 5222, 5223, X, X, X, 5224, X,
    5225, 5226, 5227, X, 5228, X, X, X, 1864, 1865, X, X, 1866, X, X, X, X, X,
    1867, X, 1868, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 1869, X, X, 6579,
    6580, X, 6581, X, X, X, 6582, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, 6583, 6584, X, 6585, X, X, 4521, 4522, X, X, X, 4523, X, 4524, 4525, X,
    4526, X, X, X, X, 4527, X, X, X, 4528, X, X, X, X, X, 4529, X, X, 4530, X,
    3028, X, X, 3029, X, X, X, 3030, 3031, 3032, X, X, X, X, 3033, X, X, X,
    3034, 3035, X, 3036, X, X, 3037, X, 3038, X, X, 3039, 3040, 2943, X, X, X,
    X, 2944, X, X, X, X, 2945, X, 2946, X, X, X, X, X, 2947, 2948, X, 2949, X,
    X, 2950, 2951, X, X, X, X, X, X, X, 4594, X, X, X, X, X, X, X, X, X, X, X,
    X, 4595, X, X, X, X, X, X, X, X, X, X, 4596, 4439, X, X, X, X, X, 4445, X,
    X, X, X, X, 4446, X, X, X, 4447, X, X, X, X, X, X, X, X, X, 4448, X, 4449,
    X, 4450, 4451, 4393, 4394, X, 4395, 4396, X, X, X, 4397, X, 4398, X, X, X,
    4399, X, X, X, X, X, X, X, X, X, X, X, 4400, X, X, X, 4401, X, 2894, 2895,
    2896, 2897, X, 2898, X, X, X, 2899, 2900, X, X, 2901, X, X, X, 2902, 2903,
    2904, X, X, X, 2905, X, X, 2906, X, X, X, X, X, 2595, X, X, X, X, X, 2596,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    3881, X, X, X, X, X, 3882, X, 2375, X, X, X, X, X, X, X, X, X, 2376, 2377,
    X, X, X, X, X, 2378, X, X, X, 2379, X, X, X, X, X, X, X, 2380, X, X, 7041,
    7040, X, 7042, X, X, X, 7043, 7044, 7045, X, X, X, X, 7046, X, X, X, X, X,
    7047, 7048, X, X, X, 7049, 7050, X, 7051, X, 6473, X, 6474, X, X, X, X,
    6475, X, X, 6476, X, 6477, 6478, 6479, X, 6480, 6481, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, 7024, 7025, X, 7026, 7027, 7028, X, X, X, X, X,
    7029, X, 7030, 7032, X, X, 5029, X, X, X, X, X, X, X, X, X, X, X, 5030, X,
    X, X, 5031, X, 5032, X, X, X, X, X, X, 5033, X, X, X, X, X, 5803, X, 5804,
    X, 5805, X, 5806, X, X, X, 5807, X, 5808, X, 5809, 5810, X, X, 5811, 5812,
    5815, X, 5813, X, 5814, X, X, 3563, X, X, X, 3564, X, X, X, X, X, X, 3565,
    X, 3566, 3567, 3568, 3569, X, 3570, X, 3571, X, X, X, 3572, X, 3573, X, X,
    X, X, 4542, 4543, X, 4544, 4545, X, X, X, 4546, X, X, X, X, X, X, X, X,
    4547, 4548, X, X, 4549, X, X, 4550, 4551, X, 4552, 4452, X, X, X, X, 4453,
    X, 4454, X, 4455, X, X, X, 4456, X, X, X, 4457, X, X, 4458, 4459, X, X, X,
    X, X, 4460, X, 4461, X, 4462, 4433, 4434, X, X, 4430, X, 4435, X, X, X,
    4436, X, X, X, X, X, X, X, 4437, 4438, X, X, 4440, 4441, X, X, 4442, 4443,
    X, X, X, 4444, 4359, X, X, X, 4360, X, 4361, X, X, X, 4362, X, 4363, X, X,
    X, 4364, 4365, X, X, 4366, X, X, X, 4367, X, X, 4368, X, X, X, X, X, 4773,
    X, 4774, X, X, 4775, X, X, X, X, X, 4776, X, X, X, X, X, X, X, 4777, X,
    4778, 4779, X, X, X, 4780, 4561, X, 4562, X, X, 4563, 4564, X, X, X, 4565,
    4566, X, X, X, X, 4567, 4568, X, X, 4569, X, X, X, X, X, X, X, X, X, 4570,
    X, 3103, 3104, 3105, 3106, X, 3107, X, X, 3108, 3109, 3110, 3111, X, 3112,
    X, 3113, 3114, X, 3115, X, X, X, 3117, X, 3116, X, X, X, X, X, X, X, 4927,
    4928, X, 4929, X, X, 4930, 4931, 4932, X, 4933, X, 4934, 4935, X, 4936, X,
    X, X, X, X, X, 4937, 4938, 4939, 4831, X, X, X, X, X, X, 4832, 4833, X, X,
    X, 4834, 4835, X, 4836, X, X, X, 4837, X, X, 4838, X, X, X, X, X, X, X, X,
    4839, 4571, X, X, 4572, X, X, X, X, X, X, X, X, 4573, X, X, X, X, X, X,
    4574, X, 4575, X, X, X, 4576, X, 4577, 4578, X, X, X, 1444, X, X, X, X, X,
    X, X, X, X, X, X, X, 1445, X, X, X, X, X, X, X, X, X, 1446, 1447, X, X, X,
    X, X, 1983, X, X, 1984, X, 1985, X, X, 1986, 1987, 1988, 1989, 1990, 1991,
    X, X, X, X, X, X, 1992, X, X, X, X, X, X, X, 2680, X, X, 2681, X, X, 2682,
    X, X, X, X, X, 2683, 2684, X, X, 2685, 2686, X, 2687, X, X, X, X, 2688,
    2536, X, X, X, 2537, X, X, X, X, 2538, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, 2539, 2540, X, X, X, X, X, X, X, 4421, 4422, 4423, X, X, 4424, X,
    4425, X, X, X, 4426, 4427, X, 4428, 4429, X, X, X, X, 4431, X, X, X, 4432,
    4334, X, X, X, 4335, X, X, X, X, X, X, X, 4336, 4337, X, X, X, X, X, X,
    4338, 4339, 4340, X, X, X, 4341, X, X, X, X, 4342, 4259, X, 4260, 4261,
    4262, 4263, 4264, 4265, 4266, X, 4267, X, X, 4268, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, 4269, X, X, 2439, 2440, X, X, X, 2441, 2442, 2443, X,
    X, X, 2444, X, X, 2445, X, X, X, 2446, 2447, X, X, X, X, 2448, 2449, 2450,
    2451, X, X, X, 5816, 5817, X, 5818, X, 5819, 5820, X, X, X, 5821, X, X, X,
    X, X, 5822, X, 5823, 5824, X, X, X, X, 5825, X, X, 5826, X, 5147, 5148, X,
    X, X, X, X, X, X, X, X, 5149, 5150, 5151, X, 5152, X, X, 5153, X, X, X,
    5154, X, X, 5155, X, 5156, 5157, X, X, 2763, X, X, X, X, X, X, X, 2764,
    2765, X, X, X, X, 2766, 2767, X, X, X, 2768, 2769, 2770, X, 2771, X, X, X,
    X, X, X, X, 4474, X, 4475, X, 4476, X, X, X, X, X, X, 4477, X, X, X, X, X,
    X, 4478, X, 4479, 4480, X, 4481, X, 2934, X, X, X, 2935, X, X, 2936, X, X,
    X, X, X, 2937, X, X, 2938, X, 2939, 2940, 2941, X, X, X, X, X, X, 2942, X,
    X, X, X, 3809, X, X, X, X, X, X, 3810, X, X, X, X, 3811, 3812, X, X, 3813,
    X, X, 3814, X, X, X, X, X, X, X, X, X, 2887, 2888, X, X, 2889, X, X, X, X,
    X, X, X, 2890, 2891, X, X, 2892, X, X, 2893, X, X, X, X, 3793, 3794, X, X,
    X, X, X, X, 3795, X, 3796, X, X, X, X, X, X, 3797, 3798, X, X, X, X, X, X,
    X, 3799, X, 2252, X, 2253, X, X, X, X, X, X, X, 2254, X, 2255, X, 2256, X,
    X, 2257, X, X, 2258, 2259, X, X, 2260, X, 2261, 2262, X, X, X, X, 3018,
    3019, X, X, X, 3020, 3021, X, X, 3022, X, X, 3023, X, X, X, X, 3024, X,
    3025, X, X, X, 3026, X, X, X, 3027, 2830, X, 2831, 2832, X, X, X, 2833, X,
    2834, X, 2835, X, X, X, X, X, X, X, X, X, X, X, X, X, 2836, X, X, X, 2837,
    X, X, X, 6483, 6482, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, 4869, 4868, 4870, 4871, 4872, 4615, X, X, X,
    4616, X, 4617, X, X, 4618, 4619, X, X, 4620, X, 4621, X, X, 4622, 4623, X,
    X, X, 4624, X, X, X, X, X, X, X, X, X, 6575, X, X, X, X, X, 6576, X, 6577,
    X, X, X, X, X, X, X, X, 6578, X, X, X, X, X, X, 7130, X, 7131, X, X, 7132,
    X, X, X, X, X, X, X, X, X, 7133, X, X, X, X, X, X, X, X, X, 7134, 6911, X,
    X, X, 6912, 6913, 6914, 6915, X, 6916, 6917, 6918, X, 6919, X, 6920, 6921,
    X, X, X, 6922, X, X, X, X, X, 6923, X, X, 6924, 6925, X, 6408, X, 6409,
    6410, X, 6411, X, 6412, 6418, X, 6413, X, X, X, X, X, X, X, X, 6414, 6415,
    6416, X, X, X, 6417, X, X, X, X, X, X, 6926, 6927, X, 6928, X, X, 6929, X,
    X, X, 6930, 6931, 6932, X, X, X, X, 6933, 6934, X, X, 6935, 6936, X, 6937,
    6938, 6671, X, X, 6672, X, 6681, 6673, X, X, X, X, 6674, X, X, 6675, 6676,
    6677, X, 6678, 6679, X, 6680, X, X, X, X, X, X, X, X, 6682, X, 5943, 5944,
    X, X, X, X, X, X, 5945, X, X, 5946, 5947, X, 5948, 5949, 5950, X, X, X, X,
    X, X, X, 5951, 5952, 5953, X, X, X, X, X, 6121, X, X, X, X, X, 6124, X, X,
    X, 6125, 6126, X, X, X, 6127, X, 6123, X, X, X, X, X, X, X, 6128, 6129,
    5620, X, 5621, X, X, 5622, 5623, X, X, 5624, X, X, X, X, X, 5625, X, X,
    5626, X, X, X, X, 5627, X, X, 5628, 5629, 5630, X, X, X, 2322, X, 2323, X,
    2324, X, X, X, X, X, 2325, X, X, X, X, X, X, X, X, X, 2326, X, X, 2327,
    2328, X, X, 2329, X, X, 7033, 7034, X, 7031, X, 7035, X, X, 7036, X, X, X,
    X, X, X, X, X, 7037, 7038, X, X, X, X, X, X, X, X, X, X, 7039, 6845, X, X,
    X, 6846, 6847, X, 6848, X, 6849, X, X, 6850, X, X, X, X, X, 6851, 6852, X,
    6853, X, X, X, 6854, 6855, X, X, 6856, X, 6857, 6613, X, X, X, X, X, X, X,
    X, 6614, X, X, X, X, X, X, X, X, X, X, X, 6615, 6616, 6617, X, 6618, 6619,
    X, X, X, 6620, 6621, 6259, X, 6260, 6261, X, X, 6262, 6263, X, X, 6264, X,
    X, 6265, 6266, 6267, X, 6268, X, X, X, X, X, X, 6269, 6270, X, X, 6271,
    6272, X, X, 4309, X, X, 4310, 4311, X, X, X, 4312, X, X, 4313, 4314, 4315,
    X, X, 4316, X, X, X, 4317, 4318, X, X, X, X, 4319, X, 4320, 4321, 4233,
    4234, X, 4235, 4236, 4237, X, X, X, 4238, 4232, 4239, X, X, X, X, X, X, X,
    X, X, 4240, X, X, X, 4241, X, X, X, X, X, 4242, 4183, 4184, X, X, 4185, X,
    4186, X, X, X, X, X, 4187, X, 4188, 4189, X, X, X, X, X, X, X, 4190, X, X,
    X, X, 4191, X, X, 4192, 4193, 4194, X, X, 4195, X, X, 4196, X, X, X, X,
    4197, X, 4198, 4199, X, 4200, X, X, X, X, X, X, X, 4201, X, X, X, X, X, X,
    X, 6780, X, X, 6781, 6782, 6783, X, X, X, 6784, X, X, X, 6785, 6786, X, X,
    X, 6787, X, X, X, 6788, 6789, X, 6177, X, 6178, X, 6179, 6180, X, X, X,
    6181, X, X, X, 6182, X, X, 6183, X, 6184, 6185, 6186, X, X, 6187, X, X, X,
    X, X, 6188, X, 5523, X, 5524, X, X, 5525, X, X, 5526, 5527, 5528, X, X, X,
    X, 5529, X, 5531, 5532, 5533, X, X, X, 5534, 5530, 5535, 5536, 5537, X,
    5538, 5539, 5257, X, 5258, X, X, X, X, 5259, 5260, X, X, X, 5261, X, X,
    5262, X, X, X, 5263, X, X, X, X, X, X, X, X, 5264, X, X, X, 1960, 1961, X,
    X, X, X, X, X, X, X, 1962, X, X, X, X, 1963, X, X, X, X, X, X, X, X, X, X,
    X, X, 1964, 1566, 1567, 1568, X, X, 1569, 1570, X, X, X, 1571, X, 1572, X,
    1573, X, X, 1574, 1575, 1576, X, X, X, 1577, X, 1578, X, X, X, X, X, 1579,
    852, 946, 850, 944, 853, 947, 856, 950, 857, 951, 860, 954, 858, 952, 861,
    955, 753, 785, 868, 962, X, X, 867, 961, 869, 963, 866, 960, 871, 965, 872,
    966, X, 6811, X, X, 6812, X, X, 6810, X, X, 6813, 6814, 6815, X, 6816, X,
    X, 6817, X, X, 6818, X, 6819, X, X, X, X, X, X, 6820, X, X, 4645, X, X,
    4646, X, X, 4647, X, 4648, X, X, X, X, X, X, X, X, X, 4649, X, 4650, 4651,
    X, 4652, 4653, 4654, X, X, X, X, X, 5664, X, X, X, 5665, X, 5666, X, 5667,
    X, X, X, 5668, X, 5669, X, X, 5670, X, X, 5671, X, X, X, 5672, X, 5673,
    5359, X, X, X, 5360, 5361, X, X, X, X, X, X, X, 5362, 5363, X, 5364, 5365,
    5366, X, X, X, X, X, 5367, 5368, X, 5369, X, X, 5370, X, 4531, X, X, X, X,
    X, 4532, X, X, X, 4533, X, 4534, X, 4535, 4536, X, X, X, 4537, 4538, X, X,
    4539, 4540, 4541, X, X, X, X, X, X, 4795, 4796, X, X, 4797, X, X, X, X, X,
    X, X, X, 4798, X, X, 4799, 4800, X, 4801, X, X, X, X, X, X, 2036, 2037,
    2038, 2039, X, 2040, 2041, 2042, X, X, X, 2043, X, 2044, X, X, X, 2045, X,
    X, X, X, X, X, 2046, X, X, 6721, X, X, X, X, 6722, 6723, X, X, X, X, X, X,
    X, X, 6724, X, X, X, 6725, 6726, 6727, X, X, 6728, 6729, 6730, X, X, 6731,
    6315, 6316, 6317, 6318, X, 6319, 6320, 6321, 6322, X, X, 6323, 6324, 6325,
    6326, X, 6327, X, X, 6328, X, 6329, X, 6330, 6331, 6332, X, X, 6333, 6334,
    X, 6335, 5879, X, X, X, X, X, 5880, X, X, X, X, 5881, 5882, X, X, 5883, X,
    X, 5884, X, X, 5885, X, 5886, X, 5887, X, 5888, 5906, X, X, X, 2878, 2879,
    X, X, X, X, X, 2880, 2881, X, 2882, X, X, 2883, X, X, 2884, X, X, 2885, X,
    2886, X, X, X, X, X, X, X, X, 4655, X, 4656, X, X, X, X, X, X, X, 4657, X,
    4658, 4659, X, X, 4660, 4661, 4662, X, 4663, X, 4664, X, 3278, X, 3279, X,
    3280, X, X, X, 3281, 3282, X, X, X, 3283, X, X, X, 3284, X, X, X, X, X, X,
    X, X, 3285, X, X, X, X, X, 3286, X, X, 3287, X, X, X, 3288, X, X, 3289,
    3290, 3291, X, 3292, X, X, 3293, X, X, 3294, X, X, 3295, 3296, X, X, 1559,
    X, X, X, X, 1560, X, X, X, X, X, X, 1561, X, 1562, X, 1563, 1564, X, 1565,
    X, X, X, X, X, 1589, X, X, X, X, X, 2047, X, X, X, 2048, 2049, 2050, 2053,
    2054, X, 2051, 2052, X, X, X, X, X, X, X, X, 2055, X, X, 2056, 2057, X,
    2058, 1729, 1730, X, X, X, X, 1731, X, X, X, X, X, X, X, 1732, X, X, X, X,
    X, X, X, X, 1733, 1734, 1735, X, X, X, X, X, X, X, 2452, 2453, X, 2454, X,
    X, X, X, 2455, X, X, 2456, X, X, X, X, X, X, X, X, X, X, 2457, X, 2458,
    2338, X, 2339, X, X, X, X, 2340, X, X, X, X, 2341, X, X, X, X, 2342, 2343,
    2344, X, 2345, X, X, 2346, X, 2347, 2348, X, X, X, 2349, 2188, 2189, X, X,
    X, X, X, 2190, 2191, 2192, 2193, X, 2194, 2195, X, 2196, 2197, X, X, X,
    2198, X, 2199, X, X, X, X, X, X, 2200, X, X, X, 4989, X, X, X, X, X, X, X,
    4990, X, X, X, X, X, X, X, X, X, X, 4991, 4992, 4993, X, X, X, 4994, X,
    4995, X, 4161, X, X, X, X, X, X, X, X, X, X, X, X, X, 4162, X, 4163, X, X,
    X, X, X, X, X, 4164, 4165, 4166, 4167, 4168, 4169, X, 2666, 2667, X, X, X,
    X, X, 2668, 2669, 2670, X, 2671, 2672, 2673, 2674, X, X, 2675, 2676, X, X,
    2677, X, X, X, 2678, X, 2679, X, X, X, X, 3582, X, X, 3583, X, X, 3584, X,
    X, X, 3585, 3586, X, 3587, X, 3588, X, X, X, X, X, X, 3589, X, X, X, X, X,
    X, 4711, 4712, X, X, X, X, X, X, X, 4713, X, X, X, X, 4714, X, X, X, X, X,
    X, X, X, X, 4715, X, 3406, X, 3407, X, X, 3408, 3409, X, 3410, X, 3411, X,
    X, X, X, X, 3412, X, X, X, X, X, X, X, X, X, 3413, X, 3414, 3415, 3416,
    3342, X, X, X, X, X, X, X, X, X, X, X, X, 3343, X, X, X, X, 3344, X, X, X,
    3345, X, 3346, X, X, X, X, X, X, X, X, 4971, X, X, X, X, 4972, X, 4973, X,
    X, 4974, X, 4975, 4976, X, 4977, 4978, X, X, X, X, X, X, X, X, 5540, X, X,
    X, X, 5541, 5542, X, 5543, X, 5544, X, X, 5545, X, X, X, X, 5546, X, 5547,
    X, X, X, 2290, 2291, X, X, 2292, X, X, X, X, X, X, 2293, 2294, X, 2295,
    2296, X, 2297, X, X, 2298, X, X, X, X, X, X, X, X, X, X, 6821, X, 6822, X,
    6823, 6824, X, X, 6825, X, 6826, 6827, 6828, X, X, 6829, X, 6830, X, X,
    6831, 6832, 6518, X, X, X, 6519, X, 6520, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, 2436, 2437, X, 2438, X, X, X, X,
    3455, X, X, X, 3456, X, X, 3457, 3458, X, X, 3459, X, X, X, X, X, 3460,
    3461, X, X, X, X, 3462, X, X, X, 3463, 3379, X, X, X, 3380, X, X, X, 3381,
    X, X, X, X, X, X, X, 3382, X, 3383, X, 3384, X, X, 3385, X, X, X, 3386, X,
    X, 3387, 3388, 3220, X, 3221, 3222, X, 3223, X, X, 3224, 3225, X, X, X, X,
    X, X, X, X, 3226, X, X, X, X, 3227, X, 3228, X, X, 3229, X, X, X, X, 3923,
    X, X, X, X, 3924, X, X, X, 3925, 3926, X, X, X, X, 3927, X, X, X, X, X, X,
    X, 3928, X, X, X, X, X, 4019, 4020, X, X, 4021, X, 4022, 4023, X, X, 4024,
    X, X, 4025, 4026, X, X, 4027, X, X, 4028, X, X, X, 4029, X, X, 2100, X, X,
    2101, X, 2102, 2103, X, X, 2104, X, 2105, 2106, 2107, 2108, 2109, X, 2110,
    2111, 2112, X, 2113, X, 2114, 2115, 2116, 2117, X, 2118, X, X, 6732, X, X,
    X, 6733, 6734, X, X, X, 6735, X, X, X, X, X, 6736, 6737, 6738, 6739, 6740,
    X, X, X, 6741, 6742, 6743, 6744, X, X, X, 3329, 3330, 3331, 3332, X, 3333,
    3334, X, X, 3335, X, X, X, 3336, 3337, 3338, X, X, X, X, X, X, X, 3339,
    3340, X, X, X, 3341, 3185, X, 3186, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, 3187, X, X, X, X, X, X, X, X, X, X, 3188, X, 1891, X, X, X, X,
    1892, 1893, X, 1894, 1895, X, X, 1896, 1897, X, X, 1898, X, X, X, X, X,
    1899, X, 1900, 1901, 1902, X, X, X, 1903, 1525, 1526, X, X, X, 1527, 1528,
    X, 1529, 1530, X, 1531, 1532, 1533, X, 1534, X, X, 1535, X, X, X, X, X, X,
    X, X, X, 1536, X, X, X, X, 2689, X, X, X, X, X, X, X, X, 2690, X, X, X, X,
    X, 2691, X, 2692, X, X, X, X, X, X, X, X, X, X, X, 2263, 2264, X, 2265, X,
    X, X, 2266, X, X, 2267, X, 2268, X, X, X, X, X, X, X, 2269, 2014, 2015,
    2016, 2017, X, X, 2018, X, X, 2019, X, X, X, 2020, X, 2021, X, 2022, 2023,
    X, X, 2024, X, X, X, X, X, X, X, X, X, X, X, X, 5750, X, X, X, 5751, X, X,
    X, 5752, 5753, 5754, X, X, X, X, X, 5755, X, X, 5756, 5430, X, X, 5431, X,
    5432, X, 5433, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 5435,
    X, 5436, 5437, X, X, 3363, X, X, 3364, X, X, X, X, X, X, X, X, 3365, 3366,
    X, 3367, X, 3368, X, 3369, X, X, X, X, X, X, X, X, 3370, X, 1933, X, X, X,
    X, X, 1934, X, 1935, 1936, X, X, 1937, X, X, 1938, 1939, X, X, X, X, X, X,
    1940, X, 1941, 1942, X, X, 1943, X, X, 6622, X, X, X, X, X, X, X, X, X,
    6623, X, 6624, X, X, 6625, 6626, X, X, 6627, 6628, X, 6629, 6630, 6631, X,
    6632, X, 6633, 6634, 6273, 6274, X, X, X, 6275, X, 6276, 6277, 6278, X, X,
    X, X, 6279, 6280, 6281, X, X, X, X, 6282, 6283, 6284, 6285, 6286, X, 6287,
    6288, 6289, X, 6290, 5683, X, 5684, X, 5685, X, 5686, X, X, X, X, 5687,
    5688, X, X, 5689, X, X, X, X, X, 5690, X, 5691, X, X, X, X, X, 5692, 5693,
    X, 4901, 4902, X, X, X, 4903, X, X, X, 4904, X, X, 4905, X, X, X, X, X, X,
    4906, X, X, X, X, X, X, X, 4907, X, X, 4908, 4677, X, X, X, X, 4678, 4679,
    X, 4680, X, X, X, 4681, X, X, X, X, 4682, X, 4683, 4684, X, 4685, X, X,
    4686, 4687, X, X, X, X, X, X, 4966, 4967, X, X, X, 4968, X, X, X, X, X, X,
    X, X, X, X, X, X, 4969, 4970, X, X, X, X, X, X, 2860, X, 2861, X, X, X, X,
    X, X, X, X, X, X, 2862, X, X, 2863, 2864, X, X, 2865, X, X, X, 2866, 2867,
    2628, X, X, 2629, 2630, X, X, 2631, X, X, X, X, X, X, X, 2632, X, X, 2633,
    X, 2634, 2635, X, X, 2636, X, 2637, X, X, 2638, 2639, X, 127, X, X, 173, X,
    128, X, X, 170, 169, X, X, X, 171, 113, X, X, X, X, X, X, X, X, 110, X,
    168, X, X, X, X, 129, X, 6592, X, 6593, X, X, X, X, X, X, 6594, X, X, X,
    6595, 6596, X, X, X, X, X, 6597, X, 6598, 6599, X, 6600, 6601, X, X, X, X,
    2270, X, X, 2271, X, X, X, X, X, 2272, 2273, 2274, 2275, X, X, 2276, X, X,
    X, 2277, X, X, 2278, X, 2279, X, X, X, X, 3251, 3252, X, X, X, X, 3253, X,
    3254, X, X, X, X, X, 3236, X, X, 3255, X, 3256, 3257, X, X, 3258, X, X, X,
    X, X, 3189, X, 3190, 3191, X, X, X, 3192, X, X, X, X, X, X, X, 3193, 3194,
    X, X, X, X, X, X, X, 3195, X, X, 172, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 6028, X, X, 3949, X,
    3950, 3951, X, 3952, X, X, X, 3953, X, 3954, X, X, X, X, 3955, 3956, X, X,
    X, X, 3957, 3958, X, X, X, X, 3959, X, 2605, 2606, 2607, 2608, X, X, X,
    2609, X, X, 2610, 2611, X, 2612, X, 2613, X, X, X, 2614, X, 2615, X, X, X,
    X, 2616, X, 2617, X, 2618, 2522, X, X, X, X, X, X, 2523, X, X, X, 2524, X,
    X, X, X, 2525, X, 6569, X, 2526, X, X, X, 2527, 2528, X, X, X, X, X, X, X,
    3242, 3241, X, X, X, 3243, 3244, X, 3245, 3246, 3247, X, 3248, X, X, X, X,
    X, X, X, 3249, X, X, X, 3250, 3164, X, 3165, 3166, X, X, X, X, 3167, X, X,
    X, 3168, X, 3169, 3170, X, X, X, X, 3171, X, X, X, X, X, X, 3172, X, X, X,
    3173, 3144, X, X, X, X, X, X, X, X, X, X, 3146, 3147, 3148, X, X, 3149, X,
    3150, X, X, X, X, X, X, 3151, 3152, 3153, 3154, X, X, 3155, 3118, X, X, X,
    X, 3119, 3120, X, X, X, 3121, X, 3122, X, 3124, X, X, 3123, X, X, X, X, X,
    3125, 3126, 3127, X, 3128, 3129, X, X, X, X, 3823, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, 3824, X, X, X, X, X, X, 4738, X, X,
    4739, X, 4740, X, X, X, X, X, X, X, X, X, 4741, X, X, X, X, X, X, X, X, X,
    X, X, 2970, X, X, X, 2971, X, 2972, 2973, 2974, 2975, X, X, X, X, X, 2976,
    2977, 2978, 2979, X, 2980, 2784, 2785, X, 2786, 2787, X, X, X, X, X, X,
    2788, X, 2789, X, X, X, X, 2790, 2791, X, X, X, 2792, 2793, X, X, X, 2794,
    2795, X, 2796, 2571, X, X, X, X, X, X, X, X, X, X, 2572, X, X, 2573, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 964, X, X, X, X,
    X, X, X, X, X, X, X, X, X, 2856, 2857, 2858, 2859, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, 3560, X, 3561, X, 3562, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, 2473, X, X, 2474, 2475, X, 2476, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, 6455, 6456, X, 6457, 6458, 6459, 6460, X, X, X, X, X, X,
    6461, X, 6463, X, 6462, 6000, 6001, X, 6002, X, 6003, X, 6004, 6005, X, X,
    X, 6006, 6007, 6008, X, X, X, X, X, 6009, 6010, 6011, 6012, X, X, 6013, X,
    X, X, X, X, X, 6763, X, X, X, X, X, X, X, X, X, 6764, 6765, 6766, X, X,
    6767, X, X, X, 6768, 6769, X, X, 6770, X, 6771, 6395, 6396, 6397, X, X, X,
    X, X, 6398, X, 6399, 6400, X, 6401, X, 6402, X, X, 6403, X, X, 6404, X, X,
    6405, X, X, 6406, X, X, 6407, X, 5707, X, X, X, 5708, X, 5709, X, X, X, X,
    X, X, X, X, X, X, X, X, X, 5710, 5711, 5712, X, 5713, 5714, 5715, X, X,
    5716, 5717, 5379, 2231, 5380, X, X, X, 5381, X, X, X, X, X, X, X, X, X, X,
    X, 5382, 5383, X, X, 5384, 5385, 5386, 5387, X, X, X, 5388, X, X, 3323, X,
    X, 3324, X, X, X, 3325, X, X, X, X, 3326, X, X, X, X, X, X, X, X, 3327, X,
    X, X, 3328, X, X, X, X, X, 3358, X, X, 3359, X, X, X, X, X, X, X, X, 3360,
    X, X, X, X, 3361, 3362, X, X, X, X, X, X, X, X, X, 2557, X, 2555, X, X, X,
    X, 2556, 2558, X, X, X, X, 2559, X, 2560, X, X, 2561, 2562, X, 2563, X, X,
    7146, 7147, X, X, X, X, X, 7148, X, X, X, X, X, 7149, 7150, 7151, 7152, X,
    7153, X, 7154, 7155, X, 7156, 7157, 7158, X, X, X, 7159, 6960, X, 6961, X,
    X, X, X, X, X, X, X, 6962, X, X, X, 6963, X, 6964, X, X, X, X, 6965, X,
    6966, 6967, 6968, X, 6969, X, 6970, X, 6419, X, X, 6420, 6421, 6422, 6423,
    X, 6424, 6425, 6426, 6427, 6428, X, X, X, X, X, 6429, X, X, X, X, X, 6430,
    X, X, 6431, X, 6432, 6433, 5973, 5974, X, 5975, 5976, X, X, 5977, X, X, X,
    X, X, X, X, 5978, X, 5979, X, X, 5980, X, X, X, X, X, X, X, 5981, X, X, X,
    3049, X, X, X, 3050, X, 3051, X, X, X, X, X, X, 3052, X, 3053, X, 3054, X,
    X, X, X, X, X, X, X, X, X, 3055, 2959, X, 2960, X, 2961, 2962, X, X, X,
    2963, 2964, X, X, X, X, 2965, 2966, X, X, X, X, 2967, X, X, X, X, X, X, X,
    2968, X, 2969, 2777, X, X, X, X, X, X, X, X, X, X, X, 2778, X, X, X, X, X,
    2779, X, X, X, X, X, 2780, X, X, 2781, 2782, X, X, 2783, 2549, X, X, X, X,
    X, X, X, 2551, X, X, X, X, X, 2550, X, X, X, 2552, X, X, 2553, X, X, X, X,
    X, X, X, X, 2554, X, X, 7095, X, X, X, X, 7096, X, X, 7094, X, X, X, 7097,
    X, 7098, 7099, 7100, X, X, 7101, 7102, X, X, 7103, X, X, 7104, 7105, X, X,
    5158, 5159, 5160, X, X, 5161, X, X, X, X, X, 5162, 5163, X, X, 5164, X,
    5199, 5142, 5165, 5166, 5167, X, X, X, X, X, X, X, X, 2564, X, 2565, 2566,
    2567, 2568, 2569, X, 2570, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    3212, 3213, 3214, X, X, 3215, X, X, X, X, X, 3216, 3217, 3218, X, X, 1410,
    X, 1411, 1412, X, X, X, X, X, X, 1413, X, X, X, X, X, 1414, X, X, X, X, X,
    X, X, X, X, X, X, X, 1415, X, 6983, X, 6984, 6985, 6986, X, X, X, 6987,
    6988, X, X, X, 6989, 6990, 6991, X, X, 6992, 6993, X, 6994, X, 6995, X, X,
    6996, 7003, 6997, 6998, 6999, 6799, X, 6800, 6801, 6802, X, X, 6803, X, X,
    X, X, X, 6804, 6805, X, X, X, X, 6806, X, 6807, 6808, X, 6809, X, X, X, X,
    X, X, X, X, 6291, 6292, 6293, X, X, 6294, 6295, X, X, X, 6296, X, X, X, X,
    6297, X, 6298, X, X, X, X, X, 6299, 5694, X, X, 5695, X, 5696, X, 5697, X,
    5698, X, X, X, 5699, 5700, X, X, X, X, 5701, X, X, 5702, 5703, 5704, X, X,
    X, 5705, 5706, X, X, 3512, X, 3513, 3514, X, X, X, 3515, X, X, X, 3516,
    3517, X, 3518, X, 3519, X, X, X, X, X, X, 3520, X, X, X, X, X, 3521, 3574,
    X, X, X, X, X, X, 3575, X, 3576, X, 3577, 3578, X, 3579, X, X, X, 3580, X,
    3581, X, X, X, X, X, X, X, X, X, X, X, X, X, 851, 945, 880, 974, 898, 992,
    916, 1010, 925, 1019, 922, 1016, 924, 1018, 923, 1017, X, X, X, X, 2350, X,
    2351, X, 2352, X, X, X, X, X, X, 2353, X, X, X, X, X, X, X, X, X, X, 2354,
    X, 2355, X, X, X, X, 3400, X, X, 3401, X, X, 3402, X, X, X, X, X, X, 3403,
    X, 3404, X, X, X, X, X, X, X, X, X, X, 3405, X, 1949, 1950, X, X, X, 1951,
    X, 1952, X, X, X, X, X, 1953, 1954, X, 1955, 1956, 1957, 1958, X, X, 1959,
    X, X, X, X, X, X, X, X, X, X, 4402, X, X, X, X, 4403, X, X, X, X, 4404, X,
    X, X, 4405, X, X, X, X, 4407, 4408, 4409, 4287, X, X, X, X, X, 4288, X, X,
    X, 4289, X, X, X, 4290, X, X, X, 4291, X, 4292, 4293, X, 4294, X, 4295,
    4296, X, 4297, X, X, X, X, 7121, X, X, X, 7122, X, X, X, 7123, X, 7124,
    7125, 7126, X, X, 7127, 7128, 7129, X, X, X, X, X, X, X, X, X, X, X, 4482,
    4483, X, X, X, X, 4484, X, 4485, 4486, 4487, 4488, X, 4489, X, X, 4490,
    4491, X, X, X, 1416, 1417, X, X, X, 1418, X, X, 1419, X, X, 1420, 1421,
    1422, X, X, X, X, 1423, X, X, X, X, X, X, X, X, X, X, X, X, X, 3672, X, X,
    X, X, X, 3673, X, X, X, X, X, 3674, X, X, X, X, X, X, X, 5592, X, X, X, X,
    X, X, X, 5593, 5594, 5595, X, X, X, 5596, X, 5597, X, X, X, X, X, X, X, X,
    3174, X, X, 3175, 3176, X, 3177, X, X, X, X, X, X, X, X, X, X, X, 3178,
    3132, X, X, X, X, X, 2907, 2908, X, X, X, X, X, 2909, 2910, X, X, X, 2911,
    X, X, 2912, 2913, X, X, 2914, X, X, X, 2915, 2916, X, 2917, 2693, X, X, X,
    X, X, X, 2694, 2695, 2696, X, X, 2697, X, X, X, X, 2698, X, X, 2699, X,
    2700, 2701, X, X, X, X, X, 2702, X, X, X, 6243, 6244, 6245, 6246, X, 6247,
    X, X, X, X, X, 6248, 6249, 6250, X, X, 6251, X, 6252, 6253, X, 6254, 6255,
    6256, X, 6257, X, 6258, X, 5598, X, X, X, X, 5599, X, X, X, X, X, X, 5600,
    5601, 5602, X, X, X, X, X, 5603, 5604, X, 5605, 5606, 5607, X, 5608, X, X,
    X, 2307, 2308, X, X, 2309, 2310, X, 2311, X, X, 2312, X, X, 2313, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, 3085, X, 3086, X, 3087, 3088, X, X,
    X, 3089, X, X, X, X, 3090, 3091, 3068, X, X, 3069, X, X, 3070, X, X, X, X,
    X, X, X, 3071, X, X, X, 3072, 3073, 3074, X, X, X, X, X, X, X, X, X, X,
    3075, 2981, 2982, X, 2983, X, X, X, X, X, X, X, X, X, 2984, X, X, X, X, X,
    2985, 2986, X, X, X, X, X, X, 2987, X, 2988, X, X, X, 7052, 7053, X, 7054,
    X, X, X, 7055, X, X, 7056, 7057, X, X, X, 7058, 7059, X, 7060, 7061, 7062,
    7063, X, X, X, X, X, X, X, X, 6887, X, X, 6888, 6889, X, X, X, X, X, X, X,
    X, 6890, 6891, 6892, X, X, X, 6893, X, X, 6894, X, 6359, X, X, 6360, 6361,
    X, 6362, X, 6363, 6364, X, X, X, X, X, X, X, X, 6365, 6366, X, 6367, 6368,
    X, X, X, X, X, X, X, X, 3762, 3763, X, X, X, X, X, X, 3764, X, X, X, X,
    3765, X, X, X, 3766, X, X, 3767, 3768, X, X, 1870, X, 1871, X, 1872, 1873,
    X, 1874, X, 1875, X, 1876, 1877, X, X, X, X, X, 1878, X, X, X, X, X, X, X,
    X, X, X, 1879, 1479, X, 1480, X, X, X, X, X, 1481, 1482, X, 1483, 1484, X,
    X, X, X, X, 1485, X, 1486, X, 1487, X, 1488, X, X, X, X, X, X, 1489, X,
    7207, 7208, 7209, X, 7210, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, 7106, 7107, 7108, X, X, X, 3782, 3783, X, X,
    X, 3784, 3785, 3786, 3787, X, X, 3792, X, X, X, X, X, 3788, 3789, X, X, X,
    X, X, X, X, 3790, 3791, X, 2233, X, 2234, 2235, X, X, X, 2236, X, X, X, X,
    X, X, 2237, 2238, X, X, 2239, X, 2240, 2241, X, X, X, X, X, X, X, X, 2242,
    1944, 1945, X, X, 1946, X, 1947, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, 1948, 1544, 1545, X, X, 1546, X, X, 1547, X,
    X, 1548, X, 1549, X, 1550, X, 1551, X, X, 1552, X, X, X, 1553, 1554, X, X,
    1555, 1556, 1557, 1558, X, X, 5870, X, 5871, X, X, X, 5872, X, X, X, X,
    5873, X, X, 5874, 5875, X, X, X, 5876, X, X, X, X, X, X, X, X, 5877, 5878,
    5575, X, X, X, X, X, X, X, 5576, X, 5577, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, 5578, X, X, 5579, 5580, X, 4781, 4782, 4783, X, 4784, 4785, X,
    4786, X, X, 4787, 4788, 4789, X, X, X, 4790, X, X, X, X, 4791, 4792, X, X,
    X, X, X, 4793, 4794, X, 3726, 3727, X, X, X, X, X, 3728, X, X, X, 3729, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 3730, 3731, X, 2181, X, X,
    2182, X, X, 2183, 2184, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 2185,
    X, X, X, 2186, X, X, 2187, 1916, 1917, X, X, X, 1918, X, X, 1919, 1920, X,
    X, 1921, 1922, 1923, X, X, X, X, X, X, 1924, X, X, X, X, X, X, X, X, X, X,
    X, X, 2422, X, X, X, X, X, X, X, X, X, X, 2423, X, X, X, X, X, X, 2424,
    2425, 2299, X, X, X, 2300, X, X, X, X, X, X, X, 2301, 2302, 2303, X, X, X,
    2304, 2305, X, X, X, X, X, X, X, X, X, X, 2306, X, X, 6971, 6972, X, X,
    6973, 6974, 6975, 6976, 6977, X, X, X, X, X, X, 6978, X, X, X, 6979, 6980,
    6981, X, X, X, X, X, 6982, X, X, 4813, X, X, 4814, 4815, X, X, X, 4816,
    4817, X, 4818, X, X, X, 4819, X, X, X, 4820, 4821, X, X, 4822, 4823, X, X,
    X, X, X, X, 5121, X, X, X, X, X, X, X, X, X, 5122, X, X, X, X, 5123, X, X,
    X, X, 5124, X, X, X, X, X, X, 5247, X, 5248, 5249, 5250, X, X, X, X, 5251,
    X, 5252, X, X, 5253, X, X, X, X, X, 5254, X, X, 5255, 5256, X, 4406, X, X,
    4410, X, X, X, 4411, X, X, X, 4412, 4413, X, X, 4414, 4415, 4416, 4417, X,
    X, X, X, X, X, X, 4418, X, 4419, X, 4420, 4322, X, 4323, X, 4324, X, X,
    4325, X, X, 4326, X, 4327, X, X, X, 4328, X, 4329, 4330, 4331, X, X, X, X,
    X, 4332, X, X, 4333, X, X, 2491, 2492, X, X, 2493, X, 2494, X, 2498, X, X,
    X, X, X, X, 2496, X, X, X, 2495, X, X, X, 2497, X, X, X, X, X, 2499, 2363,
    2364, X, X, X, X, X, X, 2365, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    2366, X, 2368, X, 2369, X, 2370, X, X, X, 5738, X, X, 5739, X, 5740, 5741,
    5742, X, X, X, X, X, X, 5743, X, 5744, 5745, 5746, X, 5747, X, X, X, X, X,
    5748, X, 5749, 5420, 5421, X, 5422, X, 5423, X, X, X, X, X, X, X, X, X, X,
    X, 5424, 5425, X, X, 5426, X, 5427, X, X, 5428, X, 5429, X, X, X, 2243, X,
    X, 2244, X, X, X, X, X, X, X, X, X, X, X, 2245, 2246, X, X, X, X, X, 2247,
    X, 2248, X, 2249, 2250, 2251, 2003, 2004, X, 2005, 2006, X, 2007, X, X,
    2008, X, 2009, X, 2010, X, 2011, X, X, X, X, 2012, X, X, X, X, X, X, X, X,
    X, 2013, X, X, 6709, X, X, 6710, X, X, 6711, X, X, X, 6712, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 6484, 6485, X, X,
    X, X, 6486, X, 5788, X, X, 5789, 5790, X, X, X, X, X, 5791, X, 5792, X,
    5793, X, X, X, X, 5794, 5795, X, X, X, X, X, X, 5796, X, 5797, 5798, 5491,
    X, X, 5492, X, X, X, 5493, X, X, X, X, 5494, 5495, 5496, X, X, 5497, X, X,
    X, 5498, X, X, X, X, X, X, X, X, 5499, 5500, 5172, X, 5173, X, 5174, X,
    5175, X, X, X, X, X, X, 5176, X, X, X, X, 5177, X, 5178, 5179, X, X, 5180,
    5181, X, 5182, 5183, 5184, X, X, 2838, 2839, 2840, X, 2841, X, X, X, X, X,
    2842, X, X, X, 2843, 2844, 2845, X, 2846, X, 2847, X, X, X, 2848, X, 2849,
    X, X, X, X, 3698, X, X, X, 3699, X, 3700, X, 3701, 3702, X, X, X, X, X, X,
    X, X, 3703, X, 3704, X, 3705, 3706, X, X, X, X, X, 3550, 3551, 3552, X,
    3553, X, X, X, X, X, X, X, X, X, X, 3554, 3555, X, 3556, 3557, X, X, X,
    3558, X, X, 3559, 3642, X, X, X, 3643, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, 3644, X, 2119, X, 2120, X, X, X, X,
    X, X, X, X, 2121, X, X, X, X, X, X, X, 2122, 2131, X, 2123, X, 2124, 2125,
    X, 2126, 2127, 2128, 2129, 1760, X, X, X, 1761, X, 1762, X, 1763, X, X, X,
    1764, X, X, 1765, X, 1766, X, X, 1767, X, 1768, X, X, X, X, 1769, 1770, X,
    X, X, X, 2928, X, 2929, X, X, X, X, X, X, 2930, 2931, 2932, X, X, X, X, X,
    X, X, X, X, X, X, X, X, 2933, X, X, X, 7000, X, X, X, X, 7005, 7001, 7002,
    7004, X, X, 7006, X, 7007, X, 7008, X, X, 7009, X, 7010, X, X, X, 7011, X,
    X, X, X, 2314, 2315, X, 2316, 2317, X, X, X, 2318, X, X, X, 2319, X, X, X,
    X, 2320, X, X, X, X, X, X, X, X, 2321, X, X, 7017, X, X, X, X, X, X, X, X,
    7016, X, X, X, X, X, 7018, X, X, X, X, X, 7019, 7020, X, X, X, 7021, 7022,
    7023, X, 6443, 6444, X, 6445, X, X, X, 6446, 6447, X, X, X, 6448, 6449,
    6450, X, X, X, X, X, 6451, 6452, 6453, X, X, X, X, X, X, X, 6454, 5990, X,
    5991, X, X, X, X, 5992, 5993, X, X, X, X, X, X, 5994, 5995, X, X, X, X, X,
    5996, 5997, 5998, X, X, X, X, X, 5999, X, 5319, X, X, X, 5320, 5321, X, X,
    5322, X, 5323, 5324, X, X, 5325, X, X, X, 5326, X, X, X, X, 5327, X, X, X,
    X, 5328, X, 5329, 5058, X, X, 5059, X, X, X, X, X, X, X, X, X, X, X, 5060,
    X, X, X, 5061, 5062, X, X, X, X, 5063, 5064, X, X, 5065, X, X, 2749, X, X,
    X, X, 2750, X, X, 2751, X, 2752, X, X, X, 2753, 2754, 2755, 2756, 2757, X,
    2758, 2759, X, 2760, X, X, 2761, X, 2762, X, 1771, X, X, X, 1772, X, X,
    1773, 1774, 1775, X, 1776, X, X, X, 1777, 1778, X, X, 1779, X, 1780, 1781,
    X, X, X, X, X, X, X, X, X, X, 3815, X, X, X, X, X, X, 3816, X, 3817, 3818,
    3819, 3820, X, 3821, X, X, X, 3822, X, X, X, X, 5901, 5902, X, 5903, X, X,
    X, X, 5904, X, X, X, 5905, 5907, 5908, X, 5909, X, X, X, X, X, X, X, X,
    5910, X, X, 3645, X, X, X, X, 3646, X, X, X, X, X, X, X, X, X, X, 3647, X,
    X, X, 3648, X, X, 3649, X, 3650, 3651, X, X, X, X, 4840, 4841, X, 4842, X,
    X, X, X, X, X, 4843, X, 4844, X, 4845, X, X, X, X, X, 4846, X, X, X, X, X,
    X, 4847, 4610, 4611, X, X, X, X, X, 4612, X, X, X, X, X, X, 4613, X, X, X,
    X, X, X, 4614, X, X, X, X, X, X, X, X, X, X, X, 2330, X, X, X, X, 2331, X,
    X, 2332, X, X, 2333, X, X, 2334, X, X, 2335, X, 2336, 2337, 2167, X, X, X,
    X, X, 2168, 2169, X, X, X, X, X, 2170, X, X, X, X, 2171, X, X, X, X, X, X,
    2172, X, X, X, X, X, 2173, 1849, X, X, X, X, X, 1850, 1851, X, X, X, X, X,
    X, X, X, X, X, X, X, X, 1852, X, X, X, X, X, X, X, X, X, X, X, X, X, 5765,
    X, X, 5766, X, X, X, X, X, X, 5767, X, X, X, X, 5768, X, X, X, 2482, 2483,
    X, 2484, 2485, X, X, X, 2481, X, X, X, X, X, 2486, X, X, 2487, X, X, X, X,
    2488, X, X, X, 2489, X, 2490, 2356, X, X, X, X, 2357, X, X, X, X, 2358, X,
    X, X, 2359, X, X, X, X, X, X, 2360, 2361, X, X, X, X, X, X, 2362, X, X, X,
    5475, 5476, 5477, 5478, 5479, 5480, 5481, X, 5482, 5483, X, X, X, 5484, X,
    X, 5485, X, 5486, X, 5487, 5488, 5489, X, X, X, X, 5490, X, 4700, X, 4701,
    X, X, X, 4702, X, 4703, X, X, X, 4704, 4705, X, 4706, X, 4707, X, X, X, X,
    X, X, 4708, X, X, 4709, 4710, X, X, 2646, X, 2649, X, X, 2647, X, X, X,
    2648, 2650, X, X, 2651, 2652, 2653, X, X, X, X, X, X, 2654, X, X, X, X, X,
    X, X, X, 4585, 4586, X, 4587, 4588, X, X, X, X, 4589, X, X, 4590, X, X, X,
    X, X, X, 4591, X, 4592, 4593, X, 3202, X, X, 3203, X, X, X, X, X, X, X, X,
    X, 3204, 3205, X, 3206, X, 3207, X, X, 3208, X, 3209, 3210, X, 3211, X, X,
    X, X, X, 3179, X, 3180, X, X, X, X, X, X, 3181, X, X, X, X, 3182, X, X, X,
    X, X, 3183, X, X, 3184, X, X, X, X, 3892, X, X, X, X, X, X, 3893, X, X, X,
    3894, X, X, X, X, 3895, X, X, X, 3896, 3897, X, X, X, X, X, X, X, 6369,
    6370, 6371, X, X, X, X, X, X, 6372, 6373, 6374, X, X, 6375, X, 6376, 6377,
    X, 6378, X, X, X, 6379, X, 5631, 5632, 5633, X, X, X, X, X, X, X, 5634, X,
    X, 5635, X, 5636, X, X, 5637, X, 5638, X, X, X, X, 5639, 5640, 5641, 5642,
    X, X, 3479, X, X, 3480, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    3481, X, X, X, 3482, X, X, X, 3483, 3471, X, X, X, X, X, X, 3472, X, X, X,
    3473, X, X, 3474, X, 3475, X, X, X, X, 3476, X, X, X, X, X, X, X, 3477,
    3478, X, 2059, X, X, 2060, 2061, 2062, 2063, 2064, X, X, 2066, X, 2067, X,
    X, X, 2065, X, X, X, X, 2068, 2069, X, X, X, X, X, X, X, X, X, X, 6567, X,
    X, X, X, X, X, X, 6568, X, X, X, X, X, 6570, X, 6571, X, X, 6572, 6573,
    6574, 6144, X, 6146, 6147, X, 6145, X, 6148, X, 6149, X, X, X, X, 6150,
    6151, X, 6152, X, X, 6153, X, 6154, 6155, X, 6156, 6157, X, 6158, 6159, X,
    X, 4075, X, X, X, 4076, 4077, 4078, X, X, 4079, X, 4080, 4081, X, X, 4082,
    4083, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 5214, X, X, X, X, X, X,
    X, X, X, 5215, X, X, X, X, X, X, 3310, X, X, 3311, 3312, X, X, X, X, X,
    3313, 3314, X, 3315, X, X, 3316, 3317, X, X, X, X, X, X, X, X, X, 2468, X,
    2469, X, X, X, X, X, X, 2470, X, X, X, X, 2472, X, X, X, X, X, 2471, X, X,
    X, 6074, 6075, X, X, X, X, X, X, X, 6076, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, 6077, X, 6078, X, X, 3960, X, 3961, X, X, 3962, 3963, X, X, X,
    3964, X, X, X, X, 3965, 3966, X, X, 3967, X, X, X, X, 3968, 3969, X, 3970,
    X, X, 1979, X, X, X, X, X, X, 1980, X, X, X, X, X, X, X, X, X, X, X, X,
    1981, X, X, X, X, X, X, X, X, 1982, 1580, X, 1581, 1582, X, X, 1583, 1584,
    X, X, 1585, X, X, 1586, X, X, 1587, 1588, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, 5168, X, X, X, X, X, X, X, 5169, X, X, X, X, 5170, X, 5171,
    4953, X, X, X, 4954, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, 6521, 6522, X, 5848, X, X, X, X, X, X,
    5849, X, X, X, 5850, X, X, 5851, 5852, X, 5853, X, X, 5854, X, 5855, 5856,
    X, X, X, X, X, 5857, 5858, 5563, X, X, X, 5564, X, X, X, X, 5565, X, X, X,
    X, X, X, X, 5566, X, X, X, X, X, X, X, 5567, X, 5568, X, X, X, X, X, 6027,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, 6760, X, 6761, X, 6762, 6348, X, 6349, X, X, X, X, X, 6350, X, X, X,
    X, 6351, X, X, X, 6352, X, X, 6353, 6354, X, X, X, X, X, X, 6355, 6356,
    6357, 6358, 5919, 5920, 5921, 5922, X, X, 5923, 5924, X, X, X, X, X, X, X,
    X, X, 5925, X, 5926, X, X, 5927, 5928, 5929, 5930, X, X, X, 5931, X, X,
    3666, 3667, X, X, X, X, 3668, X, X, X, X, X, X, X, X, X, X, 3669, X, X, X,
    X, X, X, X, 3670, X, 3671, X, X, 1807, X, X, X, X, X, X, X, X, 1809, 1808,
    X, X, X, X, X, X, X, X, X, X, X, X, 1810, X, 1811, X, X, X, X, X, 2095,
    2096, X, X, X, X, X, 2097, 2098, X, X, X, X, 2099, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, 1442, X, X, X, X, X, X, X, X, X, 1443, X, X, X, X, X,
    X, X, X, 7188, 7189, X, X, X, 7190, 7191, 7192, 7193, 7194, X, 7195, X,
    7196, X, X, X, X, 7197, X, X, 7198, X, X, 5276, 5277, X, X, X, 5278, X, X,
    X, X, 5279, X, 5280, X, 5281, X, X, X, X, X, X, X, X, X, X, X, 5282, X,
    5283, X, 4492, X, X, X, X, X, X, 4493, 4494, X, 4495, X, X, X, 4496, X,
    4497, X, X, 4498, X, X, X, 4499, X, X, 4500, X, X, X, X, X, 5004, X, 5005,
    X, X, 5006, X, 5007, X, X, X, X, X, 5008, X, X, X, X, 5009, X, X, X, X, X,
    X, X, X, 2381, X, X, X, X, X, 2382, 2383, X, X, X, X, X, X, X, X, X, X, X,
    X, 2384, 2385, 2386, 2387, 2201, 2202, 2203, X, X, X, 2204, X, X, 2205, X,
    X, X, X, X, X, X, 2206, 2207, X, X, X, X, X, X, X, X, X, 2209, X, X, X, X,
    3008, X, X, X, X, 3009, 3010, 3011, 3012, X, 3013, X, 3014, 3015, X, X, X,
    3016, X, 3017, X, X, X, X, X, X, X, X, X, 2174, X, X, 2175, 2176, X, 2177,
    2178, X, X, X, X, 2179, X, X, X, X, X, X, X, X, X, 2180, 1908, X, X, X, X,
    X, X, X, X, X, 1909, X, 1910, X, X, 1911, X, X, X, X, X, X, 1912, X, X, X,
    X, X, 1913, X, 1914, 1915, 1537, X, 1538, X, X, X, X, X, X, X, X, X, X, X,
    X, X, 1539, X, 1540, X, X, X, X, X, X, X, X, X, 1541, 1542, X, 1543, 941,
    940, 943, 949, 942, 948, 784, 953, 957, 956, 959, 958, 971, 970, 973, 972,
    786, 987, 989, 988, 991, 995, 990, X, 795, 1006, 1005, 1008, 1007, 1021,
    799, 1022, X, 6713, X, 6714, X, 6715, 6716, 6717, X, X, 6718, X, X, X, X,
    X, X, X, X, 6719, X, X, 6720, X, X, X, X, X, X, X, X, X, X, 3533, 3534, X,
    3535, X, 3536, X, X, 3537, X, 3538, X, X, X, X, 3539, X, 3540, 3541, X, X,
    X, X, 4463, 4464, 4465, X, X, X, 4466, 4467, X, X, X, 4468, X, 4469, X, X,
    4470, X, X, X, 4471, X, X, 4472, 4473, X, X, X, X, 7135, X, X, 7136, X, X,
    X, X, 7137, 7138, 7139, X, 7140, 7141, 7142, X, X, 7143, X, X, 7144, X, X,
    X, X, X, X, 7145, 7084, X, X, X, X, 7085, X, 7086, X, 7087, X, 7088, X, X,
    7089, X, 7090, X, X, 7091, 7092, X, X, X, X, X, X, X, X, X, 7093, X, 6495,
    X, X, X, X, 6496, X, X, 6497, X, 6498, 6499, X, X, X, X, X, X, X, 6500, X,
    6501, X, X, X, 6502, X, X, 6503, X, 6504, 6038, 6039, X, X, X, X, 6040, X,
    X, X, 6041, 6042, X, 6043, X, X, 6044, X, 6045, 6046, X, 6047, X, X, X, X,
    X, X, X, X, X, X, X, 3692, X, 3693, 3694, X, X, X, X, X, X, X, X, X, X,
    3695, X, 3696, X, 3697, X, X, 1853, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, 1854, X, X, X, X, X, X, 1855, X, X, X, X, X, X, 3590, 3591, 3592,
    X, X, X, X, X, 3594, 3595, X, 3596, X, X, X, X, X, X, X, 3597, X, X, 3598,
    X, X, 3599, 3675, X, X, X, X, X, X, 3676, X, X, X, X, X, 3677, 3678, X, X,
    3679, X, 3680, X, X, X, X, X, X, X, 3681, X, X, X, 3682, 3775, X, X, 3776,
    X, X, X, X, X, X, X, X, X, X, X, 3777, X, X, X, X, 3778, X, X, 3779, X,
    3780, X, X, 3781, X, X, X, X, 5836, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, 5837, 5838, X, X, X, X, X, X, 5827, 5828, X, X, X,
    5829, X, X, X, X, 5830, X, 5831, 5832, X, X, X, X, X, 5833, X, 5834, 5835,
    X, X, X, 2529, X, X, X, 2530, X, X, X, 2531, X, X, 2533, X, 2532, X, X, X,
    X, X, X, X, 2534, 2535, X, X, X, X, X, X, X, 3593, X, X, X, 3542, X, 3543,
    X, 3544, X, X, X, X, 3545, X, 3546, X, 3547, 3548, X, 3549, X, X, X, X, X,
    3389, 3390, X, X, 3391, 3392, X, X, X, 3393, X, 3394, 3395, 3396, X, X,
    3397, 3398, X, X, X, X, 3399, X, X, X, X, X, 3417, X, X, X, X, X, 3418, X,
    X, X, 3419, 3420, 3421, X, X, 3422, X, X, X, X, X, X, X, X, 3423, 3424,
    3425, 3371, 3372, X, 3373, X, X, X, X, X, X, X, X, X, X, X, 3374, X, 3375,
    X, X, X, 3376, X, X, X, X, 3377, X, X, 3378, X, X, 1666, X, X, X, X, X, X,
    X, 1667, X, X, X, X, 1668, X, X, X, 1669, X, 1670, X, 1671, 1672, X, X, X,
    X, X, X, 1673, 907, 1001, 910, 1004, 909, 1003, 766, 798, 921, 1015, 918,
    1012, 915, 1009, 920, 1014, 917, 1011, 919, 1013, 926, 1020, 929, 1023,
    928, 930, 1024, 932, 1026, 931, 1025, X, X, 5284, 5285, 5286, 5287, X,
    5288, X, X, 5289, 5290, X, X, X, 5291, X, X, 5272, 5292, 5293, X, 5294, X,
    X, X, X, X, X, X, X, 5295, 4979, X, X, X, X, X, X, X, X, X, X, X, X, 4980,
    4981, X, 4982, X, 4983, 4984, X, X, 4985, X, X, 4986, 4987, X, X, X, 4988,
    X, 4030, X, 4031, X, X, 4032, 4033, X, 4034, X, X, X, X, X, X, X, X, X, X,
    4035, 4036, X, 4037, X, 4038, 4039, 4040, X, 4041, X, 4042, 3992, 3993, X,
    3994, X, 3995, 3996, X, X, X, X, X, X, X, 3997, X, 3998, X, X, 3999, X,
    4000, X, 4001, 4002, X, X, X, 4003, X, 4004, 4005, 3911, X, X, 3912, X, X,
    X, X, 3913, X, X, 3914, X, X, 3915, 3916, X, 3917, X, X, X, X, X, 3918,
    3919, X, X, 3920, 3921, X, X, 3922, 3863, X, 3864, X, X, X, X, X, X, X, X,
    X, X, X, X, 3865, 3866, X, 3867, 3868, X, X, X, X, X, X, 3869, X, X, X, X,
    3870, 3853, X, X, X, X, X, X, X, 3854, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, 3855, X, X, X, X, X, X, X, 5729, X, 5730, X, X, X, X, 5731,
    5732, X, X, X, 5733, X, X, 5734, 5735, X, X, X, 5736, X, X, 5737, X, 4961,
    X, X, X, X, X, X, 4962, X, X, X, X, X, 4963, X, X, X, X, X, X, X, X, X, X,
    X, X, X, 4964, X, 4965, X, 3935, X, X, X, X, X, 3936, X, 3937, X, X, 3938,
    X, X, X, X, X, X, X, X, 3939, 3940, X, 3941, X, X, X, X, X, X, 3942, 3871,
    3872, X, X, 3873, X, X, X, X, X, X, 3874, 3875, X, X, X, X, X, X, 3876, X,
    X, 3877, X, X, 3878, 3879, X, 3880, X, X, X, X, 6213, 6214, X, X, X, 6215,
    6216, X, 6217, 6218, 6219, 6220, 6221, 6222, X, X, X, X, X, 6223, X, 6224,
    X, 6225, X, 6226, X, X, 4178, X, 4179, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, 4180, X, X, X, X, X, 4181, X, X, X, X, 4182, 4151, X, X, 4152, X,
    X, X, 4153, 4154, X, X, X, X, X, 4155, X, 4156, X, 4157, X, X, X, X, 4158,
    X, X, X, X, X, X, 4159, 4160, 4139, 4140, X, X, 4141, X, X, 4142, X, 4143,
    4144, X, X, X, X, 4145, X, X, X, X, X, X, 4146, X, X, 4147, X, X, X, 4148,
    4149, 4150, 4099, 4100, X, 4101, X, X, 4102, X, 4103, 4104, 4105, 4106, X,
    X, 4107, 4108, X, 4109, 4110, X, X, 4111, X, X, X, 4112, X, 4113, X, X, X,
    4114, 4043, 4044, X, X, 4045, X, X, 4046, X, X, 4047, X, X, X, X, X, X,
    4048, X, X, X, X, X, X, X, X, 4049, 4050, X, X, X, X, X, 4369, 4370, X, X,
    4371, X, X, X, 4372, 4373, X, X, 4374, X, X, X, X, X, X, X, X, X, X, X,
    4375, X, X, 2574, X, 2575, 2576, X, X, 2577, X, 2578, X, 2579, X, X, X, X,
    2580, X, 2581, X, X, X, X, X, X, X, X, X, 2582, 2583, 2584, 2500, 2501,
    2502, X, 2503, X, X, X, X, X, 2504, X, X, 2505, X, X, 2506, X, X, X, X, X,
    X, X, X, 2507, 2508, X, X, X, 2509, 2510, 2408, 2409, X, X, X, X, X, X, X,
    X, X, X, X, 2410, X, 2411, X, X, X, X, X, X, 2412, 2413, 2414, 2415, 2416,
    X, X, X, X, X, X, 3707, X, X, 3708, 3709, X, X, 3716, X, 3710, 3711, X, X,
    3712, X, X, 3713, X, X, X, X, 3714, 3715, X, X, X, X, 5438, 5439, X, 5440,
    X, X, X, 5441, X, X, 5442, 5443, 5444, X, X, 5445, 5446, X, X, X, X, 5447,
    X, X, X, X, 5448, 5449, 5136, 5137, X, X, X, X, X, 5138, 5139, X, 5140,
    5141, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 5143, X, 5144, 5145,
    5146, 4940, X, X, X, 4941, X, 4942, X, X, X, X, X, 4943, X, 4944, X, 4945,
    X, X, X, 4946, 4947, X, 4948, X, 4949, 4950, X, 4951, X, 4952, X, 3898,
    3899, 3900, X, 3901, X, X, X, X, X, X, X, X, 3902, 3903, 3904, X, X, 3905,
    X, 3906, 3907, X, X, X, 3908, X, 3909, X, 3910, X, 2388, X, X, 2389, X,
    2390, X, X, X, 2391, X, X, X, 2392, X, 2393, 2394, X, 2395, 2396, X, 2397,
    X, X, X, X, X, X, X, X, X, X, 538, 543, 550, 551, 552, 553, 560, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, 3318, X, 3319, X, 3320, X, X,
    3321, X, X, 3322, X, X, X, X, X, 3297, X, X, 3298, X, 3299, 3300, 3301,
    3302, X, X, 3303, 3304, X, X, X, 3305, 3306, X, X, X, X, 3307, 3308, 3309,
    X, X, 1628, X, 1629, X, 1630, X, 1631, 1632, X, X, X, X, X, 1633, X, 1634,
    1646, X, X, X, 1635, X, X, X, 1636, X, X, X, 1637, X, X, 5954, 5955, X, X,
    X, X, X, 5956, X, X, X, X, X, X, 5957, X, 5958, X, X, 5959, X, X, X, X,
    5960, 5961, X, 5962, 5963, X, 5241, X, X, X, 5242, X, X, X, X, X, X, X, X,
    X, X, X, X, 5243, 5244, X, 5245, X, X, X, X, X, X, X, X, 5246, X, 4376,
    4377, 4378, X, X, X, X, X, X, X, X, X, 4379, 4380, X, 4381, X, X, X, X,
    4382, X, 4383, X, X, X, X, X, X, X, X, X, 5643, X, X, X, 5644, X, X, 5645,
    X, X, X, 5646, 5647, X, X, X, X, X, 5648, 5649, X, X, 5650, 5351, X, X, X,
    X, X, 5352, X, 5353, X, X, X, X, 5354, X, X, X, X, X, 5355, X, X, 5356, X,
    X, X, X, X, 5357, X, X, 5358, 5104, 5105, X, 5106, 5107, X, X, 5108, 5109,
    5110, 5111, X, X, X, 5112, X, 5113, X, 5114, X, 5115, X, X, 5116, X, X,
    5117, X, 5118, X, 5119, 5120, 4909, X, X, 4910, X, X, X, X, 4911, X, X, X,
    X, X, 4912, 4913, X, X, X, X, X, X, X, X, X, X, X, 4914, X, X, X, 4915,
    4716, X, X, X, X, X, 4717, X, X, X, X, X, X, X, X, X, 4718, X, X, X, X, X,
    4719, 4720, X, X, 4721, 4722, 4723, X, X, 4724, 4553, X, X, X, X, 4554, X,
    4555, X, X, 4556, X, X, 4557, X, X, X, X, X, X, X, 4558, X, X, 4559, X, X,
    X, X, X, 4560, X, 3061, X, X, X, 3062, X, X, X, X, 3063, X, X, X, X, X, X,
    X, 3064, X, X, 3065, X, X, 3066, X, X, X, X, 3067, X, X, 597, 598, 599,
    600, 601, 602, 603, 604, 605, 606, 607, X, 608, 609, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, 3237, X, X, X, X, 3238, X, X, X,
    3239, X, 3240, 3156, X, X, X, 3157, X, X, X, X, X, X, X, X, 3158, X, X, X,
    3159, 3160, X, X, 3161, X, X, X, X, X, 3162, X, X, X, 3163, 3130, 3131, X,
    X, X, X, X, X, X, X, 3133, 3134, 3135, X, X, X, X, X, X, 3137, X, 3138, X,
    3140, 3141, 3142, X, 3143, 3145, X, 3136, 3139, 3092, X, X, X, 3093, X, X,
    X, 3094, 3095, X, X, X, 3096, X, X, X, 3097, 3098, X, X, 3099, 3100, X, X,
    X, X, X, X, 3101, 3102, X, 1880, X, 1881, X, 1882, X, X, 1883, 1884, X, X,
    X, 1885, X, X, X, 1886, X, X, X, 1887, 1888, X, X, X, X, X, 1889, X, X,
    1890, 1472, X, X, 1490, X, X, X, X, X, X, 1491, X, 1492, X, 1493, X, X,
    1494, X, X, X, X, X, 1495, 1496, 1497, 1498, X, X, 1499, 1500, X, X, 5512,
    5513, 5514, X, X, X, X, X, 5515, 5516, X, 5517, X, X, X, 5518, X, 5519, X,
    X, X, X, 5520, X, 5521, X, X, X, X, 5522, 5229, X, X, X, 5230, 5231, X,
    5232, X, X, 5233, X, X, X, X, X, 5234, X, X, 5235, 5236, X, 5237, X, 5238,
    X, X, X, 5239, 5240, X, X, 3041, X, X, X, 3042, X, X, 3043, X, X, X, X,
    3044, X, X, 3045, X, X, X, X, X, X, X, X, 3046, X, 3047, 3048, X, X, X,
    7073, X, X, X, 7074, X, 7075, 7076, X, X, X, X, X, X, X, X, X, 7077, 7078,
    7079, 7080, X, X, 7081, X, X, X, 7082, 7083, 6876, X, X, X, X, X, 6877, X,
    X, X, X, 6878, X, 6879, X, X, X, X, X, 6880, 6881, 6882, X, 6883, X, 6884,
    6885, X, X, 6886, X, X, 4802, 4803, 4804, 4805, 4806, X, X, X, X, X, 4807,
    4808, 4809, X, X, X, X, X, X, X, X, 4810, X, 4811, X, X, X, X, X, X, 2585,
    X, X, X, X, 2587, 2586, X, 2588, X, X, 2589, 2590, X, 2591, 2592, X, X, X,
    X, X, X, 2593, X, 2594, X, X, 7160, X, X, X, 7161, X, X, X, 7162, 7163, X,
    X, X, 7164, X, 7165, 7166, X, 7167, X, X, 7168, X, 7169, 7170, X, 7171,
    7172, X, 7173,
]; // 18922 entries

#[cfg(not(feature = "no-optimized-legacy-encoding"))]
const BACKWARD_TABLE_UPPER: &'static [u16] = &[
    0, 0, 0, 0, 0, 11486, 1569, 16592, 9732, 6616, 3981, 17204, 0, 0, 12912,
    12008, 0, 0, 0, 0, 0, 0, 7320, 0, 0, 0, 0, 0, 1747, 18060, 2671, 0, 18473,
    0, 2734, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2053, 11633, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12708, 13137,
    1477, 4825, 6785, 16272, 8378, 4104, 7294, 4559, 13612, 18648, 1537, 1764,
    11014, 16560, 13774, 10176, 9700, 15949, 6584, 6350, 3949, 18135, 4415,
    2260, 17172, 1688, 5279, 1445, 2918, 5606, 7124, 3005, 4072, 10236, 7445,
    1201, 14700, 15005, 7262, 5397, 16225, 3188, 4734, 448, 5036, 15235, 16852,
    6296, 7558, 13580, 18616, 10982, 2038, 16528, 13962, 2432, 11212, 13742,
    13001, 9668, 3563, 15917, 8406, 6318, 14379, 11097, 3917, 9938, 10204,
    15672, 572, 7413, 16253, 10859, 14668, 1322, 2286, 7230, 5004, 15203,
    16496, 13930, 10326, 16443, 6026, 241, 5220, 13710, 14347, 8845, 11065,
    11546, 7381, 10616, 14016, 13359, 14787, 9266, 15171, 10294, 12941, 15318,
    14256, 5939, 7874, 16411, 18037, 5547, 17855, 6970, 13984, 2409, 10679,
    8584, 10262, 6214, 15827, 12068, 7180, 15286, 14224, 17823, 6938, 11729,
    17028, 8464, 6182, 12576, 12325, 12661, 11993, 17791, 18859, 7831, 5784,
    11697, 5192, 11455, 1143, 15409, 1506, 10418, 8432, 11043, 13269, 6150,
    6553, 1414, 7093, 632, 14974, 8675, 3157, 12544, 11961, 1058, 5160, 3280,
    1262, 8906, 14548, 3034, 12030, 11423, 7474, 3828, 10062, 8785, 7803,
    13237, 417, 14729, 8732, 7682, 6265, 12512, 11929, 13440, 1026, 5128,
    16472, 8874, 7650, 18741, 12480, 2641, 18443, 13408, 2609, 13376, 18585,
    8259, 11851, 18553, 11819, 18521, 11787, 13209, 15493, 10951, 11603, 998,
    15465, 12678, 10772, 2553, 18489, 11755, 11575, 3719, 755, 10118, 10146,
    18105, 15803, 18077, 12273, 10919, 10537, 6735, 12301, 11181, 17142, 10740,
    17082, 12970, 10505, 17110, 2888, 5576, 3532, 10708, 2975, 15641, 15609,
    541, 6677, 509, 12859, 6462, 16647, 17054, 14605, 12047, 8043, 12891,
    10447, 16879, 2686, 2493, 4680, 5630, 1087, 6494, 14637, 15088, 1291,
    16195, 13159, 16911, 2718, 16822, 14577, 17882, 7199, 13899, 4918, 5662,
    210, 13550, 1119, 16943, 13679, 8814, 182, 8761, 15029, 11880, 7350, 4950,
    5908, 17426, 6879, 17394, 17546, 7843, 6847, 15522, 18006, 17362, 10801,
    7149, 17514, 6907, 11666, 15887, 6815, 880, 17330, 848, 10829, 17298,
    17733, 3748, 5996, 15758, 816, 17701, 5964, 784, 6241, 17669, 17637, 10387,
    1857, 17605, 9487, 9519, 6119, 6380, 9455, 6764, 6087, 8554, 2012, 5341,
    13057, 3126, 9423, 14194, 8522, 3249, 5309, 8168, 17761, 18228, 1231, 7772,
    13025, 14162, 8490, 8136, 7740, 8104, 16676, 8701, 13108, 16359, 5097,
    4796, 7619, 9885, 8072, 18412, 8228, 8349, 7501, 15434, 7708, 4764, 15149,
    8973, 2522, 5754, 9794, 10087, 3442, 11370, 6704, 15379, 10474, 18380,
    6523, 11907, 478, 2462, 1384, 8196, 13868, 9912, 18833, 14077, 7063, 8317,
    15117, 151, 5877, 0, 0, 0, 0, 8941, 602, 5722, 4386, 11338, 18348, 1352,
    8285, 17975, 15999, 3697, 17483, 11397, 10562, 17267, 10356, 2231, 16387,
    5523, 1826, 7985, 6056, 7031, 14944, 3638, 5250, 4354, 4622, 18316, 14104,
    1981, 17943, 8645, 12637, 15967, 14518, 3665, 387, 4705, 972, 15777, 7529,
    18711, 18197, 14131, 9639, 2579, 16328, 17235, 2199, 5491, 14912, 4322,
    4590, 18284, 9854, 725, 12243, 2172, 4975, 1949, 14318, 11151, 17911, 3411,
    3502, 4230, 15348, 14486, 355, 18679, 9607, 10587, 5459, 16067, 4290,
    13837, 120, 13185, 13330, 5846, 9237, 15579, 18252, 2380, 3296, 9822, 5691,
    11307, 12829, 12211, 2140, 17452, 14286, 11119, 3470, 15257, 1795, 7000,
    14454, 0, 0, 0, 0, 3607, 8013, 8614, 16999, 16972, 4650, 16035, 1632, 0, 0,
    4258, 13805, 10033, 2862, 15058, 3805, 16165, 941, 9177, 18166, 4446,
    12451, 3321, 14881, 12121, 694, 16095, 11636, 1918, 16800, 3380, 1719, 88,
    15857, 2949, 1660, 4199, 5814, 9205, 324, 15728, 1173, 3889, 9576, 2348,
    5428, 17575, 3096, 13299, 9393, 11275, 12797, 2108, 10001, 2830, 16133,
    13526, 15548, 909, 12180, 9087, 12419, 3219, 14849, 12089, 662, 7936, 8936,
    0, 0, 0, 0, 0, 0, 14423, 1886, 16768, 3348, 10672, 16004, 5067, 63, 4167,
    292, 6409, 15696, 8997, 7589, 4539, 11518, 3064, 9361, 11243, 1601, 4045,
    3774, 9146, 5370, 3594, 0, 2076, 14410, 16624, 9969, 10890, 2798, 4506,
    16101, 12148, 3858, 9545, 2317, 12772, 9764, 0, 0, 10640, 6648, 9329, 4889,
    18803, 13495, 4013, 9056, 9114, 2766, 4474, 12388, 14047, 12740, 14759, 0,
    0, 0, 6436, 14818, 7955, 9297, 7905, 13470, 4857, 18771, 16737, 12607, 0,
    0, 13650, 32, 13086, 9024, 16705, 12356, 18890, 4136, 16298, 261, 13644, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4508,
]; // 2043 entries

#[cfg(feature = "no-optimized-legacy-encoding")]
const BACKWARD_SEARCH_LOWER: &'static [(u16, u16)] = &[
    (0, 95), (285, 560), (130, 191), (64, 67), (560, 694), (694, 1003),
    (1003, 1312), (1307, 1572), (1572, 1830), (38487, 23986), (1830, 2102),
    (2102, 2386), (2386, 2662), (2662, 2919), (2919, 3193), (3193, 3519),
    (3519, 3815), (3815, 4077), (4077, 4364), (34149, 34369), (4356, 4673),
    (4673, 4949), (4949, 5208), (5208, 5593), (5593, 5812), (5812, 6110),
    (6110, 6361), (32776, 65374),
]; // 28 entries

#[cfg(feature = "no-optimized-legacy-encoding")]
const BACKWARD_SEARCH_UPPER: &'static [u16] = &[
    0, 2, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 6, 7, 8, 10,
    11, 12, 13, 14, 15, 16, 17, 18, 19, 21, 22, 23, 24, 25, 26, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
    27, 28,
]; // 65 entries

/// Returns the index pointer for code point `code` in this index.
#[inline]
#[cfg(not(feature = "no-optimized-legacy-encoding"))]
pub fn backward(code: u32) -> u16 {
    let offset = (code >> 5) as usize;
    let offset = if offset < 2043 {BACKWARD_TABLE_UPPER[offset] as usize} else {0};
    // BACKWARD_TABLE_LOWER stores the actual (pre-mapped) value
    // so we don't have to call premap_backward here.
    BACKWARD_TABLE_LOWER[offset + ((code & 31) as usize)]
}

/// Returns the index pointer for code point `code` in this index.
#[cfg(feature = "no-optimized-legacy-encoding")]
pub fn backward(code: u32) -> u16 {
    // avoid mistaking a placeholder for the actual value
    if code == X as u32 { return 0xffff; }
    let codelo = (code & 0xffff) as u16;
    let offset = (code >> 10) as usize;
    let (start, end) = if offset < 64 {
        (BACKWARD_SEARCH_UPPER[offset], BACKWARD_SEARCH_UPPER[offset+1])
    } else {
        (0, 0)
    };
    for &(s, e) in &BACKWARD_SEARCH_LOWER[(start as usize)..(end as usize)] {
        if s >= 0x8000 {
            if e == codelo {
                return premap_backward((s & 0x7fff) + 108);
            }
        } else {
            for i in s..e {
                if FORWARD_TABLE[i as usize] == codelo {
                    return premap_backward((i) + 108);
                }
            }
        }
    }
    X
}

#[cfg(test)]
multi_byte_tests! {
    dups = []
}
