/* Generated by re2c */
// re2c $INPUT -o $OUTPUT --eager-skip -bi --tags

#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <sys/time.h>
#include <stdint.h>
#include <inttypes.h>

#define PRE \
    int print_timing = argc == 2 && strcmp(argv[1], "-t") == 0 ? 1 : 0; \
    uint64_t start = getTimeMs();

#define POST \
    uint64_t stop = getTimeMs(); \
    if (print_timing) { \
        fprintf(stderr, "time (ms): %" PRIu64 "\n", stop - start); \
    }

static inline uint64_t getTimeMs()
{
    struct timeval tv;
    gettimeofday(&tv, NULL);
    return tv.tv_usec / 1000 + tv.tv_sec * 1000;
}

static const size_t SIZE = 4096 * 16;

typedef struct {
    char *buf;
    char *pos;
} Output;

static inline void init_output(Output *out)
{
    out->buf = (char*) malloc(SIZE);
    out->pos = out->buf;
}

static inline void free_output(Output *out)
{
    free(out->buf);
}

static inline void flush(Output *out)
{
    fwrite(out->buf, 1, out->pos - out->buf, stdout);
    out->pos = out->buf;
}

// define as macro to enforce inlining
#define outs(out, s, e) do {                 \
    long n = (e) - (s);                      \
    if ((out->pos - out->buf) + n >= SIZE) { \
        flush(out);                          \
    }                                        \
    memcpy(out->pos, s, n);                  \
    out->pos += n;                           \
} while (0)

// define as macro to enforce inlining
#define outc(out, c) do {                  \
    if (out->pos + 1 - out->buf >= SIZE) { \
        flush(out);                        \
    }                                      \
    *out->pos++ = c;                       \
} while (0)

// define as macro to enforce inlining
// first argument must be a string literal
#define OUT(s, p1, p2) do {          \
    const char *p = s;               \
    outs(out, p, p + sizeof(s) - 1); \
    outs(out, p1, p2);               \
    outc(out, '\n');                 \
} while (0)



typedef struct taglist_t {
    struct taglist_t *pred;
    long dist;
} taglist_t;

typedef struct taglistpool_t {
    taglist_t *head;
    taglist_t *next;
    taglist_t *last;
} taglistpool_t;

typedef struct {
    char *buf;
    char *lim;
    char *cur;
    char *mar;
    char *tok;
    char *yyt1;
char *yyt10;
char *yyt11;
char *yyt12;
char *yyt13;
char *yyt14;
char *yyt15;
char *yyt2;
char *yyt3;
char *yyt4;
char *yyt5;
char *yyt6;
char *yyt7;
char *yyt8;
char *yyt9;

    
    taglistpool_t tlp;
    int eof;
} input_t;

static inline void taglistpool_clear(taglistpool_t *tlp, input_t *in)
{
    tlp->next = tlp->head;
    
}

static inline void taglistpool_init(taglistpool_t *tlp)
{
    static const unsigned size = 1024 * 1024;
    tlp->head = (taglist_t*)malloc(size * sizeof(taglist_t));
    tlp->next = tlp->head;
    tlp->last = tlp->head + size;
}

static inline void taglistpool_free(taglistpool_t *tlp)
{
    free(tlp->head);
    tlp->head = tlp->next = tlp->last = NULL;
}

static inline void taglist(taglist_t **ptl, const char *b, const char *t, taglistpool_t *tlp)
{
#ifdef GROW_MTAG_LIST
    if (tlp->next >= tlp->last) {
        const unsigned size = tlp->last - tlp->head;
        taglist_t *head = (taglist_t*)malloc(2 * size * sizeof(taglist_t));
        memcpy(head, tlp->head, size * sizeof(taglist_t));
        free(tlp->head);
        tlp->head = head;
        tlp->next = head + size;
        tlp->last = head + size * 2;
    }
#else
    assert(tlp->next < tlp->last);
#endif
    taglist_t *tl = tlp->next++;
    tl->pred = *ptl;
    tl->dist = t - b;
    *ptl = tl;
}



#define YYMAXFILL 8


static inline int fill(input_t *in, size_t need)
{
    size_t free;
    if (in->eof) return 1;

    free = in->tok - in->buf;
    assert(free >= need);

    memmove(in->buf, in->tok, in->lim - in->tok);
    in->lim -= free;
    in->cur -= free;
    in->mar -= free;
    in->tok -= free;
    if (in->yyt1) in->yyt1 -= free;
if (in->yyt10) in->yyt10 -= free;
if (in->yyt11) in->yyt11 -= free;
if (in->yyt12) in->yyt12 -= free;
if (in->yyt13) in->yyt13 -= free;
if (in->yyt14) in->yyt14 -= free;
if (in->yyt15) in->yyt15 -= free;
if (in->yyt2) in->yyt2 -= free;
if (in->yyt3) in->yyt3 -= free;
if (in->yyt4) in->yyt4 -= free;
if (in->yyt5) in->yyt5 -= free;
if (in->yyt6) in->yyt6 -= free;
if (in->yyt7) in->yyt7 -= free;
if (in->yyt8) in->yyt8 -= free;
if (in->yyt9) in->yyt9 -= free;


    in->lim += fread(in->lim, 1, free, stdin);

    if (in->lim < in->buf + SIZE) {
        in->eof = 1;
        memset(in->lim, 0, YYMAXFILL);
        in->lim += YYMAXFILL;
    }

    return 0;
}

static inline void init_input(input_t *in)
{
    in->buf = (char*) malloc(SIZE + YYMAXFILL);
    in->lim = in->buf + SIZE;
    in->cur = in->lim;
    in->mar = in->lim;
    in->tok = in->lim;
    in->yyt1 = 0;
in->yyt10 = 0;
in->yyt11 = 0;
in->yyt12 = 0;
in->yyt13 = 0;
in->yyt14 = 0;
in->yyt15 = 0;
in->yyt2 = 0;
in->yyt3 = 0;
in->yyt4 = 0;
in->yyt5 = 0;
in->yyt6 = 0;
in->yyt7 = 0;
in->yyt8 = 0;
in->yyt9 = 0;

    
    taglistpool_init(&in->tlp);
    in->eof = 0;
}

static inline void free_input(input_t *in)
{
    free(in->buf);
    taglistpool_free(&in->tlp);
}

static int lex(input_t *in, Output *out);

int main(int argc, char **argv)
{
    PRE;
    input_t in;
    Output out;

    init_input(&in);
    init_output(&out);

    switch (lex(&in, &out)) {
        case 0:  break;
        case 1:  fprintf(stderr, "*** %s: syntax error\n", argv[0]); break;
        case 2:  fprintf(stderr, "*** %s: yyfill error\n", argv[0]); break;
        default: fprintf(stderr, "*** %s: panic\n", argv[0]); break;
    }

    flush(&out);
    free_output(&out);
    free_input(&in);

    POST;
    return 0;
}

static int lex(input_t *in, Output *out)
{
    const char
        *a0, *a1,
        *b0, *b1;
loop:
    in->tok = in->cur;

{
	char yych;
	static const unsigned char yybm[256] = {
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0, 192,  32,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0
	};
	if ((in->lim - in->cur) < 8) if (fill(in, 8) != 0) return 1;
	yych = *in->cur;
	if (yych <= 0x00) {
		++in->cur;
		goto yy1;
	}
	if (yych == 'a') {
		in->yyt1 = in->cur;
		in->yyt2 = in->cur;
		++in->cur;
		goto yy4;
	}
	++in->cur;
	goto yy2;
yy1:
	{ return 0; }
yy2:
yy3:
	{ return 1; }
yy4:
	yych = *(in->mar = in->cur);
	if (yych != 'a') goto yy3;
	in->yyt3 = in->cur;
	yych = *++in->cur;
	if (yych == 'a') {
		in->yyt4 = in->cur;
		++in->cur;
		goto yy6;
	}
yy5:
	in->cur = in->mar;
	goto yy3;
yy6:
	yych = *in->cur;
	if (yych != 'a') goto yy5;
	in->yyt5 = in->cur;
	yych = *++in->cur;
	if (yych != 'a') goto yy8;
	in->yyt6 = in->cur;
	in->yyt7 = in->cur;
	in->yyt8 = in->cur;
	yych = *++in->cur;
	if (yych <= '`') goto yy5;
	if (yych <= 'a') {
		in->yyt9 = in->cur;
		in->yyt10 = in->cur;
		in->yyt11 = in->cur;
		++in->cur;
		goto yy9;
	}
	if (yych >= 'c') goto yy5;
	in->yyt2 = in->yyt3;
	++in->cur;
yy7:
	if ((in->lim - in->cur) < 4) if (fill(in, 4) != 0) return 1;
	yych = *in->cur;
yy8:
	if (yybm[0+yych] & 32) {
		++in->cur;
		goto yy7;
	}
	if (yych == 'a') {
		in->yyt7 = in->cur;
		in->yyt8 = in->cur;
		++in->cur;
		goto yy10;
	}
	goto yy5;
yy9:
	yych = *in->cur;
	if (yych <= '`') goto yy5;
	if (yych <= 'a') {
		in->yyt12 = in->cur;
		in->yyt13 = in->cur;
		++in->cur;
		goto yy11;
	}
	if (yych <= 'b') {
		in->yyt2 = in->yyt4;
		++in->cur;
		goto yy7;
	}
	goto yy5;
yy10:
	yych = *in->cur;
	if (yych == 'a') {
		in->yyt3 = in->cur;
		++in->cur;
		goto yy12;
	}
	goto yy5;
yy11:
	yych = *in->cur;
	if (yych <= '`') goto yy5;
	if (yych <= 'a') {
		in->yyt14 = in->cur;
		in->yyt15 = in->cur;
		++in->cur;
		goto yy13;
	}
	if (yych <= 'b') {
		in->yyt2 = in->yyt5;
		++in->cur;
		goto yy7;
	}
	goto yy5;
yy12:
	yych = *in->cur;
	if (yych == 'a') {
		in->yyt4 = in->cur;
		++in->cur;
		goto yy14;
	}
	goto yy5;
yy13:
	if (in->lim <= in->cur) if (fill(in, 1) != 0) return 1;
	yych = *in->cur;
	if (yybm[0+yych] & 64) {
		in->yyt2 = in->yyt3;
		in->yyt3 = in->yyt4;
		in->yyt4 = in->yyt5;
		in->yyt7 = in->yyt10;
		in->yyt8 = in->yyt11;
		in->yyt10 = in->yyt13;
		in->yyt11 = in->yyt13;
		in->yyt13 = in->yyt15;
		in->yyt15 = in->cur;
		in->yyt5 = in->yyt6;
		in->yyt6 = in->yyt9;
		in->yyt9 = in->yyt12;
		in->yyt12 = in->yyt14;
		in->yyt14 = in->cur;
		++in->cur;
		goto yy13;
	}
	if (yych == '\n') {
		++in->cur;
		goto yy15;
	}
	if (yych <= '`') goto yy5;
	if (yych <= 'b') {
		++in->cur;
		goto yy16;
	}
	goto yy5;
yy14:
	yych = *in->cur;
	if (yych == 'a') {
		in->yyt5 = in->cur;
		++in->cur;
		goto yy17;
	}
	goto yy5;
yy15:
	a0 = in->yyt1;
	b0 = in->yyt2;
	a1 = in->yyt7;
	b1 = in->yyt8;
	{
        outs(out, a0, b0); outc(out, '.'); outs(out, b0, a1); outc(out, '.');
        outs(out, a1, b1); outc(out, '.'); outs(out, b1, in->cur);
        goto loop;
    }
yy16:
	if ((in->lim - in->cur) < 4) if (fill(in, 4) != 0) return 1;
	yych = *in->cur;
	if (yych <= '`') {
		if (yych == '\n') {
			++in->cur;
			goto yy15;
		}
		goto yy5;
	} else {
		if (yych <= 'a') {
			in->yyt2 = in->yyt6;
			in->yyt7 = in->cur;
			in->yyt8 = in->cur;
			++in->cur;
			goto yy10;
		}
		if (yych <= 'b') {
			++in->cur;
			goto yy16;
		}
		goto yy5;
	}
yy17:
	if (in->lim <= in->cur) if (fill(in, 1) != 0) return 1;
	yych = *in->cur;
	if (yybm[0+yych] & 128) {
		in->yyt8 = in->yyt3;
		in->yyt3 = in->yyt4;
		in->yyt4 = in->yyt5;
		in->yyt5 = in->cur;
		++in->cur;
		goto yy17;
	}
	if (yych == '\n') {
		++in->cur;
		goto yy15;
	}
	if (yych <= '`') goto yy5;
	if (yych >= 'c') goto yy5;
	++in->cur;
yy18:
	if (in->lim <= in->cur) if (fill(in, 1) != 0) return 1;
	yych = *in->cur;
	if (yych == '\n') {
		++in->cur;
		goto yy15;
	}
	if (yych == 'b') {
		++in->cur;
		goto yy18;
	}
	goto yy5;
}

}
eager_skip_with_bitmaps.re:245:9: warning: tag `b0` has 9th degree of nondeterminism [-Wnondeterministic-tags]
eager_skip_with_bitmaps.re:245:9: warning: tag `a1` has 5th degree of nondeterminism [-Wnondeterministic-tags]
eager_skip_with_bitmaps.re:245:9: warning: tag `b1` has 5th degree of nondeterminism [-Wnondeterministic-tags]
