% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ten.R
\name{ten}
\alias{ten}
\alias{ten.numeric}
\alias{ten.Surv}
\alias{ten.coxph}
\alias{ten.survfit}
\alias{ten.formula}
\alias{ten.data.frame}
\alias{ten.data.table}
\alias{ten.ten}
\title{\bold{t}ime, \bold{e}vent(s) and \bold{n}umber at risk.}
\usage{
ten(x, ...)

\method{ten}{numeric}(x, ...)

\method{ten}{Surv}(x, ..., call = NULL)

\method{ten}{coxph}(x, ..., abbNames = TRUE, contrasts.arg = NULL)

\method{ten}{survfit}(x, ..., abbNames = TRUE, contrasts.arg = NULL)

\method{ten}{formula}(x, ..., abbNames = TRUE, contrasts.arg = NULL)

\method{ten}{data.frame}(x, ..., abbNames = TRUE, contrasts.arg = NULL,
  call = NULL)

\method{ten}{data.table}(x, ..., abbNames = TRUE, mm = NULL, call = NULL)

\method{ten}{ten}(x, ..., abbNames = NULL, call = NULL)
}
\arguments{
\item{x}{For the default method, a \code{numeric} vector indicating an
\emph{event} (or status).
 \cr
Each element indicates whether an event occurred (\code{1}) or
not (\code{0}) for an observation.
 \cr
These are assumed to be ordered by discrete times.
 \cr
This is similar to the \code{event} argument for \code{Surv}
objects.
 \cr \cr
Methods are available for objects of class
\code{Surv}, \code{survfit},
\code{coxph} and \code{formula}.}

\item{...}{Additional arguments (not implemented).}

\item{call}{Used to pass the \code{call} from a \code{formula}
to the final \code{ten.data.table} method.}

\item{abbNames}{\bold{Abb}reviate names?
 \cr
If \code{abbNames="TRUE"} (the default), 
the covariate groups are referred to by number. 
 \cr
As the names for each covariate group are made by concatenating
the predictor names, the full names can become unwieldly.
 \cr
If \code{abbNames="FALSE"}, the full names are given.
 \cr
In either case, the \code{longNames} are given
as an \code{attribute} of the returned \code{ten} object.}

\item{contrasts.arg}{Methods for handling factors.
 \cr
A \code{list}. The \code{names} are the names of
columns of the \code{model.frame} containing
\code{factor}s.
 \cr
The \emph{values} are used as replacement
values for the \code{stats::contrasts} replacement function.
These should be functions (given as character strings)
or numeric matrices. 
 \cr
This can be passed from
\code{survfit}, \code{coxph} and \code{formula} objects to:
 \cr
?stats::model.matrix}

\item{mm}{Used to pass the \code{model.matrix} from a \code{formula}
to the final \code{ten.data.table} method.}
}
\value{
A \code{data.table} with the additional \code{class}
\code{ten}. 
 \cr
By default, the shape returned is 'long' i.e. there is one row for each unique 
 timepoint per covariate group. 
 \cr
The basic form, for a \code{numeric} or \code{Surv} object, has columns: 
 \item{t}{\bold{t}ime.}
 \item{e}{number of \bold{e}vents.}
 \item{n}{\bold{n}umber at risk.}
A \code{survfit}, \code{coxph} or \code{formula} object
will have additional columns:
 \item{cg}{\bold{c}ovariate \bold{g}roup.
  This is formed by combining the variables; these
  are separated by a comma ','.}
 \item{ncg}{\bold{n}umber at risk, by \bold{c}ovariate \bold{g}roup}
 
\bold{Special terms}.
 \cr \cr
The following are considered 'special'
terms in a survival model:
  \item{strata}{For a stratified model, \code{ten} returns a \code{list} with
   one element per strata, which is a \code{ten} object.
    \cr
   This has the class \code{stratTen}. The name of the 
   list elements are those of the strata in the model.}
  \item{cluster}{These terms are dropped.}
  \item{tt}{The variable is unchanged. That is, time-transform
   terms are handled as if the the function
   \code{tt(x)} was \code{identity(x)}.}
\bold{Attribures}.
 \cr
The returned object will also have the following \code{attributes}:
 \item{shape}{The default is \code{"long"} but 
  is changed to \code{"wide"} when \code{asWide} is called on the object.}
 \item{abbNames}{Abbreviate names?}
 \item{longNames}{A \code{data.table} with two columns, showing the abbrevbiated 
  and full names.}
 \item{ncg}{Number of covariate groups}
 \item{call}{The call used to generate the object}
 \item{mm}{The \code{model.matrix} used to generate to 
  generate the object, if applicable.}
Additional attributes will be added by the following functions:
 \cr
\code{\link{sf}}
\code{\link{ci}}
}
\description{
\bold{t}ime, \bold{e}vent(s) and \bold{n}umber at risk.
}
\note{
The methods for \code{data.frame} (for a model frame)
and \code{data.table} are not typically intended for interactive use.
 \cr \cr
Currently only binary status and right-censoring
are supported. 
 \cr \cr
In stratified models, only one level of stratification is supported
(i.e. strata cannot be 'nested' currently).
 \cr \cr
Partial matching is available for the
following arguments, based on the characters in bold:
\itemize{
 \item \bold{abb}Names
 \item \bold{con}trasts.arg
}
}
\examples{
require("survival")
## binary vector
ten(c(1, 0, 1, 0, 1))

## Surv object
df0 <- data.frame(t=c(1, 1, 2, 3, 5, 8, 13, 21),
                  e=rep(c(0, 1), 4))
s1 <- with(df0, Surv(t, e, type="right"))
ten(s1)
## some awkward values
suppressWarnings(
    s1 <- Surv(time=c(Inf, -1, NaN, NA, 10, 12),
               event=c(c(NA, 1, 1, NaN, Inf, 0.75))))
ten(s1)

## coxph object
## K&M. Section 1.2. Table 1.1, page 2.
data("hodg", package="KMsurv")
hodg <- data.table::data.table(hodg)
data.table::setnames(hodg,
                     c(names(hodg)[!names(hodg) \%in\%
                                   c("score", "wtime")],
                       "Z1", "Z2"))
c1 <- coxph(Surv(time=time, event=delta) ~ Z1 + Z2,
            data=hodg[gtype==1 && dtype==1, ])
ten(c1)
data("bmt", package="KMsurv")
ten(c1 <- coxph(Surv(t2, d3) ~ z3*z10, data=bmt))
## T&G. Section 3.2, pg 47.
## stratified model
data("pbc", package="survival")
c1 <- coxph(Surv(time, status==2) ~ log(bili) + age + strata(edema), data=pbc)
ten(c1)

## K&M. Example 7.2, pg 210.
data("kidney", package="KMsurv")
with(kidney[kidney$type==2, ], ten(Surv(time=time, event=delta)))
s1 <- survfit(Surv(time=time, event=delta) ~ type, data=kidney)
ten(s1)[e > 0, ]

## A null model is passed to ten.Surv
(t1 <- with(kidney, ten(Surv(time=time, event=delta) ~ 0)))
## but the original call is preserved
attr(t1, "call")
## survival::survfit doesn't accept interaction terms...
\dontrun{
    s1 <- survfit(Surv(t2, d3) ~ z3*z10, data=bmt)}
## but ten.formula does:
ten(Surv(time=t2, event=d3) ~ z3*z10, data=bmt)
## the same is true for the '.' (dot operator) in formulas
(t1 <- ten(Surv(time=t2, event=d3) ~ ., data=bmt))
## impractical long names stored as an attribute
attr(t1, "longNames")

## not typically intended to be called directly
mf1 <- stats::model.frame(Surv(time, status==2) ~ age + strata(edema) + strata(spiders), pbc, 
                          drop.unused.levels = TRUE)
ten(mf1)

}
\seealso{
\code{\link{asWide}}

\code{\link{print}}
}
