% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_CosmicRayRemoval.R
\name{apply_CosmicRayRemoval}
\alias{apply_CosmicRayRemoval}
\title{Function to remove cosmic rays from an RLum.Data.Spectrum S4 class object}
\usage{
apply_CosmicRayRemoval(
  object,
  method = "smooth",
  method.Pych.smoothing = 2,
  method.Pych.threshold_factor = 3,
  MARGIN = 2,
  verbose = FALSE,
  plot = FALSE,
  ...
)
}
\arguments{
\item{object}{\linkS4class{RLum.Data.Spectrum} or \linkS4class{RLum.Analysis} (\strong{required}): input
object to be treated. This can be also provided as \link{list}. If an \linkS4class{RLum.Analysis} object
is provided, only the \linkS4class{RLum.Data.Spectrum} objects are treated. Please note: this mixing of
objects do not work for a list of \code{RLum.Data} objects.}

\item{method}{\link{character} (\emph{with default}):
Defines method that is applied for cosmic ray removal. Allowed methods are
\code{smooth}, the default, (\link{smooth}), \code{smooth.spline} (\link{smooth.spline})
and \code{Pych}. See details for further information.}

\item{method.Pych.smoothing}{\link{integer} (\emph{with default}):
Smoothing parameter for cosmic ray removal according to Pych (2003).
The value defines how many neighbouring values in each frame are used for smoothing
(e.g., \code{2} means that the two previous and two following values are used).}

\item{method.Pych.threshold_factor}{\link{numeric} (\emph{with default}):
Threshold for zero-bins in the histogram. Small values mean that more peaks
are removed, but signal might be also affected by this removal.}

\item{MARGIN}{\link{integer} (\emph{with default}):
on which part the function cosmic ray removal should be applied on:
\itemize{
\item 1 = along the time axis (line by line),
\item 2 = along the wavelength axis (column by column).
}

\strong{Note:} This argument currently only affects the methods \code{smooth} and \code{smooth.spline}}

\item{verbose}{\link{logical} (\emph{with default}):
Option to suppress terminal output.,}

\item{plot}{\link{logical} (\emph{with default}):
If \code{TRUE} the histograms used for the cosmic-ray removal are returned as plot
including the used threshold. Note: A separate plot is returned for each frame!
Currently only for \code{method = "Pych"} a graphical output is provided.}

\item{...}{further arguments and graphical parameters that will be passed
to the \link{smooth} function.}
}
\value{
Returns same object as input.
}
\description{
The function provides several methods for cosmic-ray removal and spectrum
smoothing \linkS4class{RLum.Data.Spectrum} objects and such objects embedded in \link{list} or
\linkS4class{RLum.Analysis} objects.
}
\details{
\strong{\code{method = "Pych"}}

This method applies the cosmic-ray removal algorithm described by Pych
(2003). Some aspects that are different to the publication:
\itemize{
\item For interpolation between neighbouring values the median and not the mean is used.
\item The number of breaks to construct the histogram is set to: \code{length(number.of.input.values)/2}
}

For further details see references below.

\strong{\code{method = "smooth"}}

Method uses the function \link{smooth} to remove cosmic rays.

Arguments that can be passed are: \code{kind}, \code{twiceit}

\strong{\code{method = "smooth.spline"}}

Method uses the function \link{smooth.spline} to remove cosmic rays.

Arguments that can be passed are: \code{spar}

\strong{How to combine methods?}

Different methods can be combined by applying the method repeatedly to the
dataset (see example).
}
\section{Function version}{
 0.3.0
}

\examples{

##(1) - use with your own data and combine (uncomment for usage)
## run two times the default method and smooth with another method
## your.spectrum <- apply_CosmicRayRemoval(your.spectrum, method = "Pych")
## your.spectrum <- apply_CosmicRayRemoval(your.spectrum, method = "Pych")
## your.spectrum <- apply_CosmicRayRemoval(your.spectrum, method = "smooth")

} 

\section{How to cite}{
Kreutzer, S., 2023. apply_CosmicRayRemoval(): Function to remove cosmic rays from an RLum.Data.Spectrum S4 class object. Function version 0.3.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., 2023. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.21. https://CRAN.R-project.org/package=Luminescence
}

\references{
Pych, W., 2004. A Fast Algorithm for Cosmic-Ray Removal from
Single Images. The Astronomical Society of the Pacific 116 (816), 148-153.
\doi{10.1086/381786}
}
\seealso{
\linkS4class{RLum.Data.Spectrum}, \linkS4class{RLum.Analysis}, \link{smooth}, \link{smooth.spline},
\link{apply_CosmicRayRemoval}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team}
\keyword{manip}
