% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_card_fn.R
\name{as_cards_fn}
\alias{as_cards_fn}
\alias{is_cards_fn}
\alias{get_cards_fn_stat_names}
\title{As card function}
\usage{
as_cards_fn(f, stat_names)

is_cards_fn(f)

get_cards_fn_stat_names(f)
}
\arguments{
\item{f}{(\code{function})\cr
a function}

\item{stat_names}{(\code{character})\cr
a character vector of the expected statistic names returned by function \code{f}}
}
\value{
an ARD data frame of class 'card'
}
\description{
Add attributes to a function that specify the expected results.
It is used when \code{ard_summary()} or \code{ard_mvsummary()} errors and constructs
an ARD with the correct structure when the results cannot be calculated.
}
\examples{
# When there is no error, everything works as if we hadn't used `as_card_fn()`
ttest_works <-
  as_cards_fn(
    \(x) t.test(x)[c("statistic", "p.value")],
    stat_names = c("statistic", "p.value")
  )
ard_summary(
  mtcars,
  variables = mpg,
  statistic = ~ list(ttest = ttest_works)
)

# When there is an error and we use `as_card_fn()`,
#   we will see the same structure as when there is no error
ttest_error <-
  as_cards_fn(
    \(x) {
      t.test(x)[c("statistic", "p.value")]
      stop("Intentional Error")
    },
    stat_names = c("statistic", "p.value")
  )
ard_summary(
  mtcars,
  variables = mpg,
  statistic = ~ list(ttest = ttest_error)
)

# if we don't use `as_card_fn()` and there is an error,
#   the returned result is only one row
ard_summary(
  mtcars,
  variables = mpg,
  statistic = ~ list(ttest = \(x) {
    t.test(x)[c("statistic", "p.value")]
    stop("Intentional Error")
  })
)
}
