% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Diversity.R
\name{plotDiversityTest}
\alias{plotDiversityTest}
\title{Plot the results of diversity testing}
\usage{
plotDiversityTest(
  data,
  q,
  colors = NULL,
  main_title = "Diversity",
  legend_title = "Group",
  log_d = FALSE,
  annotate = c("none", "depth"),
  silent = FALSE,
  ...
)
}
\arguments{
\item{data}{\link{DiversityCurve} object returned by 
\link{alphaDiversity}.}

\item{q}{diversity order to plot the test for.}

\item{colors}{named character vector whose names are values in the 
\code{group} column of the \code{data} slot of \code{data},
and whose values are colors to assign to those group names.}

\item{main_title}{string specifying the plot title.}

\item{legend_title}{string specifying the legend title.}

\item{log_d}{if \code{TRUE} then plot the diversity scores \eqn{D} 
on a log scale; if \code{FALSE} plot on a linear scale.}

\item{annotate}{string defining whether to added values to the group labels 
of the legend. When \code{"none"} (default) is specified no
annotations are added. Specifying (\code{"depth"}) adds 
sequence counts to the labels.}

\item{silent}{if \code{TRUE} do not draw the plot and just return the ggplot2 
object; if \code{FALSE} draw the plot.}

\item{...}{additional arguments to pass to ggplot2::theme.}
}
\value{
A \code{ggplot} object defining the plot.
}
\description{
\code{plotDiversityTest} plots summary data for a \code{DiversityCurve} object 
with mean and a line range indicating plus/minus one standard deviation.
}
\examples{
# Calculate diversity
div <- alphaDiversity(ExampleDb, group="sample_id", min_q=0, max_q=2, step_q=1, nboot=100)

# Plot results at q=0 (equivalent to species richness)
plotDiversityTest(div, 0, legend_title="Sample")

# Plot results at q=2 (equivalent to Simpson's index)
plotDiversityTest(div, q=2, legend_title="Sample")

}
\seealso{
See \link{alphaDiversity} for generating input.
          Plotting is performed with \link{ggplot}.
}
