% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateObject.R
\name{updateObject}
\alias{updateObject}
\alias{updateObject,SingleCellExperiment-method}
\title{Update a SingleCellExperiment object}
\usage{
\S4method{updateObject}{SingleCellExperiment}(object, ..., verbose = FALSE)
}
\arguments{
\item{object}{A old \linkS4class{SingleCellExperiment} object.}

\item{...}{Additional arguments that are ignored.}

\item{verbose}{Logical scalar indicating whether a message should be emitted as the object is updated.}
}
\value{
An updated version of \code{object}.
}
\description{
Update \linkS4class{SingleCellExperiment} objects to the latest version of the class structure.
This is usually called by methods in the \pkg{SingleCellExperiment} package rather than by users or downstream packages.
}
\details{
This function updates the SingleCellExperiment to match changes in the internal class representation.
Changes are as follows:
\itemize{
\item Objects created before 1.7.1 are modified to include \code{\link{altExps}} and \code{\link{reducedDims}} fields in their internal column metadata.
Reduced dimension results previously in the \code{reducedDims} slot are transferred to the \code{reducedDims} field.
\item Objects created before 1.9.1 are modified so that the size factors are stored by \code{\link{sizeFactors<-}} in \code{\link{colData}} rather than \code{\link{int_colData}}.
}
}
\seealso{
\code{\link{objectVersion}}, which is used to determine if the object is up-to-date.
}
\author{
Aaron Lun
}
