% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_dmSQTLdata.R
\docType{class}
\name{dmSQTLdata-class}
\alias{dmSQTLdata-class}
\alias{counts,dmSQTLdata-method}
\alias{samples,dmSQTLdata-method}
\alias{names,dmSQTLdata-method}
\alias{length,dmSQTLdata-method}
\alias{[,dmSQTLdata,ANY-method}
\alias{[,dmSQTLdata-method}
\title{dmSQTLdata object}
\usage{
\S4method{counts}{dmSQTLdata}(object)

\S4method{samples}{dmSQTLdata}(x)

\S4method{names}{dmSQTLdata}(x)

\S4method{length}{dmSQTLdata}(x)

\S4method{[}{dmSQTLdata,ANY}(x, i, j)
}
\arguments{
\item{x, object}{dmSQTLdata object.}

\item{i, j}{Parameters used for subsetting.}
}
\value{
\itemize{ \item \code{names(x)}: Get the gene names. \item \code{length(x)}: 
Get the number of genes. \item \code{x[i, j]}: Get a subset of dmDSdata 
object that consists of counts, genotypes and blocks corresponding to genes i
and samples j. }
}
\description{
dmSQTLdata contains genomic feature expression (counts), genotypes and sample
information needed for the transcript/exon usage QTL analysis. It can be 
created with function \code{\link{dmSQTLdata}}.
}
\section{Slots}{

\describe{
\item{\code{counts}}{\code{\linkS4class{MatrixList}} of expression, in counts, of 
genomic features. Rows correspond to genomic features, such as exons or 
transcripts. Columns correspond to samples. MatrixList is partitioned in a 
way that each of the matrices in a list contains counts for a single gene.}

\item{\code{genotypes}}{MatrixList of unique genotypes. Rows correspond to blocks, 
columns to samples. Each matrix in this list is a collection of unique 
genotypes that are matched with a given gene.}

\item{\code{blocks}}{MatrixList with two columns \code{block_id} and \code{snp_id}. 
For each gene, it identifies SNPs with identical genotypes across the 
samples and assigns them to blocks.}

\item{\code{samples}}{Data frame with information about samples. It must contain 
variable \code{sample_id} with unique sample names.}
}}

\examples{
# --------------------------------------------------------------------------
# Create dmSQTLdata object
# --------------------------------------------------------------------------
# Use subsets of data defined in the GeuvadisTranscriptExpr package

library(GeuvadisTranscriptExpr)
\donttest{
geuv_counts <- GeuvadisTranscriptExpr::counts
geuv_genotypes <- GeuvadisTranscriptExpr::genotypes
geuv_gene_ranges <- GeuvadisTranscriptExpr::gene_ranges
geuv_snp_ranges <- GeuvadisTranscriptExpr::snp_ranges

colnames(geuv_counts)[c(1,2)] <- c("feature_id", "gene_id")
colnames(geuv_genotypes)[4] <- "snp_id"
geuv_samples <- data.frame(sample_id = colnames(geuv_counts)[-c(1,2)])

d <- dmSQTLdata(counts = geuv_counts, gene_ranges = geuv_gene_ranges,  
  genotypes = geuv_genotypes, snp_ranges = geuv_snp_ranges, 
  samples = geuv_samples, window = 5e3)
}
}
\seealso{
\code{\linkS4class{dmSQTLprecision}}, 
  \code{\linkS4class{dmSQTLfit}}, \code{\linkS4class{dmSQTLtest}}
}
\author{
Malgorzata Nowicka
}
