# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.netapp.aio import NetAppManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetAppManagementActiveDirectoryConfigsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetAppManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_active_directory_configs_get(self, resource_group):
        response = await self.client.active_directory_configs.get(
            resource_group_name=resource_group.name,
            active_directory_config_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_active_directory_configs_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.active_directory_configs.begin_create_or_update(
                resource_group_name=resource_group.name,
                active_directory_config_name="str",
                body={
                    "location": "str",
                    "etag": "str",
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "name": "str",
                    "properties": {
                        "domain": "str",
                        "secretPassword": {
                            "identity": {"principalId": "str", "userAssignedIdentity": "str"},
                            "keyVaultProperties": {"keyVaultUri": "str", "secretName": "str"},
                        },
                        "activeDirectoryStatus": "str",
                        "administrators": ["str"],
                        "backupOperators": ["str"],
                        "dns": ["str"],
                        "organizationalUnit": "str",
                        "provisioningState": "str",
                        "securityOperators": ["str"],
                        "site": "str",
                        "smbServerName": "str",
                        "userName": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_active_directory_configs_begin_update(self, resource_group):
        response = await (
            await self.client.active_directory_configs.begin_update(
                resource_group_name=resource_group.name,
                active_directory_config_name="str",
                body={
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "properties": {
                        "administrators": ["str"],
                        "backupOperators": ["str"],
                        "dns": ["str"],
                        "domain": "str",
                        "organizationalUnit": "str",
                        "secretPassword": {
                            "identity": {"principalId": "str", "userAssignedIdentity": "str"},
                            "keyVaultProperties": {"keyVaultUri": "str", "secretName": "str"},
                        },
                        "securityOperators": ["str"],
                        "site": "str",
                        "smbServerName": "str",
                        "userName": "str",
                    },
                    "tags": {"str": "str"},
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_active_directory_configs_begin_delete(self, resource_group):
        response = await (
            await self.client.active_directory_configs.begin_delete(
                resource_group_name=resource_group.name,
                active_directory_config_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_active_directory_configs_list_by_resource_group(self, resource_group):
        response = self.client.active_directory_configs.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_active_directory_configs_list_by_subscription(self, resource_group):
        response = self.client.active_directory_configs.list_by_subscription()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
