# pylint: disable=too-many-locals,protected-access
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
import json
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, overload

from azure.core import PipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._configuration import MetricsClientConfiguration
from .._utils.model_base import SdkJSONEncoder, _deserialize, _failsafe_deserialize
from .._utils.serialization import Serializer
from .._utils.utils import ClientMixinABC

JSON = MutableMapping[str, Any]
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_metrics_query_resources_request(
    subscription_id: str,
    *,
    metric_namespace: str,
    metric_names: List[str],
    start_time: Optional[str] = None,
    end_time: Optional[str] = None,
    interval: Optional[str] = None,
    aggregation: Optional[str] = None,
    top: Optional[int] = None,
    order_by: Optional[str] = None,
    filter: Optional[str] = None,
    roll_up_by: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("content-type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/subscriptions/{subscriptionId}/metrics:getBatch"
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if start_time is not None:
        _params["starttime"] = _SERIALIZER.query("start_time", start_time, "str")
    if end_time is not None:
        _params["endtime"] = _SERIALIZER.query("end_time", end_time, "str")
    if interval is not None:
        _params["interval"] = _SERIALIZER.query("interval", interval, "str")
    _params["metricnamespace"] = _SERIALIZER.query("metric_namespace", metric_namespace, "str")
    _params["metricnames"] = _SERIALIZER.query("metric_names", metric_names, "[str]", div=",")
    if aggregation is not None:
        _params["aggregation"] = _SERIALIZER.query("aggregation", aggregation, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")
    if order_by is not None:
        _params["orderby"] = _SERIALIZER.query("order_by", order_by, "str")
    if filter is not None:
        _params["filter"] = _SERIALIZER.query("filter", filter, "str")
    if roll_up_by is not None:
        _params["rollupby"] = _SERIALIZER.query("roll_up_by", roll_up_by, "str")

    # Construct headers
    if content_type is not None:
        _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class _MetricsClientOperationsMixin(
    ClientMixinABC[PipelineClient[HttpRequest, HttpResponse], MetricsClientConfiguration]
):

    @overload
    def _query_resources(
        self,
        subscription_id: str,
        batch_request: _models._models.ResourceIdList,
        *,
        metric_namespace: str,
        metric_names: List[str],
        start_time: Optional[str] = None,
        end_time: Optional[str] = None,
        interval: Optional[str] = None,
        aggregation: Optional[str] = None,
        top: Optional[int] = None,
        order_by: Optional[str] = None,
        filter: Optional[str] = None,
        roll_up_by: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models._models.MetricResultsResponse: ...
    @overload
    def _query_resources(
        self,
        subscription_id: str,
        batch_request: JSON,
        *,
        metric_namespace: str,
        metric_names: List[str],
        start_time: Optional[str] = None,
        end_time: Optional[str] = None,
        interval: Optional[str] = None,
        aggregation: Optional[str] = None,
        top: Optional[int] = None,
        order_by: Optional[str] = None,
        filter: Optional[str] = None,
        roll_up_by: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models._models.MetricResultsResponse: ...
    @overload
    def _query_resources(
        self,
        subscription_id: str,
        batch_request: IO[bytes],
        *,
        metric_namespace: str,
        metric_names: List[str],
        start_time: Optional[str] = None,
        end_time: Optional[str] = None,
        interval: Optional[str] = None,
        aggregation: Optional[str] = None,
        top: Optional[int] = None,
        order_by: Optional[str] = None,
        filter: Optional[str] = None,
        roll_up_by: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models._models.MetricResultsResponse: ...

    @distributed_trace
    def _query_resources(
        self,
        subscription_id: str,
        batch_request: Union[_models._models.ResourceIdList, JSON, IO[bytes]],
        *,
        metric_namespace: str,
        metric_names: List[str],
        start_time: Optional[str] = None,
        end_time: Optional[str] = None,
        interval: Optional[str] = None,
        aggregation: Optional[str] = None,
        top: Optional[int] = None,
        order_by: Optional[str] = None,
        filter: Optional[str] = None,
        roll_up_by: Optional[str] = None,
        **kwargs: Any
    ) -> _models._models.MetricResultsResponse:
        """Lists the metric values for multiple resources.

        :param subscription_id: The subscription identifier for the resources in this batch. Required.
        :type subscription_id: str
        :param batch_request: Metrics batch body including the list of resource ids. Is one of the
         following types: ResourceIdList, JSON, IO[bytes] Required.
        :type batch_request: ~azure.monitor.querymetrics.models._models.ResourceIdList or JSON or
         IO[bytes]
        :keyword metric_namespace: Metric namespace that contains the requested metric names. Required.
        :paramtype metric_namespace: str
        :keyword metric_names: The names of the metrics (comma separated) to retrieve. Required.
        :paramtype metric_names: list[str]
        :keyword start_time: The start time of the query. It is a string in the format
         'yyyy-MM-ddTHH:mm:ss.fffZ'. If you have specified the endtime parameter, then
         this parameter is required.
         If only starttime is specified, then endtime defaults to the current time.
         If no time interval is specified, the default is 1 hour. Default value is None.
        :paramtype start_time: str
        :keyword end_time: The end time of the query. It is a string in the format
         'yyyy-MM-ddTHH:mm:ss.fffZ'. Default value is None.
        :paramtype end_time: str
        :keyword interval: The interval (i.e. timegrain) of the query in ISO 8601 duration format.
         Defaults to PT1M. Special case for 'FULL' value that returns single datapoint
         for entire time span requested.
         *Examples: PT15M, PT1H, P1D, FULL*. Default value is None.
        :paramtype interval: str
        :keyword aggregation: The list of aggregation types (comma separated) to retrieve. *Examples:
         average, minimum, maximum*. Default value is None.
        :paramtype aggregation: str
        :keyword top: The maximum number of records to retrieve per resource ID in the request.
         Valid only if filter is specified.
         Defaults to 10. Default value is None.
        :paramtype top: int
        :keyword order_by: The aggregation to use for sorting results and the direction of the sort.
         Only one order can be specified.
         *Examples: sum asc*. Default value is None.
        :paramtype order_by: str
        :keyword filter: The filter is used to reduce the set of metric data
         returned.<br>Example:<br>Metric contains metadata A, B and C.<br>- Return all
         time series of C where A = a1 and B = b1 or b2<br>**filter=A eq ‘a1’ and B eq
         ‘b1’ or B eq ‘b2’ and C eq ‘*’**<br>- Invalid variant:<br>**filter=A eq ‘a1’
         and B eq ‘b1’ and C eq ‘*’ or B = ‘b2’**<br>This is invalid because the logical
         or operator cannot separate two different metadata names.<br>- Return all time
         series where A = a1, B = b1 and C = c1:<br>**filter=A eq ‘a1’ and B eq ‘b1’ and
         C eq ‘c1’**<br>- Return all time series where A = a1<br>**filter=A eq ‘a1’ and
         B eq ‘*’ and C eq ‘*’**. Default value is None.
        :paramtype filter: str
        :keyword roll_up_by: Dimension name(s) to rollup results by. For example if you only want to
         see
         metric values with a filter like 'City eq Seattle or City eq Tacoma' but don't
         want to see separate values for each city, you can specify 'RollUpBy=City' to
         see the results for Seattle and Tacoma rolled up into one timeseries. Default value is None.
        :paramtype roll_up_by: str
        :return: MetricResultsResponse. The MetricResultsResponse is compatible with MutableMapping
        :rtype: ~azure.monitor.querymetrics.models._models.MetricResultsResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("content-type", None))
        cls: ClsType[_models._models.MetricResultsResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(batch_request, (IOBase, bytes)):
            _content = batch_request
        else:
            _content = json.dumps(batch_request, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_metrics_query_resources_request(
            subscription_id=subscription_id,
            metric_namespace=metric_namespace,
            metric_names=metric_names,
            start_time=start_time,
            end_time=end_time,
            interval=interval,
            aggregation=aggregation,
            top=top,
            order_by=order_by,
            filter=filter,
            roll_up_by=roll_up_by,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models._models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(
                _models._models.MetricResultsResponse, response.json()  # pylint: disable=protected-access
            )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
