# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class CollectionConfigurationError(_serialization.Model):
    """Represents an error while SDK parses and applies an instance of CollectionConfigurationInfo.

    All required parameters must be populated in order to send to server.

    :ivar collection_configuration_error_type: Error type. Required. Known values are: "Unknown",
     "PerformanceCounterParsing", "PerformanceCounterUnexpected", "PerformanceCounterDuplicateIds",
     "DocumentStreamDuplicateIds", "DocumentStreamFailureToCreate",
     "DocumentStreamFailureToCreateFilterUnexpected", "MetricDuplicateIds",
     "MetricTelemetryTypeUnsupported", "MetricFailureToCreate",
     "MetricFailureToCreateFilterUnexpected", "FilterFailureToCreateUnexpected", and
     "CollectionConfigurationFailureToCreateUnexpected".
    :vartype collection_configuration_error_type: str or
     ~quickpulse_client.models.CollectionConfigurationErrorType
    :ivar message: Error message. Required.
    :vartype message: str
    :ivar full_exception: Exception that led to the creation of the configuration error. Required.
    :vartype full_exception: str
    :ivar data: Custom properties to add more information to the error. Required.
    :vartype data: list[~quickpulse_client.models.KeyValuePairString]
    """

    _validation = {
        "collection_configuration_error_type": {"required": True},
        "message": {"required": True},
        "full_exception": {"required": True},
        "data": {"required": True},
    }

    _attribute_map = {
        "collection_configuration_error_type": {"key": "CollectionConfigurationErrorType", "type": "str"},
        "message": {"key": "Message", "type": "str"},
        "full_exception": {"key": "FullException", "type": "str"},
        "data": {"key": "Data", "type": "[KeyValuePairString]"},
    }

    def __init__(
        self,
        *,
        collection_configuration_error_type: Union[str, "_models.CollectionConfigurationErrorType"],
        message: str,
        full_exception: str,
        data: List["_models.KeyValuePairString"],
        **kwargs: Any
    ) -> None:
        """
        :keyword collection_configuration_error_type: Error type. Required. Known values are:
         "Unknown", "PerformanceCounterParsing", "PerformanceCounterUnexpected",
         "PerformanceCounterDuplicateIds", "DocumentStreamDuplicateIds",
         "DocumentStreamFailureToCreate", "DocumentStreamFailureToCreateFilterUnexpected",
         "MetricDuplicateIds", "MetricTelemetryTypeUnsupported", "MetricFailureToCreate",
         "MetricFailureToCreateFilterUnexpected", "FilterFailureToCreateUnexpected", and
         "CollectionConfigurationFailureToCreateUnexpected".
        :paramtype collection_configuration_error_type: str or
         ~quickpulse_client.models.CollectionConfigurationErrorType
        :keyword message: Error message. Required.
        :paramtype message: str
        :keyword full_exception: Exception that led to the creation of the configuration error.
         Required.
        :paramtype full_exception: str
        :keyword data: Custom properties to add more information to the error. Required.
        :paramtype data: list[~quickpulse_client.models.KeyValuePairString]
        """
        super().__init__(**kwargs)
        self.collection_configuration_error_type = collection_configuration_error_type
        self.message = message
        self.full_exception = full_exception
        self.data = data


class CollectionConfigurationInfo(_serialization.Model):
    """Represents the collection configuration - a customizable description of performance counters,
    metrics, and full telemetry documents to be collected by the client SDK.

    All required parameters must be populated in order to send to server.

    :ivar e_tag: An encoded string that indicates whether the collection configuration is changed.
     Required.
    :vartype e_tag: str
    :ivar metrics: An array of metric configuration info. Required.
    :vartype metrics: list[~quickpulse_client.models.DerivedMetricInfo]
    :ivar document_streams: An array of document stream configuration info. Required.
    :vartype document_streams: list[~quickpulse_client.models.DocumentStreamInfo]
    :ivar quota_info: Controls document quotas to be sent to Live Metrics.
    :vartype quota_info: ~quickpulse_client.models.QuotaConfigurationInfo
    """

    _validation = {
        "e_tag": {"required": True},
        "metrics": {"required": True},
        "document_streams": {"required": True},
    }

    _attribute_map = {
        "e_tag": {"key": "ETag", "type": "str"},
        "metrics": {"key": "Metrics", "type": "[DerivedMetricInfo]"},
        "document_streams": {"key": "DocumentStreams", "type": "[DocumentStreamInfo]"},
        "quota_info": {"key": "QuotaInfo", "type": "QuotaConfigurationInfo"},
    }

    def __init__(
        self,
        *,
        e_tag: str,
        metrics: List["_models.DerivedMetricInfo"],
        document_streams: List["_models.DocumentStreamInfo"],
        quota_info: Optional["_models.QuotaConfigurationInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword e_tag: An encoded string that indicates whether the collection configuration is
         changed. Required.
        :paramtype e_tag: str
        :keyword metrics: An array of metric configuration info. Required.
        :paramtype metrics: list[~quickpulse_client.models.DerivedMetricInfo]
        :keyword document_streams: An array of document stream configuration info. Required.
        :paramtype document_streams: list[~quickpulse_client.models.DocumentStreamInfo]
        :keyword quota_info: Controls document quotas to be sent to Live Metrics.
        :paramtype quota_info: ~quickpulse_client.models.QuotaConfigurationInfo
        """
        super().__init__(**kwargs)
        self.e_tag = e_tag
        self.metrics = metrics
        self.document_streams = document_streams
        self.quota_info = quota_info


class DerivedMetricInfo(_serialization.Model):
    """A metric configuration set by UX to scope the metrics it's interested in.

    All required parameters must be populated in order to send to server.

    :ivar id: metric configuration identifier. Required.
    :vartype id: str
    :ivar telemetry_type: Telemetry type. Required.
    :vartype telemetry_type: str
    :ivar filter_groups: A collection of filters to scope metrics that UX needs. Required.
    :vartype filter_groups: list[~quickpulse_client.models.FilterConjunctionGroupInfo]
    :ivar projection: Telemetry's metric dimension whose value is to be aggregated. Example values:
     Duration, Count(),... Required.
    :vartype projection: str
    :ivar aggregation: Aggregation type. This is the aggregation done from everything within a
     single server. Required. Known values are: "Avg", "Sum", "Min", and "Max".
    :vartype aggregation: str or ~quickpulse_client.models.AggregationType
    :ivar back_end_aggregation: Aggregation type. This Aggregation is done across the values for
     all the servers taken together. Required. Known values are: "Avg", "Sum", "Min", and "Max".
    :vartype back_end_aggregation: str or ~quickpulse_client.models.AggregationType
    """

    _validation = {
        "id": {"required": True},
        "telemetry_type": {"required": True},
        "filter_groups": {"required": True},
        "projection": {"required": True},
        "aggregation": {"required": True},
        "back_end_aggregation": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "Id", "type": "str"},
        "telemetry_type": {"key": "TelemetryType", "type": "str"},
        "filter_groups": {"key": "FilterGroups", "type": "[FilterConjunctionGroupInfo]"},
        "projection": {"key": "Projection", "type": "str"},
        "aggregation": {"key": "Aggregation", "type": "str"},
        "back_end_aggregation": {"key": "BackEndAggregation", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        telemetry_type: str,
        filter_groups: List["_models.FilterConjunctionGroupInfo"],
        projection: str,
        aggregation: Union[str, "_models.AggregationType"],
        back_end_aggregation: Union[str, "_models.AggregationType"],
        **kwargs: Any
    ) -> None:
        """
        :keyword id: metric configuration identifier. Required.
        :paramtype id: str
        :keyword telemetry_type: Telemetry type. Required.
        :paramtype telemetry_type: str
        :keyword filter_groups: A collection of filters to scope metrics that UX needs. Required.
        :paramtype filter_groups: list[~quickpulse_client.models.FilterConjunctionGroupInfo]
        :keyword projection: Telemetry's metric dimension whose value is to be aggregated. Example
         values: Duration, Count(),... Required.
        :paramtype projection: str
        :keyword aggregation: Aggregation type. This is the aggregation done from everything within a
         single server. Required. Known values are: "Avg", "Sum", "Min", and "Max".
        :paramtype aggregation: str or ~quickpulse_client.models.AggregationType
        :keyword back_end_aggregation: Aggregation type. This Aggregation is done across the values for
         all the servers taken together. Required. Known values are: "Avg", "Sum", "Min", and "Max".
        :paramtype back_end_aggregation: str or ~quickpulse_client.models.AggregationType
        """
        super().__init__(**kwargs)
        self.id = id
        self.telemetry_type = telemetry_type
        self.filter_groups = filter_groups
        self.projection = projection
        self.aggregation = aggregation
        self.back_end_aggregation = back_end_aggregation


class DocumentFilterConjunctionGroupInfo(_serialization.Model):
    """A collection of filters for a specific telemetry type.

    All required parameters must be populated in order to send to server.

    :ivar telemetry_type: Telemetry type. Required. Known values are: "Request", "Dependency",
     "Exception", "Event", "Metric", "PerformanceCounter", and "Trace".
    :vartype telemetry_type: str or ~quickpulse_client.models.TelemetryType
    :ivar filters: An array of filter groups. Required.
    :vartype filters: ~quickpulse_client.models.FilterConjunctionGroupInfo
    """

    _validation = {
        "telemetry_type": {"required": True},
        "filters": {"required": True},
    }

    _attribute_map = {
        "telemetry_type": {"key": "TelemetryType", "type": "str"},
        "filters": {"key": "Filters", "type": "FilterConjunctionGroupInfo"},
    }

    def __init__(
        self,
        *,
        telemetry_type: Union[str, "_models.TelemetryType"],
        filters: "_models.FilterConjunctionGroupInfo",
        **kwargs: Any
    ) -> None:
        """
        :keyword telemetry_type: Telemetry type. Required. Known values are: "Request", "Dependency",
         "Exception", "Event", "Metric", "PerformanceCounter", and "Trace".
        :paramtype telemetry_type: str or ~quickpulse_client.models.TelemetryType
        :keyword filters: An array of filter groups. Required.
        :paramtype filters: ~quickpulse_client.models.FilterConjunctionGroupInfo
        """
        super().__init__(**kwargs)
        self.telemetry_type = telemetry_type
        self.filters = filters


class DocumentIngress(_serialization.Model):
    """Base class of the specific document types.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    Event, Exception, RemoteDependency, Request, Trace

    All required parameters must be populated in order to send to server.

    :ivar document_type: Telemetry type. Types not defined in enum will get replaced with a
     'Unknown' type. Required. Known values are: "Request", "RemoteDependency", "Exception",
     "Event", "Trace", and "Unknown".
    :vartype document_type: str or ~quickpulse_client.models.DocumentType
    :ivar document_stream_ids: An array of document streaming ids. Each id identifies a flow of
     documents customized by UX customers.
    :vartype document_stream_ids: list[str]
    :ivar properties: Collection of custom properties.
    :vartype properties: list[~quickpulse_client.models.KeyValuePairString]
    """

    _validation = {
        "document_type": {"required": True},
    }

    _attribute_map = {
        "document_type": {"key": "DocumentType", "type": "str"},
        "document_stream_ids": {"key": "DocumentStreamIds", "type": "[str]"},
        "properties": {"key": "Properties", "type": "[KeyValuePairString]"},
    }

    _subtype_map = {
        "document_type": {
            "Event": "Event",
            "Exception": "Exception",
            "RemoteDependency": "RemoteDependency",
            "Request": "Request",
            "Trace": "Trace",
        }
    }

    def __init__(
        self,
        *,
        document_stream_ids: Optional[List[str]] = None,
        properties: Optional[List["_models.KeyValuePairString"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword document_stream_ids: An array of document streaming ids. Each id identifies a flow of
         documents customized by UX customers.
        :paramtype document_stream_ids: list[str]
        :keyword properties: Collection of custom properties.
        :paramtype properties: list[~quickpulse_client.models.KeyValuePairString]
        """
        super().__init__(**kwargs)
        self.document_type: Optional[str] = None
        self.document_stream_ids = document_stream_ids
        self.properties = properties


class DocumentStreamInfo(_serialization.Model):
    """Configurations/filters set by UX to scope the document/telemetry it's interested in.

    All required parameters must be populated in order to send to server.

    :ivar id: Identifier of the document stream initiated by a UX. Required.
    :vartype id: str
    :ivar document_filter_groups: Gets or sets an OR-connected collection of filter groups.
     Required.
    :vartype document_filter_groups:
     list[~quickpulse_client.models.DocumentFilterConjunctionGroupInfo]
    """

    _validation = {
        "id": {"required": True},
        "document_filter_groups": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "Id", "type": "str"},
        "document_filter_groups": {"key": "DocumentFilterGroups", "type": "[DocumentFilterConjunctionGroupInfo]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        document_filter_groups: List["_models.DocumentFilterConjunctionGroupInfo"],
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Identifier of the document stream initiated by a UX. Required.
        :paramtype id: str
        :keyword document_filter_groups: Gets or sets an OR-connected collection of filter groups.
         Required.
        :paramtype document_filter_groups:
         list[~quickpulse_client.models.DocumentFilterConjunctionGroupInfo]
        """
        super().__init__(**kwargs)
        self.id = id
        self.document_filter_groups = document_filter_groups


class Event(DocumentIngress):
    """Event document type.

    All required parameters must be populated in order to send to server.

    :ivar document_type: Telemetry type. Types not defined in enum will get replaced with a
     'Unknown' type. Required. Known values are: "Request", "RemoteDependency", "Exception",
     "Event", "Trace", and "Unknown".
    :vartype document_type: str or ~quickpulse_client.models.DocumentType
    :ivar document_stream_ids: An array of document streaming ids. Each id identifies a flow of
     documents customized by UX customers.
    :vartype document_stream_ids: list[str]
    :ivar properties: Collection of custom properties.
    :vartype properties: list[~quickpulse_client.models.KeyValuePairString]
    :ivar name: Event name.
    :vartype name: str
    """

    _validation = {
        "document_type": {"required": True},
        "name": {"max_length": 512},
    }

    _attribute_map = {
        "document_type": {"key": "DocumentType", "type": "str"},
        "document_stream_ids": {"key": "DocumentStreamIds", "type": "[str]"},
        "properties": {"key": "Properties", "type": "[KeyValuePairString]"},
        "name": {"key": "Name", "type": "str"},
    }

    def __init__(
        self,
        *,
        document_stream_ids: Optional[List[str]] = None,
        properties: Optional[List["_models.KeyValuePairString"]] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword document_stream_ids: An array of document streaming ids. Each id identifies a flow of
         documents customized by UX customers.
        :paramtype document_stream_ids: list[str]
        :keyword properties: Collection of custom properties.
        :paramtype properties: list[~quickpulse_client.models.KeyValuePairString]
        :keyword name: Event name.
        :paramtype name: str
        """
        super().__init__(document_stream_ids=document_stream_ids, properties=properties, **kwargs)
        self.document_type: str = "Event"
        self.name = name


class Exception(DocumentIngress):
    """Exception document type.

    All required parameters must be populated in order to send to server.

    :ivar document_type: Telemetry type. Types not defined in enum will get replaced with a
     'Unknown' type. Required. Known values are: "Request", "RemoteDependency", "Exception",
     "Event", "Trace", and "Unknown".
    :vartype document_type: str or ~quickpulse_client.models.DocumentType
    :ivar document_stream_ids: An array of document streaming ids. Each id identifies a flow of
     documents customized by UX customers.
    :vartype document_stream_ids: list[str]
    :ivar properties: Collection of custom properties.
    :vartype properties: list[~quickpulse_client.models.KeyValuePairString]
    :ivar exception_type: Exception type name.
    :vartype exception_type: str
    :ivar exception_message: Exception message.
    :vartype exception_message: str
    """

    _validation = {
        "document_type": {"required": True},
        "exception_type": {"max_length": 1024},
        "exception_message": {"max_length": 32768},
    }

    _attribute_map = {
        "document_type": {"key": "DocumentType", "type": "str"},
        "document_stream_ids": {"key": "DocumentStreamIds", "type": "[str]"},
        "properties": {"key": "Properties", "type": "[KeyValuePairString]"},
        "exception_type": {"key": "ExceptionType", "type": "str"},
        "exception_message": {"key": "ExceptionMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        document_stream_ids: Optional[List[str]] = None,
        properties: Optional[List["_models.KeyValuePairString"]] = None,
        exception_type: Optional[str] = None,
        exception_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword document_stream_ids: An array of document streaming ids. Each id identifies a flow of
         documents customized by UX customers.
        :paramtype document_stream_ids: list[str]
        :keyword properties: Collection of custom properties.
        :paramtype properties: list[~quickpulse_client.models.KeyValuePairString]
        :keyword exception_type: Exception type name.
        :paramtype exception_type: str
        :keyword exception_message: Exception message.
        :paramtype exception_message: str
        """
        super().__init__(document_stream_ids=document_stream_ids, properties=properties, **kwargs)
        self.document_type: str = "Exception"
        self.exception_type = exception_type
        self.exception_message = exception_message


class FilterConjunctionGroupInfo(_serialization.Model):
    """An AND-connected group of FilterInfo objects.

    All required parameters must be populated in order to send to server.

    :ivar filters: An array of filters. Required.
    :vartype filters: list[~quickpulse_client.models.FilterInfo]
    """

    _validation = {
        "filters": {"required": True},
    }

    _attribute_map = {
        "filters": {"key": "Filters", "type": "[FilterInfo]"},
    }

    def __init__(self, *, filters: List["_models.FilterInfo"], **kwargs: Any) -> None:
        """
        :keyword filters: An array of filters. Required.
        :paramtype filters: list[~quickpulse_client.models.FilterInfo]
        """
        super().__init__(**kwargs)
        self.filters = filters


class FilterInfo(_serialization.Model):
    """A filter set on UX.

    All required parameters must be populated in order to send to server.

    :ivar field_name: dimension name of the filter. Required.
    :vartype field_name: str
    :ivar predicate: Operator of the filter. Required. Known values are: "Equal", "NotEqual",
     "LessThan", "GreaterThan", "LessThanOrEqual", "GreaterThanOrEqual", "Contains", and
     "DoesNotContain".
    :vartype predicate: str or ~quickpulse_client.models.PredicateType
    :ivar comparand: Comparand of the filter. Required.
    :vartype comparand: str
    """

    _validation = {
        "field_name": {"required": True},
        "predicate": {"required": True},
        "comparand": {"required": True},
    }

    _attribute_map = {
        "field_name": {"key": "FieldName", "type": "str"},
        "predicate": {"key": "Predicate", "type": "str"},
        "comparand": {"key": "Comparand", "type": "str"},
    }

    def __init__(
        self, *, field_name: str, predicate: Union[str, "_models.PredicateType"], comparand: str, **kwargs: Any
    ) -> None:
        """
        :keyword field_name: dimension name of the filter. Required.
        :paramtype field_name: str
        :keyword predicate: Operator of the filter. Required. Known values are: "Equal", "NotEqual",
         "LessThan", "GreaterThan", "LessThanOrEqual", "GreaterThanOrEqual", "Contains", and
         "DoesNotContain".
        :paramtype predicate: str or ~quickpulse_client.models.PredicateType
        :keyword comparand: Comparand of the filter. Required.
        :paramtype comparand: str
        """
        super().__init__(**kwargs)
        self.field_name = field_name
        self.predicate = predicate
        self.comparand = comparand


class KeyValuePairString(_serialization.Model):
    """Key-value pair of string and string.

    All required parameters must be populated in order to send to server.

    :ivar key: Key of the key-value pair. Required.
    :vartype key: str
    :ivar value: Value of the key-value pair. Required.
    :vartype value: str
    """

    _validation = {
        "key": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, key: str, value: str, **kwargs: Any) -> None:
        """
        :keyword key: Key of the key-value pair. Required.
        :paramtype key: str
        :keyword value: Value of the key-value pair. Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.key = key
        self.value = value


class MetricPoint(_serialization.Model):
    """Metric data point.

    All required parameters must be populated in order to send to server.

    :ivar name: Metric name. Required.
    :vartype name: str
    :ivar value: Metric value. Required.
    :vartype value: float
    :ivar weight: Metric weight. Required.
    :vartype weight: int
    """

    _validation = {
        "name": {"required": True},
        "value": {"required": True},
        "weight": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "Name", "type": "str"},
        "value": {"key": "Value", "type": "float"},
        "weight": {"key": "Weight", "type": "int"},
    }

    def __init__(self, *, name: str, value: float, weight: int, **kwargs: Any) -> None:
        """
        :keyword name: Metric name. Required.
        :paramtype name: str
        :keyword value: Metric value. Required.
        :paramtype value: float
        :keyword weight: Metric weight. Required.
        :paramtype weight: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.weight = weight


class MonitoringDataPoint(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Monitoring data point coming from the client, which includes metrics, documents and other
    metadata info.

    All required parameters must be populated in order to send to server.

    :ivar version: Application Insights SDK version. Required.
    :vartype version: str
    :ivar invariant_version: Version/generation of the data contract (MonitoringDataPoint) between
     SDK and Live Metrics. Required.
    :vartype invariant_version: int
    :ivar instance: Service instance name where Application Insights SDK lives. Required.
    :vartype instance: str
    :ivar role_name: Service role name. Required.
    :vartype role_name: str
    :ivar machine_name: Computer name where Application Insights SDK lives. Required.
    :vartype machine_name: str
    :ivar stream_id: Identifies an Application Insights SDK as a trusted agent to report metrics
     and documents. Required.
    :vartype stream_id: str
    :ivar timestamp: Data point generation timestamp.
    :vartype timestamp: ~datetime.datetime
    :ivar transmission_time: Timestamp when the client transmits the metrics and documents to Live
     Metrics.
    :vartype transmission_time: ~datetime.datetime
    :ivar is_web_app: True if the current application is an Azure Web App. Required.
    :vartype is_web_app: bool
    :ivar performance_collection_supported: True if performance counters collection is supported.
     Required.
    :vartype performance_collection_supported: bool
    :ivar metrics: An array of metric data points.
    :vartype metrics: list[~quickpulse_client.models.MetricPoint]
    :ivar documents: An array of documents of a specific type {Request}, {RemoteDependency},
     {Exception}, {Event}, or {Trace}.
    :vartype documents: list[~quickpulse_client.models.DocumentIngress]
    :ivar top_cpu_processes: An array of top cpu consumption data point.
    :vartype top_cpu_processes: list[~quickpulse_client.models.ProcessCpuData]
    :ivar collection_configuration_errors: An array of error while SDK parses and applies the
     {CollectionConfigurationInfo} provided by Live Metrics.
    :vartype collection_configuration_errors:
     list[~quickpulse_client.models.CollectionConfigurationError]
    """

    _validation = {
        "version": {"required": True},
        "invariant_version": {"required": True},
        "instance": {"required": True},
        "role_name": {"required": True},
        "machine_name": {"required": True},
        "stream_id": {"required": True},
        "is_web_app": {"required": True},
        "performance_collection_supported": {"required": True},
    }

    _attribute_map = {
        "version": {"key": "Version", "type": "str"},
        "invariant_version": {"key": "InvariantVersion", "type": "int"},
        "instance": {"key": "Instance", "type": "str"},
        "role_name": {"key": "RoleName", "type": "str"},
        "machine_name": {"key": "MachineName", "type": "str"},
        "stream_id": {"key": "StreamId", "type": "str"},
        "timestamp": {"key": "Timestamp", "type": "iso-8601"},
        "transmission_time": {"key": "TransmissionTime", "type": "iso-8601"},
        "is_web_app": {"key": "IsWebApp", "type": "bool"},
        "performance_collection_supported": {"key": "PerformanceCollectionSupported", "type": "bool"},
        "metrics": {"key": "Metrics", "type": "[MetricPoint]"},
        "documents": {"key": "Documents", "type": "[DocumentIngress]"},
        "top_cpu_processes": {"key": "TopCpuProcesses", "type": "[ProcessCpuData]"},
        "collection_configuration_errors": {
            "key": "CollectionConfigurationErrors",
            "type": "[CollectionConfigurationError]",
        },
    }

    def __init__(
        self,
        *,
        version: str,
        invariant_version: int,
        instance: str,
        role_name: str,
        machine_name: str,
        stream_id: str,
        is_web_app: bool,
        performance_collection_supported: bool,
        timestamp: Optional[datetime.datetime] = None,
        transmission_time: Optional[datetime.datetime] = None,
        metrics: Optional[List["_models.MetricPoint"]] = None,
        documents: Optional[List["_models.DocumentIngress"]] = None,
        top_cpu_processes: Optional[List["_models.ProcessCpuData"]] = None,
        collection_configuration_errors: Optional[List["_models.CollectionConfigurationError"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword version: Application Insights SDK version. Required.
        :paramtype version: str
        :keyword invariant_version: Version/generation of the data contract (MonitoringDataPoint)
         between SDK and Live Metrics. Required.
        :paramtype invariant_version: int
        :keyword instance: Service instance name where Application Insights SDK lives. Required.
        :paramtype instance: str
        :keyword role_name: Service role name. Required.
        :paramtype role_name: str
        :keyword machine_name: Computer name where Application Insights SDK lives. Required.
        :paramtype machine_name: str
        :keyword stream_id: Identifies an Application Insights SDK as a trusted agent to report metrics
         and documents. Required.
        :paramtype stream_id: str
        :keyword timestamp: Data point generation timestamp.
        :paramtype timestamp: ~datetime.datetime
        :keyword transmission_time: Timestamp when the client transmits the metrics and documents to
         Live Metrics.
        :paramtype transmission_time: ~datetime.datetime
        :keyword is_web_app: True if the current application is an Azure Web App. Required.
        :paramtype is_web_app: bool
        :keyword performance_collection_supported: True if performance counters collection is
         supported. Required.
        :paramtype performance_collection_supported: bool
        :keyword metrics: An array of metric data points.
        :paramtype metrics: list[~quickpulse_client.models.MetricPoint]
        :keyword documents: An array of documents of a specific type {Request}, {RemoteDependency},
         {Exception}, {Event}, or {Trace}.
        :paramtype documents: list[~quickpulse_client.models.DocumentIngress]
        :keyword top_cpu_processes: An array of top cpu consumption data point.
        :paramtype top_cpu_processes: list[~quickpulse_client.models.ProcessCpuData]
        :keyword collection_configuration_errors: An array of error while SDK parses and applies the
         {CollectionConfigurationInfo} provided by Live Metrics.
        :paramtype collection_configuration_errors:
         list[~quickpulse_client.models.CollectionConfigurationError]
        """
        super().__init__(**kwargs)
        self.version = version
        self.invariant_version = invariant_version
        self.instance = instance
        self.role_name = role_name
        self.machine_name = machine_name
        self.stream_id = stream_id
        self.timestamp = timestamp
        self.transmission_time = transmission_time
        self.is_web_app = is_web_app
        self.performance_collection_supported = performance_collection_supported
        self.metrics = metrics
        self.documents = documents
        self.top_cpu_processes = top_cpu_processes
        self.collection_configuration_errors = collection_configuration_errors


class ProcessCpuData(_serialization.Model):
    """CPU consumption datapoint.

    All required parameters must be populated in order to send to server.

    :ivar process_name: Process name. Required.
    :vartype process_name: str
    :ivar cpu_percentage: CPU consumption percentage. Required.
    :vartype cpu_percentage: int
    """

    _validation = {
        "process_name": {"required": True},
        "cpu_percentage": {"required": True},
    }

    _attribute_map = {
        "process_name": {"key": "ProcessName", "type": "str"},
        "cpu_percentage": {"key": "CpuPercentage", "type": "int"},
    }

    def __init__(self, *, process_name: str, cpu_percentage: int, **kwargs: Any) -> None:
        """
        :keyword process_name: Process name. Required.
        :paramtype process_name: str
        :keyword cpu_percentage: CPU consumption percentage. Required.
        :paramtype cpu_percentage: int
        """
        super().__init__(**kwargs)
        self.process_name = process_name
        self.cpu_percentage = cpu_percentage


class QuotaConfigurationInfo(_serialization.Model):
    """Controls document quotas to be sent to Live Metrics.

    All required parameters must be populated in order to send to server.

    :ivar initial_quota: Initial quota.
    :vartype initial_quota: float
    :ivar max_quota: Max quota. Required.
    :vartype max_quota: float
    :ivar quota_accrual_rate_per_sec: Quota accrual rate per second. Required.
    :vartype quota_accrual_rate_per_sec: float
    """

    _validation = {
        "max_quota": {"required": True},
        "quota_accrual_rate_per_sec": {"required": True},
    }

    _attribute_map = {
        "initial_quota": {"key": "InitialQuota", "type": "float"},
        "max_quota": {"key": "MaxQuota", "type": "float"},
        "quota_accrual_rate_per_sec": {"key": "QuotaAccrualRatePerSec", "type": "float"},
    }

    def __init__(
        self,
        *,
        max_quota: float,
        quota_accrual_rate_per_sec: float,
        initial_quota: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword initial_quota: Initial quota.
        :paramtype initial_quota: float
        :keyword max_quota: Max quota. Required.
        :paramtype max_quota: float
        :keyword quota_accrual_rate_per_sec: Quota accrual rate per second. Required.
        :paramtype quota_accrual_rate_per_sec: float
        """
        super().__init__(**kwargs)
        self.initial_quota = initial_quota
        self.max_quota = max_quota
        self.quota_accrual_rate_per_sec = quota_accrual_rate_per_sec


class RemoteDependency(DocumentIngress):
    """RemoteDependency document type.

    All required parameters must be populated in order to send to server.

    :ivar document_type: Telemetry type. Types not defined in enum will get replaced with a
     'Unknown' type. Required. Known values are: "Request", "RemoteDependency", "Exception",
     "Event", "Trace", and "Unknown".
    :vartype document_type: str or ~quickpulse_client.models.DocumentType
    :ivar document_stream_ids: An array of document streaming ids. Each id identifies a flow of
     documents customized by UX customers.
    :vartype document_stream_ids: list[str]
    :ivar properties: Collection of custom properties.
    :vartype properties: list[~quickpulse_client.models.KeyValuePairString]
    :ivar name: Name of the command initiated with this dependency call, e.g., GET /username.
    :vartype name: str
    :ivar command_name: URL of the dependency call to the target, with all query string parameters.
    :vartype command_name: str
    :ivar result_code: Result code of a dependency call. Examples are SQL error code and HTTP
     status code.
    :vartype result_code: str
    :ivar duration: Request duration in ISO 8601 duration format, i.e., P[n]Y[n]M[n]DT[n]H[n]M[n]S
     or P[n]W.
    :vartype duration: str
    """

    _validation = {
        "document_type": {"required": True},
        "name": {"max_length": 1024},
        "command_name": {"max_length": 2048},
        "result_code": {"max_length": 1024},
    }

    _attribute_map = {
        "document_type": {"key": "DocumentType", "type": "str"},
        "document_stream_ids": {"key": "DocumentStreamIds", "type": "[str]"},
        "properties": {"key": "Properties", "type": "[KeyValuePairString]"},
        "name": {"key": "Name", "type": "str"},
        "command_name": {"key": "CommandName", "type": "str"},
        "result_code": {"key": "ResultCode", "type": "str"},
        "duration": {"key": "Duration", "type": "str"},
    }

    def __init__(
        self,
        *,
        document_stream_ids: Optional[List[str]] = None,
        properties: Optional[List["_models.KeyValuePairString"]] = None,
        name: Optional[str] = None,
        command_name: Optional[str] = None,
        result_code: Optional[str] = None,
        duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword document_stream_ids: An array of document streaming ids. Each id identifies a flow of
         documents customized by UX customers.
        :paramtype document_stream_ids: list[str]
        :keyword properties: Collection of custom properties.
        :paramtype properties: list[~quickpulse_client.models.KeyValuePairString]
        :keyword name: Name of the command initiated with this dependency call, e.g., GET /username.
        :paramtype name: str
        :keyword command_name: URL of the dependency call to the target, with all query string
         parameters.
        :paramtype command_name: str
        :keyword result_code: Result code of a dependency call. Examples are SQL error code and HTTP
         status code.
        :paramtype result_code: str
        :keyword duration: Request duration in ISO 8601 duration format, i.e.,
         P[n]Y[n]M[n]DT[n]H[n]M[n]S or P[n]W.
        :paramtype duration: str
        """
        super().__init__(document_stream_ids=document_stream_ids, properties=properties, **kwargs)
        self.document_type: str = "RemoteDependency"
        self.name = name
        self.command_name = command_name
        self.result_code = result_code
        self.duration = duration


class Request(DocumentIngress):
    """Request document type.

    All required parameters must be populated in order to send to server.

    :ivar document_type: Telemetry type. Types not defined in enum will get replaced with a
     'Unknown' type. Required. Known values are: "Request", "RemoteDependency", "Exception",
     "Event", "Trace", and "Unknown".
    :vartype document_type: str or ~quickpulse_client.models.DocumentType
    :ivar document_stream_ids: An array of document streaming ids. Each id identifies a flow of
     documents customized by UX customers.
    :vartype document_stream_ids: list[str]
    :ivar properties: Collection of custom properties.
    :vartype properties: list[~quickpulse_client.models.KeyValuePairString]
    :ivar name: Name of the request, e.g., 'GET /values/{id}'.
    :vartype name: str
    :ivar url: Request URL with all query string parameters.
    :vartype url: str
    :ivar response_code: Result of a request execution. For http requests, it could be some HTTP
     status code.
    :vartype response_code: str
    :ivar duration: Request duration in ISO 8601 duration format, i.e., P[n]Y[n]M[n]DT[n]H[n]M[n]S
     or P[n]W.
    :vartype duration: str
    """

    _validation = {
        "document_type": {"required": True},
        "name": {"max_length": 1024},
        "url": {"max_length": 2048},
        "response_code": {"max_length": 1024},
    }

    _attribute_map = {
        "document_type": {"key": "DocumentType", "type": "str"},
        "document_stream_ids": {"key": "DocumentStreamIds", "type": "[str]"},
        "properties": {"key": "Properties", "type": "[KeyValuePairString]"},
        "name": {"key": "Name", "type": "str"},
        "url": {"key": "Url", "type": "str"},
        "response_code": {"key": "ResponseCode", "type": "str"},
        "duration": {"key": "Duration", "type": "str"},
    }

    def __init__(
        self,
        *,
        document_stream_ids: Optional[List[str]] = None,
        properties: Optional[List["_models.KeyValuePairString"]] = None,
        name: Optional[str] = None,
        url: Optional[str] = None,
        response_code: Optional[str] = None,
        duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword document_stream_ids: An array of document streaming ids. Each id identifies a flow of
         documents customized by UX customers.
        :paramtype document_stream_ids: list[str]
        :keyword properties: Collection of custom properties.
        :paramtype properties: list[~quickpulse_client.models.KeyValuePairString]
        :keyword name: Name of the request, e.g., 'GET /values/{id}'.
        :paramtype name: str
        :keyword url: Request URL with all query string parameters.
        :paramtype url: str
        :keyword response_code: Result of a request execution. For http requests, it could be some HTTP
         status code.
        :paramtype response_code: str
        :keyword duration: Request duration in ISO 8601 duration format, i.e.,
         P[n]Y[n]M[n]DT[n]H[n]M[n]S or P[n]W.
        :paramtype duration: str
        """
        super().__init__(document_stream_ids=document_stream_ids, properties=properties, **kwargs)
        self.document_type: str = "Request"
        self.name = name
        self.url = url
        self.response_code = response_code
        self.duration = duration


class ServiceError(_serialization.Model):
    """Optional http response body, whose existence carries additional error descriptions.

    All required parameters must be populated in order to send to server.

    :ivar request_id: A globally unique identifier to identify the diagnostic context. It defaults
     to the empty GUID.
    :vartype request_id: str
    :ivar response_date_time: Service error response date time. Required.
    :vartype response_date_time: str
    :ivar code: Error code. Required.
    :vartype code: str
    :ivar message: Error message. Required.
    :vartype message: str
    :ivar exception: Message of the exception that triggers the error response. Required.
    :vartype exception: str
    """

    _validation = {
        "request_id": {"required": True},
        "response_date_time": {"required": True},
        "code": {"required": True},
        "message": {"required": True},
        "exception": {"required": True},
    }

    _attribute_map = {
        "request_id": {"key": "RequestId", "type": "str"},
        "response_date_time": {"key": "ResponseDateTime", "type": "str"},
        "code": {"key": "Code", "type": "str"},
        "message": {"key": "Message", "type": "str"},
        "exception": {"key": "Exception", "type": "str"},
    }

    def __init__(
        self,
        *,
        request_id: str = "00000000-0000-0000-0000-000000000000",
        response_date_time: str,
        code: str,
        message: str,
        exception: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword request_id: A globally unique identifier to identify the diagnostic context. It
         defaults to the empty GUID.
        :paramtype request_id: str
        :keyword response_date_time: Service error response date time. Required.
        :paramtype response_date_time: str
        :keyword code: Error code. Required.
        :paramtype code: str
        :keyword message: Error message. Required.
        :paramtype message: str
        :keyword exception: Message of the exception that triggers the error response. Required.
        :paramtype exception: str
        """
        super().__init__(**kwargs)
        self.request_id = request_id
        self.response_date_time = response_date_time
        self.code = code
        self.message = message
        self.exception = exception


class Trace(DocumentIngress):
    """Trace document type.

    All required parameters must be populated in order to send to server.

    :ivar document_type: Telemetry type. Types not defined in enum will get replaced with a
     'Unknown' type. Required. Known values are: "Request", "RemoteDependency", "Exception",
     "Event", "Trace", and "Unknown".
    :vartype document_type: str or ~quickpulse_client.models.DocumentType
    :ivar document_stream_ids: An array of document streaming ids. Each id identifies a flow of
     documents customized by UX customers.
    :vartype document_stream_ids: list[str]
    :ivar properties: Collection of custom properties.
    :vartype properties: list[~quickpulse_client.models.KeyValuePairString]
    :ivar message: Trace message.
    :vartype message: str
    """

    _validation = {
        "document_type": {"required": True},
        "message": {"max_length": 32768},
    }

    _attribute_map = {
        "document_type": {"key": "DocumentType", "type": "str"},
        "document_stream_ids": {"key": "DocumentStreamIds", "type": "[str]"},
        "properties": {"key": "Properties", "type": "[KeyValuePairString]"},
        "message": {"key": "Message", "type": "str"},
    }

    def __init__(
        self,
        *,
        document_stream_ids: Optional[List[str]] = None,
        properties: Optional[List["_models.KeyValuePairString"]] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword document_stream_ids: An array of document streaming ids. Each id identifies a flow of
         documents customized by UX customers.
        :paramtype document_stream_ids: list[str]
        :keyword properties: Collection of custom properties.
        :paramtype properties: list[~quickpulse_client.models.KeyValuePairString]
        :keyword message: Trace message.
        :paramtype message: str
        """
        super().__init__(document_stream_ids=document_stream_ids, properties=properties, **kwargs)
        self.document_type: str = "Trace"
        self.message = message
