# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.azurestackhcivm import AzureStackHCIVmClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAzureStackHCIVmVirtualMachineInstancesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AzureStackHCIVmClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_machine_instances_get(self, resource_group):
        response = self.client.virtual_machine_instances.get(
            resource_uri="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_machine_instances_begin_create_or_update(self, resource_group):
        response = self.client.virtual_machine_instances.begin_create_or_update(
            resource_uri="str",
            resource={
                "extendedLocation": {"name": "str", "type": "str"},
                "id": "str",
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "name": "str",
                "properties": {
                    "createFromLocal": bool,
                    "guestAgentInstallStatus": {
                        "agentVersion": "str",
                        "errorDetails": [
                            {
                                "additionalInfo": [{"info": {}, "type": "str"}],
                                "code": "str",
                                "details": [...],
                                "message": "str",
                                "target": "str",
                            }
                        ],
                        "lastStatusChange": "2020-02-20 00:00:00",
                        "status": "str",
                        "vmUuid": "str",
                    },
                    "hardwareProfile": {
                        "dynamicMemoryConfig": {"maximumMemoryMB": 0, "minimumMemoryMB": 0, "targetMemoryBuffer": 0},
                        "memoryMB": 0,
                        "processors": 0,
                        "virtualMachineGPUs": [{"assignmentType": "str", "gpuName": "str", "partitionSizeMB": 0}],
                        "vmSize": "str",
                    },
                    "hostNodeIpAddress": "str",
                    "hostNodeName": "str",
                    "httpProxyConfig": {
                        "httpProxy": "str",
                        "httpsProxy": "str",
                        "noProxy": ["str"],
                        "trustedCa": "str",
                    },
                    "hyperVVmId": "str",
                    "instanceView": {
                        "vmAgent": {
                            "statuses": [
                                {
                                    "code": "str",
                                    "displayStatus": "str",
                                    "level": "str",
                                    "message": "str",
                                    "time": "2020-02-20 00:00:00",
                                }
                            ],
                            "vmConfigAgentVersion": "str",
                        }
                    },
                    "networkProfile": {"networkInterfaces": [{"id": "str"}]},
                    "osProfile": {
                        "adminPassword": "str",
                        "adminUsername": "str",
                        "computerName": "str",
                        "linuxConfiguration": {
                            "disablePasswordAuthentication": bool,
                            "provisionVMAgent": bool,
                            "provisionVMConfigAgent": bool,
                            "ssh": {"publicKeys": [{"keyData": "str", "path": "str"}]},
                        },
                        "windowsConfiguration": {
                            "enableAutomaticUpdates": bool,
                            "provisionVMAgent": bool,
                            "provisionVMConfigAgent": bool,
                            "ssh": {"publicKeys": [{"keyData": "str", "path": "str"}]},
                            "timeZone": "str",
                        },
                    },
                    "placementProfile": {"strictPlacementPolicy": bool, "zone": "str"},
                    "provisioningState": "str",
                    "resourceUid": "str",
                    "securityProfile": {
                        "enableTPM": bool,
                        "securityType": "str",
                        "uefiSettings": {"secureBootEnabled": bool},
                    },
                    "status": {
                        "errorCode": "str",
                        "errorMessage": "str",
                        "powerState": "str",
                        "provisioningStatus": {"operationId": "str", "status": "str"},
                    },
                    "storageProfile": {
                        "dataDisks": [{"id": "str"}],
                        "imageReference": {"id": "str"},
                        "osDisk": {
                            "id": "str",
                            "managedDisk": {"securityProfile": {"securityEncryptionType": "str"}},
                            "osType": "str",
                        },
                        "vmConfigStoragePathId": "str",
                    },
                    "vmId": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_machine_instances_begin_update(self, resource_group):
        response = self.client.virtual_machine_instances.begin_update(
            resource_uri="str",
            properties={
                "identity": {"principalId": "str", "tenantId": "str", "type": "SystemAssigned"},
                "properties": {
                    "hardwareProfile": {
                        "memoryMB": 0,
                        "processors": 0,
                        "virtualMachineGPUs": [{"assignmentType": "str", "gpuName": "str", "partitionSizeMB": 0}],
                        "vmSize": "str",
                    },
                    "networkProfile": {"networkInterfaces": [{"id": "str"}]},
                    "osProfile": {
                        "computerName": "str",
                        "linuxConfiguration": {"provisionVMAgent": bool, "provisionVMConfigAgent": bool},
                        "windowsConfiguration": {"provisionVMAgent": bool, "provisionVMConfigAgent": bool},
                    },
                    "storageProfile": {"dataDisks": [{"id": "str"}]},
                },
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_machine_instances_begin_delete(self, resource_group):
        response = self.client.virtual_machine_instances.begin_delete(
            resource_uri="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_machine_instances_list(self, resource_group):
        response = self.client.virtual_machine_instances.list(
            resource_uri="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_machine_instances_begin_start(self, resource_group):
        response = self.client.virtual_machine_instances.begin_start(
            resource_uri="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_machine_instances_begin_stop(self, resource_group):
        response = self.client.virtual_machine_instances.begin_stop(
            resource_uri="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_machine_instances_begin_restart(self, resource_group):
        response = self.client.virtual_machine_instances.begin_restart(
            resource_uri="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_machine_instances_begin_pause(self, resource_group):
        response = self.client.virtual_machine_instances.begin_pause(
            resource_uri="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_machine_instances_begin_save(self, resource_group):
        response = self.client.virtual_machine_instances.begin_save(
            resource_uri="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
