# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.sql.aio import SqlManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSqlManagementSyncGroupsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SqlManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_sync_groups_list_sync_database_ids(self, resource_group):
        response = self.client.sync_groups.list_sync_database_ids(
            location_name="str",
            api_version="2024-05-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_sync_groups_list_by_database(self, resource_group):
        response = self.client.sync_groups.list_by_database(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            api_version="2024-05-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_sync_groups_get(self, resource_group):
        response = await self.client.sync_groups.get(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            sync_group_name="str",
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_sync_groups_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.sync_groups.begin_create_or_update(
                resource_group_name=resource_group.name,
                server_name="str",
                database_name="str",
                sync_group_name="str",
                parameters={
                    "conflictLoggingRetentionInDays": 0,
                    "conflictResolutionPolicy": "str",
                    "enableConflictLogging": bool,
                    "hubDatabasePassword": "str",
                    "hubDatabaseUserName": "str",
                    "id": "str",
                    "interval": 0,
                    "lastSyncTime": "2020-02-20 00:00:00",
                    "name": "str",
                    "privateEndpointName": "str",
                    "schema": {
                        "masterSyncMemberName": "str",
                        "tables": [
                            {
                                "columns": [{"dataSize": "str", "dataType": "str", "quotedName": "str"}],
                                "quotedName": "str",
                            }
                        ],
                    },
                    "sku": {"name": "str", "capacity": 0, "family": "str", "size": "str", "tier": "str"},
                    "syncDatabaseId": "str",
                    "syncState": "str",
                    "type": "str",
                    "usePrivateLinkConnection": bool,
                },
                api_version="2024-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_sync_groups_begin_delete(self, resource_group):
        response = await (
            await self.client.sync_groups.begin_delete(
                resource_group_name=resource_group.name,
                server_name="str",
                database_name="str",
                sync_group_name="str",
                api_version="2024-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_sync_groups_begin_update(self, resource_group):
        response = await (
            await self.client.sync_groups.begin_update(
                resource_group_name=resource_group.name,
                server_name="str",
                database_name="str",
                sync_group_name="str",
                parameters={
                    "conflictLoggingRetentionInDays": 0,
                    "conflictResolutionPolicy": "str",
                    "enableConflictLogging": bool,
                    "hubDatabasePassword": "str",
                    "hubDatabaseUserName": "str",
                    "id": "str",
                    "interval": 0,
                    "lastSyncTime": "2020-02-20 00:00:00",
                    "name": "str",
                    "privateEndpointName": "str",
                    "schema": {
                        "masterSyncMemberName": "str",
                        "tables": [
                            {
                                "columns": [{"dataSize": "str", "dataType": "str", "quotedName": "str"}],
                                "quotedName": "str",
                            }
                        ],
                    },
                    "sku": {"name": "str", "capacity": 0, "family": "str", "size": "str", "tier": "str"},
                    "syncDatabaseId": "str",
                    "syncState": "str",
                    "type": "str",
                    "usePrivateLinkConnection": bool,
                },
                api_version="2024-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_sync_groups_cancel_sync(self, resource_group):
        response = await self.client.sync_groups.cancel_sync(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            sync_group_name="str",
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_sync_groups_list_hub_schemas(self, resource_group):
        response = self.client.sync_groups.list_hub_schemas(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            sync_group_name="str",
            api_version="2024-05-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_sync_groups_list_logs(self, resource_group):
        response = self.client.sync_groups.list_logs(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            sync_group_name="str",
            start_time="str",
            end_time="str",
            type="str",
            api_version="2024-05-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_sync_groups_begin_refresh_hub_schema(self, resource_group):
        response = await (
            await self.client.sync_groups.begin_refresh_hub_schema(
                resource_group_name=resource_group.name,
                server_name="str",
                database_name="str",
                sync_group_name="str",
                api_version="2024-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_sync_groups_trigger_sync(self, resource_group):
        response = await self.client.sync_groups.trigger_sync(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            sync_group_name="str",
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...
