# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.sql import SqlManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-sql
# USAGE
    python export_database_using_database_extensions_with_managed_identity.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = SqlManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="0ca8cd24-0b47-4ad5-bc7e-d70e35c44adf",
    )

    response = client.database_extensions.begin_create_or_update(
        resource_group_name="rg_d1ef9eae-044d-4710-ba59-b82e84ad3157",
        server_name="srv_9243d320-ac4e-4f97-8e06-b1167dae5f4c",
        database_name="db_7fe424c8-23cf-4ac3-bdc3-e21f424bdb68",
        extension_name="Export",
        parameters={
            "properties": {
                "administratorLogin": "/subscriptions/00000000-1111-2222-3333-444444444444/resourcegroups/rgName/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identityName",
                "authenticationType": "ManagedIdentity",
                "operationMode": "Export",
                "storageKey": "/subscriptions/00000000-1111-2222-3333-444444444444/resourcegroups/rgName/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identityName",
                "storageKeyType": "ManagedIdentity",
                "storageUri": "https://teststorage.blob.core.windows.net/testcontainer/Manifest.xml",
            }
        },
    ).result()
    print(response)


# x-ms-original-file: specification/sql/resource-manager/Microsoft.Sql/preview/2024-05-01-preview/examples/ExportDatabaseUsingDatabaseExtensionsWithManagedIdentity.json
if __name__ == "__main__":
    main()
