# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class CustomerManagedKeyEncryption(_Model):
    """Customer-managed key encryption properties for the resource.

    :ivar key_encryption_key_identity: All identity configuration for Customer-managed key settings
     defining which identity should be used to auth to Key Vault.
    :vartype key_encryption_key_identity:
     ~azure.mgmt.onlineexperimentation.models.KeyEncryptionKeyIdentity
    :ivar key_encryption_key_url: key encryption key Url, versioned or non-versioned. Ex:
     `https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78
     <https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78>`_ or
     `https://contosovault.vault.azure.net/keys/contosokek
     <https://contosovault.vault.azure.net/keys/contosokek>`_.
    :vartype key_encryption_key_url: str
    """

    key_encryption_key_identity: Optional["_models.KeyEncryptionKeyIdentity"] = rest_field(
        name="keyEncryptionKeyIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """All identity configuration for Customer-managed key settings defining which identity should be
     used to auth to Key Vault."""
    key_encryption_key_url: Optional[str] = rest_field(
        name="keyEncryptionKeyUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """key encryption key Url, versioned or non-versioned. Ex:
     `https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78
     <https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78>`_ or
     `https://contosovault.vault.azure.net/keys/contosokek
     <https://contosovault.vault.azure.net/keys/contosokek>`_."""

    @overload
    def __init__(
        self,
        *,
        key_encryption_key_identity: Optional["_models.KeyEncryptionKeyIdentity"] = None,
        key_encryption_key_url: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.onlineexperimentation.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.onlineexperimentation.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.onlineexperimentation.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyEncryptionKeyIdentity(_Model):
    """All identity configuration for Customer-managed key settings defining which identity should be
    used to auth to Key Vault.

    :ivar identity_type: The type of identity to use. Values can be systemAssignedIdentity,
     userAssignedIdentity, or delegatedResourceIdentity. Known values are: "SystemAssignedIdentity"
     and "UserAssignedIdentity".
    :vartype identity_type: str or
     ~azure.mgmt.onlineexperimentation.models.KeyEncryptionKeyIdentityType
    :ivar user_assigned_identity_resource_id: User assigned identity to use for accessing key
     encryption key Url. Ex:
     /subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/<resource
     group>/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId. Mutually exclusive with
     identityType systemAssignedIdentity.
    :vartype user_assigned_identity_resource_id: str
    :ivar federated_client_id: application client identity to use for accessing key encryption key
     Url in a different tenant. Ex: f83c6b1b-4d34-47e4-bb34-9d83df58b540.
    :vartype federated_client_id: str
    """

    identity_type: Optional[Union[str, "_models.KeyEncryptionKeyIdentityType"]] = rest_field(
        name="identityType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity to use. Values can be systemAssignedIdentity, userAssignedIdentity, or
     delegatedResourceIdentity. Known values are: \"SystemAssignedIdentity\" and
     \"UserAssignedIdentity\"."""
    user_assigned_identity_resource_id: Optional[str] = rest_field(
        name="userAssignedIdentityResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """User assigned identity to use for accessing key encryption key Url. Ex:
     /subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/<resource
     group>/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId. Mutually exclusive with
     identityType systemAssignedIdentity."""
    federated_client_id: Optional[str] = rest_field(
        name="federatedClientId", visibility=["read", "create", "update", "delete", "query"]
    )
    """application client identity to use for accessing key encryption key Url in a different tenant.
     Ex: f83c6b1b-4d34-47e4-bb34-9d83df58b540."""

    @overload
    def __init__(
        self,
        *,
        identity_type: Optional[Union[str, "_models.KeyEncryptionKeyIdentityType"]] = None,
        user_assigned_identity_resource_id: Optional[str] = None,
        federated_client_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedServiceIdentity(_Model):
    """Managed service identity (system assigned and/or user assigned identities).

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.onlineexperimentation.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.onlineexperimentation.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ManagedServiceIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.onlineexperimentation.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.onlineexperimentation.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OnlineExperimentationWorkspace(TrackedResource):
    """An online experimentation workspace resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.onlineexperimentation.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.onlineexperimentation.models.OnlineExperimentationWorkspaceProperties
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.onlineexperimentation.models.ManagedServiceIdentity
    :ivar sku: The SKU (Stock Keeping Unit) assigned to this resource.
    :vartype sku: ~azure.mgmt.onlineexperimentation.models.OnlineExperimentationWorkspaceSku
    """

    properties: Optional["_models.OnlineExperimentationWorkspaceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""
    sku: Optional["_models.OnlineExperimentationWorkspaceSku"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The SKU (Stock Keeping Unit) assigned to this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.OnlineExperimentationWorkspaceProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        sku: Optional["_models.OnlineExperimentationWorkspaceSku"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OnlineExperimentationWorkspacePatch(_Model):
    """Partial update of an online experimentation workspace resource.

    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.onlineexperimentation.models.ManagedServiceIdentity
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The SKU (Stock Keeping Unit) assigned to this resource.
    :vartype sku: ~azure.mgmt.onlineexperimentation.models.OnlineExperimentationWorkspaceSku
    :ivar properties: Updatable properties of the online experimentation workspace resource.
    :vartype properties:
     ~azure.mgmt.onlineexperimentation.models.OnlineExperimentationWorkspacePatchProperties
    """

    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""
    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    sku: Optional["_models.OnlineExperimentationWorkspaceSku"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The SKU (Stock Keeping Unit) assigned to this resource."""
    properties: Optional["_models.OnlineExperimentationWorkspacePatchProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Updatable properties of the online experimentation workspace resource."""

    @overload
    def __init__(
        self,
        *,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.OnlineExperimentationWorkspaceSku"] = None,
        properties: Optional["_models.OnlineExperimentationWorkspacePatchProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OnlineExperimentationWorkspacePatchProperties(_Model):  # pylint: disable=name-too-long
    """OnlineExperimentationWorkspacePatchProperties.

    :ivar log_analytics_workspace_resource_id: The resource identifier of the Log Analytics
     workspace which online experimentation workspace uses for generating experiment analysis
     results.
    :vartype log_analytics_workspace_resource_id: str
    :ivar logs_exporter_storage_account_resource_id: The resource identifier of storage account
     where logs are exported from Log Analytics workspace. online experimentation workspace uses it
     generating experiment analysis results.
    :vartype logs_exporter_storage_account_resource_id: str
    :ivar encryption: The encryption configuration for the online experimentation workspace
     resource.
    :vartype encryption: ~azure.mgmt.onlineexperimentation.models.ResourceEncryptionConfiguration
    """

    log_analytics_workspace_resource_id: Optional[str] = rest_field(
        name="logAnalyticsWorkspaceResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource identifier of the Log Analytics workspace which online experimentation workspace
     uses for generating experiment analysis results."""
    logs_exporter_storage_account_resource_id: Optional[str] = rest_field(
        name="logsExporterStorageAccountResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource identifier of storage account where logs are exported from Log Analytics
     workspace. online experimentation workspace uses it generating experiment analysis results."""
    encryption: Optional["_models.ResourceEncryptionConfiguration"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The encryption configuration for the online experimentation workspace resource."""

    @overload
    def __init__(
        self,
        *,
        log_analytics_workspace_resource_id: Optional[str] = None,
        logs_exporter_storage_account_resource_id: Optional[str] = None,
        encryption: Optional["_models.ResourceEncryptionConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OnlineExperimentationWorkspaceProperties(_Model):
    """The properties of an online experimentation workspace.

    :ivar workspace_id: The Id of the workspace.
    :vartype workspace_id: str
    :ivar provisioning_state: The provisioning state for the resource. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.onlineexperimentation.models.ResourceProvisioningState
    :ivar log_analytics_workspace_resource_id: The resource identifier of the Log Analytics
     workspace which online experimentation workspace uses for generating experiment analysis
     results. Required.
    :vartype log_analytics_workspace_resource_id: str
    :ivar logs_exporter_storage_account_resource_id: The resource identifier of storage account
     where logs are exported from Log Analytics workspace. online experimentation workspace uses it
     generating experiment analysis results. Required.
    :vartype logs_exporter_storage_account_resource_id: str
    :ivar app_configuration_resource_id: The resource identifier of App Configuration with which
     this online experimentation workspace is tied for experimentation. This is a required field for
     creating an online experimentation workspace. Required.
    :vartype app_configuration_resource_id: str
    :ivar encryption: The encryption configuration for the online experimentation workspace
     resource.
    :vartype encryption: ~azure.mgmt.onlineexperimentation.models.ResourceEncryptionConfiguration
    :ivar endpoint: The data plane endpoint for the online experimentation workspace resource.
    :vartype endpoint: str
    """

    workspace_id: Optional[str] = rest_field(name="workspaceId", visibility=["read"])
    """The Id of the workspace."""
    provisioning_state: Optional[Union[str, "_models.ResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state for the resource. Known values are: \"Succeeded\", \"Failed\", and
     \"Canceled\"."""
    log_analytics_workspace_resource_id: str = rest_field(
        name="logAnalyticsWorkspaceResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource identifier of the Log Analytics workspace which online experimentation workspace
     uses for generating experiment analysis results. Required."""
    logs_exporter_storage_account_resource_id: str = rest_field(
        name="logsExporterStorageAccountResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource identifier of storage account where logs are exported from Log Analytics
     workspace. online experimentation workspace uses it generating experiment analysis results.
     Required."""
    app_configuration_resource_id: str = rest_field(name="appConfigurationResourceId", visibility=["read", "create"])
    """The resource identifier of App Configuration with which this online experimentation workspace
     is tied for experimentation. This is a required field for creating an online experimentation
     workspace. Required."""
    encryption: Optional["_models.ResourceEncryptionConfiguration"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The encryption configuration for the online experimentation workspace resource."""
    endpoint: Optional[str] = rest_field(visibility=["read"])
    """The data plane endpoint for the online experimentation workspace resource."""

    @overload
    def __init__(
        self,
        *,
        log_analytics_workspace_resource_id: str,
        logs_exporter_storage_account_resource_id: str,
        app_configuration_resource_id: str,
        encryption: Optional["_models.ResourceEncryptionConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OnlineExperimentationWorkspaceSku(_Model):
    """The SKU (Stock Keeping Unit) assigned to this resource.

    :ivar name: The name of the SKU. Ex - F0, P0. It is typically a letter+number code. Required.
     Known values are: "F0", "S0", "P0", and "D0".
    :vartype name: str or
     ~azure.mgmt.onlineexperimentation.models.OnlineExperimentationWorkspaceSkuName
    :ivar tier: The name of the SKU tier. Known values are: "Free", "Standard", "Premium", and
     "Developer".
    :vartype tier: str or
     ~azure.mgmt.onlineexperimentation.models.OnlineExperimentationWorkspaceSkuTier
    """

    name: Union[str, "_models.OnlineExperimentationWorkspaceSkuName"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the SKU. Ex - F0, P0. It is typically a letter+number code. Required. Known values
     are: \"F0\", \"S0\", \"P0\", and \"D0\"."""
    tier: Optional[Union[str, "_models.OnlineExperimentationWorkspaceSkuTier"]] = rest_field(visibility=["read"])
    """The name of the SKU tier. Known values are: \"Free\", \"Standard\", \"Premium\", and
     \"Developer\"."""

    @overload
    def __init__(
        self,
        *,
        name: Union[str, "_models.OnlineExperimentationWorkspaceSkuName"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """REST API Operation.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.onlineexperimentation.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.onlineexperimentation.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.onlineexperimentation.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class ResourceEncryptionConfiguration(_Model):
    """The encryption configuration for the online experimentation workspace resource.

    :ivar customer_managed_key_encryption: All Customer-managed key encryption properties for the
     resource.
    :vartype customer_managed_key_encryption:
     ~azure.mgmt.onlineexperimentation.models.CustomerManagedKeyEncryption
    """

    customer_managed_key_encryption: Optional["_models.CustomerManagedKeyEncryption"] = rest_field(
        name="customerManagedKeyEncryption", visibility=["read", "create", "update", "delete", "query"]
    )
    """All Customer-managed key encryption properties for the resource."""

    @overload
    def __init__(
        self,
        *,
        customer_managed_key_encryption: Optional["_models.CustomerManagedKeyEncryption"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.onlineexperimentation.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.onlineexperimentation.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_Model):
    """User assigned identity properties.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""
