# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.iothub import IotHubClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestIotHubCertificatesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(IotHubClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_certificates_list_by_iot_hub(self, resource_group):
        response = self.client.certificates.list_by_iot_hub(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2023-06-30",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_certificates_get(self, resource_group):
        response = self.client.certificates.get(
            resource_group_name=resource_group.name,
            resource_name="str",
            certificate_name="str",
            api_version="2023-06-30",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_certificates_create_or_update(self, resource_group):
        response = self.client.certificates.create_or_update(
            resource_group_name=resource_group.name,
            resource_name="str",
            certificate_name="str",
            certificate_description={
                "etag": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "certificate": "str",
                    "created": "2020-02-20 00:00:00",
                    "expiry": "2020-02-20 00:00:00",
                    "isVerified": bool,
                    "subject": "str",
                    "thumbprint": "str",
                    "updated": "2020-02-20 00:00:00",
                },
                "type": "str",
            },
            api_version="2023-06-30",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_certificates_delete(self, resource_group):
        response = self.client.certificates.delete(
            resource_group_name=resource_group.name,
            resource_name="str",
            certificate_name="str",
            if_match="str",
            api_version="2023-06-30",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_certificates_generate_verification_code(self, resource_group):
        response = self.client.certificates.generate_verification_code(
            resource_group_name=resource_group.name,
            resource_name="str",
            certificate_name="str",
            if_match="str",
            api_version="2023-06-30",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_certificates_verify(self, resource_group):
        response = self.client.certificates.verify(
            resource_group_name=resource_group.name,
            resource_name="str",
            certificate_name="str",
            if_match="str",
            certificate_verification_body={"certificate": "str"},
            api_version="2023-06-30",
        )

        # please add some check logic here by yourself
        # ...
