# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Cluster(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Define the cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Gets or sets the location. Required.
    :vartype location: str
    :ivar extended_location: Gets or sets the extended location.
    :vartype extended_location: ~azure.mgmt.connectedvmware.models.ExtendedLocation
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    :ivar tags: Gets or sets the Resource tags.
    :vartype tags: dict[str, str]
    :ivar name: Gets or sets the name.
    :vartype name: str
    :ivar id: Gets or sets the Id.
    :vartype id: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :vartype kind: str
    :ivar uuid: Gets or sets a unique identifier for this resource.
    :vartype uuid: str
    :ivar v_center_id: Gets or sets the ARM Id of the vCenter resource in which this cluster
     resides.
    :vartype v_center_id: str
    :ivar mo_ref_id: Gets or sets the vCenter MoRef (Managed Object Reference) ID for the cluster.
    :vartype mo_ref_id: str
    :ivar inventory_item_id: Gets or sets the inventory Item ID for the cluster.
    :vartype inventory_item_id: str
    :ivar mo_name: Gets or sets the vCenter Managed Object name for the cluster.
    :vartype mo_name: str
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.connectedvmware.models.ResourceStatus]
    :ivar custom_resource_name: Gets the name of the corresponding resource in Kubernetes.
    :vartype custom_resource_name: str
    :ivar used_memory_gb: Gets the used physical memory on the cluster in GB.
    :vartype used_memory_gb: int
    :ivar total_memory_gb: Gets the total amount of physical memory on the cluster in GB.
    :vartype total_memory_gb: int
    :ivar used_cpu_m_hz: Gets the used CPU usage across all cores on the cluster in MHz.
    :vartype used_cpu_m_hz: int
    :ivar total_cpu_m_hz: Gets the max CPU usage across all cores on the cluster in MHz.
    :vartype total_cpu_m_hz: int
    :ivar datastore_ids: Gets the datastore ARM ids.
    :vartype datastore_ids: list[str]
    :ivar network_ids: Gets the network ARM ids.
    :vartype network_ids: list[str]
    :ivar provisioning_state: Gets the provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Provisioning", "Updating", "Deleting", "Accepted", and "Created".
    :vartype provisioning_state: str or ~azure.mgmt.connectedvmware.models.ProvisioningState
    """

    _validation = {
        "location": {"required": True},
        "system_data": {"readonly": True},
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "uuid": {"readonly": True},
        "mo_name": {"readonly": True},
        "statuses": {"readonly": True},
        "custom_resource_name": {"readonly": True},
        "used_memory_gb": {"readonly": True},
        "total_memory_gb": {"readonly": True},
        "used_cpu_m_hz": {"readonly": True},
        "total_cpu_m_hz": {"readonly": True},
        "datastore_ids": {"readonly": True},
        "network_ids": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "uuid": {"key": "properties.uuid", "type": "str"},
        "v_center_id": {"key": "properties.vCenterId", "type": "str"},
        "mo_ref_id": {"key": "properties.moRefId", "type": "str"},
        "inventory_item_id": {"key": "properties.inventoryItemId", "type": "str"},
        "mo_name": {"key": "properties.moName", "type": "str"},
        "statuses": {"key": "properties.statuses", "type": "[ResourceStatus]"},
        "custom_resource_name": {"key": "properties.customResourceName", "type": "str"},
        "used_memory_gb": {"key": "properties.usedMemoryGB", "type": "int"},
        "total_memory_gb": {"key": "properties.totalMemoryGB", "type": "int"},
        "used_cpu_m_hz": {"key": "properties.usedCpuMHz", "type": "int"},
        "total_cpu_m_hz": {"key": "properties.totalCpuMHz", "type": "int"},
        "datastore_ids": {"key": "properties.datastoreIds", "type": "[str]"},
        "network_ids": {"key": "properties.networkIds", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        tags: Optional[Dict[str, str]] = None,
        kind: Optional[str] = None,
        v_center_id: Optional[str] = None,
        mo_ref_id: Optional[str] = None,
        inventory_item_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Gets or sets the location. Required.
        :paramtype location: str
        :keyword extended_location: Gets or sets the extended location.
        :paramtype extended_location: ~azure.mgmt.connectedvmware.models.ExtendedLocation
        :keyword tags: Gets or sets the Resource tags.
        :paramtype tags: dict[str, str]
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
         the resource provider must validate and persist this value.
        :paramtype kind: str
        :keyword v_center_id: Gets or sets the ARM Id of the vCenter resource in which this cluster
         resides.
        :paramtype v_center_id: str
        :keyword mo_ref_id: Gets or sets the vCenter MoRef (Managed Object Reference) ID for the
         cluster.
        :paramtype mo_ref_id: str
        :keyword inventory_item_id: Gets or sets the inventory Item ID for the cluster.
        :paramtype inventory_item_id: str
        """
        super().__init__(**kwargs)
        self.location = location
        self.extended_location = extended_location
        self.system_data = None
        self.tags = tags
        self.name = None
        self.id = None
        self.type = None
        self.kind = kind
        self.uuid = None
        self.v_center_id = v_center_id
        self.mo_ref_id = mo_ref_id
        self.inventory_item_id = inventory_item_id
        self.mo_name = None
        self.statuses = None
        self.custom_resource_name = None
        self.used_memory_gb = None
        self.total_memory_gb = None
        self.used_cpu_m_hz = None
        self.total_cpu_m_hz = None
        self.datastore_ids = None
        self.network_ids = None
        self.provisioning_state = None


class InventoryItemProperties(_serialization.Model):
    """Describes the properties of an Inventory Item.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ClusterInventoryItem, DatastoreInventoryItem, HostInventoryItem, ResourcePoolInventoryItem,
    VirtualMachineInventoryItem, VirtualMachineTemplateInventoryItem, VirtualNetworkInventoryItem

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar inventory_type: They inventory type. Required. Known values are: "ResourcePool",
     "VirtualMachine", "VirtualMachineTemplate", "VirtualNetwork", "Cluster", "Datastore", and
     "Host".
    :vartype inventory_type: str or ~azure.mgmt.connectedvmware.models.InventoryType
    :ivar managed_resource_id: Gets or sets the tracked resource id corresponding to the inventory
     resource.
    :vartype managed_resource_id: str
    :ivar mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
    :vartype mo_ref_id: str
    :ivar mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
    :vartype mo_name: str
    :ivar provisioning_state: Gets the provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Provisioning", "Updating", "Deleting", "Accepted", and "Created".
    :vartype provisioning_state: str or ~azure.mgmt.connectedvmware.models.ProvisioningState
    """

    _validation = {
        "inventory_type": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "inventory_type": {"key": "inventoryType", "type": "str"},
        "managed_resource_id": {"key": "managedResourceId", "type": "str"},
        "mo_ref_id": {"key": "moRefId", "type": "str"},
        "mo_name": {"key": "moName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    _subtype_map = {
        "inventory_type": {
            "Cluster": "ClusterInventoryItem",
            "Datastore": "DatastoreInventoryItem",
            "Host": "HostInventoryItem",
            "ResourcePool": "ResourcePoolInventoryItem",
            "VirtualMachine": "VirtualMachineInventoryItem",
            "VirtualMachineTemplate": "VirtualMachineTemplateInventoryItem",
            "VirtualNetwork": "VirtualNetworkInventoryItem",
        }
    }

    def __init__(
        self,
        *,
        managed_resource_id: Optional[str] = None,
        mo_ref_id: Optional[str] = None,
        mo_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword managed_resource_id: Gets or sets the tracked resource id corresponding to the
         inventory resource.
        :paramtype managed_resource_id: str
        :keyword mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory
         item.
        :paramtype mo_ref_id: str
        :keyword mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
        :paramtype mo_name: str
        """
        super().__init__(**kwargs)
        self.inventory_type: Optional[str] = None
        self.managed_resource_id = managed_resource_id
        self.mo_ref_id = mo_ref_id
        self.mo_name = mo_name
        self.provisioning_state = None


class ClusterInventoryItem(InventoryItemProperties):
    """The cluster inventory item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar inventory_type: They inventory type. Required. Known values are: "ResourcePool",
     "VirtualMachine", "VirtualMachineTemplate", "VirtualNetwork", "Cluster", "Datastore", and
     "Host".
    :vartype inventory_type: str or ~azure.mgmt.connectedvmware.models.InventoryType
    :ivar managed_resource_id: Gets or sets the tracked resource id corresponding to the inventory
     resource.
    :vartype managed_resource_id: str
    :ivar mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
    :vartype mo_ref_id: str
    :ivar mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
    :vartype mo_name: str
    :ivar provisioning_state: Gets the provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Provisioning", "Updating", "Deleting", "Accepted", and "Created".
    :vartype provisioning_state: str or ~azure.mgmt.connectedvmware.models.ProvisioningState
    """

    _validation = {
        "inventory_type": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "inventory_type": {"key": "inventoryType", "type": "str"},
        "managed_resource_id": {"key": "managedResourceId", "type": "str"},
        "mo_ref_id": {"key": "moRefId", "type": "str"},
        "mo_name": {"key": "moName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        managed_resource_id: Optional[str] = None,
        mo_ref_id: Optional[str] = None,
        mo_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword managed_resource_id: Gets or sets the tracked resource id corresponding to the
         inventory resource.
        :paramtype managed_resource_id: str
        :keyword mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory
         item.
        :paramtype mo_ref_id: str
        :keyword mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
        :paramtype mo_name: str
        """
        super().__init__(managed_resource_id=managed_resource_id, mo_ref_id=mo_ref_id, mo_name=mo_name, **kwargs)
        self.inventory_type: str = "Cluster"


class ClustersList(_serialization.Model):
    """List of Clusters.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: Url to follow for getting next page of Clusters.
    :vartype next_link: str
    :ivar value: Array of Clusters. Required.
    :vartype value: list[~azure.mgmt.connectedvmware.models.Cluster]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Cluster]"},
    }

    def __init__(self, *, value: List["_models.Cluster"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: Url to follow for getting next page of Clusters.
        :paramtype next_link: str
        :keyword value: Array of Clusters. Required.
        :paramtype value: list[~azure.mgmt.connectedvmware.models.Cluster]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class Condition(_serialization.Model):
    """Condition defines an extension to status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: Status of the condition.
    :vartype status: str
    :ivar reason: The reason for the condition's status.
    :vartype reason: str
    :ivar message: A human readable message indicating details about the status.
    :vartype message: str
    :ivar severity: Severity with which to treat failures of this type of condition.
    :vartype severity: str
    """

    _validation = {
        "status": {"readonly": True},
        "reason": {"readonly": True},
        "message": {"readonly": True},
        "severity": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.reason = None
        self.message = None
        self.severity = None


class Datastore(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Define the datastore.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Gets or sets the location. Required.
    :vartype location: str
    :ivar extended_location: Gets or sets the extended location.
    :vartype extended_location: ~azure.mgmt.connectedvmware.models.ExtendedLocation
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    :ivar tags: Gets or sets the Resource tags.
    :vartype tags: dict[str, str]
    :ivar name: Gets or sets the name.
    :vartype name: str
    :ivar id: Gets or sets the Id.
    :vartype id: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :vartype kind: str
    :ivar uuid: Gets or sets a unique identifier for this resource.
    :vartype uuid: str
    :ivar v_center_id: Gets or sets the ARM Id of the vCenter resource in which this datastore
     resides.
    :vartype v_center_id: str
    :ivar mo_ref_id: Gets or sets the vCenter MoRef (Managed Object Reference) ID for the
     datastore.
    :vartype mo_ref_id: str
    :ivar inventory_item_id: Gets or sets the inventory Item ID for the datastore.
    :vartype inventory_item_id: str
    :ivar mo_name: Gets or sets the vCenter Managed Object name for the datastore.
    :vartype mo_name: str
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.connectedvmware.models.ResourceStatus]
    :ivar custom_resource_name: Gets the name of the corresponding resource in Kubernetes.
    :vartype custom_resource_name: str
    :ivar capacity_gb: Gets or sets Maximum capacity of this datastore in GBs.
    :vartype capacity_gb: int
    :ivar free_space_gb: Gets or sets Available space of this datastore in GBs.
    :vartype free_space_gb: int
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", "Accepted", and "Created".
    :vartype provisioning_state: str or ~azure.mgmt.connectedvmware.models.ProvisioningState
    """

    _validation = {
        "location": {"required": True},
        "system_data": {"readonly": True},
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "uuid": {"readonly": True},
        "mo_name": {"readonly": True},
        "statuses": {"readonly": True},
        "custom_resource_name": {"readonly": True},
        "capacity_gb": {"readonly": True},
        "free_space_gb": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "uuid": {"key": "properties.uuid", "type": "str"},
        "v_center_id": {"key": "properties.vCenterId", "type": "str"},
        "mo_ref_id": {"key": "properties.moRefId", "type": "str"},
        "inventory_item_id": {"key": "properties.inventoryItemId", "type": "str"},
        "mo_name": {"key": "properties.moName", "type": "str"},
        "statuses": {"key": "properties.statuses", "type": "[ResourceStatus]"},
        "custom_resource_name": {"key": "properties.customResourceName", "type": "str"},
        "capacity_gb": {"key": "properties.capacityGB", "type": "int"},
        "free_space_gb": {"key": "properties.freeSpaceGB", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        tags: Optional[Dict[str, str]] = None,
        kind: Optional[str] = None,
        v_center_id: Optional[str] = None,
        mo_ref_id: Optional[str] = None,
        inventory_item_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Gets or sets the location. Required.
        :paramtype location: str
        :keyword extended_location: Gets or sets the extended location.
        :paramtype extended_location: ~azure.mgmt.connectedvmware.models.ExtendedLocation
        :keyword tags: Gets or sets the Resource tags.
        :paramtype tags: dict[str, str]
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
         the resource provider must validate and persist this value.
        :paramtype kind: str
        :keyword v_center_id: Gets or sets the ARM Id of the vCenter resource in which this datastore
         resides.
        :paramtype v_center_id: str
        :keyword mo_ref_id: Gets or sets the vCenter MoRef (Managed Object Reference) ID for the
         datastore.
        :paramtype mo_ref_id: str
        :keyword inventory_item_id: Gets or sets the inventory Item ID for the datastore.
        :paramtype inventory_item_id: str
        """
        super().__init__(**kwargs)
        self.location = location
        self.extended_location = extended_location
        self.system_data = None
        self.tags = tags
        self.name = None
        self.id = None
        self.type = None
        self.kind = kind
        self.uuid = None
        self.v_center_id = v_center_id
        self.mo_ref_id = mo_ref_id
        self.inventory_item_id = inventory_item_id
        self.mo_name = None
        self.statuses = None
        self.custom_resource_name = None
        self.capacity_gb = None
        self.free_space_gb = None
        self.provisioning_state = None


class DatastoreInventoryItem(InventoryItemProperties):
    """The datastore inventory item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar inventory_type: They inventory type. Required. Known values are: "ResourcePool",
     "VirtualMachine", "VirtualMachineTemplate", "VirtualNetwork", "Cluster", "Datastore", and
     "Host".
    :vartype inventory_type: str or ~azure.mgmt.connectedvmware.models.InventoryType
    :ivar managed_resource_id: Gets or sets the tracked resource id corresponding to the inventory
     resource.
    :vartype managed_resource_id: str
    :ivar mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
    :vartype mo_ref_id: str
    :ivar mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
    :vartype mo_name: str
    :ivar provisioning_state: Gets the provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Provisioning", "Updating", "Deleting", "Accepted", and "Created".
    :vartype provisioning_state: str or ~azure.mgmt.connectedvmware.models.ProvisioningState
    :ivar capacity_gb: Gets or sets Maximum capacity of this datastore, in GBs.
    :vartype capacity_gb: int
    :ivar free_space_gb: Gets or sets Available space of this datastore, in GBs.
    :vartype free_space_gb: int
    """

    _validation = {
        "inventory_type": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "inventory_type": {"key": "inventoryType", "type": "str"},
        "managed_resource_id": {"key": "managedResourceId", "type": "str"},
        "mo_ref_id": {"key": "moRefId", "type": "str"},
        "mo_name": {"key": "moName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "capacity_gb": {"key": "capacityGB", "type": "int"},
        "free_space_gb": {"key": "freeSpaceGB", "type": "int"},
    }

    def __init__(
        self,
        *,
        managed_resource_id: Optional[str] = None,
        mo_ref_id: Optional[str] = None,
        mo_name: Optional[str] = None,
        capacity_gb: Optional[int] = None,
        free_space_gb: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword managed_resource_id: Gets or sets the tracked resource id corresponding to the
         inventory resource.
        :paramtype managed_resource_id: str
        :keyword mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory
         item.
        :paramtype mo_ref_id: str
        :keyword mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
        :paramtype mo_name: str
        :keyword capacity_gb: Gets or sets Maximum capacity of this datastore, in GBs.
        :paramtype capacity_gb: int
        :keyword free_space_gb: Gets or sets Available space of this datastore, in GBs.
        :paramtype free_space_gb: int
        """
        super().__init__(managed_resource_id=managed_resource_id, mo_ref_id=mo_ref_id, mo_name=mo_name, **kwargs)
        self.inventory_type: str = "Datastore"
        self.capacity_gb = capacity_gb
        self.free_space_gb = free_space_gb


class DatastoresList(_serialization.Model):
    """List of Datastores.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: Url to follow for getting next page of Datastores.
    :vartype next_link: str
    :ivar value: Array of Datastores. Required.
    :vartype value: list[~azure.mgmt.connectedvmware.models.Datastore]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Datastore]"},
    }

    def __init__(self, *, value: List["_models.Datastore"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: Url to follow for getting next page of Datastores.
        :paramtype next_link: str
        :keyword value: Array of Datastores. Required.
        :paramtype value: list[~azure.mgmt.connectedvmware.models.Datastore]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.connectedvmware.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.connectedvmware.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.connectedvmware.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.connectedvmware.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ExtendedLocation(_serialization.Model):
    """The extended location.

    :ivar type: The extended location type.
    :vartype type: str
    :ivar name: The extended location name.
    :vartype name: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, type: Optional[str] = None, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword type: The extended location type.
        :paramtype type: str
        :keyword name: The extended location name.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.name = name


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class GuestAgent(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Defines the GuestAgent.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    :ivar uuid: Gets or sets a unique identifier for this resource.
    :vartype uuid: str
    :ivar credentials: Username / Password Credentials to provision guest agent.
    :vartype credentials: ~azure.mgmt.connectedvmware.models.GuestCredential
    :ivar private_link_scope_resource_id: The resource id of the private link scope this machine is
     assigned to, if any.
    :vartype private_link_scope_resource_id: str
    :ivar http_proxy_config: HTTP Proxy configuration for the VM.
    :vartype http_proxy_config: ~azure.mgmt.connectedvmware.models.HttpProxyConfiguration
    :ivar provisioning_action: Gets or sets the guest agent provisioning action. Known values are:
     "install", "uninstall", and "repair".
    :vartype provisioning_action: str or ~azure.mgmt.connectedvmware.models.ProvisioningAction
    :ivar status: Gets or sets the guest agent status.
    :vartype status: str
    :ivar custom_resource_name: Gets the name of the corresponding resource in Kubernetes.
    :vartype custom_resource_name: str
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.connectedvmware.models.ResourceStatus]
    :ivar provisioning_state: Gets the provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Provisioning", "Updating", "Deleting", "Accepted", and "Created".
    :vartype provisioning_state: str or ~azure.mgmt.connectedvmware.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "uuid": {"readonly": True},
        "status": {"readonly": True},
        "custom_resource_name": {"readonly": True},
        "statuses": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "uuid": {"key": "properties.uuid", "type": "str"},
        "credentials": {"key": "properties.credentials", "type": "GuestCredential"},
        "private_link_scope_resource_id": {"key": "properties.privateLinkScopeResourceId", "type": "str"},
        "http_proxy_config": {"key": "properties.httpProxyConfig", "type": "HttpProxyConfiguration"},
        "provisioning_action": {"key": "properties.provisioningAction", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "custom_resource_name": {"key": "properties.customResourceName", "type": "str"},
        "statuses": {"key": "properties.statuses", "type": "[ResourceStatus]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        credentials: Optional["_models.GuestCredential"] = None,
        private_link_scope_resource_id: Optional[str] = None,
        http_proxy_config: Optional["_models.HttpProxyConfiguration"] = None,
        provisioning_action: Optional[Union[str, "_models.ProvisioningAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword credentials: Username / Password Credentials to provision guest agent.
        :paramtype credentials: ~azure.mgmt.connectedvmware.models.GuestCredential
        :keyword private_link_scope_resource_id: The resource id of the private link scope this machine
         is assigned to, if any.
        :paramtype private_link_scope_resource_id: str
        :keyword http_proxy_config: HTTP Proxy configuration for the VM.
        :paramtype http_proxy_config: ~azure.mgmt.connectedvmware.models.HttpProxyConfiguration
        :keyword provisioning_action: Gets or sets the guest agent provisioning action. Known values
         are: "install", "uninstall", and "repair".
        :paramtype provisioning_action: str or ~azure.mgmt.connectedvmware.models.ProvisioningAction
        """
        super().__init__(**kwargs)
        self.uuid = None
        self.credentials = credentials
        self.private_link_scope_resource_id = private_link_scope_resource_id
        self.http_proxy_config = http_proxy_config
        self.provisioning_action = provisioning_action
        self.status = None
        self.custom_resource_name = None
        self.statuses = None
        self.provisioning_state = None


class GuestAgentList(_serialization.Model):
    """List of GuestAgent.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: Url to follow for getting next page of GuestAgent.
    :vartype next_link: str
    :ivar value: Array of GuestAgent. Required.
    :vartype value: list[~azure.mgmt.connectedvmware.models.GuestAgent]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[GuestAgent]"},
    }

    def __init__(self, *, value: List["_models.GuestAgent"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: Url to follow for getting next page of GuestAgent.
        :paramtype next_link: str
        :keyword value: Array of GuestAgent. Required.
        :paramtype value: list[~azure.mgmt.connectedvmware.models.GuestAgent]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class GuestCredential(_serialization.Model):
    """Username / Password Credentials to connect to guest.

    :ivar username: Gets or sets username to connect with the guest.
    :vartype username: str
    :ivar password: Gets or sets the password to connect with the guest.
    :vartype password: str
    """

    _attribute_map = {
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
    }

    def __init__(self, *, username: Optional[str] = None, password: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword username: Gets or sets username to connect with the guest.
        :paramtype username: str
        :keyword password: Gets or sets the password to connect with the guest.
        :paramtype password: str
        """
        super().__init__(**kwargs)
        self.username = username
        self.password = password


class HardwareProfile(_serialization.Model):
    """Specifies the hardware settings for the virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar memory_size_mb: Gets or sets memory size in MBs for the vm.
    :vartype memory_size_mb: int
    :ivar num_cp_us: Gets or sets the number of vCPUs for the vm.
    :vartype num_cp_us: int
    :ivar num_cores_per_socket: Gets or sets the number of cores per socket for the vm. Defaults to
     1 if unspecified.
    :vartype num_cores_per_socket: int
    :ivar cpu_hot_add_enabled: Gets or sets a value indicating whether virtual processors can be
     added while this virtual machine is running.
    :vartype cpu_hot_add_enabled: bool
    :ivar cpu_hot_remove_enabled: Gets or sets a value indicating whether virtual processors can be
     removed while this virtual machine is running.
    :vartype cpu_hot_remove_enabled: bool
    :ivar memory_hot_add_enabled: Gets or sets a value indicating whether memory can be added while
     this virtual machine is running.
    :vartype memory_hot_add_enabled: bool
    """

    _validation = {
        "cpu_hot_add_enabled": {"readonly": True},
        "cpu_hot_remove_enabled": {"readonly": True},
        "memory_hot_add_enabled": {"readonly": True},
    }

    _attribute_map = {
        "memory_size_mb": {"key": "memorySizeMB", "type": "int"},
        "num_cp_us": {"key": "numCPUs", "type": "int"},
        "num_cores_per_socket": {"key": "numCoresPerSocket", "type": "int"},
        "cpu_hot_add_enabled": {"key": "cpuHotAddEnabled", "type": "bool"},
        "cpu_hot_remove_enabled": {"key": "cpuHotRemoveEnabled", "type": "bool"},
        "memory_hot_add_enabled": {"key": "memoryHotAddEnabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        memory_size_mb: Optional[int] = None,
        num_cp_us: Optional[int] = None,
        num_cores_per_socket: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword memory_size_mb: Gets or sets memory size in MBs for the vm.
        :paramtype memory_size_mb: int
        :keyword num_cp_us: Gets or sets the number of vCPUs for the vm.
        :paramtype num_cp_us: int
        :keyword num_cores_per_socket: Gets or sets the number of cores per socket for the vm. Defaults
         to 1 if unspecified.
        :paramtype num_cores_per_socket: int
        """
        super().__init__(**kwargs)
        self.memory_size_mb = memory_size_mb
        self.num_cp_us = num_cp_us
        self.num_cores_per_socket = num_cores_per_socket
        self.cpu_hot_add_enabled = None
        self.cpu_hot_remove_enabled = None
        self.memory_hot_add_enabled = None


class Host(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Define the host.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Gets or sets the location. Required.
    :vartype location: str
    :ivar extended_location: Gets or sets the extended location.
    :vartype extended_location: ~azure.mgmt.connectedvmware.models.ExtendedLocation
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    :ivar tags: Gets or sets the Resource tags.
    :vartype tags: dict[str, str]
    :ivar name: Gets or sets the name.
    :vartype name: str
    :ivar id: Gets or sets the Id.
    :vartype id: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :vartype kind: str
    :ivar uuid: Gets or sets a unique identifier for this resource.
    :vartype uuid: str
    :ivar v_center_id: Gets or sets the ARM Id of the vCenter resource in which this host resides.
    :vartype v_center_id: str
    :ivar mo_ref_id: Gets or sets the vCenter MoRef (Managed Object Reference) ID for the host.
    :vartype mo_ref_id: str
    :ivar inventory_item_id: Gets or sets the inventory Item ID for the host.
    :vartype inventory_item_id: str
    :ivar mo_name: Gets or sets the vCenter Managed Object name for the host.
    :vartype mo_name: str
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.connectedvmware.models.ResourceStatus]
    :ivar custom_resource_name: Gets the name of the corresponding resource in Kubernetes.
    :vartype custom_resource_name: str
    :ivar overall_memory_usage_gb: Gets the used physical memory on the host in GB.
    :vartype overall_memory_usage_gb: int
    :ivar memory_size_gb: Gets the total amount of physical memory on the host in GB.
    :vartype memory_size_gb: int
    :ivar overall_cpu_usage_m_hz: Gets the used CPU usage across all cores in MHz.
    :vartype overall_cpu_usage_m_hz: int
    :ivar cpu_mhz: Gets the max CPU usage across all cores in MHz.
    :vartype cpu_mhz: int
    :ivar datastore_ids: Gets the datastore ARM ids.
    :vartype datastore_ids: list[str]
    :ivar network_ids: Gets the network ARM ids.
    :vartype network_ids: list[str]
    :ivar provisioning_state: Gets the provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Provisioning", "Updating", "Deleting", "Accepted", and "Created".
    :vartype provisioning_state: str or ~azure.mgmt.connectedvmware.models.ProvisioningState
    """

    _validation = {
        "location": {"required": True},
        "system_data": {"readonly": True},
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "uuid": {"readonly": True},
        "mo_name": {"readonly": True},
        "statuses": {"readonly": True},
        "custom_resource_name": {"readonly": True},
        "overall_memory_usage_gb": {"readonly": True},
        "memory_size_gb": {"readonly": True},
        "overall_cpu_usage_m_hz": {"readonly": True},
        "cpu_mhz": {"readonly": True},
        "datastore_ids": {"readonly": True},
        "network_ids": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "uuid": {"key": "properties.uuid", "type": "str"},
        "v_center_id": {"key": "properties.vCenterId", "type": "str"},
        "mo_ref_id": {"key": "properties.moRefId", "type": "str"},
        "inventory_item_id": {"key": "properties.inventoryItemId", "type": "str"},
        "mo_name": {"key": "properties.moName", "type": "str"},
        "statuses": {"key": "properties.statuses", "type": "[ResourceStatus]"},
        "custom_resource_name": {"key": "properties.customResourceName", "type": "str"},
        "overall_memory_usage_gb": {"key": "properties.overallMemoryUsageGB", "type": "int"},
        "memory_size_gb": {"key": "properties.memorySizeGB", "type": "int"},
        "overall_cpu_usage_m_hz": {"key": "properties.overallCpuUsageMHz", "type": "int"},
        "cpu_mhz": {"key": "properties.cpuMhz", "type": "int"},
        "datastore_ids": {"key": "properties.datastoreIds", "type": "[str]"},
        "network_ids": {"key": "properties.networkIds", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        tags: Optional[Dict[str, str]] = None,
        kind: Optional[str] = None,
        v_center_id: Optional[str] = None,
        mo_ref_id: Optional[str] = None,
        inventory_item_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Gets or sets the location. Required.
        :paramtype location: str
        :keyword extended_location: Gets or sets the extended location.
        :paramtype extended_location: ~azure.mgmt.connectedvmware.models.ExtendedLocation
        :keyword tags: Gets or sets the Resource tags.
        :paramtype tags: dict[str, str]
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
         the resource provider must validate and persist this value.
        :paramtype kind: str
        :keyword v_center_id: Gets or sets the ARM Id of the vCenter resource in which this host
         resides.
        :paramtype v_center_id: str
        :keyword mo_ref_id: Gets or sets the vCenter MoRef (Managed Object Reference) ID for the host.
        :paramtype mo_ref_id: str
        :keyword inventory_item_id: Gets or sets the inventory Item ID for the host.
        :paramtype inventory_item_id: str
        """
        super().__init__(**kwargs)
        self.location = location
        self.extended_location = extended_location
        self.system_data = None
        self.tags = tags
        self.name = None
        self.id = None
        self.type = None
        self.kind = kind
        self.uuid = None
        self.v_center_id = v_center_id
        self.mo_ref_id = mo_ref_id
        self.inventory_item_id = inventory_item_id
        self.mo_name = None
        self.statuses = None
        self.custom_resource_name = None
        self.overall_memory_usage_gb = None
        self.memory_size_gb = None
        self.overall_cpu_usage_m_hz = None
        self.cpu_mhz = None
        self.datastore_ids = None
        self.network_ids = None
        self.provisioning_state = None


class HostInventoryItem(InventoryItemProperties):
    """The host inventory item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar inventory_type: They inventory type. Required. Known values are: "ResourcePool",
     "VirtualMachine", "VirtualMachineTemplate", "VirtualNetwork", "Cluster", "Datastore", and
     "Host".
    :vartype inventory_type: str or ~azure.mgmt.connectedvmware.models.InventoryType
    :ivar managed_resource_id: Gets or sets the tracked resource id corresponding to the inventory
     resource.
    :vartype managed_resource_id: str
    :ivar mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
    :vartype mo_ref_id: str
    :ivar mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
    :vartype mo_name: str
    :ivar provisioning_state: Gets the provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Provisioning", "Updating", "Deleting", "Accepted", and "Created".
    :vartype provisioning_state: str or ~azure.mgmt.connectedvmware.models.ProvisioningState
    :ivar parent: Parent host inventory resource details.
    :vartype parent: ~azure.mgmt.connectedvmware.models.InventoryItemDetails
    """

    _validation = {
        "inventory_type": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "inventory_type": {"key": "inventoryType", "type": "str"},
        "managed_resource_id": {"key": "managedResourceId", "type": "str"},
        "mo_ref_id": {"key": "moRefId", "type": "str"},
        "mo_name": {"key": "moName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "parent": {"key": "parent", "type": "InventoryItemDetails"},
    }

    def __init__(
        self,
        *,
        managed_resource_id: Optional[str] = None,
        mo_ref_id: Optional[str] = None,
        mo_name: Optional[str] = None,
        parent: Optional["_models.InventoryItemDetails"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword managed_resource_id: Gets or sets the tracked resource id corresponding to the
         inventory resource.
        :paramtype managed_resource_id: str
        :keyword mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory
         item.
        :paramtype mo_ref_id: str
        :keyword mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
        :paramtype mo_name: str
        :keyword parent: Parent host inventory resource details.
        :paramtype parent: ~azure.mgmt.connectedvmware.models.InventoryItemDetails
        """
        super().__init__(managed_resource_id=managed_resource_id, mo_ref_id=mo_ref_id, mo_name=mo_name, **kwargs)
        self.inventory_type: str = "Host"
        self.parent = parent


class HostsList(_serialization.Model):
    """List of Hosts.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: Url to follow for getting next page of Hosts.
    :vartype next_link: str
    :ivar value: Array of Hosts. Required.
    :vartype value: list[~azure.mgmt.connectedvmware.models.Host]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Host]"},
    }

    def __init__(self, *, value: List["_models.Host"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: Url to follow for getting next page of Hosts.
        :paramtype next_link: str
        :keyword value: Array of Hosts. Required.
        :paramtype value: list[~azure.mgmt.connectedvmware.models.Host]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class HttpProxyConfiguration(_serialization.Model):
    """HTTP Proxy configuration for the VM.

    :ivar https_proxy: Gets or sets httpsProxy url.
    :vartype https_proxy: str
    """

    _attribute_map = {
        "https_proxy": {"key": "httpsProxy", "type": "str"},
    }

    def __init__(self, *, https_proxy: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword https_proxy: Gets or sets httpsProxy url.
        :paramtype https_proxy: str
        """
        super().__init__(**kwargs)
        self.https_proxy = https_proxy


class InfrastructureProfile(_serialization.Model):
    """Specifies the vCenter infrastructure specific settings for the virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar template_id: Gets or sets the ARM Id of the template resource to deploy the virtual
     machine.
    :vartype template_id: str
    :ivar v_center_id: Gets or sets the ARM Id of the vCenter resource in which this resource pool
     resides.
    :vartype v_center_id: str
    :ivar mo_ref_id: Gets or sets the vCenter MoRef (Managed Object Reference) ID for the virtual
     machine.
    :vartype mo_ref_id: str
    :ivar inventory_item_id: Gets or sets the inventory Item ID for the virtual machine.
    :vartype inventory_item_id: str
    :ivar mo_name: Gets or sets the vCenter Managed Object name for the virtual machine.
    :vartype mo_name: str
    :ivar folder_path: Gets or sets the folder path of the vm.
    :vartype folder_path: str
    :ivar instance_uuid: Gets or sets the instance uuid of the vm.
    :vartype instance_uuid: str
    :ivar smbios_uuid: Gets or sets the SMBIOS UUID of the vm.
    :vartype smbios_uuid: str
    :ivar firmware_type: Firmware type. Known values are: "bios" and "efi".
    :vartype firmware_type: str or ~azure.mgmt.connectedvmware.models.FirmwareType
    :ivar custom_resource_name: Gets the name of the corresponding resource in Kubernetes.
    :vartype custom_resource_name: str
    """

    _validation = {
        "mo_ref_id": {"readonly": True},
        "mo_name": {"readonly": True},
        "folder_path": {"readonly": True},
        "instance_uuid": {"readonly": True},
        "custom_resource_name": {"readonly": True},
    }

    _attribute_map = {
        "template_id": {"key": "templateId", "type": "str"},
        "v_center_id": {"key": "vCenterId", "type": "str"},
        "mo_ref_id": {"key": "moRefId", "type": "str"},
        "inventory_item_id": {"key": "inventoryItemId", "type": "str"},
        "mo_name": {"key": "moName", "type": "str"},
        "folder_path": {"key": "folderPath", "type": "str"},
        "instance_uuid": {"key": "instanceUuid", "type": "str"},
        "smbios_uuid": {"key": "smbiosUuid", "type": "str"},
        "firmware_type": {"key": "firmwareType", "type": "str"},
        "custom_resource_name": {"key": "customResourceName", "type": "str"},
    }

    def __init__(
        self,
        *,
        template_id: Optional[str] = None,
        v_center_id: Optional[str] = None,
        inventory_item_id: Optional[str] = None,
        smbios_uuid: Optional[str] = None,
        firmware_type: Optional[Union[str, "_models.FirmwareType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword template_id: Gets or sets the ARM Id of the template resource to deploy the virtual
         machine.
        :paramtype template_id: str
        :keyword v_center_id: Gets or sets the ARM Id of the vCenter resource in which this resource
         pool resides.
        :paramtype v_center_id: str
        :keyword inventory_item_id: Gets or sets the inventory Item ID for the virtual machine.
        :paramtype inventory_item_id: str
        :keyword smbios_uuid: Gets or sets the SMBIOS UUID of the vm.
        :paramtype smbios_uuid: str
        :keyword firmware_type: Firmware type. Known values are: "bios" and "efi".
        :paramtype firmware_type: str or ~azure.mgmt.connectedvmware.models.FirmwareType
        """
        super().__init__(**kwargs)
        self.template_id = template_id
        self.v_center_id = v_center_id
        self.mo_ref_id = None
        self.inventory_item_id = inventory_item_id
        self.mo_name = None
        self.folder_path = None
        self.instance_uuid = None
        self.smbios_uuid = smbios_uuid
        self.firmware_type = firmware_type
        self.custom_resource_name = None


class InventoryItem(ProxyResource):
    """Defines the inventory item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :vartype kind: str
    :ivar inventory_type: They inventory type. Required. Known values are: "ResourcePool",
     "VirtualMachine", "VirtualMachineTemplate", "VirtualNetwork", "Cluster", "Datastore", and
     "Host".
    :vartype inventory_type: str or ~azure.mgmt.connectedvmware.models.InventoryType
    :ivar managed_resource_id: Gets or sets the tracked resource id corresponding to the inventory
     resource.
    :vartype managed_resource_id: str
    :ivar mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
    :vartype mo_ref_id: str
    :ivar mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
    :vartype mo_name: str
    :ivar provisioning_state: Gets the provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Provisioning", "Updating", "Deleting", "Accepted", and "Created".
    :vartype provisioning_state: str or ~azure.mgmt.connectedvmware.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "inventory_type": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "inventory_type": {"key": "properties.inventoryType", "type": "str"},
        "managed_resource_id": {"key": "properties.managedResourceId", "type": "str"},
        "mo_ref_id": {"key": "properties.moRefId", "type": "str"},
        "mo_name": {"key": "properties.moName", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        managed_resource_id: Optional[str] = None,
        mo_ref_id: Optional[str] = None,
        mo_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
         the resource provider must validate and persist this value.
        :paramtype kind: str
        :keyword managed_resource_id: Gets or sets the tracked resource id corresponding to the
         inventory resource.
        :paramtype managed_resource_id: str
        :keyword mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory
         item.
        :paramtype mo_ref_id: str
        :keyword mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
        :paramtype mo_name: str
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.inventory_type: Optional[str] = None
        self.managed_resource_id = managed_resource_id
        self.mo_ref_id = mo_ref_id
        self.mo_name = mo_name
        self.provisioning_state = None


class InventoryItemDetails(_serialization.Model):
    """Describes the properties of an Inventory Item reference.

    :ivar inventory_item_id: Gets or sets the inventory Item ID for the resource.
    :vartype inventory_item_id: str
    :ivar mo_name: Gets or sets the vCenter Managed Object name for the resource.
    :vartype mo_name: str
    :ivar inventory_type: The inventory type. Known values are: "ResourcePool", "VirtualMachine",
     "VirtualMachineTemplate", "VirtualNetwork", "Cluster", "Datastore", and "Host".
    :vartype inventory_type: str or ~azure.mgmt.connectedvmware.models.InventoryType
    """

    _attribute_map = {
        "inventory_item_id": {"key": "inventoryItemId", "type": "str"},
        "mo_name": {"key": "moName", "type": "str"},
        "inventory_type": {"key": "inventoryType", "type": "str"},
    }

    def __init__(
        self,
        *,
        inventory_item_id: Optional[str] = None,
        mo_name: Optional[str] = None,
        inventory_type: Optional[Union[str, "_models.InventoryType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword inventory_item_id: Gets or sets the inventory Item ID for the resource.
        :paramtype inventory_item_id: str
        :keyword mo_name: Gets or sets the vCenter Managed Object name for the resource.
        :paramtype mo_name: str
        :keyword inventory_type: The inventory type. Known values are: "ResourcePool",
         "VirtualMachine", "VirtualMachineTemplate", "VirtualNetwork", "Cluster", "Datastore", and
         "Host".
        :paramtype inventory_type: str or ~azure.mgmt.connectedvmware.models.InventoryType
        """
        super().__init__(**kwargs)
        self.inventory_item_id = inventory_item_id
        self.mo_name = mo_name
        self.inventory_type = inventory_type


class InventoryItemsList(_serialization.Model):
    """List of InventoryItems.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: Url to follow for getting next page of InventoryItems.
    :vartype next_link: str
    :ivar value: Array of InventoryItems. Required.
    :vartype value: list[~azure.mgmt.connectedvmware.models.InventoryItem]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[InventoryItem]"},
    }

    def __init__(self, *, value: List["_models.InventoryItem"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: Url to follow for getting next page of InventoryItems.
        :paramtype next_link: str
        :keyword value: Array of InventoryItems. Required.
        :paramtype value: list[~azure.mgmt.connectedvmware.models.InventoryItem]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class NetworkInterface(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Network Interface model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Gets or sets the name of the network interface.
    :vartype name: str
    :ivar label: Gets or sets the label of the virtual network in vCenter that the nic is connected
     to.
    :vartype label: str
    :ivar ip_addresses: Gets or sets the nic ip addresses.
    :vartype ip_addresses: list[str]
    :ivar mac_address: Gets or sets the NIC MAC address.
    :vartype mac_address: str
    :ivar network_id: Gets or sets the ARM Id of the network resource to connect the virtual
     machine.
    :vartype network_id: str
    :ivar nic_type: NIC type. Known values are: "vmxnet3", "vmxnet2", "vmxnet", "e1000", "e1000e",
     and "pcnet32".
    :vartype nic_type: str or ~azure.mgmt.connectedvmware.models.NICType
    :ivar power_on_boot: Gets or sets the power on boot. Known values are: "enabled" and
     "disabled".
    :vartype power_on_boot: str or ~azure.mgmt.connectedvmware.models.PowerOnBootOption
    :ivar network_mo_ref_id: Gets or sets the vCenter MoRef (Managed Object Reference) ID of the
     virtual network
     that the nic is connected to.
    :vartype network_mo_ref_id: str
    :ivar network_mo_name: Gets or sets the name of the virtual network in vCenter that the nic is
     connected to.
    :vartype network_mo_name: str
    :ivar device_key: Gets or sets the device key value.
    :vartype device_key: int
    :ivar ip_settings: Gets or sets the ipsettings.
    :vartype ip_settings: ~azure.mgmt.connectedvmware.models.NicIPSettings
    """

    _validation = {
        "label": {"readonly": True},
        "ip_addresses": {"readonly": True},
        "mac_address": {"readonly": True},
        "network_mo_ref_id": {"readonly": True},
        "network_mo_name": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "ip_addresses": {"key": "ipAddresses", "type": "[str]"},
        "mac_address": {"key": "macAddress", "type": "str"},
        "network_id": {"key": "networkId", "type": "str"},
        "nic_type": {"key": "nicType", "type": "str"},
        "power_on_boot": {"key": "powerOnBoot", "type": "str"},
        "network_mo_ref_id": {"key": "networkMoRefId", "type": "str"},
        "network_mo_name": {"key": "networkMoName", "type": "str"},
        "device_key": {"key": "deviceKey", "type": "int"},
        "ip_settings": {"key": "ipSettings", "type": "NicIPSettings"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        network_id: Optional[str] = None,
        nic_type: Optional[Union[str, "_models.NICType"]] = None,
        power_on_boot: Optional[Union[str, "_models.PowerOnBootOption"]] = None,
        device_key: Optional[int] = None,
        ip_settings: Optional["_models.NicIPSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Gets or sets the name of the network interface.
        :paramtype name: str
        :keyword network_id: Gets or sets the ARM Id of the network resource to connect the virtual
         machine.
        :paramtype network_id: str
        :keyword nic_type: NIC type. Known values are: "vmxnet3", "vmxnet2", "vmxnet", "e1000",
         "e1000e", and "pcnet32".
        :paramtype nic_type: str or ~azure.mgmt.connectedvmware.models.NICType
        :keyword power_on_boot: Gets or sets the power on boot. Known values are: "enabled" and
         "disabled".
        :paramtype power_on_boot: str or ~azure.mgmt.connectedvmware.models.PowerOnBootOption
        :keyword device_key: Gets or sets the device key value.
        :paramtype device_key: int
        :keyword ip_settings: Gets or sets the ipsettings.
        :paramtype ip_settings: ~azure.mgmt.connectedvmware.models.NicIPSettings
        """
        super().__init__(**kwargs)
        self.name = name
        self.label = None
        self.ip_addresses = None
        self.mac_address = None
        self.network_id = network_id
        self.nic_type = nic_type
        self.power_on_boot = power_on_boot
        self.network_mo_ref_id = None
        self.network_mo_name = None
        self.device_key = device_key
        self.ip_settings = ip_settings


class NetworkInterfaceUpdate(_serialization.Model):
    """Defines the network interface update.

    :ivar name: Gets or sets the name of the network interface.
    :vartype name: str
    :ivar network_id: Gets or sets the ARM Id of the network resource to connect the virtual
     machine.
    :vartype network_id: str
    :ivar nic_type: NIC type. Known values are: "vmxnet3", "vmxnet2", "vmxnet", "e1000", "e1000e",
     and "pcnet32".
    :vartype nic_type: str or ~azure.mgmt.connectedvmware.models.NICType
    :ivar power_on_boot: Gets or sets the power on boot. Known values are: "enabled" and
     "disabled".
    :vartype power_on_boot: str or ~azure.mgmt.connectedvmware.models.PowerOnBootOption
    :ivar device_key: Gets or sets the device key value.
    :vartype device_key: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "network_id": {"key": "networkId", "type": "str"},
        "nic_type": {"key": "nicType", "type": "str"},
        "power_on_boot": {"key": "powerOnBoot", "type": "str"},
        "device_key": {"key": "deviceKey", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        network_id: Optional[str] = None,
        nic_type: Optional[Union[str, "_models.NICType"]] = None,
        power_on_boot: Optional[Union[str, "_models.PowerOnBootOption"]] = None,
        device_key: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Gets or sets the name of the network interface.
        :paramtype name: str
        :keyword network_id: Gets or sets the ARM Id of the network resource to connect the virtual
         machine.
        :paramtype network_id: str
        :keyword nic_type: NIC type. Known values are: "vmxnet3", "vmxnet2", "vmxnet", "e1000",
         "e1000e", and "pcnet32".
        :paramtype nic_type: str or ~azure.mgmt.connectedvmware.models.NICType
        :keyword power_on_boot: Gets or sets the power on boot. Known values are: "enabled" and
         "disabled".
        :paramtype power_on_boot: str or ~azure.mgmt.connectedvmware.models.PowerOnBootOption
        :keyword device_key: Gets or sets the device key value.
        :paramtype device_key: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.network_id = network_id
        self.nic_type = nic_type
        self.power_on_boot = power_on_boot
        self.device_key = device_key


class NetworkProfile(_serialization.Model):
    """Specifies the network interfaces of the virtual machine.

    :ivar network_interfaces: Gets or sets the list of network interfaces associated with the
     virtual machine.
    :vartype network_interfaces: list[~azure.mgmt.connectedvmware.models.NetworkInterface]
    """

    _attribute_map = {
        "network_interfaces": {"key": "networkInterfaces", "type": "[NetworkInterface]"},
    }

    def __init__(self, *, network_interfaces: Optional[List["_models.NetworkInterface"]] = None, **kwargs: Any) -> None:
        """
        :keyword network_interfaces: Gets or sets the list of network interfaces associated with the
         virtual machine.
        :paramtype network_interfaces: list[~azure.mgmt.connectedvmware.models.NetworkInterface]
        """
        super().__init__(**kwargs)
        self.network_interfaces = network_interfaces


class NetworkProfileUpdate(_serialization.Model):
    """Specifies the network interfaces of the virtual machine.

    :ivar network_interfaces: Gets or sets the list of network interfaces associated with the
     virtual machine.
    :vartype network_interfaces: list[~azure.mgmt.connectedvmware.models.NetworkInterfaceUpdate]
    """

    _attribute_map = {
        "network_interfaces": {"key": "networkInterfaces", "type": "[NetworkInterfaceUpdate]"},
    }

    def __init__(
        self, *, network_interfaces: Optional[List["_models.NetworkInterfaceUpdate"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword network_interfaces: Gets or sets the list of network interfaces associated with the
         virtual machine.
        :paramtype network_interfaces: list[~azure.mgmt.connectedvmware.models.NetworkInterfaceUpdate]
        """
        super().__init__(**kwargs)
        self.network_interfaces = network_interfaces


class NicIPAddressSettings(_serialization.Model):
    """IP address information for a virtual network adapter reported by the fabric.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar allocation_method: Gets the ip address allocation method.
    :vartype allocation_method: str
    :ivar ip_address: Gets the ip address for the nic.
    :vartype ip_address: str
    :ivar subnet_mask: Gets the mask.
    :vartype subnet_mask: str
    """

    _validation = {
        "allocation_method": {"readonly": True},
        "ip_address": {"readonly": True},
        "subnet_mask": {"readonly": True},
    }

    _attribute_map = {
        "allocation_method": {"key": "allocationMethod", "type": "str"},
        "ip_address": {"key": "ipAddress", "type": "str"},
        "subnet_mask": {"key": "subnetMask", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.allocation_method = None
        self.ip_address = None
        self.subnet_mask = None


class NicIPSettings(_serialization.Model):
    """Defines the network interface ip settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar allocation_method: Gets or sets the nic allocation method. Known values are: "unset",
     "dynamic", "static", "linklayer", "random", and "other".
    :vartype allocation_method: str or ~azure.mgmt.connectedvmware.models.IPAddressAllocationMethod
    :ivar dns_servers: Gets or sets the dns servers.
    :vartype dns_servers: list[str]
    :ivar gateway: Gets or sets the gateway.
    :vartype gateway: list[str]
    :ivar ip_address: Gets or sets the ip address for the nic.
    :vartype ip_address: str
    :ivar subnet_mask: Gets or sets the mask.
    :vartype subnet_mask: str
    :ivar primary_wins_server: Gets or sets the primary server.
    :vartype primary_wins_server: str
    :ivar secondary_wins_server: Gets or sets the secondary server.
    :vartype secondary_wins_server: str
    :ivar ip_address_info: Gets or sets the IP address information being reported for this NIC.
     This contains the same IPv4 information above plus IPV6 information.
    :vartype ip_address_info: list[~azure.mgmt.connectedvmware.models.NicIPAddressSettings]
    """

    _validation = {
        "primary_wins_server": {"readonly": True},
        "secondary_wins_server": {"readonly": True},
        "ip_address_info": {"readonly": True},
    }

    _attribute_map = {
        "allocation_method": {"key": "allocationMethod", "type": "str"},
        "dns_servers": {"key": "dnsServers", "type": "[str]"},
        "gateway": {"key": "gateway", "type": "[str]"},
        "ip_address": {"key": "ipAddress", "type": "str"},
        "subnet_mask": {"key": "subnetMask", "type": "str"},
        "primary_wins_server": {"key": "primaryWinsServer", "type": "str"},
        "secondary_wins_server": {"key": "secondaryWinsServer", "type": "str"},
        "ip_address_info": {"key": "ipAddressInfo", "type": "[NicIPAddressSettings]"},
    }

    def __init__(
        self,
        *,
        allocation_method: Optional[Union[str, "_models.IPAddressAllocationMethod"]] = None,
        dns_servers: Optional[List[str]] = None,
        gateway: Optional[List[str]] = None,
        ip_address: Optional[str] = None,
        subnet_mask: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword allocation_method: Gets or sets the nic allocation method. Known values are: "unset",
         "dynamic", "static", "linklayer", "random", and "other".
        :paramtype allocation_method: str or
         ~azure.mgmt.connectedvmware.models.IPAddressAllocationMethod
        :keyword dns_servers: Gets or sets the dns servers.
        :paramtype dns_servers: list[str]
        :keyword gateway: Gets or sets the gateway.
        :paramtype gateway: list[str]
        :keyword ip_address: Gets or sets the ip address for the nic.
        :paramtype ip_address: str
        :keyword subnet_mask: Gets or sets the mask.
        :paramtype subnet_mask: str
        """
        super().__init__(**kwargs)
        self.allocation_method = allocation_method
        self.dns_servers = dns_servers
        self.gateway = gateway
        self.ip_address = ip_address
        self.subnet_mask = subnet_mask
        self.primary_wins_server = None
        self.secondary_wins_server = None
        self.ip_address_info = None


class Operation(_serialization.Model):
    """Operation provided by provider.

    :ivar name: Name of the operation.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is data action or not.
    :vartype is_data_action: bool
    :ivar display: Properties of the operation.
    :vartype display: ~azure.mgmt.connectedvmware.models.OperationDisplay
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["_models.OperationDisplay"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the operation.
        :paramtype name: str
        :keyword is_data_action: Indicates whether the operation is data action or not.
        :paramtype is_data_action: bool
        :keyword display: Properties of the operation.
        :paramtype display: ~azure.mgmt.connectedvmware.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display


class OperationDisplay(_serialization.Model):
    """Properties of the operation.

    :ivar provider: Provider name.
    :vartype provider: str
    :ivar resource: Resource name.
    :vartype resource: str
    :ivar operation: Operation name.
    :vartype operation: str
    :ivar description: Description of the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Provider name.
        :paramtype provider: str
        :keyword resource: Resource name.
        :paramtype resource: str
        :keyword operation: Operation name.
        :paramtype operation: str
        :keyword description: Description of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationsList(_serialization.Model):
    """Lists the operations available.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: Url to follow for getting next page of operations.
    :vartype next_link: str
    :ivar value: Array of operations. Required.
    :vartype value: list[~azure.mgmt.connectedvmware.models.Operation]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Operation]"},
    }

    def __init__(self, *, value: List["_models.Operation"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: Url to follow for getting next page of operations.
        :paramtype next_link: str
        :keyword value: Array of operations. Required.
        :paramtype value: list[~azure.mgmt.connectedvmware.models.Operation]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class OsProfileForVMInstance(_serialization.Model):
    """Specifies the operating system settings for the virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar computer_name: Gets or sets computer name.
    :vartype computer_name: str
    :ivar admin_username: Gets or sets administrator username.
    :vartype admin_username: str
    :ivar admin_password: Sets administrator password.
    :vartype admin_password: str
    :ivar guest_id: Gets or sets the guestId.
    :vartype guest_id: str
    :ivar os_type: Gets or sets the type of the os. Known values are: "Windows", "Linux", and
     "Other".
    :vartype os_type: str or ~azure.mgmt.connectedvmware.models.OsType
    :ivar os_sku: Gets or sets os sku.
    :vartype os_sku: str
    :ivar tools_running_status: Gets or sets the current running status of VMware Tools running in
     the guest operating system.
    :vartype tools_running_status: str
    :ivar tools_version_status: Gets or sets the current version status of VMware Tools installed
     in the guest operating system.
    :vartype tools_version_status: str
    :ivar tools_version: Gets or sets the current version of VMware Tools.
    :vartype tools_version: str
    """

    _validation = {
        "os_sku": {"readonly": True},
        "tools_running_status": {"readonly": True},
        "tools_version_status": {"readonly": True},
        "tools_version": {"readonly": True},
    }

    _attribute_map = {
        "computer_name": {"key": "computerName", "type": "str"},
        "admin_username": {"key": "adminUsername", "type": "str"},
        "admin_password": {"key": "adminPassword", "type": "str"},
        "guest_id": {"key": "guestId", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "os_sku": {"key": "osSku", "type": "str"},
        "tools_running_status": {"key": "toolsRunningStatus", "type": "str"},
        "tools_version_status": {"key": "toolsVersionStatus", "type": "str"},
        "tools_version": {"key": "toolsVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        computer_name: Optional[str] = None,
        admin_username: Optional[str] = None,
        admin_password: Optional[str] = None,
        guest_id: Optional[str] = None,
        os_type: Optional[Union[str, "_models.OsType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword computer_name: Gets or sets computer name.
        :paramtype computer_name: str
        :keyword admin_username: Gets or sets administrator username.
        :paramtype admin_username: str
        :keyword admin_password: Sets administrator password.
        :paramtype admin_password: str
        :keyword guest_id: Gets or sets the guestId.
        :paramtype guest_id: str
        :keyword os_type: Gets or sets the type of the os. Known values are: "Windows", "Linux", and
         "Other".
        :paramtype os_type: str or ~azure.mgmt.connectedvmware.models.OsType
        """
        super().__init__(**kwargs)
        self.computer_name = computer_name
        self.admin_username = admin_username
        self.admin_password = admin_password
        self.guest_id = guest_id
        self.os_type = os_type
        self.os_sku = None
        self.tools_running_status = None
        self.tools_version_status = None
        self.tools_version = None


class PlacementProfile(_serialization.Model):
    """Specifies the compute and storage placement settings for the virtual machine.

    :ivar resource_pool_id: Gets or sets the ARM Id of the resourcePool resource on which this
     virtual machine will deploy.
    :vartype resource_pool_id: str
    :ivar cluster_id: Gets or sets the ARM Id of the cluster resource on which this virtual machine
     will deploy.
    :vartype cluster_id: str
    :ivar host_id: Gets or sets the ARM Id of the host resource on which this virtual machine will
     deploy.
    :vartype host_id: str
    :ivar datastore_id: Gets or sets the ARM Id of the datastore resource on which the data for the
     virtual machine will be kept.
    :vartype datastore_id: str
    """

    _attribute_map = {
        "resource_pool_id": {"key": "resourcePoolId", "type": "str"},
        "cluster_id": {"key": "clusterId", "type": "str"},
        "host_id": {"key": "hostId", "type": "str"},
        "datastore_id": {"key": "datastoreId", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_pool_id: Optional[str] = None,
        cluster_id: Optional[str] = None,
        host_id: Optional[str] = None,
        datastore_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_pool_id: Gets or sets the ARM Id of the resourcePool resource on which this
         virtual machine will deploy.
        :paramtype resource_pool_id: str
        :keyword cluster_id: Gets or sets the ARM Id of the cluster resource on which this virtual
         machine will deploy.
        :paramtype cluster_id: str
        :keyword host_id: Gets or sets the ARM Id of the host resource on which this virtual machine
         will deploy.
        :paramtype host_id: str
        :keyword datastore_id: Gets or sets the ARM Id of the datastore resource on which the data for
         the virtual machine will be kept.
        :paramtype datastore_id: str
        """
        super().__init__(**kwargs)
        self.resource_pool_id = resource_pool_id
        self.cluster_id = cluster_id
        self.host_id = host_id
        self.datastore_id = datastore_id


class ResourcePatch(_serialization.Model):
    """Object containing updates for patch operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class ResourcePool(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Define the resourcePool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Gets or sets the location. Required.
    :vartype location: str
    :ivar extended_location: Gets or sets the extended location.
    :vartype extended_location: ~azure.mgmt.connectedvmware.models.ExtendedLocation
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    :ivar tags: Gets or sets the Resource tags.
    :vartype tags: dict[str, str]
    :ivar name: Gets or sets the name.
    :vartype name: str
    :ivar id: Gets or sets the Id.
    :vartype id: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :vartype kind: str
    :ivar uuid: Gets or sets a unique identifier for this resource.
    :vartype uuid: str
    :ivar v_center_id: Gets or sets the ARM Id of the vCenter resource in which this resource pool
     resides.
    :vartype v_center_id: str
    :ivar mo_ref_id: Gets or sets the vCenter MoRef (Managed Object Reference) ID for the resource
     pool.
    :vartype mo_ref_id: str
    :ivar inventory_item_id: Gets or sets the inventory Item ID for the resource pool.
    :vartype inventory_item_id: str
    :ivar mo_name: Gets or sets the vCenter Managed Object name for the resource pool.
    :vartype mo_name: str
    :ivar cpu_shares_level: Gets or sets CPUSharesLevel which specifies the CPU allocation level
     for this pool.
     This property is used in relative allocation between resource consumers.
    :vartype cpu_shares_level: str
    :ivar cpu_reservation_m_hz: Gets or sets CPUReservationMHz which specifies the CPU size in MHz
     that is guaranteed
     to be available.
    :vartype cpu_reservation_m_hz: int
    :ivar cpu_limit_m_hz: Gets or sets CPULimitMHz which specifies a CPU usage limit in MHz.
     Utilization will not exceed this limit even if there are available resources.
    :vartype cpu_limit_m_hz: int
    :ivar mem_shares_level: Gets or sets CPUSharesLevel which specifies the memory allocation level
     for this pool.
     This property is used in relative allocation between resource consumers.
    :vartype mem_shares_level: str
    :ivar mem_reservation_mb: Gets or sets MemReservationMB which specifies the guaranteed
     available memory in
     megabytes.
    :vartype mem_reservation_mb: int
    :ivar mem_limit_mb: Gets or sets MemLimitMB specifies a memory usage limit in megabytes.
     Utilization will not exceed the specified limit even if there are available resources.
    :vartype mem_limit_mb: int
    :ivar mem_overall_usage_gb: Gets the used physical memory on the pool in GB.
    :vartype mem_overall_usage_gb: int
    :ivar mem_capacity_gb: Gets the total amount of physical memory on the pool in GB.
    :vartype mem_capacity_gb: int
    :ivar cpu_overall_usage_m_hz: Gets the used CPU usage across all cores on the pool in MHz.
    :vartype cpu_overall_usage_m_hz: int
    :ivar cpu_capacity_m_hz: Gets the max CPU usage across all cores on the pool in MHz.
    :vartype cpu_capacity_m_hz: int
    :ivar custom_resource_name: Gets the name of the corresponding resource in Kubernetes.
    :vartype custom_resource_name: str
    :ivar datastore_ids: Gets the datastore ARM ids.
    :vartype datastore_ids: list[str]
    :ivar network_ids: Gets the network ARM ids.
    :vartype network_ids: list[str]
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.connectedvmware.models.ResourceStatus]
    :ivar provisioning_state: Gets the provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Provisioning", "Updating", "Deleting", "Accepted", and "Created".
    :vartype provisioning_state: str or ~azure.mgmt.connectedvmware.models.ProvisioningState
    """

    _validation = {
        "location": {"required": True},
        "system_data": {"readonly": True},
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "uuid": {"readonly": True},
        "mo_name": {"readonly": True},
        "cpu_shares_level": {"readonly": True},
        "cpu_reservation_m_hz": {"readonly": True},
        "cpu_limit_m_hz": {"readonly": True},
        "mem_shares_level": {"readonly": True},
        "mem_reservation_mb": {"readonly": True},
        "mem_limit_mb": {"readonly": True},
        "mem_overall_usage_gb": {"readonly": True},
        "mem_capacity_gb": {"readonly": True},
        "cpu_overall_usage_m_hz": {"readonly": True},
        "cpu_capacity_m_hz": {"readonly": True},
        "custom_resource_name": {"readonly": True},
        "datastore_ids": {"readonly": True},
        "network_ids": {"readonly": True},
        "statuses": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "uuid": {"key": "properties.uuid", "type": "str"},
        "v_center_id": {"key": "properties.vCenterId", "type": "str"},
        "mo_ref_id": {"key": "properties.moRefId", "type": "str"},
        "inventory_item_id": {"key": "properties.inventoryItemId", "type": "str"},
        "mo_name": {"key": "properties.moName", "type": "str"},
        "cpu_shares_level": {"key": "properties.cpuSharesLevel", "type": "str"},
        "cpu_reservation_m_hz": {"key": "properties.cpuReservationMHz", "type": "int"},
        "cpu_limit_m_hz": {"key": "properties.cpuLimitMHz", "type": "int"},
        "mem_shares_level": {"key": "properties.memSharesLevel", "type": "str"},
        "mem_reservation_mb": {"key": "properties.memReservationMB", "type": "int"},
        "mem_limit_mb": {"key": "properties.memLimitMB", "type": "int"},
        "mem_overall_usage_gb": {"key": "properties.memOverallUsageGB", "type": "int"},
        "mem_capacity_gb": {"key": "properties.memCapacityGB", "type": "int"},
        "cpu_overall_usage_m_hz": {"key": "properties.cpuOverallUsageMHz", "type": "int"},
        "cpu_capacity_m_hz": {"key": "properties.cpuCapacityMHz", "type": "int"},
        "custom_resource_name": {"key": "properties.customResourceName", "type": "str"},
        "datastore_ids": {"key": "properties.datastoreIds", "type": "[str]"},
        "network_ids": {"key": "properties.networkIds", "type": "[str]"},
        "statuses": {"key": "properties.statuses", "type": "[ResourceStatus]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        tags: Optional[Dict[str, str]] = None,
        kind: Optional[str] = None,
        v_center_id: Optional[str] = None,
        mo_ref_id: Optional[str] = None,
        inventory_item_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Gets or sets the location. Required.
        :paramtype location: str
        :keyword extended_location: Gets or sets the extended location.
        :paramtype extended_location: ~azure.mgmt.connectedvmware.models.ExtendedLocation
        :keyword tags: Gets or sets the Resource tags.
        :paramtype tags: dict[str, str]
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
         the resource provider must validate and persist this value.
        :paramtype kind: str
        :keyword v_center_id: Gets or sets the ARM Id of the vCenter resource in which this resource
         pool resides.
        :paramtype v_center_id: str
        :keyword mo_ref_id: Gets or sets the vCenter MoRef (Managed Object Reference) ID for the
         resource pool.
        :paramtype mo_ref_id: str
        :keyword inventory_item_id: Gets or sets the inventory Item ID for the resource pool.
        :paramtype inventory_item_id: str
        """
        super().__init__(**kwargs)
        self.location = location
        self.extended_location = extended_location
        self.system_data = None
        self.tags = tags
        self.name = None
        self.id = None
        self.type = None
        self.kind = kind
        self.uuid = None
        self.v_center_id = v_center_id
        self.mo_ref_id = mo_ref_id
        self.inventory_item_id = inventory_item_id
        self.mo_name = None
        self.cpu_shares_level = None
        self.cpu_reservation_m_hz = None
        self.cpu_limit_m_hz = None
        self.mem_shares_level = None
        self.mem_reservation_mb = None
        self.mem_limit_mb = None
        self.mem_overall_usage_gb = None
        self.mem_capacity_gb = None
        self.cpu_overall_usage_m_hz = None
        self.cpu_capacity_m_hz = None
        self.custom_resource_name = None
        self.datastore_ids = None
        self.network_ids = None
        self.statuses = None
        self.provisioning_state = None


class ResourcePoolInventoryItem(InventoryItemProperties):
    """The resource pool inventory item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar inventory_type: They inventory type. Required. Known values are: "ResourcePool",
     "VirtualMachine", "VirtualMachineTemplate", "VirtualNetwork", "Cluster", "Datastore", and
     "Host".
    :vartype inventory_type: str or ~azure.mgmt.connectedvmware.models.InventoryType
    :ivar managed_resource_id: Gets or sets the tracked resource id corresponding to the inventory
     resource.
    :vartype managed_resource_id: str
    :ivar mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
    :vartype mo_ref_id: str
    :ivar mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
    :vartype mo_name: str
    :ivar provisioning_state: Gets the provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Provisioning", "Updating", "Deleting", "Accepted", and "Created".
    :vartype provisioning_state: str or ~azure.mgmt.connectedvmware.models.ProvisioningState
    :ivar parent: Parent resourcePool inventory resource details.
    :vartype parent: ~azure.mgmt.connectedvmware.models.InventoryItemDetails
    """

    _validation = {
        "inventory_type": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "inventory_type": {"key": "inventoryType", "type": "str"},
        "managed_resource_id": {"key": "managedResourceId", "type": "str"},
        "mo_ref_id": {"key": "moRefId", "type": "str"},
        "mo_name": {"key": "moName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "parent": {"key": "parent", "type": "InventoryItemDetails"},
    }

    def __init__(
        self,
        *,
        managed_resource_id: Optional[str] = None,
        mo_ref_id: Optional[str] = None,
        mo_name: Optional[str] = None,
        parent: Optional["_models.InventoryItemDetails"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword managed_resource_id: Gets or sets the tracked resource id corresponding to the
         inventory resource.
        :paramtype managed_resource_id: str
        :keyword mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory
         item.
        :paramtype mo_ref_id: str
        :keyword mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
        :paramtype mo_name: str
        :keyword parent: Parent resourcePool inventory resource details.
        :paramtype parent: ~azure.mgmt.connectedvmware.models.InventoryItemDetails
        """
        super().__init__(managed_resource_id=managed_resource_id, mo_ref_id=mo_ref_id, mo_name=mo_name, **kwargs)
        self.inventory_type: str = "ResourcePool"
        self.parent = parent


class ResourcePoolsList(_serialization.Model):
    """List of ResourcePools.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: Url to follow for getting next page of ResourcePools.
    :vartype next_link: str
    :ivar value: Array of ResourcePools. Required.
    :vartype value: list[~azure.mgmt.connectedvmware.models.ResourcePool]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ResourcePool]"},
    }

    def __init__(self, *, value: List["_models.ResourcePool"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: Url to follow for getting next page of ResourcePools.
        :paramtype next_link: str
        :keyword value: Array of ResourcePools. Required.
        :paramtype value: list[~azure.mgmt.connectedvmware.models.ResourcePool]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ResourceStatus(_serialization.Model):
    """The resource status information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the condition.
    :vartype type: str
    :ivar status: Status of the condition.
    :vartype status: str
    :ivar reason: The reason for the condition's status.
    :vartype reason: str
    :ivar message: A human readable message indicating details about the status.
    :vartype message: str
    :ivar severity: Severity with which to treat failures of this type of condition.
    :vartype severity: str
    :ivar last_updated_at: The last update time for this condition.
    :vartype last_updated_at: ~datetime.datetime
    """

    _validation = {
        "type": {"readonly": True},
        "status": {"readonly": True},
        "reason": {"readonly": True},
        "message": {"readonly": True},
        "severity": {"readonly": True},
        "last_updated_at": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "last_updated_at": {"key": "lastUpdatedAt", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.status = None
        self.reason = None
        self.message = None
        self.severity = None
        self.last_updated_at = None


class SecurityProfile(_serialization.Model):
    """Specifies the Security profile settings for the virtual machine.

    :ivar uefi_settings: Specifies the security settings like secure boot used while creating the
     virtual machine.
    :vartype uefi_settings: ~azure.mgmt.connectedvmware.models.UefiSettings
    """

    _attribute_map = {
        "uefi_settings": {"key": "uefiSettings", "type": "UefiSettings"},
    }

    def __init__(self, *, uefi_settings: Optional["_models.UefiSettings"] = None, **kwargs: Any) -> None:
        """
        :keyword uefi_settings: Specifies the security settings like secure boot used while creating
         the virtual machine.
        :paramtype uefi_settings: ~azure.mgmt.connectedvmware.models.UefiSettings
        """
        super().__init__(**kwargs)
        self.uefi_settings = uefi_settings


class StopVirtualMachineOptions(_serialization.Model):
    """Defines the stop action properties.

    :ivar skip_shutdown: Gets or sets a value indicating whether to request non-graceful VM
     shutdown. True value for this flag indicates non-graceful shutdown whereas false indicates
     otherwise. Defaults to false.
    :vartype skip_shutdown: bool
    """

    _attribute_map = {
        "skip_shutdown": {"key": "skipShutdown", "type": "bool"},
    }

    def __init__(self, *, skip_shutdown: bool = False, **kwargs: Any) -> None:
        """
        :keyword skip_shutdown: Gets or sets a value indicating whether to request non-graceful VM
         shutdown. True value for this flag indicates non-graceful shutdown whereas false indicates
         otherwise. Defaults to false.
        :paramtype skip_shutdown: bool
        """
        super().__init__(**kwargs)
        self.skip_shutdown = skip_shutdown


class StorageProfile(_serialization.Model):
    """Specifies the storage settings for the virtual machine disks.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar disks: Gets or sets the list of virtual disks associated with the virtual machine.
    :vartype disks: list[~azure.mgmt.connectedvmware.models.VirtualDisk]
    :ivar scsi_controllers: Gets or sets the list of virtual SCSI controllers associated with the
     virtual machine.
    :vartype scsi_controllers: list[~azure.mgmt.connectedvmware.models.VirtualSCSIController]
    """

    _validation = {
        "scsi_controllers": {"readonly": True},
    }

    _attribute_map = {
        "disks": {"key": "disks", "type": "[VirtualDisk]"},
        "scsi_controllers": {"key": "scsiControllers", "type": "[VirtualSCSIController]"},
    }

    def __init__(self, *, disks: Optional[List["_models.VirtualDisk"]] = None, **kwargs: Any) -> None:
        """
        :keyword disks: Gets or sets the list of virtual disks associated with the virtual machine.
        :paramtype disks: list[~azure.mgmt.connectedvmware.models.VirtualDisk]
        """
        super().__init__(**kwargs)
        self.disks = disks
        self.scsi_controllers = None


class StorageProfileUpdate(_serialization.Model):
    """Specifies the storage settings for the virtual machine disks.

    :ivar disks: Gets or sets the list of virtual disks associated with the virtual machine.
    :vartype disks: list[~azure.mgmt.connectedvmware.models.VirtualDiskUpdate]
    """

    _attribute_map = {
        "disks": {"key": "disks", "type": "[VirtualDiskUpdate]"},
    }

    def __init__(self, *, disks: Optional[List["_models.VirtualDiskUpdate"]] = None, **kwargs: Any) -> None:
        """
        :keyword disks: Gets or sets the list of virtual disks associated with the virtual machine.
        :paramtype disks: list[~azure.mgmt.connectedvmware.models.VirtualDiskUpdate]
        """
        super().__init__(**kwargs)
        self.disks = disks


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.connectedvmware.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.connectedvmware.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.connectedvmware.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.connectedvmware.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UefiSettings(_serialization.Model):
    """Specifies the security settings like secure boot used while creating the virtual machine.

    :ivar secure_boot_enabled: Specifies whether secure boot should be enabled on the virtual
     machine.
    :vartype secure_boot_enabled: bool
    """

    _attribute_map = {
        "secure_boot_enabled": {"key": "secureBootEnabled", "type": "bool"},
    }

    def __init__(self, *, secure_boot_enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword secure_boot_enabled: Specifies whether secure boot should be enabled on the virtual
         machine.
        :paramtype secure_boot_enabled: bool
        """
        super().__init__(**kwargs)
        self.secure_boot_enabled = secure_boot_enabled


class VCenter(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Defines the vCenter.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Gets or sets the location. Required.
    :vartype location: str
    :ivar extended_location: Gets or sets the extended location.
    :vartype extended_location: ~azure.mgmt.connectedvmware.models.ExtendedLocation
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    :ivar tags: Gets or sets the Resource tags.
    :vartype tags: dict[str, str]
    :ivar name: Gets or sets the name.
    :vartype name: str
    :ivar id: Gets or sets the Id.
    :vartype id: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :vartype kind: str
    :ivar uuid: Gets or sets a unique identifier for this resource.
    :vartype uuid: str
    :ivar fqdn: Gets or sets the FQDN/IPAddress of the vCenter. Required.
    :vartype fqdn: str
    :ivar port: Gets or sets the port of the vCenter.
    :vartype port: int
    :ivar version: Gets or sets the version of the vCenter.
    :vartype version: str
    :ivar instance_uuid: Gets or sets the instance UUID of the vCenter.
    :vartype instance_uuid: str
    :ivar connection_status: Gets or sets the connection status to the vCenter.
    :vartype connection_status: str
    :ivar custom_resource_name: Gets the name of the corresponding resource in Kubernetes.
    :vartype custom_resource_name: str
    :ivar credentials: Username / Password Credentials to connect to vcenter.
    :vartype credentials: ~azure.mgmt.connectedvmware.models.VICredential
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.connectedvmware.models.ResourceStatus]
    :ivar provisioning_state: Gets the provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Provisioning", "Updating", "Deleting", "Accepted", and "Created".
    :vartype provisioning_state: str or ~azure.mgmt.connectedvmware.models.ProvisioningState
    """

    _validation = {
        "location": {"required": True},
        "system_data": {"readonly": True},
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "uuid": {"readonly": True},
        "fqdn": {"required": True},
        "port": {"maximum": 65535, "minimum": 1},
        "version": {"readonly": True},
        "instance_uuid": {"readonly": True},
        "connection_status": {"readonly": True},
        "custom_resource_name": {"readonly": True},
        "statuses": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "uuid": {"key": "properties.uuid", "type": "str"},
        "fqdn": {"key": "properties.fqdn", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "version": {"key": "properties.version", "type": "str"},
        "instance_uuid": {"key": "properties.instanceUuid", "type": "str"},
        "connection_status": {"key": "properties.connectionStatus", "type": "str"},
        "custom_resource_name": {"key": "properties.customResourceName", "type": "str"},
        "credentials": {"key": "properties.credentials", "type": "VICredential"},
        "statuses": {"key": "properties.statuses", "type": "[ResourceStatus]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        fqdn: str,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        tags: Optional[Dict[str, str]] = None,
        kind: Optional[str] = None,
        port: Optional[int] = None,
        credentials: Optional["_models.VICredential"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Gets or sets the location. Required.
        :paramtype location: str
        :keyword extended_location: Gets or sets the extended location.
        :paramtype extended_location: ~azure.mgmt.connectedvmware.models.ExtendedLocation
        :keyword tags: Gets or sets the Resource tags.
        :paramtype tags: dict[str, str]
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
         the resource provider must validate and persist this value.
        :paramtype kind: str
        :keyword fqdn: Gets or sets the FQDN/IPAddress of the vCenter. Required.
        :paramtype fqdn: str
        :keyword port: Gets or sets the port of the vCenter.
        :paramtype port: int
        :keyword credentials: Username / Password Credentials to connect to vcenter.
        :paramtype credentials: ~azure.mgmt.connectedvmware.models.VICredential
        """
        super().__init__(**kwargs)
        self.location = location
        self.extended_location = extended_location
        self.system_data = None
        self.tags = tags
        self.name = None
        self.id = None
        self.type = None
        self.kind = kind
        self.uuid = None
        self.fqdn = fqdn
        self.port = port
        self.version = None
        self.instance_uuid = None
        self.connection_status = None
        self.custom_resource_name = None
        self.credentials = credentials
        self.statuses = None
        self.provisioning_state = None


class VCentersList(_serialization.Model):
    """List of VCenters.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: Url to follow for getting next page of VCenters.
    :vartype next_link: str
    :ivar value: Array of VCenters. Required.
    :vartype value: list[~azure.mgmt.connectedvmware.models.VCenter]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[VCenter]"},
    }

    def __init__(self, *, value: List["_models.VCenter"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: Url to follow for getting next page of VCenters.
        :paramtype next_link: str
        :keyword value: Array of VCenters. Required.
        :paramtype value: list[~azure.mgmt.connectedvmware.models.VCenter]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class VICredential(_serialization.Model):
    """Username / Password Credentials to connect to vcenter.

    :ivar username: Gets or sets username to connect with the vCenter.
    :vartype username: str
    :ivar password: Gets or sets the password to connect with the vCenter.
    :vartype password: str
    """

    _attribute_map = {
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
    }

    def __init__(self, *, username: Optional[str] = None, password: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword username: Gets or sets username to connect with the vCenter.
        :paramtype username: str
        :keyword password: Gets or sets the password to connect with the vCenter.
        :paramtype password: str
        """
        super().__init__(**kwargs)
        self.username = username
        self.password = password


class VirtualDisk(_serialization.Model):
    """Virtual disk model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Gets or sets the name of the virtual disk.
    :vartype name: str
    :ivar label: Gets or sets the label of the virtual disk in vCenter.
    :vartype label: str
    :ivar disk_object_id: Gets or sets the disk object id.
    :vartype disk_object_id: str
    :ivar disk_size_gb: Gets or sets the disk total size.
    :vartype disk_size_gb: int
    :ivar device_key: Gets or sets the device key value.
    :vartype device_key: int
    :ivar disk_mode: Gets or sets the disk mode. Known values are: "persistent",
     "independent_persistent", and "independent_nonpersistent".
    :vartype disk_mode: str or ~azure.mgmt.connectedvmware.models.DiskMode
    :ivar controller_key: Gets or sets the controller id.
    :vartype controller_key: int
    :ivar unit_number: Gets or sets the unit number of the disk on the controller.
    :vartype unit_number: int
    :ivar device_name: Gets or sets the device name.
    :vartype device_name: str
    :ivar disk_type: Gets or sets the disk backing type. Known values are: "flat", "pmem",
     "rawphysical", "rawvirtual", "sparse", "sesparse", and "unknown".
    :vartype disk_type: str or ~azure.mgmt.connectedvmware.models.DiskType
    """

    _validation = {
        "label": {"readonly": True},
        "disk_object_id": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "disk_object_id": {"key": "diskObjectId", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "device_key": {"key": "deviceKey", "type": "int"},
        "disk_mode": {"key": "diskMode", "type": "str"},
        "controller_key": {"key": "controllerKey", "type": "int"},
        "unit_number": {"key": "unitNumber", "type": "int"},
        "device_name": {"key": "deviceName", "type": "str"},
        "disk_type": {"key": "diskType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        disk_size_gb: Optional[int] = None,
        device_key: Optional[int] = None,
        disk_mode: Optional[Union[str, "_models.DiskMode"]] = None,
        controller_key: Optional[int] = None,
        unit_number: Optional[int] = None,
        device_name: Optional[str] = None,
        disk_type: Optional[Union[str, "_models.DiskType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Gets or sets the name of the virtual disk.
        :paramtype name: str
        :keyword disk_size_gb: Gets or sets the disk total size.
        :paramtype disk_size_gb: int
        :keyword device_key: Gets or sets the device key value.
        :paramtype device_key: int
        :keyword disk_mode: Gets or sets the disk mode. Known values are: "persistent",
         "independent_persistent", and "independent_nonpersistent".
        :paramtype disk_mode: str or ~azure.mgmt.connectedvmware.models.DiskMode
        :keyword controller_key: Gets or sets the controller id.
        :paramtype controller_key: int
        :keyword unit_number: Gets or sets the unit number of the disk on the controller.
        :paramtype unit_number: int
        :keyword device_name: Gets or sets the device name.
        :paramtype device_name: str
        :keyword disk_type: Gets or sets the disk backing type. Known values are: "flat", "pmem",
         "rawphysical", "rawvirtual", "sparse", "sesparse", and "unknown".
        :paramtype disk_type: str or ~azure.mgmt.connectedvmware.models.DiskType
        """
        super().__init__(**kwargs)
        self.name = name
        self.label = None
        self.disk_object_id = None
        self.disk_size_gb = disk_size_gb
        self.device_key = device_key
        self.disk_mode = disk_mode
        self.controller_key = controller_key
        self.unit_number = unit_number
        self.device_name = device_name
        self.disk_type = disk_type


class VirtualDiskUpdate(_serialization.Model):
    """Defines the virtual disk update.

    :ivar name: Gets or sets the name of the virtual disk.
    :vartype name: str
    :ivar disk_size_gb: Gets or sets the disk total size.
    :vartype disk_size_gb: int
    :ivar device_key: Gets or sets the device key value.
    :vartype device_key: int
    :ivar disk_mode: Gets or sets the disk mode. Known values are: "persistent",
     "independent_persistent", and "independent_nonpersistent".
    :vartype disk_mode: str or ~azure.mgmt.connectedvmware.models.DiskMode
    :ivar controller_key: Gets or sets the controller id.
    :vartype controller_key: int
    :ivar unit_number: Gets or sets the unit number of the disk on the controller.
    :vartype unit_number: int
    :ivar device_name: Gets or sets the device name.
    :vartype device_name: str
    :ivar disk_type: Gets or sets the disk backing type. Known values are: "flat", "pmem",
     "rawphysical", "rawvirtual", "sparse", "sesparse", and "unknown".
    :vartype disk_type: str or ~azure.mgmt.connectedvmware.models.DiskType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "device_key": {"key": "deviceKey", "type": "int"},
        "disk_mode": {"key": "diskMode", "type": "str"},
        "controller_key": {"key": "controllerKey", "type": "int"},
        "unit_number": {"key": "unitNumber", "type": "int"},
        "device_name": {"key": "deviceName", "type": "str"},
        "disk_type": {"key": "diskType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        disk_size_gb: Optional[int] = None,
        device_key: Optional[int] = None,
        disk_mode: Optional[Union[str, "_models.DiskMode"]] = None,
        controller_key: Optional[int] = None,
        unit_number: Optional[int] = None,
        device_name: Optional[str] = None,
        disk_type: Optional[Union[str, "_models.DiskType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Gets or sets the name of the virtual disk.
        :paramtype name: str
        :keyword disk_size_gb: Gets or sets the disk total size.
        :paramtype disk_size_gb: int
        :keyword device_key: Gets or sets the device key value.
        :paramtype device_key: int
        :keyword disk_mode: Gets or sets the disk mode. Known values are: "persistent",
         "independent_persistent", and "independent_nonpersistent".
        :paramtype disk_mode: str or ~azure.mgmt.connectedvmware.models.DiskMode
        :keyword controller_key: Gets or sets the controller id.
        :paramtype controller_key: int
        :keyword unit_number: Gets or sets the unit number of the disk on the controller.
        :paramtype unit_number: int
        :keyword device_name: Gets or sets the device name.
        :paramtype device_name: str
        :keyword disk_type: Gets or sets the disk backing type. Known values are: "flat", "pmem",
         "rawphysical", "rawvirtual", "sparse", "sesparse", and "unknown".
        :paramtype disk_type: str or ~azure.mgmt.connectedvmware.models.DiskType
        """
        super().__init__(**kwargs)
        self.name = name
        self.disk_size_gb = disk_size_gb
        self.device_key = device_key
        self.disk_mode = disk_mode
        self.controller_key = controller_key
        self.unit_number = unit_number
        self.device_name = device_name
        self.disk_type = disk_type


class VirtualMachineInstance(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Define the virtualMachineInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    :ivar extended_location: Gets or sets the extended location.
    :vartype extended_location: ~azure.mgmt.connectedvmware.models.ExtendedLocation
    :ivar placement_profile: Placement properties.
    :vartype placement_profile: ~azure.mgmt.connectedvmware.models.PlacementProfile
    :ivar os_profile: OS properties.
    :vartype os_profile: ~azure.mgmt.connectedvmware.models.OsProfileForVMInstance
    :ivar hardware_profile: Hardware properties.
    :vartype hardware_profile: ~azure.mgmt.connectedvmware.models.HardwareProfile
    :ivar network_profile: Network properties.
    :vartype network_profile: ~azure.mgmt.connectedvmware.models.NetworkProfile
    :ivar storage_profile: Storage properties.
    :vartype storage_profile: ~azure.mgmt.connectedvmware.models.StorageProfile
    :ivar security_profile: Gets the security profile.
    :vartype security_profile: ~azure.mgmt.connectedvmware.models.SecurityProfile
    :ivar infrastructure_profile: Gets the infrastructure profile.
    :vartype infrastructure_profile: ~azure.mgmt.connectedvmware.models.InfrastructureProfile
    :ivar power_state: Gets the power state of the virtual machine.
    :vartype power_state: str
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.connectedvmware.models.ResourceStatus]
    :ivar provisioning_state: Gets the provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Provisioning", "Updating", "Deleting", "Accepted", and "Created".
    :vartype provisioning_state: str or ~azure.mgmt.connectedvmware.models.ProvisioningState
    :ivar resource_uid: Gets or sets a unique identifier for the vm resource.
    :vartype resource_uid: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "power_state": {"readonly": True},
        "statuses": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "resource_uid": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "placement_profile": {"key": "properties.placementProfile", "type": "PlacementProfile"},
        "os_profile": {"key": "properties.osProfile", "type": "OsProfileForVMInstance"},
        "hardware_profile": {"key": "properties.hardwareProfile", "type": "HardwareProfile"},
        "network_profile": {"key": "properties.networkProfile", "type": "NetworkProfile"},
        "storage_profile": {"key": "properties.storageProfile", "type": "StorageProfile"},
        "security_profile": {"key": "properties.securityProfile", "type": "SecurityProfile"},
        "infrastructure_profile": {"key": "properties.infrastructureProfile", "type": "InfrastructureProfile"},
        "power_state": {"key": "properties.powerState", "type": "str"},
        "statuses": {"key": "properties.statuses", "type": "[ResourceStatus]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_uid": {"key": "properties.resourceUid", "type": "str"},
    }

    def __init__(
        self,
        *,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        placement_profile: Optional["_models.PlacementProfile"] = None,
        os_profile: Optional["_models.OsProfileForVMInstance"] = None,
        hardware_profile: Optional["_models.HardwareProfile"] = None,
        network_profile: Optional["_models.NetworkProfile"] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        security_profile: Optional["_models.SecurityProfile"] = None,
        infrastructure_profile: Optional["_models.InfrastructureProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword extended_location: Gets or sets the extended location.
        :paramtype extended_location: ~azure.mgmt.connectedvmware.models.ExtendedLocation
        :keyword placement_profile: Placement properties.
        :paramtype placement_profile: ~azure.mgmt.connectedvmware.models.PlacementProfile
        :keyword os_profile: OS properties.
        :paramtype os_profile: ~azure.mgmt.connectedvmware.models.OsProfileForVMInstance
        :keyword hardware_profile: Hardware properties.
        :paramtype hardware_profile: ~azure.mgmt.connectedvmware.models.HardwareProfile
        :keyword network_profile: Network properties.
        :paramtype network_profile: ~azure.mgmt.connectedvmware.models.NetworkProfile
        :keyword storage_profile: Storage properties.
        :paramtype storage_profile: ~azure.mgmt.connectedvmware.models.StorageProfile
        :keyword security_profile: Gets the security profile.
        :paramtype security_profile: ~azure.mgmt.connectedvmware.models.SecurityProfile
        :keyword infrastructure_profile: Gets the infrastructure profile.
        :paramtype infrastructure_profile: ~azure.mgmt.connectedvmware.models.InfrastructureProfile
        """
        super().__init__(**kwargs)
        self.extended_location = extended_location
        self.placement_profile = placement_profile
        self.os_profile = os_profile
        self.hardware_profile = hardware_profile
        self.network_profile = network_profile
        self.storage_profile = storage_profile
        self.security_profile = security_profile
        self.infrastructure_profile = infrastructure_profile
        self.power_state = None
        self.statuses = None
        self.provisioning_state = None
        self.resource_uid = None


class VirtualMachineInstancesList(_serialization.Model):
    """List of VirtualMachineInstances.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: Url to follow for getting next page of VirtualMachines.
    :vartype next_link: str
    :ivar value: Array of VirtualMachines. Required.
    :vartype value: list[~azure.mgmt.connectedvmware.models.VirtualMachineInstance]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[VirtualMachineInstance]"},
    }

    def __init__(
        self, *, value: List["_models.VirtualMachineInstance"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: Url to follow for getting next page of VirtualMachines.
        :paramtype next_link: str
        :keyword value: Array of VirtualMachines. Required.
        :paramtype value: list[~azure.mgmt.connectedvmware.models.VirtualMachineInstance]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class VirtualMachineInstanceUpdate(_serialization.Model):
    """Defines the virtualMachineInstanceUpdate.

    :ivar hardware_profile: Specifies the hardware settings for the virtual machine.
    :vartype hardware_profile: ~azure.mgmt.connectedvmware.models.HardwareProfile
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.connectedvmware.models.StorageProfileUpdate
    :ivar network_profile: Specifies the network interfaces of the virtual machine.
    :vartype network_profile: ~azure.mgmt.connectedvmware.models.NetworkProfileUpdate
    """

    _attribute_map = {
        "hardware_profile": {"key": "properties.hardwareProfile", "type": "HardwareProfile"},
        "storage_profile": {"key": "properties.storageProfile", "type": "StorageProfileUpdate"},
        "network_profile": {"key": "properties.networkProfile", "type": "NetworkProfileUpdate"},
    }

    def __init__(
        self,
        *,
        hardware_profile: Optional["_models.HardwareProfile"] = None,
        storage_profile: Optional["_models.StorageProfileUpdate"] = None,
        network_profile: Optional["_models.NetworkProfileUpdate"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword hardware_profile: Specifies the hardware settings for the virtual machine.
        :paramtype hardware_profile: ~azure.mgmt.connectedvmware.models.HardwareProfile
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile: ~azure.mgmt.connectedvmware.models.StorageProfileUpdate
        :keyword network_profile: Specifies the network interfaces of the virtual machine.
        :paramtype network_profile: ~azure.mgmt.connectedvmware.models.NetworkProfileUpdate
        """
        super().__init__(**kwargs)
        self.hardware_profile = hardware_profile
        self.storage_profile = storage_profile
        self.network_profile = network_profile


class VirtualMachineInventoryItem(InventoryItemProperties):  # pylint: disable=too-many-instance-attributes
    """The VM inventory item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar inventory_type: They inventory type. Required. Known values are: "ResourcePool",
     "VirtualMachine", "VirtualMachineTemplate", "VirtualNetwork", "Cluster", "Datastore", and
     "Host".
    :vartype inventory_type: str or ~azure.mgmt.connectedvmware.models.InventoryType
    :ivar managed_resource_id: Gets or sets the tracked resource id corresponding to the inventory
     resource.
    :vartype managed_resource_id: str
    :ivar mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
    :vartype mo_ref_id: str
    :ivar mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
    :vartype mo_name: str
    :ivar provisioning_state: Gets the provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Provisioning", "Updating", "Deleting", "Accepted", and "Created".
    :vartype provisioning_state: str or ~azure.mgmt.connectedvmware.models.ProvisioningState
    :ivar os_type: Gets or sets the type of the os. Known values are: "Windows", "Linux", and
     "Other".
    :vartype os_type: str or ~azure.mgmt.connectedvmware.models.OsType
    :ivar os_name: Gets or sets os name.
    :vartype os_name: str
    :ivar ip_addresses: Gets or sets the nic ip addresses.
    :vartype ip_addresses: list[str]
    :ivar folder_path: Gets or sets the folder path of the vm.
    :vartype folder_path: str
    :ivar host: Host inventory resource details.
    :vartype host: ~azure.mgmt.connectedvmware.models.InventoryItemDetails
    :ivar resource_pool: ResourcePool inventory resource details.
    :vartype resource_pool: ~azure.mgmt.connectedvmware.models.InventoryItemDetails
    :ivar cluster: Cluster inventory resource details.
    :vartype cluster: ~azure.mgmt.connectedvmware.models.InventoryItemDetails
    :ivar instance_uuid: Gets or sets the instance uuid of the vm.
    :vartype instance_uuid: str
    :ivar smbios_uuid: Gets or sets the SMBIOS UUID of the vm.
    :vartype smbios_uuid: str
    :ivar power_state: Gets the power state of the virtual machine.
    :vartype power_state: str
    :ivar tools_running_status: Gets or sets the current running status of VMware Tools running in
     the guest operating system.
    :vartype tools_running_status: str
    :ivar tools_version_status: Gets or sets the current version status of VMware Tools installed
     in the guest operating system.
    :vartype tools_version_status: str
    :ivar tools_version: Gets or sets the current version of VMware Tools.
    :vartype tools_version: str
    """

    _validation = {
        "inventory_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "power_state": {"readonly": True},
        "tools_running_status": {"readonly": True},
        "tools_version_status": {"readonly": True},
        "tools_version": {"readonly": True},
    }

    _attribute_map = {
        "inventory_type": {"key": "inventoryType", "type": "str"},
        "managed_resource_id": {"key": "managedResourceId", "type": "str"},
        "mo_ref_id": {"key": "moRefId", "type": "str"},
        "mo_name": {"key": "moName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "os_name": {"key": "osName", "type": "str"},
        "ip_addresses": {"key": "ipAddresses", "type": "[str]"},
        "folder_path": {"key": "folderPath", "type": "str"},
        "host": {"key": "host", "type": "InventoryItemDetails"},
        "resource_pool": {"key": "resourcePool", "type": "InventoryItemDetails"},
        "cluster": {"key": "cluster", "type": "InventoryItemDetails"},
        "instance_uuid": {"key": "instanceUuid", "type": "str"},
        "smbios_uuid": {"key": "smbiosUuid", "type": "str"},
        "power_state": {"key": "powerState", "type": "str"},
        "tools_running_status": {"key": "toolsRunningStatus", "type": "str"},
        "tools_version_status": {"key": "toolsVersionStatus", "type": "str"},
        "tools_version": {"key": "toolsVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        managed_resource_id: Optional[str] = None,
        mo_ref_id: Optional[str] = None,
        mo_name: Optional[str] = None,
        os_type: Optional[Union[str, "_models.OsType"]] = None,
        os_name: Optional[str] = None,
        ip_addresses: Optional[List[str]] = None,
        folder_path: Optional[str] = None,
        host: Optional["_models.InventoryItemDetails"] = None,
        resource_pool: Optional["_models.InventoryItemDetails"] = None,
        cluster: Optional["_models.InventoryItemDetails"] = None,
        instance_uuid: Optional[str] = None,
        smbios_uuid: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword managed_resource_id: Gets or sets the tracked resource id corresponding to the
         inventory resource.
        :paramtype managed_resource_id: str
        :keyword mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory
         item.
        :paramtype mo_ref_id: str
        :keyword mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
        :paramtype mo_name: str
        :keyword os_type: Gets or sets the type of the os. Known values are: "Windows", "Linux", and
         "Other".
        :paramtype os_type: str or ~azure.mgmt.connectedvmware.models.OsType
        :keyword os_name: Gets or sets os name.
        :paramtype os_name: str
        :keyword ip_addresses: Gets or sets the nic ip addresses.
        :paramtype ip_addresses: list[str]
        :keyword folder_path: Gets or sets the folder path of the vm.
        :paramtype folder_path: str
        :keyword host: Host inventory resource details.
        :paramtype host: ~azure.mgmt.connectedvmware.models.InventoryItemDetails
        :keyword resource_pool: ResourcePool inventory resource details.
        :paramtype resource_pool: ~azure.mgmt.connectedvmware.models.InventoryItemDetails
        :keyword cluster: Cluster inventory resource details.
        :paramtype cluster: ~azure.mgmt.connectedvmware.models.InventoryItemDetails
        :keyword instance_uuid: Gets or sets the instance uuid of the vm.
        :paramtype instance_uuid: str
        :keyword smbios_uuid: Gets or sets the SMBIOS UUID of the vm.
        :paramtype smbios_uuid: str
        """
        super().__init__(managed_resource_id=managed_resource_id, mo_ref_id=mo_ref_id, mo_name=mo_name, **kwargs)
        self.inventory_type: str = "VirtualMachine"
        self.os_type = os_type
        self.os_name = os_name
        self.ip_addresses = ip_addresses
        self.folder_path = folder_path
        self.host = host
        self.resource_pool = resource_pool
        self.cluster = cluster
        self.instance_uuid = instance_uuid
        self.smbios_uuid = smbios_uuid
        self.power_state = None
        self.tools_running_status = None
        self.tools_version_status = None
        self.tools_version = None


class VirtualMachineTemplate(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Define the virtualMachineTemplate.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Gets or sets the location. Required.
    :vartype location: str
    :ivar extended_location: Gets or sets the extended location.
    :vartype extended_location: ~azure.mgmt.connectedvmware.models.ExtendedLocation
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    :ivar tags: Gets or sets the Resource tags.
    :vartype tags: dict[str, str]
    :ivar name: Gets or sets the name.
    :vartype name: str
    :ivar id: Gets or sets the Id.
    :vartype id: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :vartype kind: str
    :ivar uuid: Gets or sets a unique identifier for this resource.
    :vartype uuid: str
    :ivar v_center_id: Gets or sets the ARM Id of the vCenter resource in which this template
     resides.
    :vartype v_center_id: str
    :ivar mo_ref_id: Gets or sets the vCenter MoRef (Managed Object Reference) ID for the virtual
     machine
     template.
    :vartype mo_ref_id: str
    :ivar inventory_item_id: Gets or sets the inventory Item ID for the virtual machine template.
    :vartype inventory_item_id: str
    :ivar mo_name: Gets or sets the vCenter Managed Object name for the virtual machine template.
    :vartype mo_name: str
    :ivar memory_size_mb: Gets or sets memory size in MBs for the template.
    :vartype memory_size_mb: int
    :ivar num_cp_us: Gets or sets the number of vCPUs for the template.
    :vartype num_cp_us: int
    :ivar num_cores_per_socket: Gets or sets the number of cores per socket for the template.
     Defaults to 1 if unspecified.
    :vartype num_cores_per_socket: int
    :ivar os_type: Gets or sets the type of the os. Known values are: "Windows", "Linux", and
     "Other".
    :vartype os_type: str or ~azure.mgmt.connectedvmware.models.OsType
    :ivar os_name: Gets or sets os name.
    :vartype os_name: str
    :ivar folder_path: Gets or sets the folder path of the template.
    :vartype folder_path: str
    :ivar network_interfaces: Gets or sets the network interfaces of the template.
    :vartype network_interfaces: list[~azure.mgmt.connectedvmware.models.NetworkInterface]
    :ivar disks: Gets or sets the disks the template.
    :vartype disks: list[~azure.mgmt.connectedvmware.models.VirtualDisk]
    :ivar custom_resource_name: Gets the name of the corresponding resource in Kubernetes.
    :vartype custom_resource_name: str
    :ivar tools_version_status: Gets or sets the current version status of VMware Tools installed
     in the guest operating system.
    :vartype tools_version_status: str
    :ivar tools_version: Gets or sets the current version of VMware Tools.
    :vartype tools_version: str
    :ivar firmware_type: Firmware type. Known values are: "bios" and "efi".
    :vartype firmware_type: str or ~azure.mgmt.connectedvmware.models.FirmwareType
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.connectedvmware.models.ResourceStatus]
    :ivar provisioning_state: Gets the provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Provisioning", "Updating", "Deleting", "Accepted", and "Created".
    :vartype provisioning_state: str or ~azure.mgmt.connectedvmware.models.ProvisioningState
    """

    _validation = {
        "location": {"required": True},
        "system_data": {"readonly": True},
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "uuid": {"readonly": True},
        "mo_name": {"readonly": True},
        "memory_size_mb": {"readonly": True},
        "num_cp_us": {"readonly": True},
        "num_cores_per_socket": {"readonly": True},
        "os_type": {"readonly": True},
        "os_name": {"readonly": True},
        "folder_path": {"readonly": True},
        "network_interfaces": {"readonly": True},
        "disks": {"readonly": True},
        "custom_resource_name": {"readonly": True},
        "tools_version_status": {"readonly": True},
        "tools_version": {"readonly": True},
        "firmware_type": {"readonly": True},
        "statuses": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "uuid": {"key": "properties.uuid", "type": "str"},
        "v_center_id": {"key": "properties.vCenterId", "type": "str"},
        "mo_ref_id": {"key": "properties.moRefId", "type": "str"},
        "inventory_item_id": {"key": "properties.inventoryItemId", "type": "str"},
        "mo_name": {"key": "properties.moName", "type": "str"},
        "memory_size_mb": {"key": "properties.memorySizeMB", "type": "int"},
        "num_cp_us": {"key": "properties.numCPUs", "type": "int"},
        "num_cores_per_socket": {"key": "properties.numCoresPerSocket", "type": "int"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "os_name": {"key": "properties.osName", "type": "str"},
        "folder_path": {"key": "properties.folderPath", "type": "str"},
        "network_interfaces": {"key": "properties.networkInterfaces", "type": "[NetworkInterface]"},
        "disks": {"key": "properties.disks", "type": "[VirtualDisk]"},
        "custom_resource_name": {"key": "properties.customResourceName", "type": "str"},
        "tools_version_status": {"key": "properties.toolsVersionStatus", "type": "str"},
        "tools_version": {"key": "properties.toolsVersion", "type": "str"},
        "firmware_type": {"key": "properties.firmwareType", "type": "str"},
        "statuses": {"key": "properties.statuses", "type": "[ResourceStatus]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        tags: Optional[Dict[str, str]] = None,
        kind: Optional[str] = None,
        v_center_id: Optional[str] = None,
        mo_ref_id: Optional[str] = None,
        inventory_item_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Gets or sets the location. Required.
        :paramtype location: str
        :keyword extended_location: Gets or sets the extended location.
        :paramtype extended_location: ~azure.mgmt.connectedvmware.models.ExtendedLocation
        :keyword tags: Gets or sets the Resource tags.
        :paramtype tags: dict[str, str]
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
         the resource provider must validate and persist this value.
        :paramtype kind: str
        :keyword v_center_id: Gets or sets the ARM Id of the vCenter resource in which this template
         resides.
        :paramtype v_center_id: str
        :keyword mo_ref_id: Gets or sets the vCenter MoRef (Managed Object Reference) ID for the
         virtual machine
         template.
        :paramtype mo_ref_id: str
        :keyword inventory_item_id: Gets or sets the inventory Item ID for the virtual machine
         template.
        :paramtype inventory_item_id: str
        """
        super().__init__(**kwargs)
        self.location = location
        self.extended_location = extended_location
        self.system_data = None
        self.tags = tags
        self.name = None
        self.id = None
        self.type = None
        self.kind = kind
        self.uuid = None
        self.v_center_id = v_center_id
        self.mo_ref_id = mo_ref_id
        self.inventory_item_id = inventory_item_id
        self.mo_name = None
        self.memory_size_mb = None
        self.num_cp_us = None
        self.num_cores_per_socket = None
        self.os_type = None
        self.os_name = None
        self.folder_path = None
        self.network_interfaces = None
        self.disks = None
        self.custom_resource_name = None
        self.tools_version_status = None
        self.tools_version = None
        self.firmware_type = None
        self.statuses = None
        self.provisioning_state = None


class VirtualMachineTemplateInventoryItem(InventoryItemProperties):  # pylint: disable=too-many-instance-attributes
    """The VM Template inventory item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar inventory_type: They inventory type. Required. Known values are: "ResourcePool",
     "VirtualMachine", "VirtualMachineTemplate", "VirtualNetwork", "Cluster", "Datastore", and
     "Host".
    :vartype inventory_type: str or ~azure.mgmt.connectedvmware.models.InventoryType
    :ivar managed_resource_id: Gets or sets the tracked resource id corresponding to the inventory
     resource.
    :vartype managed_resource_id: str
    :ivar mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
    :vartype mo_ref_id: str
    :ivar mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
    :vartype mo_name: str
    :ivar provisioning_state: Gets the provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Provisioning", "Updating", "Deleting", "Accepted", and "Created".
    :vartype provisioning_state: str or ~azure.mgmt.connectedvmware.models.ProvisioningState
    :ivar memory_size_mb: Gets or sets memory size in MBs for the template.
    :vartype memory_size_mb: int
    :ivar num_cp_us: Gets or sets the number of vCPUs for the template.
    :vartype num_cp_us: int
    :ivar num_cores_per_socket: Gets or sets the number of cores per socket for the template.
     Defaults to 1 if unspecified.
    :vartype num_cores_per_socket: int
    :ivar os_type: Gets or sets the type of the os. Known values are: "Windows", "Linux", and
     "Other".
    :vartype os_type: str or ~azure.mgmt.connectedvmware.models.OsType
    :ivar os_name: Gets or sets os name.
    :vartype os_name: str
    :ivar tools_version_status: Gets or sets the current version status of VMware Tools installed
     in the guest operating system.
    :vartype tools_version_status: str
    :ivar tools_version: Gets or sets the current version of VMware Tools.
    :vartype tools_version: str
    :ivar folder_path: Gets or sets the folder path of the template.
    :vartype folder_path: str
    """

    _validation = {
        "inventory_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "tools_version_status": {"readonly": True},
        "tools_version": {"readonly": True},
    }

    _attribute_map = {
        "inventory_type": {"key": "inventoryType", "type": "str"},
        "managed_resource_id": {"key": "managedResourceId", "type": "str"},
        "mo_ref_id": {"key": "moRefId", "type": "str"},
        "mo_name": {"key": "moName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "memory_size_mb": {"key": "memorySizeMB", "type": "int"},
        "num_cp_us": {"key": "numCPUs", "type": "int"},
        "num_cores_per_socket": {"key": "numCoresPerSocket", "type": "int"},
        "os_type": {"key": "osType", "type": "str"},
        "os_name": {"key": "osName", "type": "str"},
        "tools_version_status": {"key": "toolsVersionStatus", "type": "str"},
        "tools_version": {"key": "toolsVersion", "type": "str"},
        "folder_path": {"key": "folderPath", "type": "str"},
    }

    def __init__(
        self,
        *,
        managed_resource_id: Optional[str] = None,
        mo_ref_id: Optional[str] = None,
        mo_name: Optional[str] = None,
        memory_size_mb: Optional[int] = None,
        num_cp_us: Optional[int] = None,
        num_cores_per_socket: Optional[int] = None,
        os_type: Optional[Union[str, "_models.OsType"]] = None,
        os_name: Optional[str] = None,
        folder_path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword managed_resource_id: Gets or sets the tracked resource id corresponding to the
         inventory resource.
        :paramtype managed_resource_id: str
        :keyword mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory
         item.
        :paramtype mo_ref_id: str
        :keyword mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
        :paramtype mo_name: str
        :keyword memory_size_mb: Gets or sets memory size in MBs for the template.
        :paramtype memory_size_mb: int
        :keyword num_cp_us: Gets or sets the number of vCPUs for the template.
        :paramtype num_cp_us: int
        :keyword num_cores_per_socket: Gets or sets the number of cores per socket for the template.
         Defaults to 1 if unspecified.
        :paramtype num_cores_per_socket: int
        :keyword os_type: Gets or sets the type of the os. Known values are: "Windows", "Linux", and
         "Other".
        :paramtype os_type: str or ~azure.mgmt.connectedvmware.models.OsType
        :keyword os_name: Gets or sets os name.
        :paramtype os_name: str
        :keyword folder_path: Gets or sets the folder path of the template.
        :paramtype folder_path: str
        """
        super().__init__(managed_resource_id=managed_resource_id, mo_ref_id=mo_ref_id, mo_name=mo_name, **kwargs)
        self.inventory_type: str = "VirtualMachineTemplate"
        self.memory_size_mb = memory_size_mb
        self.num_cp_us = num_cp_us
        self.num_cores_per_socket = num_cores_per_socket
        self.os_type = os_type
        self.os_name = os_name
        self.tools_version_status = None
        self.tools_version = None
        self.folder_path = folder_path


class VirtualMachineTemplatesList(_serialization.Model):
    """List of VirtualMachineTemplates.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: Url to follow for getting next page of VirtualMachineTemplates.
    :vartype next_link: str
    :ivar value: Array of VirtualMachineTemplates. Required.
    :vartype value: list[~azure.mgmt.connectedvmware.models.VirtualMachineTemplate]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[VirtualMachineTemplate]"},
    }

    def __init__(
        self, *, value: List["_models.VirtualMachineTemplate"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: Url to follow for getting next page of VirtualMachineTemplates.
        :paramtype next_link: str
        :keyword value: Array of VirtualMachineTemplates. Required.
        :paramtype value: list[~azure.mgmt.connectedvmware.models.VirtualMachineTemplate]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class VirtualNetwork(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Define the virtualNetwork.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Gets or sets the location. Required.
    :vartype location: str
    :ivar extended_location: Gets or sets the extended location.
    :vartype extended_location: ~azure.mgmt.connectedvmware.models.ExtendedLocation
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    :ivar tags: Gets or sets the Resource tags.
    :vartype tags: dict[str, str]
    :ivar name: Gets or sets the name.
    :vartype name: str
    :ivar id: Gets or sets the Id.
    :vartype id: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :vartype kind: str
    :ivar uuid: Gets or sets a unique identifier for this resource.
    :vartype uuid: str
    :ivar v_center_id: Gets or sets the ARM Id of the vCenter resource in which this template
     resides.
    :vartype v_center_id: str
    :ivar mo_ref_id: Gets or sets the vCenter MoRef (Managed Object Reference) ID for the virtual
     network.
    :vartype mo_ref_id: str
    :ivar inventory_item_id: Gets or sets the inventory Item ID for the virtual network.
    :vartype inventory_item_id: str
    :ivar mo_name: Gets or sets the vCenter Managed Object name for the virtual network.
    :vartype mo_name: str
    :ivar custom_resource_name: Gets the name of the corresponding resource in Kubernetes.
    :vartype custom_resource_name: str
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.connectedvmware.models.ResourceStatus]
    :ivar provisioning_state: Gets the provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Provisioning", "Updating", "Deleting", "Accepted", and "Created".
    :vartype provisioning_state: str or ~azure.mgmt.connectedvmware.models.ProvisioningState
    """

    _validation = {
        "location": {"required": True},
        "system_data": {"readonly": True},
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "uuid": {"readonly": True},
        "mo_name": {"readonly": True},
        "custom_resource_name": {"readonly": True},
        "statuses": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "uuid": {"key": "properties.uuid", "type": "str"},
        "v_center_id": {"key": "properties.vCenterId", "type": "str"},
        "mo_ref_id": {"key": "properties.moRefId", "type": "str"},
        "inventory_item_id": {"key": "properties.inventoryItemId", "type": "str"},
        "mo_name": {"key": "properties.moName", "type": "str"},
        "custom_resource_name": {"key": "properties.customResourceName", "type": "str"},
        "statuses": {"key": "properties.statuses", "type": "[ResourceStatus]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        tags: Optional[Dict[str, str]] = None,
        kind: Optional[str] = None,
        v_center_id: Optional[str] = None,
        mo_ref_id: Optional[str] = None,
        inventory_item_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Gets or sets the location. Required.
        :paramtype location: str
        :keyword extended_location: Gets or sets the extended location.
        :paramtype extended_location: ~azure.mgmt.connectedvmware.models.ExtendedLocation
        :keyword tags: Gets or sets the Resource tags.
        :paramtype tags: dict[str, str]
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
         the resource provider must validate and persist this value.
        :paramtype kind: str
        :keyword v_center_id: Gets or sets the ARM Id of the vCenter resource in which this template
         resides.
        :paramtype v_center_id: str
        :keyword mo_ref_id: Gets or sets the vCenter MoRef (Managed Object Reference) ID for the
         virtual network.
        :paramtype mo_ref_id: str
        :keyword inventory_item_id: Gets or sets the inventory Item ID for the virtual network.
        :paramtype inventory_item_id: str
        """
        super().__init__(**kwargs)
        self.location = location
        self.extended_location = extended_location
        self.system_data = None
        self.tags = tags
        self.name = None
        self.id = None
        self.type = None
        self.kind = kind
        self.uuid = None
        self.v_center_id = v_center_id
        self.mo_ref_id = mo_ref_id
        self.inventory_item_id = inventory_item_id
        self.mo_name = None
        self.custom_resource_name = None
        self.statuses = None
        self.provisioning_state = None


class VirtualNetworkInventoryItem(InventoryItemProperties):
    """The Virtual network inventory item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar inventory_type: They inventory type. Required. Known values are: "ResourcePool",
     "VirtualMachine", "VirtualMachineTemplate", "VirtualNetwork", "Cluster", "Datastore", and
     "Host".
    :vartype inventory_type: str or ~azure.mgmt.connectedvmware.models.InventoryType
    :ivar managed_resource_id: Gets or sets the tracked resource id corresponding to the inventory
     resource.
    :vartype managed_resource_id: str
    :ivar mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
    :vartype mo_ref_id: str
    :ivar mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
    :vartype mo_name: str
    :ivar provisioning_state: Gets the provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Provisioning", "Updating", "Deleting", "Accepted", and "Created".
    :vartype provisioning_state: str or ~azure.mgmt.connectedvmware.models.ProvisioningState
    """

    _validation = {
        "inventory_type": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "inventory_type": {"key": "inventoryType", "type": "str"},
        "managed_resource_id": {"key": "managedResourceId", "type": "str"},
        "mo_ref_id": {"key": "moRefId", "type": "str"},
        "mo_name": {"key": "moName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        managed_resource_id: Optional[str] = None,
        mo_ref_id: Optional[str] = None,
        mo_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword managed_resource_id: Gets or sets the tracked resource id corresponding to the
         inventory resource.
        :paramtype managed_resource_id: str
        :keyword mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory
         item.
        :paramtype mo_ref_id: str
        :keyword mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
        :paramtype mo_name: str
        """
        super().__init__(managed_resource_id=managed_resource_id, mo_ref_id=mo_ref_id, mo_name=mo_name, **kwargs)
        self.inventory_type: str = "VirtualNetwork"


class VirtualNetworksList(_serialization.Model):
    """List of VirtualNetworks.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: Url to follow for getting next page of VirtualNetworks.
    :vartype next_link: str
    :ivar value: Array of VirtualNetworks. Required.
    :vartype value: list[~azure.mgmt.connectedvmware.models.VirtualNetwork]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[VirtualNetwork]"},
    }

    def __init__(
        self, *, value: List["_models.VirtualNetwork"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: Url to follow for getting next page of VirtualNetworks.
        :paramtype next_link: str
        :keyword value: Array of VirtualNetworks. Required.
        :paramtype value: list[~azure.mgmt.connectedvmware.models.VirtualNetwork]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class VirtualSCSIController(_serialization.Model):
    """This data object type contains the properties of a SCSI controller device attached to a virtual
    machine that is reported by the controller.

    :ivar type: Gets or sets the controller type. Known values are: "lsilogic", "buslogic",
     "pvscsi", and "lsilogicsas".
    :vartype type: str or ~azure.mgmt.connectedvmware.models.SCSIControllerType
    :ivar controller_key: Gets or sets the key of the controller.
    :vartype controller_key: int
    :ivar bus_number: Gets or sets the bus number of the controller.
    :vartype bus_number: int
    :ivar scsi_ctlr_unit_number: Gets or sets the SCSI controller unit number.
    :vartype scsi_ctlr_unit_number: int
    :ivar sharing: Gets or sets the sharing mode. Known values are: "noSharing", "physicalSharing",
     and "virtualSharing".
    :vartype sharing: str or ~azure.mgmt.connectedvmware.models.VirtualSCSISharing
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "controller_key": {"key": "controllerKey", "type": "int"},
        "bus_number": {"key": "busNumber", "type": "int"},
        "scsi_ctlr_unit_number": {"key": "scsiCtlrUnitNumber", "type": "int"},
        "sharing": {"key": "sharing", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.SCSIControllerType"]] = None,
        controller_key: Optional[int] = None,
        bus_number: Optional[int] = None,
        scsi_ctlr_unit_number: Optional[int] = None,
        sharing: Optional[Union[str, "_models.VirtualSCSISharing"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Gets or sets the controller type. Known values are: "lsilogic", "buslogic",
         "pvscsi", and "lsilogicsas".
        :paramtype type: str or ~azure.mgmt.connectedvmware.models.SCSIControllerType
        :keyword controller_key: Gets or sets the key of the controller.
        :paramtype controller_key: int
        :keyword bus_number: Gets or sets the bus number of the controller.
        :paramtype bus_number: int
        :keyword scsi_ctlr_unit_number: Gets or sets the SCSI controller unit number.
        :paramtype scsi_ctlr_unit_number: int
        :keyword sharing: Gets or sets the sharing mode. Known values are: "noSharing",
         "physicalSharing", and "virtualSharing".
        :paramtype sharing: str or ~azure.mgmt.connectedvmware.models.VirtualSCSISharing
        """
        super().__init__(**kwargs)
        self.type = type
        self.controller_key = controller_key
        self.bus_number = bus_number
        self.scsi_ctlr_unit_number = scsi_ctlr_unit_number
        self.sharing = sharing


class VmInstanceHybridIdentityMetadata(ProxyResource):
    """Defines the HybridIdentityMetadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    :ivar resource_uid: The unique identifier for the resource.
    :vartype resource_uid: str
    :ivar public_key: Gets or sets the Public Key.
    :vartype public_key: str
    :ivar provisioning_state: Gets the provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Provisioning", "Updating", "Deleting", "Accepted", and "Created".
    :vartype provisioning_state: str or ~azure.mgmt.connectedvmware.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "resource_uid": {"key": "properties.resourceUid", "type": "str"},
        "public_key": {"key": "properties.publicKey", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, resource_uid: Optional[str] = None, public_key: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword resource_uid: The unique identifier for the resource.
        :paramtype resource_uid: str
        :keyword public_key: Gets or sets the Public Key.
        :paramtype public_key: str
        """
        super().__init__(**kwargs)
        self.resource_uid = resource_uid
        self.public_key = public_key
        self.provisioning_state = None


class VmInstanceHybridIdentityMetadataList(_serialization.Model):
    """List of HybridIdentityMetadata.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: Url to follow for getting next page of HybridIdentityMetadata.
    :vartype next_link: str
    :ivar value: Array of HybridIdentityMetadata. Required.
    :vartype value: list[~azure.mgmt.connectedvmware.models.VmInstanceHybridIdentityMetadata]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[VmInstanceHybridIdentityMetadata]"},
    }

    def __init__(
        self, *, value: List["_models.VmInstanceHybridIdentityMetadata"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: Url to follow for getting next page of HybridIdentityMetadata.
        :paramtype next_link: str
        :keyword value: Array of HybridIdentityMetadata. Required.
        :paramtype value: list[~azure.mgmt.connectedvmware.models.VmInstanceHybridIdentityMetadata]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value
