# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.apimanagement.aio import ApiManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApiManagementWorkspaceCertificateOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApiManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_certificate_list_by_workspace(self, resource_group):
        response = self.client.workspace_certificate.list_by_workspace(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            api_version="2024-05-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_certificate_get_entity_tag(self, resource_group):
        response = await self.client.workspace_certificate.get_entity_tag(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            certificate_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_certificate_get(self, resource_group):
        response = await self.client.workspace_certificate.get(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            certificate_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_certificate_create_or_update(self, resource_group):
        response = await self.client.workspace_certificate.create_or_update(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            certificate_id="str",
            parameters={
                "data": "str",
                "keyVault": {"identityClientId": "str", "secretIdentifier": "str"},
                "password": "str",
            },
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_certificate_delete(self, resource_group):
        response = await self.client.workspace_certificate.delete(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            certificate_id="str",
            if_match="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_certificate_refresh_secret(self, resource_group):
        response = await self.client.workspace_certificate.refresh_secret(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            certificate_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...
