//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// UNSUPPORTED: c++03, c++11, c++14, c++17
// UNSUPPORTED: GCC-ALWAYS_INLINE-FIXME

// <format>

// basic_format_arg<basic_format_context> arg(size_t id) const;

#include <format>
#include <iterator>
#include <cassert>

#include "test_basic_format_arg.h"
#include "test_format_context.h"
#include "test_macros.h"
#include "make_string.h"

template <class OutIt, class CharT>
void test() {
  bool b                          = true;
  CharT c                         = CharT('a');
  int a                           = 42;
  std::basic_string<CharT> string = MAKE_STRING(CharT, "string");
  auto store                      = std::make_format_args<std::basic_format_context<OutIt, CharT>>(b, c, a, string);
  std::basic_format_args args = store;

  std::basic_string<CharT> output;
  const std::basic_format_context context = test_format_context_create(OutIt{output}, args);
  LIBCPP_ASSERT(args.__size() == 4);
  ASSERT_NOEXCEPT(context.arg(0));
  for (std::size_t i = 0, e = args.__size(); i != e; ++i) {
    assert(context.arg(i));
  }
  assert(!context.arg(args.__size()));

  assert(test_basic_format_arg(context.arg(0), true));
  assert(test_basic_format_arg(context.arg(1), CharT('a')));
  assert(test_basic_format_arg(context.arg(2), 42));
  assert(test_basic_format_arg(context.arg(3),
                               std::basic_string_view<CharT>(string)));
}

int main(int, char**) {
  test<std::back_insert_iterator<std::basic_string<char>>, char>();
#ifndef TEST_HAS_NO_WIDE_CHARACTERS
  test<std::back_insert_iterator<std::basic_string<wchar_t>>, wchar_t>();
#endif

  return 0;
}
