/*
 ** This file is part of Filius, a network construction and simulation software.
 ** 
 ** Originally created at the University of Siegen, Institute "Didactics of
 ** Informatics and E-Learning" by a students' project group:
 **     members (2006-2007): 
 **         André Asschoff, Johannes Bade, Carsten Dittich, Thomas Gerding,
 **         Nadja Haßler, Ernst Johannes Klebert, Michell Weyer
 **     supervisors:
 **         Stefan Freischlad (maintainer until 2009), Peer Stechert
 ** Project is maintained since 2010 by Christian Eibl <filius@c.fameibl.de>
 **         and Stefan Freischlad
 ** Filius is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 2 of the License, or
 ** (at your option) version 3.
 ** 
 ** Filius is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied
 ** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 ** PURPOSE. See the GNU General Public License for more details.
 ** 
 ** You should have received a copy of the GNU General Public License
 ** along with Filius.  If not, see <http://www.gnu.org/licenses/>.
 */
package filius.gui.anwendungssicht;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import filius.gui.ControlPanel;
import filius.hardware.Verbindung;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.nachrichten.Lauscher;
import filius.rahmenprogramm.nachrichten.LauscherBeobachter;

@SuppressWarnings("serial")
public class SimulationControl extends ControlPanel implements I18n, LauscherBeobachter {

    private JTextPane textPane;

    public SimulationControl() {
        super();
        reInit();
    }

    protected void initContents() {
        JButton dropButton = new JButton(messages.getString("simulation_control_drop_packets"));
        dropButton.addChangeListener(new ChangeListener() {
            @Override
            public void stateChanged(ChangeEvent evt) {
                ButtonModel model = ((JButton) evt.getSource()).getModel();
                if (model.isPressed() && !Verbindung.isDrop()) {
                    Verbindung.setDrop(true);
                } else if (!model.isPressed() && Verbindung.isDrop()) {
                    Verbindung.setDrop(false);
                }
            }
        });

        Box tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(JComponent.LEFT_ALIGNMENT);
        tempBox.setPreferredSize(new Dimension(400, 35));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(dropButton);
        rightBox.add(tempBox, BorderLayout.NORTH);

        textPane = new JTextPane();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(textPane);
        scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        box.add(scrollPane);

        Lauscher.getLauscher().resetDroppedDataUnits();
        Lauscher.getLauscher().addBeobachter(Lauscher.DROPPED, this);
    }

    @Override
    public void update() {
        StringBuffer buffer = new StringBuffer();
        for (String dataUnit : Lauscher.getLauscher().getDroppedDataUnits()) {
            buffer.append(dataUnit).append("\n");
        }
        textPane.setText(buffer.toString());
    }

    @Override
    public void writeToStream(OutputStream outputStream) throws IOException {}
}
