SUBROUTINE ECTRANS_VERSION(CD_VERSION_STRING)
! ** PURPOSE
!    Return the version string of ecTrans
!
! ** DUMMY ARGUMENTS
!    CD_VERSION_STRING: version string
!
! ** AUTHOR
!    18 March 2025, S. Hatfield
!
! I. Dummy arguments declaration
USE ECTRANS_VERSION_MOD, ONLY: ECTRANS_VERSION_STR
USE, INTRINSIC :: ISO_C_BINDING, ONLY: C_CHAR
IMPLICIT NONE
CHARACTER(KIND=C_CHAR), DIMENSION(14), INTENT(OUT) :: CD_VERSION_STRING
!
! II. Local variables
INTEGER :: JI
CHARACTER(LEN=SIZE(CD_VERSION_STRING)) :: C_VERSION_STRING
!
! III. Get version
C_VERSION_STRING = ECTRANS_VERSION_STR()
DO JI=1, SIZE(CD_VERSION_STRING)
  CD_VERSION_STRING(JI)=C_VERSION_STRING(JI:JI)
ENDDO
!
END SUBROUTINE ECTRANS_VERSION
