
/*LICENSE_START*/
/*
 *  Copyright (C) 2017 Washington University School of Medicine
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
/*LICENSE_END*/

#include <algorithm>
#define __CHART_TWO_AXIS_SCALE_RANGE_MODE_ENUM_DECLARE__
#include "ChartTwoAxisScaleRangeModeEnum.h"
#undef __CHART_TWO_AXIS_SCALE_RANGE_MODE_ENUM_DECLARE__

#include "CaretAssert.h"

using namespace caret;

    
/**
 * \class caret::ChartTwoAxisScaleRangeModeEnum 
 * \brief Chart Two Axis Scale Range Mode.
 *
 * Using this enumerated type in the GUI with an EnumComboBoxTemplate
 * 
 * Header File (.h)
 *     Forward declare the data type:
 *         class EnumComboBoxTemplate;
 * 
 *     Declare the member:
 *         EnumComboBoxTemplate* m_chartTwoAxisScaleRangeModeEnumComboBox;
 * 
 *     Declare a slot that is called when user changes selection
 *         private slots:
 *             void chartTwoAxisScaleRangeModeEnumComboBoxItemActivated();
 * 
 * Implementation File (.cxx)
 *     Include the header files
 *         #include "EnumComboBoxTemplate.h"
 *         #include "ChartTwoAxisScaleRangeModeEnum.h"
 * 
 *     Instatiate:
 *         m_chartTwoAxisScaleRangeModeEnumComboBox = new EnumComboBoxTemplate(this);
 *         m_chartTwoAxisScaleRangeModeEnumComboBox->setup<ChartTwoAxisScaleRangeModeEnum,ChartTwoAxisScaleRangeModeEnum::Enum>();
 * 
 *     Get notified when the user changes the selection: 
 *         QObject::connect(m_chartTwoAxisScaleRangeModeEnumComboBox, SIGNAL(itemActivated()),
 *                          this, SLOT(chartTwoAxisScaleRangeModeEnumComboBoxItemActivated()));
 * 
 *     Update the selection:
 *         m_chartTwoAxisScaleRangeModeEnumComboBox->setSelectedItem<ChartTwoAxisScaleRangeModeEnum,ChartTwoAxisScaleRangeModeEnum::Enum>(NEW_VALUE);
 * 
 *     Read the selection:
 *         const ChartTwoAxisScaleRangeModeEnum::Enum VARIABLE = m_chartTwoAxisScaleRangeModeEnumComboBox->getSelectedItem<ChartTwoAxisScaleRangeModeEnum,ChartTwoAxisScaleRangeModeEnum::Enum>();
 * 
 */

/**
 * Constructor.
 *
 * @param enumValue
 *    An enumerated value.
 * @param name
 *    Name of enumerated value.
 *
 * @param guiName
 *    User-friendly name for use in user-interface.
 * @param oldName
 *    An older version of 'name'
 */
ChartTwoAxisScaleRangeModeEnum::ChartTwoAxisScaleRangeModeEnum(const Enum enumValue,
                                                               const AString& name,
                                                               const AString& guiName,
                                                               const AString& oldName)
{
    this->enumValue = enumValue;
    this->integerCode = integerCodeCounter++;
    this->name = name;
    this->guiName = guiName;
    this->oldName = oldName;
}

/**
 * Destructor.
 */
ChartTwoAxisScaleRangeModeEnum::~ChartTwoAxisScaleRangeModeEnum()
{
}

/**
 * Initialize the enumerated metadata.
 */
void
ChartTwoAxisScaleRangeModeEnum::initialize()
{
    if (initializedFlag) {
        return;
    }
    initializedFlag = true;

    const AString invalidOldName("");
    enumData.push_back(ChartTwoAxisScaleRangeModeEnum(AUTO,
                                                      "AUTO",
                                                      "Auto",
                                                      "AXIS_DATA_RANGE_AUTO"));
    
    enumData.push_back(ChartTwoAxisScaleRangeModeEnum(DATA,
                                                      "DATA",
                                                      "Data",
                                                      "AXIS_DATA_RANGE_DATA"));
    
    enumData.push_back(ChartTwoAxisScaleRangeModeEnum(USER,
                                                      "USER",
                                                      "User",
                                                      "AXIS_DATA_RANGE_USER"));
    
    enumData.push_back(ChartTwoAxisScaleRangeModeEnum(YOKE_A,
                                                      "YOKE_A",
                                                      "Yoke A",
                                                      invalidOldName));
    
    enumData.push_back(ChartTwoAxisScaleRangeModeEnum(YOKE_B,
                                                      "YOKE_B",
                                                      "Yoke B",
                                                      invalidOldName));
    
    enumData.push_back(ChartTwoAxisScaleRangeModeEnum(YOKE_C,
                                                      "YOKE_C",
                                                      "Yoke C",
                                                      invalidOldName));
    
    enumData.push_back(ChartTwoAxisScaleRangeModeEnum(YOKE_D,
                                                      "YOKE_D",
                                                      "Yoke D",
                                                      invalidOldName));
    
}

/**
 * Find the data for and enumerated value.
 * @param enumValue
 *     The enumerated value.
 * @return Pointer to data for this enumerated type
 * or NULL if no data for type or if type is invalid.
 */
const ChartTwoAxisScaleRangeModeEnum*
ChartTwoAxisScaleRangeModeEnum::findData(const Enum enumValue)
{
    if (initializedFlag == false) initialize();

    size_t num = enumData.size();
    for (size_t i = 0; i < num; i++) {
        const ChartTwoAxisScaleRangeModeEnum* d = &enumData[i];
        if (d->enumValue == enumValue) {
            return d;
        }
    }

    return NULL;
}

/**
 * Get a string representation of the enumerated type.
 * @param enumValue 
 *     Enumerated value.
 * @return 
 *     String representing enumerated value.
 */
AString 
ChartTwoAxisScaleRangeModeEnum::toName(Enum enumValue) {
    if (initializedFlag == false) initialize();
    
    const ChartTwoAxisScaleRangeModeEnum* enumInstance = findData(enumValue);
    return enumInstance->name;
}

/**
 * Get an enumerated value corresponding to its name.
 * @param name 
 *     Name of enumerated value.
 * @param isValidOut 
 *     If not NULL, it is set indicating that a
 *     enum value exists for the input name.
 * @return 
 *     Enumerated value.
 */
ChartTwoAxisScaleRangeModeEnum::Enum 
ChartTwoAxisScaleRangeModeEnum::fromName(const AString& name, bool* isValidOut)
{
    if (initializedFlag == false) initialize();
    
    bool validFlag = false;
    Enum enumValue = ChartTwoAxisScaleRangeModeEnum::enumData[0].enumValue;
    
    for (std::vector<ChartTwoAxisScaleRangeModeEnum>::iterator iter = enumData.begin();
         iter != enumData.end();
         iter++) {
        const ChartTwoAxisScaleRangeModeEnum& d = *iter;
        if ((d.name == name)
            || (d.oldName == name)) {
            enumValue = d.enumValue;
            validFlag = true;
            break;
        }
    }
    
    if (isValidOut != 0) {
        *isValidOut = validFlag;
    }
    else if (validFlag == false) {
        CaretAssertMessage(0, AString("Name " + name + "failed to match enumerated value for type ChartTwoAxisScaleRangeModeEnum"));
    }
    return enumValue;
}

/**
 * Get a GUI string representation of the enumerated type.
 * @param enumValue 
 *     Enumerated value.
 * @return 
 *     String representing enumerated value.
 */
AString 
ChartTwoAxisScaleRangeModeEnum::toGuiName(Enum enumValue) {
    if (initializedFlag == false) initialize();
    
    const ChartTwoAxisScaleRangeModeEnum* enumInstance = findData(enumValue);
    return enumInstance->guiName;
}

/**
 * Get an enumerated value corresponding to its GUI name.
 * @param s 
 *     Name of enumerated value.
 * @param isValidOut 
 *     If not NULL, it is set indicating that a
 *     enum value exists for the input name.
 * @return 
 *     Enumerated value.
 */
ChartTwoAxisScaleRangeModeEnum::Enum 
ChartTwoAxisScaleRangeModeEnum::fromGuiName(const AString& guiName, bool* isValidOut)
{
    if (initializedFlag == false) initialize();
    
    bool validFlag = false;
    Enum enumValue = ChartTwoAxisScaleRangeModeEnum::enumData[0].enumValue;
    
    for (std::vector<ChartTwoAxisScaleRangeModeEnum>::iterator iter = enumData.begin();
         iter != enumData.end();
         iter++) {
        const ChartTwoAxisScaleRangeModeEnum& d = *iter;
        if (d.guiName == guiName) {
            enumValue = d.enumValue;
            validFlag = true;
            break;
        }
    }
    
    if (isValidOut != 0) {
        *isValidOut = validFlag;
    }
    else if (validFlag == false) {
        CaretAssertMessage(0, AString("guiName " + guiName + "failed to match enumerated value for type ChartTwoAxisScaleRangeModeEnum"));
    }
    return enumValue;
}

/**
 * Get the integer code for a data type.
 *
 * @return
 *    Integer code for data type.
 */
int32_t
ChartTwoAxisScaleRangeModeEnum::toIntegerCode(Enum enumValue)
{
    if (initializedFlag == false) initialize();
    const ChartTwoAxisScaleRangeModeEnum* enumInstance = findData(enumValue);
    return enumInstance->integerCode;
}

/**
 * Find the data type corresponding to an integer code.
 *
 * @param integerCode
 *     Integer code for enum.
 * @param isValidOut
 *     If not NULL, on exit isValidOut will indicate if
 *     integer code is valid.
 * @return
 *     Enum for integer code.
 */
ChartTwoAxisScaleRangeModeEnum::Enum
ChartTwoAxisScaleRangeModeEnum::fromIntegerCode(const int32_t integerCode, bool* isValidOut)
{
    if (initializedFlag == false) initialize();
    
    bool validFlag = false;
    Enum enumValue = ChartTwoAxisScaleRangeModeEnum::enumData[0].enumValue;
    
    for (std::vector<ChartTwoAxisScaleRangeModeEnum>::iterator iter = enumData.begin();
         iter != enumData.end();
         iter++) {
        const ChartTwoAxisScaleRangeModeEnum& enumInstance = *iter;
        if (enumInstance.integerCode == integerCode) {
            enumValue = enumInstance.enumValue;
            validFlag = true;
            break;
        }
    }
    
    if (isValidOut != 0) {
        *isValidOut = validFlag;
    }
    else if (validFlag == false) {
        CaretAssertMessage(0, AString("Integer code " + AString::number(integerCode) + "failed to match enumerated value for type ChartTwoAxisScaleRangeModeEnum"));
    }
    return enumValue;
}

/**
 * Get all of the enumerated type values.  The values can be used
 * as parameters to toXXX() methods to get associated metadata.
 *
 * @param allEnums
 *     A vector that is OUTPUT containing all of the enumerated values.
 */
void
ChartTwoAxisScaleRangeModeEnum::getAllEnums(std::vector<ChartTwoAxisScaleRangeModeEnum::Enum>& allEnums)
{
    if (initializedFlag == false) initialize();
    
    allEnums.clear();
    
    for (std::vector<ChartTwoAxisScaleRangeModeEnum>::iterator iter = enumData.begin();
         iter != enumData.end();
         iter++) {
        allEnums.push_back(iter->enumValue);
    }
}

/**
 * Get all of the names of the enumerated type values.
 *
 * @param allNames
 *     A vector that is OUTPUT containing all of the names of the enumerated values.
 * @param isSorted
 *     If true, the names are sorted in alphabetical order.
 */
void
ChartTwoAxisScaleRangeModeEnum::getAllNames(std::vector<AString>& allNames, const bool isSorted)
{
    if (initializedFlag == false) initialize();
    
    allNames.clear();
    
    for (std::vector<ChartTwoAxisScaleRangeModeEnum>::iterator iter = enumData.begin();
         iter != enumData.end();
         iter++) {
        allNames.push_back(ChartTwoAxisScaleRangeModeEnum::toName(iter->enumValue));
    }
    
    if (isSorted) {
        std::sort(allNames.begin(), allNames.end());
    }
}

/**
 * Get all of the GUI names of the enumerated type values.
 *
 * @param allNames
 *     A vector that is OUTPUT containing all of the GUI names of the enumerated values.
 * @param isSorted
 *     If true, the names are sorted in alphabetical order.
 */
void
ChartTwoAxisScaleRangeModeEnum::getAllGuiNames(std::vector<AString>& allGuiNames, const bool isSorted)
{
    if (initializedFlag == false) initialize();
    
    allGuiNames.clear();
    
    for (std::vector<ChartTwoAxisScaleRangeModeEnum>::iterator iter = enumData.begin();
         iter != enumData.end();
         iter++) {
        allGuiNames.push_back(ChartTwoAxisScaleRangeModeEnum::toGuiName(iter->enumValue));
    }
    
    if (isSorted) {
        std::sort(allGuiNames.begin(), allGuiNames.end());
    }
}

/**
 * @return True if the given mode is a yoking range mode
 * @param enumValue
 *   The enumerated type value
 */
bool
ChartTwoAxisScaleRangeModeEnum::isYokingRangeMode(const Enum enumValue)
{
    bool yokeFlag(false);
    switch (enumValue) {
        case ChartTwoAxisScaleRangeModeEnum::AUTO:
        case ChartTwoAxisScaleRangeModeEnum::DATA:
        case ChartTwoAxisScaleRangeModeEnum::USER:
            break;
        case ChartTwoAxisScaleRangeModeEnum::YOKE_A:
        case ChartTwoAxisScaleRangeModeEnum::YOKE_B:
        case ChartTwoAxisScaleRangeModeEnum::YOKE_C:
        case ChartTwoAxisScaleRangeModeEnum::YOKE_D:
            yokeFlag = true;
            break;
    }
    
    return yokeFlag;
}
